/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idaligner;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.ExecutionContext;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IUserPrompt;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.idaligner.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class IdBasedAlignerStep
extends BasePipelineStep {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private IFilterConfigurationMapper fcMapper;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private RawDocument targetInput = null;
    private ExecutionContext context;
    private TMXWriter tmx;
    private Map<String, ITextUnit> targetTextUnitMap;
    private boolean useTargetText;
    private boolean docHasNoMatch;

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.targetInput = secondInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.EXECUTION_CONTEXT)
    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    @Override
    public String getDescription() {
        return "Align text units in two id-based files (e.g. Java properties). Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Id-Based Aligner";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        if (this.tmx == null && this.params.getGenerateTMX()) {
            File outFile = new File(this.params.getTmxOutputPath());
            if (outFile.exists()) {
                this.promptShouldOverwrite();
            }
            this.tmx = new TMXWriter(outFile.getAbsolutePath());
            this.tmx.writeStartDocument(this.sourceLocale, this.targetLocale, this.getClass().getName(), null, "paragraph", null, null);
        }
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (this.tmx != null) {
            this.tmx.writeEndDocument();
            this.tmx.close();
            this.tmx = null;
            this.LOGGER.info("Wrote TMX to {}", (Object)new File(this.params.getTmxOutputPath()).getAbsolutePath());
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        if (this.targetInput == null) {
            throw new OkapiBadStepInputException("Second input file (target) not configured.");
        }
        this.docHasNoMatch = false;
        this.getTargetTextUnits();
        return this.eventIndicatingTargetWasConsumed(event);
    }

    private Event eventIndicatingTargetWasConsumed(Event startDocEvent) {
        ArrayList<Event> list = new ArrayList<Event>();
        PipelineParameters pp = new PipelineParameters();
        pp.setSecondInputRawDocument(null);
        list.add(new Event(EventType.PIPELINE_PARAMETERS, pp));
        list.add(startDocEvent);
        return new Event(EventType.MULTI_EVENT, new MultiEvent(list));
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (this.docHasNoMatch) {
            this.LOGGER.warn("One or more entries has no match.");
        }
        return event;
    }

    private String getAlignmentKey(ITextUnit tu) {
        return this.params.isUseTextUnitIds() ? tu.getId() : tu.getName();
    }

    @Override
    protected Event handleTextUnit(Event sourceEvent) {
        int score = 100;
        if (sourceEvent.getTextUnit().getSource().hasBeenSegmented()) {
            throw new OkapiBadStepInputException("IdBasedAlignerStep only aligns unsegmented text units.");
        }
        ITextUnit sourceTu = sourceEvent.getTextUnit();
        if (!sourceTu.isTranslatable() || sourceTu.isEmpty() || !sourceTu.getSource().hasText()) {
            return sourceEvent;
        }
        ITextUnit alignedTextUnit = sourceTu.clone();
        boolean tuHasNoMatch = false;
        TextContainer targetTC = alignedTextUnit.createTarget(this.targetLocale, false, 2);
        ITextUnit refTu = this.targetTextUnitMap.get(this.getAlignmentKey(sourceTu));
        TextContainer refTc = null;
        boolean missingReferenceMatch = true;
        if (refTu != null && !refTu.isEmpty()) {
            if (this.useTargetText) {
                TextContainer srcRefTc = refTu.getSource();
                if (srcRefTc.compareTo(alignedTextUnit.getSource(), true) == 0) {
                    refTc = refTu.getTarget(this.targetLocale);
                } else {
                    missingReferenceMatch = false;
                }
            } else {
                refTc = refTu.getSource();
            }
        }
        if (refTc != null && refTc.hasText()) {
            alignedTextUnit.getSource().getFirstContent().alignCodeIds(refTc.getFirstContent());
            TextFragment tf = TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(sourceTu.getSource().getFirstContent(), refTc.getFirstContent(), true, false, null, alignedTextUnit);
            if (this.params.isCopyToTarget()) {
                targetTC.setContent(tf);
                Property prop = refTc.getProperty("approved");
                if (prop != null) {
                    targetTC.setProperty(prop.clone());
                }
            }
            if (this.params.isStoreAsAltTranslation()) {
                AltTranslation alt = new AltTranslation(this.sourceLocale, this.targetLocale, alignedTextUnit.getSource().getUnSegmentedContentCopy(), null, tf, MatchType.EXACT_UNIQUE_ID, score, this.getName());
                AltTranslationsAnnotation alta = TextUnitUtil.addAltTranslation(targetTC, alt);
                alta.sort();
            }
        } else {
            if (missingReferenceMatch) {
                if (this.getAlignmentKey(sourceTu) == null) {
                    this.LOGGER.info("Entry without original identifier (id='{}').", (Object)sourceTu.getId());
                    tuHasNoMatch = true;
                } else {
                    this.LOGGER.info("No match found for {}", (Object)this.getAlignmentKey(sourceTu));
                    tuHasNoMatch = true;
                }
            } else {
                this.LOGGER.info("Source texts differ for {}", (Object)this.getAlignmentKey(sourceTu));
                tuHasNoMatch = true;
            }
            if (this.params.getReplaceWithSource()) {
                alignedTextUnit.setTarget(this.targetLocale, sourceTu.getSource());
            }
        }
        if (!this.params.isSuppressTusWithNoTarget() || !tuHasNoMatch) {
            if (this.params.getGenerateTMX()) {
                this.tmx.writeTUFull(alignedTextUnit);
            } else {
                return new Event(EventType.TEXT_UNIT, alignedTextUnit);
            }
        }
        this.docHasNoMatch = this.docHasNoMatch || tuHasNoMatch;
        return sourceEvent;
    }

    private void getTargetTextUnits() {
        try (IFilter filter = this.fcMapper.createFilter(this.targetInput.getFilterConfigId(), null);){
            this.targetTextUnitMap = new HashMap<String, ITextUnit>();
            filter.open(this.targetInput);
            while (filter.hasNext()) {
                Event event = filter.next();
                if (event.getEventType() == EventType.TEXT_UNIT) {
                    ITextUnit tu = event.getTextUnit();
                    if (!tu.getSource().hasText()) continue;
                    if (this.getAlignmentKey(tu) == null) {
                        this.LOGGER.info("Missing original identifier in target (id='{}').", (Object)tu.getId());
                        this.docHasNoMatch = true;
                        continue;
                    }
                    ITextUnit target = this.targetTextUnitMap.get(this.getAlignmentKey(tu));
                    if (target != null) {
                        String message = "Duplicate entry for {}";
                        if (target.getSource().toString().equals(tu.getSource().toString())) {
                            message = message + " (but entry text is identical)";
                        }
                        this.LOGGER.info(message, (Object)this.getAlignmentKey(tu));
                        this.docHasNoMatch = true;
                        continue;
                    }
                    this.targetTextUnitMap.put(this.getAlignmentKey(tu), tu);
                    continue;
                }
                if (event.getEventType() != EventType.START_DOCUMENT) continue;
                this.useTargetText = event.getStartDocument().isMultilingual();
            }
        }
    }

    private void promptShouldOverwrite() {
        IUserPrompt p;
        if (this.context == null || this.context.getIsNoPrompt()) {
            return;
        }
        String promptClass = this.context.getIsGui() ? "net.sf.okapi.common.ui.UserPrompt" : "net.sf.okapi.common.UserPrompt";
        try {
            p = (IUserPrompt)Class.forName(promptClass).newInstance();
            p.initialize(this.context.getUiParent(), this.context.getApplicationName());
        }
        catch (Throwable e) {
            throw new InstantiationError("Could not instantiate user prompt.");
        }
        p.promptOKCancel("A file already exists in the target location.\nSelect \"OK\" to overwrite it.");
    }
}

