/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.preprocessing.filters.common;

import java.security.InvalidParameterException;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class PreprocessingFilter
implements IFilter {
    private IFilter filter;
    private List<IPipelineStep> steps;
    private LinkedList<Event> queue;

    public PreprocessingFilter(IFilter filter, IPipelineStep ... steps) {
        if (filter == null) {
            throw new InvalidParameterException("Internal filter is not specified");
        }
        if (steps.length == 0) {
            throw new InvalidParameterException("Steps are not specified");
        }
        this.queue = new LinkedList();
        this.filter = filter;
        this.steps = ListUtil.arrayAsList(steps);
    }

    @Override
    public String getName() {
        return "okf_preprocessing";
    }

    @Override
    public String getDisplayName() {
        return "Preprocesssing Filter";
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.filter.open(input, generateSkeleton);
        this.processFilterEvents();
    }

    @Override
    public void close() {
        for (IPipelineStep step : this.steps) {
            step.cancel();
        }
        this.filter.close();
        this.queue.clear();
    }

    @Override
    public boolean hasNext() {
        if (this.filter.hasNext()) {
            return true;
        }
        return this.queue.size() > 0;
    }

    private void processFilterEvents() {
        while (this.filter.hasNext()) {
            Event e = this.filter.next();
            if (e == null) {
                return;
            }
            if (e.isNoop()) continue;
            if (e.isStartDocument()) {
                StartDocument sd = e.getStartDocument();
                sd.setFilterId(this.getName());
                sd.setFilterParameters(this.getParameters());
            }
            if (this.steps != null) {
                for (IPipelineStep step : this.steps) {
                    e = step.handleEvent(e);
                }
                if (e.isNoop()) continue;
            }
            if (e.isMultiEvent()) {
                MultiEvent me = e.getMultiEvent();
                for (Event ev : me) {
                    this.queue.add(ev);
                }
                break;
            }
            this.queue.add(e);
            break;
        }
    }

    @Override
    public Event next() {
        if (this.queue.size() > 0) {
            return this.queue.poll();
        }
        this.processFilterEvents();
        if (this.queue.size() > 0) {
            return this.queue.poll();
        }
        return null;
    }

    @Override
    public void cancel() {
        this.close();
    }

    @Override
    public IParameters getParameters() {
        return this.filter.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.filter.setParameters(params);
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.filter.setFilterConfigurationMapper(fcMapper);
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return this.filter.createSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return this.filter.createFilterWriter();
    }

    @Override
    public EncoderManager getEncoderManager() {
        return this.filter.getEncoderManager();
    }

    @Override
    public String getMimeType() {
        return this.filter.getMimeType();
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        return this.filter.getConfigurations();
    }

    protected IFilter getFilter() {
        return this.filter;
    }

    protected void setFilter(IFilter filter) {
        this.filter = filter;
    }

    protected List<IPipelineStep> getSteps() {
        return this.steps;
    }
}

