/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;

public class XMLSkeleton
implements ISkeleton {
    private IResource parent;
    private StringBuilder before;
    private String snippet;

    @Override
    public String toString() {
        return (this.before == null ? "" : this.before.toString()) + this.getSnippetString();
    }

    @Override
    public ISkeleton clone() {
        XMLSkeleton newSkel = new XMLSkeleton();
        newSkel.parent = this.parent;
        newSkel.before = new StringBuilder(this.before);
        newSkel.snippet = this.snippet;
        return newSkel;
    }

    @Override
    public void setParent(IResource parent) {
        this.parent = parent;
    }

    @Override
    public IResource getParent() {
        return this.parent;
    }

    public void add(String data) {
        if (data != null) {
            if (this.before == null) {
                this.before = new StringBuilder();
            }
            this.before.append(data);
        }
    }

    public void addValuePlaceholder(INameable referent, String propName, LocaleId locId) {
        this.add(TextFragment.makeRefMarker("$self$", propName));
    }

    public void addContentPlaceholder(ITextUnit textUnit, LocaleId locId) {
        this.add(TextFragment.makeRefMarker("$self$"));
    }

    private String getSnippetString() {
        if (this.snippet == null) {
            return "";
        }
        return this.snippet;
    }
}

