/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xliff2.Parameters;
import net.sf.okapi.filters.xliff2.X2ToOkpConverter;
import net.sf.okapi.filters.xliff2.XLIFF2FilterWriter;
import net.sf.okapi.filters.xliff2.XMLSkeleton;
import net.sf.okapi.filters.xliff2.XMLSkeletonWriter;
import net.sf.okapi.filters.xliff2.util.NotesMapper;
import net.sf.okapi.filters.xliff2.util.PropertiesMapper;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class XLIFF2Filter
implements IFilter {
    public static final String XML_SPACE = "xml:space";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private X2ToOkpConverter cvt;
    private boolean canceled;
    private XLIFFReader reader;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private EncoderManager encoderManager;
    private Stack<String> idStack;
    private XMLSkeleton skel;
    private StartDocument startDoc;
    private StartSubDocument startSubDoc;
    private String lb;
    private LinkedList<net.sf.okapi.common.Event> queue;
    private XLIFFWriter writer;
    private StringWriter writerBuffer;
    private PropertiesMapper propertiesMapper = new PropertiesMapper();

    @Override
    public String getName() {
        return "okf_xliff2";
    }

    @Override
    public String getDisplayName() {
        return "XLIFF-2 Filter (BETA)";
    }

    @Override
    public void open(RawDocument input) {
        this.canceled = false;
        input.setEncoding("UTF-8");
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectBom();
        boolean hasUTF8BOM = detector.hasUtf8Bom();
        this.lb = detector.getNewlineType().toString();
        String encoding = "UTF-8";
        if (detector.isAutodetected()) {
            encoding = detector.getEncoding();
        }
        this.srcLoc = input.getSourceLocale();
        this.trgLoc = input.getTargetLocale();
        String docName = null;
        if (input.getInputURI() != null) {
            docName = input.getInputURI().getPath();
        }
        int validation = this.params.getMaxValidation() ? 255 : 0;
        this.reader = new XLIFFReader(validation);
        this.reader.open(input.getStream());
        this.idStack = new Stack();
        this.queue = new LinkedList();
        this.skel = new XMLSkeleton();
        this.startDoc = new StartDocument(this.idStack.push("docid"));
        this.startDoc.setName(docName);
        this.startDoc.setEncoding(encoding, hasUTF8BOM);
        this.startDoc.setFilterId(this.getName());
        this.startDoc.setFilterParameters(this.getParameters());
        this.startDoc.setFilterWriter(this.createFilterWriter());
        this.startDoc.setType("application/xliff+xml");
        this.startDoc.setMimeType("application/xliff+xml");
        this.startDoc.setMultilingual(true);
        this.startDoc.setLineBreak(this.lb);
        this.startDoc.setProperty(new Property("encoding", encoding, false));
        this.skel.add("<?xml version=\"1.0\" encoding=\"");
        this.skel.addValuePlaceholder(this.startDoc, "encoding", LocaleId.EMPTY);
        this.skel.add("\"?>" + this.lb);
        this.startDoc.setSkeleton(this.skel);
        this.writer = new XLIFFWriter();
        this.writer.setLineBreak(this.lb);
        this.writer.setUseIndentation(true);
        this.writerBuffer = new StringWriter();
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
        }
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.open(input);
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
    }

    @Override
    public boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        if (this.canceled) {
            return false;
        }
        return this.reader.hasNext();
    }

    @Override
    public net.sf.okapi.common.Event next() {
        if (this.queue.isEmpty()) {
            while (!this.readNext()) {
            }
        }
        return this.queue.poll();
    }

    private boolean readNext() {
        Event x2Event = this.reader.next();
        switch (x2Event.getType()) {
            case START_DOCUMENT: {
                return false;
            }
            case START_XLIFF: {
                StartXliffData sxd = x2Event.getStartXliffData();
                this.processLocales(sxd);
                this.skel.add(this.conv(sxd));
                net.sf.okapi.common.Event event = new net.sf.okapi.common.Event(EventType.START_DOCUMENT, this.startDoc);
                this.queue.add(event);
                PropertiesMapper.setStartXliffProperties(sxd, this.startDoc);
                this.skel = new XMLSkeleton();
                if (this.params.getNeedsSegmentation()) {
                    this.queue.add(FilterUtil.createDeepenSegmentationEvent());
                }
                return true;
            }
            case START_FILE: {
                StartFileData sfd = x2Event.getStartFileData();
                this.startSubDoc = new StartSubDocument(this.idStack.peek(), sfd.getId());
                PropertiesMapper.setStartFileProperties(sfd, this.startSubDoc);
                this.queue.add(new net.sf.okapi.common.Event(EventType.START_SUBDOCUMENT, this.startSubDoc));
                this.idStack.push(sfd.getId());
                this.startSubDoc.setName(sfd.getOriginal());
                this.skel.add(this.conv(sfd));
                return false;
            }
            case MID_FILE: {
                MidFileData midFileData = x2Event.getMidFileData();
                DocumentPart documentPart = new DocumentPart();
                net.sf.okapi.common.Event event = new net.sf.okapi.common.Event(EventType.DOCUMENT_PART, documentPart);
                PropertiesMapper.setMidFileProperties(midFileData, documentPart);
                NotesMapper.setAnnotations(midFileData, documentPart);
                this.queue.add(event);
                this.skel.add(this.conv(midFileData));
                return false;
            }
            case SKELETON: {
                Skeleton skeletonData = x2Event.getSkeletonData();
                PropertiesMapper.setSkeletonProperties(skeletonData, this.startSubDoc);
                this.skel.add(this.conv(skeletonData));
                return false;
            }
            case START_GROUP: {
                StartGroupData sgd = x2Event.getStartGroupData();
                StartGroup sg = new StartGroup(this.idStack.peek(), sgd.getId());
                PropertiesMapper.setGroupProperties(sgd, sg);
                this.idStack.push(sgd.getId());
                NotesMapper.setAnnotations(sgd, sg);
                this.queue.add(new net.sf.okapi.common.Event(EventType.START_GROUP, sg, this.skel));
                this.skel = new XMLSkeleton();
                this.skel.add(this.conv(sgd));
                return true;
            }
            case TEXT_UNIT: {
                Unit unit = x2Event.getUnit();
                ITextUnit tu = this.cvt.convert(unit);
                NotesMapper.setAnnotations(unit, tu);
                if (this.params.getUseCodeFinder()) {
                    for (Segment s : tu.getAlignedSegments()) {
                        this.params.getCodeFinder().process(s.text);
                        this.params.getCodeFinder().process(tu.getTargetSegment((LocaleId)this.trgLoc, (String)s.id, (boolean)false).text);
                    }
                }
                this.createUnitSkeleton(tu, unit, this.skel);
                tu.setMimeType(this.getMimeType());
                this.queue.add(new net.sf.okapi.common.Event(EventType.TEXT_UNIT, tu, this.skel));
                this.skel = new XMLSkeleton();
                return true;
            }
            case END_GROUP: {
                Ending eg = new Ending("end" + this.idStack.pop());
                this.skel.add(this.convEndGroup());
                this.queue.add(new net.sf.okapi.common.Event(EventType.END_GROUP, eg, this.skel));
                this.skel = new XMLSkeleton();
                return true;
            }
            case END_FILE: {
                Ending esd = new Ending("end" + this.idStack.pop());
                this.skel.add(this.convEndFile());
                this.queue.add(new net.sf.okapi.common.Event(EventType.END_SUBDOCUMENT, esd, this.skel));
                this.skel = new XMLSkeleton();
                return true;
            }
            case END_XLIFF: {
                return false;
            }
            case END_DOCUMENT: {
                Ending ed = new Ending("end" + this.idStack.pop());
                this.skel.add(this.convEndDocument());
                this.queue.add(new net.sf.okapi.common.Event(EventType.END_DOCUMENT, ed, this.skel));
                this.skel = new XMLSkeleton();
                return true;
            }
            case INSIGNIFICANT_PART: {
                this.skel.add(x2Event.getInsingnificantPartData().getData());
                return false;
            }
        }
        return false;
    }

    private void createUnitSkeleton(ITextUnit tu, Unit unit, XMLSkeleton skel) {
        PropertiesMapper.setTextUnitProperties(unit, tu);
        skel.add(String.format("<unit id=\"%s\"", unit.getId()));
        if (tu.hasProperty("name")) {
            skel.add("[$$NAME$$]");
        }
        if (tu.hasProperty("canResegment")) {
            skel.add("[$$CANRESEGMENT$$]");
        }
        if (tu.hasProperty("translate")) {
            skel.add("[$$TRANSLATE$$]");
        }
        if (tu.hasProperty("srcDir")) {
            skel.add("[$$SRCDIR$$]");
        }
        if (tu.hasProperty("trgDir")) {
            skel.add("[$$TRGDIR$$]");
        }
        if (tu.hasProperty("type")) {
            skel.add("[$$TYPE$$]");
        }
        skel.add(">\n");
        skel.add("\n[$$SEGMENTS$$]\n");
        skel.add("</unit>\n");
    }

    private String conv(StartXliffData sxd) {
        this.writer.writeStartDocument(sxd, null);
        String tmp = this.writerBuffer.toString();
        this.writerBuffer.getBuffer().setLength(0);
        return tmp.substring(tmp.indexOf("<xlif"));
    }

    private String conv(StartFileData sfd) {
        this.writer.writeStartFile(sfd);
        String tmp = this.writerBuffer.toString();
        this.writerBuffer.getBuffer().setLength(0);
        return tmp;
    }

    private String conv(StartGroupData sgd) {
        this.writer.writeStartGroup(sgd);
        String tmp = this.writerBuffer.toString();
        this.writerBuffer.getBuffer().setLength(0);
        return tmp;
    }

    private String conv(MidFileData mfd) {
        this.writer.writeMidFile(mfd);
        String tmp = this.writerBuffer.toString();
        this.writerBuffer.getBuffer().setLength(0);
        return tmp;
    }

    private String conv(Skeleton skelData) {
        this.writer.writeSkeleton(skelData);
        String tmp = this.writerBuffer.toString();
        this.writerBuffer.getBuffer().setLength(0);
        return tmp;
    }

    private String convEndGroup() {
        this.writer.writeEndGroup();
        String tmp = this.writerBuffer.toString();
        this.writerBuffer.getBuffer().setLength(0);
        return tmp;
    }

    private String convEndFile() {
        this.writer.writeEndFile();
        String tmp = this.writerBuffer.toString();
        this.writerBuffer.getBuffer().setLength(0);
        return tmp;
    }

    private String convEndDocument() {
        this.writer.writeEndDocument();
        String tmp = this.writerBuffer.toString();
        this.writerBuffer.getBuffer().setLength(0);
        return tmp;
    }

    private void processLocales(StartXliffData sxd) {
        String src = sxd.getSourceLanguage();
        if (this.srcLoc != null && !this.srcLoc.equals(LocaleId.EMPTY)) {
            if (!this.srcLoc.sameLanguageAs(src)) {
                this.logger.warn("Discrepancy between expected source ({}) and source in document ({}), Using '{}'", new Object[]{this.srcLoc, src, src});
                this.srcLoc = LocaleId.fromBCP47(src);
            }
        } else {
            this.srcLoc = LocaleId.fromBCP47(src);
        }
        this.startDoc.setLocale(this.srcLoc);
        this.writer.create(this.writerBuffer, this.srcLoc.toBCP47());
        String trg = sxd.getTargetLanguage();
        if (trg != null) {
            if (this.trgLoc != null && !this.trgLoc.equals(LocaleId.EMPTY)) {
                if (!this.trgLoc.sameLanguageAs(trg)) {
                    this.logger.warn("Discrepancy between expected target ({}) and target in document ({}), Using '{}'", new Object[]{this.trgLoc, trg, trg});
                    this.trgLoc = LocaleId.fromBCP47(trg);
                }
            } else {
                this.trgLoc = LocaleId.fromBCP47(trg);
            }
        } else if (this.trgLoc == null) {
            throw new NullPointerException("Target language not set and cannot be guessed.");
        }
        this.cvt = new X2ToOkpConverter(this.trgLoc);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.queue.clear();
        this.queue.add(new net.sf.okapi.common.Event(EventType.CANCELED));
        this.close();
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new XMLSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new XLIFF2FilterWriter();
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/xliff+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getMimeType() {
        return "application/xliff+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/xliff+xml", this.getClass().getName(), "XLIFF-2", "Configuration for XLIFF-2 documents.", null, ".xlf"));
        return list;
    }
}

