/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.transtable;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.transtable.Parameters;

public class TransTableWriter
implements IFilterWriter {
    public static final String CRUMBS_PREFIX = "okpCtx";
    public static final String SUBDOCUMENT_CRUMB = "sd=";
    public static final String GROUP_CRUMB = "gp=";
    public static final String TEXTUNIT_CRUMB = "tu=";
    public static final String SEGMENT_CRUMB = "s=";
    public static final String SIGNATURE = "TransTable";
    public static final String VERSION = "V1";
    public static final String ESCAPEABLE = "\\\"abfnrtv";
    private static final String LINEBREAK = System.getProperty("line.separator");
    private Parameters params = new Parameters();
    private OutputStream output;
    private String outputPath;
    private OutputStreamWriter writer;
    private File tempFile;
    private LocaleId language;
    private String encoding;
    private String crumbs;

    @Override
    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            this.writer.close();
            this.writer = null;
            this.output.close();
            this.output = null;
            if (this.tempFile != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempFile);
                byte[] buffer = new byte[2048];
                while ((len = orig.read(buffer)) > 0) {
                    dest.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new OkapiException(err);
                }
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
            }
        }
    }

    @Override
    public String getName() {
        return "TableWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument(event);
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument();
                break;
            }
            case START_GROUP: 
            case START_SUBFILTER: {
                this.processStartGroup(event);
                break;
            }
            case END_GROUP: 
            case END_SUBFILTER: {
                this.processEndGroup(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId language, String defaultEncoding) {
        this.language = language;
        this.encoding = defaultEncoding;
    }

    @Override
    public void setOutput(String path) {
        this.close();
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.close();
        this.outputPath = null;
        this.output = output;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private void processStartDocument(Event event) {
        try {
            StartDocument sd = (StartDocument)event.getResource();
            this.createWriter(sd);
            this.writer.write(String.format("%s%s\t%s\t%s" + LINEBREAK, SIGNATURE, VERSION, sd.getLocale().toString(), this.language.toString()));
            this.crumbs = CRUMBS_PREFIX;
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing the header.", e);
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processStartSubDocument(Event event) {
        StartSubDocument ssd = (StartSubDocument)event.getResource();
        this.pushCrumb(SUBDOCUMENT_CRUMB + ssd.getId());
    }

    private void processEndSubDocument() {
        this.popCrumb();
    }

    private void processStartGroup(Event event) {
        StartGroup sg = (StartGroup)event.getResource();
        this.pushCrumb(GROUP_CRUMB + sg.getId());
    }

    private void processEndGroup(Event event) {
        this.popCrumb();
    }

    private void popCrumb() {
        int n = this.crumbs.lastIndexOf(58);
        this.crumbs = this.crumbs.substring(0, n);
    }

    private void pushCrumb(String crumb) {
        this.crumbs = this.crumbs + ":" + crumb;
    }

    private void processTextUnit(Event event) {
        try {
            ITextUnit tu = event.getTextUnit();
            if (tu.isEmpty()) {
                return;
            }
            if (this.params.getAllowSegments()) {
                this.processWithSegments(tu);
            } else {
                this.processWithoutSegments(tu);
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error writing a text unit.", e);
        }
    }

    private void processWithSegments(ITextUnit tu) {
        try {
            ISegments srcSegs = tu.getSourceSegments();
            ISegments trgSegs = null;
            TextContainer tc = tu.getTarget(this.language);
            if (tc != null) {
                trgSegs = tc.getSegments();
            }
            for (Segment srcSeg : srcSegs) {
                Segment trgSeg;
                this.writer.write("\"" + this.crumbs + ":" + TEXTUNIT_CRUMB + tu.getId() + ":" + SEGMENT_CRUMB + srcSeg.getId() + "\"\t");
                this.writeQuotedContent(srcSeg.getContent());
                this.writer.write("\t");
                if (trgSegs != null && (trgSeg = trgSegs.get(srcSeg.getId())) != null) {
                    this.writeQuotedContent(trgSeg.getContent());
                }
                this.writer.write(LINEBREAK);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing segments.", e);
        }
    }

    private void processWithoutSegments(ITextUnit tu) {
        try {
            this.writer.write("\"" + this.crumbs + ":" + TEXTUNIT_CRUMB + tu.getId() + "\"\t");
            this.writeQuotedContent(tu.getSource());
            this.writer.write("\t");
            TextContainer tc = tu.getTarget(this.language);
            if (tc != null) {
                this.writeQuotedContent(tc);
            }
            this.writer.write(LINEBREAK);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing text unit.", e);
        }
    }

    private void writeQuotedContent(TextFragment tf) {
        try {
            String tmp = GenericContent.fromFragmentToLetterCoded(tf, true);
            tmp = this.escapeIfNeeded(tmp);
            this.writer.write("\"");
            this.writer.write(tmp);
            this.writer.write("\"");
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a quoted text.", e);
        }
    }

    private void writeQuotedContent(TextContainer tc) {
        try {
            String tmp = tc.contentIsOneSegment() ? GenericContent.fromFragmentToLetterCoded(tc.getFirstContent(), true) : GenericContent.fromFragmentToLetterCoded(tc.getUnSegmentedContentCopy(), true);
            tmp = this.escapeIfNeeded(tmp);
            this.writer.write("\"");
            this.writer.write(tmp);
            this.writer.write("\"");
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a quoted text.", e);
        }
    }

    private String escapeIfNeeded(String in) {
        int prev = 0;
        StringBuilder tmp = new StringBuilder(in.length());
        block5: for (int i = 0; i < in.length(); ++i) {
            switch (in.charAt(i)) {
                case '\\': {
                    if (i < in.length() - 1 && ESCAPEABLE.indexOf(in.charAt(i + 1)) != -1) {
                        tmp.append('\\');
                        tmp.append(in.charAt(i + 1));
                        ++i;
                    } else {
                        tmp.append("\\\\");
                    }
                    prev = 0;
                    continue block5;
                }
                case '\"': {
                    if (prev != 92) {
                        tmp.append('\\');
                    }
                    tmp.append(in.charAt(i));
                    break;
                }
                case '\n': {
                    tmp.append("\\n");
                    break;
                }
                default: {
                    tmp.append(in.charAt(i));
                }
            }
            prev = in.charAt(i);
        }
        return tmp.toString();
    }

    private void createWriter(StartDocument startDoc) {
        try {
            String originalEnc;
            this.tempFile = null;
            if (this.output == null) {
                boolean useTemp = false;
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("~okapi-28_pofwTmp_", null);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.tempFile.getAbsolutePath()));
                } else {
                    Util.createDirectories(this.outputPath);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.outputPath));
                }
            }
            if ((originalEnc = startDoc.getEncoding()) == null) {
                originalEnc = Charset.defaultCharset().name();
            }
            if (this.encoding == null) {
                this.encoding = originalEnc;
            }
            this.writer = new OutputStreamWriter(this.output, this.encoding);
            boolean useUTF8BOM = false;
            if ("utf-8".equalsIgnoreCase(this.encoding) && "utf-8".equalsIgnoreCase(originalEnc)) {
                useUTF8BOM = false;
            }
            Util.writeBOMIfNeeded(this.writer, useUTF8BOM, this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }
}

