/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEvents;

class RunFonts
implements XMLEvents {
    static final String NAME = "rFonts";
    private static final int MAX_NUMBER_OF_EVENTS = 2;
    private static final int MAX_NUMBER_OF_CONTENT_CATEGORIES = 4;
    private static final EnumSet<ContentCategory> FONT_CONTENT_CATEGORIES = EnumSet.of(ContentCategory.ASCII, ContentCategory.HIGH_ANSI, ContentCategory.COMPLEX_SCRIPT, ContentCategory.EAST_ASIAN, ContentCategory.HINT);
    private static final EnumMap<ContentCategory, ContentCategory> fontThemeContentCategories = new EnumMap(ContentCategory.class);
    private static final Map<String, EnumSet<ContentCategory>> contentCategoriesByHints;
    private final XMLEventFactory eventFactory;
    private final StartElement startElement;
    private final EnumMap<ContentCategory, String> fonts;
    private final Set<ContentCategory> detectedContentCategories;

    private RunFonts(XMLEventFactory eventFactory, StartElement startElement, EnumMap<ContentCategory, String> fonts, Set<ContentCategory> detectedContentCategories) {
        this.eventFactory = eventFactory;
        this.startElement = startElement;
        this.fonts = fonts;
        this.detectedContentCategories = detectedContentCategories;
    }

    static RunFonts createRunFonts(StartElementContext startElementContext) throws XMLStreamException {
        EnumMap<ContentCategory, String> fonts = new EnumMap<ContentCategory, String>(ContentCategory.class);
        for (ContentCategory contentCategory : ContentCategory.values()) {
            fonts.put(contentCategory, XMLEventHelpers.getAttributeValue(startElementContext.getStartElement(), new QName(startElementContext.getStartElement().getName().getNamespaceURI(), contentCategory.toString(), startElementContext.getStartElement().getName().getPrefix())));
        }
        new SkippableElements.Default(new SkippableElement[0]).skip(startElementContext);
        return new RunFonts(startElementContext.getEventFactory(), startElementContext.getStartElement(), fonts, EnumSet.noneOf(ContentCategory.class));
    }

    private EnumMap<ContentCategory, String> getFonts() {
        return this.fonts;
    }

    private boolean isDetectedContentCategory(ContentCategory category) {
        return this.detectedContentCategories.contains((Object)category);
    }

    boolean containsDetectedContentCategories() {
        return !this.detectedContentCategories.isEmpty();
    }

    void addDetectedContentCategory(ContentCategory contentCategory) {
        this.detectedContentCategories.add(contentCategory);
    }

    ContentCategory getContentCategory(ContentCategory contentCategory, ContentCategory defaultContentCategory) {
        return this.fonts.get((Object)contentCategory) == null ? defaultContentCategory : contentCategory;
    }

    boolean canBeMerged(RunFonts runFonts) {
        for (ContentCategory fontContentCategory : FONT_CONTENT_CATEGORIES) {
            if (this.canContentCategoriesBeMerged(fontContentCategory, runFonts)) continue;
            return false;
        }
        return true;
    }

    private boolean canContentCategoriesBeMerged(ContentCategory contentCategory, RunFonts runFonts) {
        if (ContentCategory.HINT == contentCategory) {
            return this.canHintsBeMerged(runFonts);
        }
        ContentCategory fontThemeCategory = fontThemeContentCategories.get((Object)contentCategory);
        if (this.isDetectedContentCategory(fontThemeCategory) && runFonts.isDetectedContentCategory(fontThemeCategory)) {
            return Objects.equals(this.fonts.get((Object)fontThemeCategory), runFonts.fonts.get((Object)fontThemeCategory));
        }
        if (this.isDetectedContentCategory(fontThemeCategory) && runFonts.isDetectedContentCategory(contentCategory)) {
            return Objects.equals(this.fonts.get((Object)fontThemeCategory), runFonts.fonts.get((Object)contentCategory));
        }
        if (this.isDetectedContentCategory(contentCategory) && runFonts.isDetectedContentCategory(fontThemeCategory)) {
            return Objects.equals(this.fonts.get((Object)contentCategory), runFonts.fonts.get((Object)fontThemeCategory));
        }
        if (this.isDetectedContentCategory(contentCategory) && runFonts.isDetectedContentCategory(contentCategory)) {
            return Objects.equals(this.fonts.get((Object)contentCategory), runFonts.fonts.get((Object)contentCategory));
        }
        return true;
    }

    private boolean canHintsBeMerged(RunFonts runFonts) {
        if (null == this.fonts.get((Object)ContentCategory.HINT) && null == runFonts.fonts.get((Object)ContentCategory.HINT)) {
            return true;
        }
        if (null != this.fonts.get((Object)ContentCategory.HINT) && null != runFonts.fonts.get((Object)ContentCategory.HINT)) {
            return Objects.equals(this.fonts.get((Object)ContentCategory.HINT), runFonts.fonts.get((Object)ContentCategory.HINT));
        }
        if (null != this.fonts.get((Object)ContentCategory.HINT) && null == runFonts.fonts.get((Object)ContentCategory.HINT)) {
            return !this.containsContentCategoryFor(this.fonts.get((Object)ContentCategory.HINT));
        }
        if (null == this.fonts.get((Object)ContentCategory.HINT) && null != runFonts.fonts.get((Object)ContentCategory.HINT)) {
            return !runFonts.containsContentCategoryFor(runFonts.fonts.get((Object)ContentCategory.HINT));
        }
        return false;
    }

    private boolean containsContentCategoryFor(String hint) {
        for (ContentCategory category : contentCategoriesByHints.get(hint)) {
            if (null == this.fonts.get((Object)category)) continue;
            return true;
        }
        return false;
    }

    RunFonts merge(RunFonts runFonts) {
        EnumMap<ContentCategory, String> newFonts = new EnumMap<ContentCategory, String>(ContentCategory.class);
        for (ContentCategory category : ContentCategory.values()) {
            newFonts.put(category, this.mergeContentCategories(category, runFonts));
        }
        EnumSet<ContentCategory> newDetectedContentCategories = EnumSet.noneOf(ContentCategory.class);
        newDetectedContentCategories.addAll(this.detectedContentCategories);
        newDetectedContentCategories.addAll(runFonts.detectedContentCategories);
        return new RunFonts(this.eventFactory, this.startElement, newFonts, newDetectedContentCategories);
    }

    private String mergeContentCategories(ContentCategory contentCategory, RunFonts runFonts) {
        if (ContentCategory.HINT == contentCategory) {
            return null == this.fonts.get((Object)ContentCategory.HINT) ? runFonts.getFonts().get((Object)ContentCategory.HINT) : this.fonts.get((Object)ContentCategory.HINT);
        }
        if (Objects.equals(this.fonts.get((Object)contentCategory), runFonts.getFonts().get((Object)contentCategory))) {
            return this.fonts.get((Object)contentCategory);
        }
        if (this.isDetectedContentCategory(contentCategory)) {
            return this.fonts.get((Object)contentCategory);
        }
        if (runFonts.isDetectedContentCategory(contentCategory)) {
            return runFonts.fonts.get((Object)contentCategory);
        }
        return null;
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(2);
        events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes(this.startElement), this.startElement.getNamespaces()));
        events.add(this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces()));
        return events;
    }

    private Iterator<Attribute> getAttributes(StartElement startElement) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(4);
        for (ContentCategory category : ContentCategory.values()) {
            String value = this.fonts.get((Object)category);
            if (value == null) continue;
            attributes.add(this.eventFactory.createAttribute(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), category.toString(), value));
        }
        return attributes.iterator();
    }

    void apply(FontMappings fontMappings) {
        this.fonts.entrySet().stream().filter(e -> Objects.nonNull(e.getValue())).forEach(e -> e.setValue(fontMappings.targetFontFor((String)e.getValue())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunFonts runFonts = (RunFonts)o;
        return Objects.equals(this.fonts, runFonts.fonts);
    }

    public int hashCode() {
        return Objects.hash(this.fonts);
    }

    static {
        fontThemeContentCategories.put(ContentCategory.ASCII, ContentCategory.ASCII_THEME);
        fontThemeContentCategories.put(ContentCategory.HIGH_ANSI, ContentCategory.HIGH_ANSI_THEME);
        fontThemeContentCategories.put(ContentCategory.COMPLEX_SCRIPT, ContentCategory.COMPLEX_SCRIPT_THEME);
        fontThemeContentCategories.put(ContentCategory.EAST_ASIAN, ContentCategory.EAST_ASIAN_THEME);
        contentCategoriesByHints = new HashMap<String, EnumSet<ContentCategory>>();
        contentCategoriesByHints.put(Hint.DEFAULT.toString(), EnumSet.of(ContentCategory.HIGH_ANSI_THEME, ContentCategory.HIGH_ANSI));
        contentCategoriesByHints.put(Hint.COMPLEX_SCRIPT.toString(), EnumSet.of(ContentCategory.COMPLEX_SCRIPT_THEME, ContentCategory.COMPLEX_SCRIPT));
        contentCategoriesByHints.put(Hint.EAST_ASIAN.toString(), EnumSet.of(ContentCategory.EAST_ASIAN_THEME, ContentCategory.EAST_ASIAN));
    }

    static enum Hint {
        DEFAULT("default"),
        COMPLEX_SCRIPT("cs"),
        EAST_ASIAN("eastAsia");

        private final String value;

        private Hint(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    static enum ContentCategory {
        ASCII("ascii"),
        ASCII_THEME("asciiTheme"),
        HIGH_ANSI("hAnsi"),
        HIGH_ANSI_THEME("hAnsiTheme"),
        COMPLEX_SCRIPT("cs"),
        COMPLEX_SCRIPT_THEME("cstheme"),
        EAST_ASIAN("eastAsia"),
        EAST_ASIAN_THEME("eastAsiaTheme"),
        HINT("hint");

        private final String value;

        private ContentCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

