/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

public class Parameters
extends StringParameters
implements ISimplifierRulesParameters {
    private static final String EXTRACTBODYPAGES = "extractBodyPages";
    private static final String EXTRACTREFERENCEPAGES = "extractReferencePages";
    private static final String EXTRACTMASTERPAGES = "extractMasterPages";
    private static final String EXTRACTHIDDENPAGES = "extractHiddenPages";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String EXTRACTVARIABLES = "extractVariables";
    private static final String EXTRACTINDEXMARKERS = "extractIndexMarkers";
    private static final String EXTRACTLINKS = "extractLinks";
    private static final String EXTRACT_PGF_NUM_FORMATS_INLINE = "extractPgfNumFormatsInline";
    private static final String EXTRACT_REFERENCE_FORMATS = "extractReferenceFormats";
    private InlineCodeFinder codeFinder;

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getCodeFinderData() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderData(String data) {
        this.codeFinder.fromString(data);
    }

    public boolean getExtractReferencePages() {
        return this.getBoolean(EXTRACTREFERENCEPAGES);
    }

    public void setExtractReferencePages(boolean extractReferencePages) {
        this.setBoolean(EXTRACTREFERENCEPAGES, extractReferencePages);
    }

    public boolean getExtractMasterPages() {
        return this.getBoolean(EXTRACTMASTERPAGES);
    }

    public void setExtractMasterPages(boolean extractMasterPages) {
        this.setBoolean(EXTRACTMASTERPAGES, extractMasterPages);
    }

    public boolean getExtractHiddenPages() {
        return this.getBoolean(EXTRACTHIDDENPAGES);
    }

    public void setExtractHiddenPages(boolean extractHiddenPages) {
        this.setBoolean(EXTRACTHIDDENPAGES, extractHiddenPages);
    }

    public boolean getExtractBodyPages() {
        return this.getBoolean(EXTRACTBODYPAGES);
    }

    public void setExtractBodyPages(boolean extractBodyPages) {
        this.setBoolean(EXTRACTBODYPAGES, extractBodyPages);
    }

    public boolean getExtractVariables() {
        return this.getBoolean(EXTRACTVARIABLES);
    }

    public void setExtractVariables(boolean extractVariables) {
        this.setBoolean(EXTRACTVARIABLES, extractVariables);
    }

    public boolean getExtractIndexMarkers() {
        return this.getBoolean(EXTRACTINDEXMARKERS);
    }

    public void setExtractIndexMarkers(boolean extractIndexMarkers) {
        this.setBoolean(EXTRACTINDEXMARKERS, extractIndexMarkers);
    }

    public boolean getExtractLinks() {
        return this.getBoolean(EXTRACTLINKS);
    }

    public void setExtractLinks(boolean extractLinks) {
        this.setBoolean(EXTRACTLINKS, extractLinks);
    }

    public boolean getExtractPgfNumFormatsInline() {
        return this.getBoolean(EXTRACT_PGF_NUM_FORMATS_INLINE);
    }

    public void setExtractPgfNumFormatsInline(boolean extractPgfNumFormatsInline) {
        this.setBoolean(EXTRACT_PGF_NUM_FORMATS_INLINE, extractPgfNumFormatsInline);
    }

    public boolean getExtractReferenceFormats() {
        return this.getBoolean(EXTRACT_REFERENCE_FORMATS);
    }

    public void setExtractReferenceFormats(boolean extractReferenceFormats) {
        this.setBoolean(EXTRACT_REFERENCE_FORMATS, extractReferenceFormats);
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public void reset() {
        super.reset();
        this.setExtractBodyPages(true);
        this.setExtractMasterPages(true);
        this.setExtractReferencePages(true);
        this.setExtractHiddenPages(true);
        this.setExtractVariables(true);
        this.setExtractIndexMarkers(true);
        this.setExtractLinks(false);
        this.setExtractPgfNumFormatsInline(false);
        this.setExtractReferenceFormats(false);
        this.setUseCodeFinder(true);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("H: \u2022\\\\t<n\\><n+\\><n=1\\><a\\><a+\\><a=1\\><A\\><A+\\><A=1\\><r\\><r+\\><r=1\\><R\\><R+\\><R=1\\><$volnum\\><$chapnum\\><$sectionnum\\><$subsectionnum\\>< \\><zenkaku a\\><zenkaku a+\\><zenkaku a=1\\><zenkaku A\\><zenkaku A+\\><zenkaku A=1\\><zenkaku n\\><zenkaku n+\\><zenkaku n=1\\><kanji kazu\\><kanji kazu+\\><kanji kazu=1\\><kanji n\\><kanji n+\\><kanji n=1\\><daiji\\><daiji+\\><daiji=1\\><hira iroha\\><hira iroha+\\><hira iroha=1\\><kata iroha\\><kata iroha+\\><kata iroha=1\\><hira gojuon\\><hira gojuon+\\><hira gojuon=1\\><kata gojuon\\><kata gojuon+\\><kata gojuon=1\\><full-width a\\><full-width a+\\><full-width a=1\\><full-width A\\><full-width A+\\><full-width A=1\\><full-width n\\><full-width n+\\><full-width n=1\\><chinese n\\><chinese n+\\><chinese n=1\\><Indic n\\><Indic n=1\\><Indic n+\\><Farsi n\\><Farsi n=1\\><Farsi n+\\><Farsi a\\><Farsi a=1\\><Farsi a+\\><Hebrew n\\><Hebrew n=1\\><Hebrew n+\\><Hebrew a\\><Hebrew a=1\\><Hebrew a+\\><Abjad n\\><Abjad n=1\\><Abjad n+\\><Alif Ba Ta n\\><Alif Ba Ta n=1\\><Alif Ba Ta n+\\><Thai n\\><Thai n=1\\><Thai n+\\><Thai a\\><Thai a=1\\><Thai a+\\> text <$varName\\> text <$varName[PgfTag]\\> <Default \u00b6 Font\\>");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("^[A-Z]{1}:");
        this.codeFinder.addRule("\u2022");
        this.codeFinder.addRule("\\\\t");
        this.codeFinder.addRule("<[naArR ]{1}[+]*\\>");
        this.codeFinder.addRule("<[naArR]{1}=[0-9]+\\>");
        this.codeFinder.addRule("<\\$.*?>");
        this.codeFinder.addRule("<Default \u00b6 Font\\>");
        this.codeFinder.addRule("<(zenkaku|kanji|full-width|chinese|Indic|Farsi|Hebrew|Abjad|Alif Ba Ta|Thai) [naA]{1}[+]*\\>");
        this.codeFinder.addRule("<(zenkaku|kanji|full-width|chinese|Indic|Farsi|Hebrew|Abjad|Alif Ba Ta|Thai) [naA]{1}=[0-9]+\\>");
        this.codeFinder.addRule("<(kanji kazu|daiji|hira iroha|kata iroha|hira gojuon|kata gojuon)[+]*\\>");
        this.codeFinder.addRule("<(kanji kazu|daiji|hira iroha|kata iroha|hira gojuon|kata gojuon)=[0-9]+\\>");
        this.setSimplifierRules(null);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }
}

