/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.StyleDefinition;

interface StyleDefinitionsReader {
    public StartDocument startDocument() throws XMLStreamException;

    public StartElement startElement() throws XMLStreamException;

    public StyleDefinition.Group rootCharacterStyleGroup() throws XMLStreamException;

    public StyleDefinition.Group rootParagraphStyleGroup() throws XMLStreamException;

    public List<StyleDefinition.Style> tablesOfContents() throws XMLStreamException;

    public StyleDefinition.Group rootCellStyleGroup() throws XMLStreamException;

    public StyleDefinition.Group rootTableStyleGroup() throws XMLStreamException;

    public StyleDefinition.Group rootObjectStyleGroup() throws XMLStreamException;

    public List<StyleDefinition.Style> trapPresets() throws XMLStreamException;

    public EndElement endElement() throws XMLStreamException;

    public EndDocument endDocument() throws XMLStreamException;

    public static class Cached
    implements StyleDefinitionsReader {
        private final Default defaultReader;
        private StartDocument startDocument;
        private StartElement startElement;
        private StyleDefinition.Group rootCharacterStyleGroup;
        private StyleDefinition.Group rootParagraphStyleGroup;
        private List<StyleDefinition.Style> tablesOfContents;
        private StyleDefinition.Group rootCellStyleGroup;
        private StyleDefinition.Group rootTableStyleGroup;
        private StyleDefinition.Group rootObjectStyleGroup;
        private List<StyleDefinition.Style> trapPresets;
        private EndElement endElement;
        private EndDocument endDocument;

        Cached(Default defaultReader) {
            this.defaultReader = defaultReader;
        }

        @Override
        public StartDocument startDocument() throws XMLStreamException {
            if (null == this.startDocument) {
                this.startDocument = this.defaultReader.startDocument();
            }
            return this.startDocument;
        }

        @Override
        public StartElement startElement() throws XMLStreamException {
            if (null == this.startDocument) {
                this.startDocument();
            }
            if (null == this.startElement) {
                this.startElement = this.defaultReader.startElement();
            }
            return this.startElement;
        }

        @Override
        public StyleDefinition.Group rootCharacterStyleGroup() throws XMLStreamException {
            if (null == this.startElement) {
                this.startElement();
            }
            if (null == this.rootCharacterStyleGroup) {
                this.rootCharacterStyleGroup = this.defaultReader.rootCharacterStyleGroup();
            }
            return this.rootCharacterStyleGroup;
        }

        @Override
        public StyleDefinition.Group rootParagraphStyleGroup() throws XMLStreamException {
            if (null == this.rootCharacterStyleGroup) {
                this.rootCharacterStyleGroup();
            }
            if (null == this.rootParagraphStyleGroup) {
                this.rootParagraphStyleGroup = this.defaultReader.rootParagraphStyleGroup();
            }
            return this.rootParagraphStyleGroup;
        }

        @Override
        public List<StyleDefinition.Style> tablesOfContents() throws XMLStreamException {
            if (null == this.rootParagraphStyleGroup) {
                this.rootParagraphStyleGroup();
            }
            if (null == this.tablesOfContents) {
                this.tablesOfContents = this.defaultReader.tablesOfContents();
            }
            return this.tablesOfContents;
        }

        @Override
        public StyleDefinition.Group rootCellStyleGroup() throws XMLStreamException {
            if (null == this.tablesOfContents) {
                this.tablesOfContents();
            }
            if (null == this.rootCellStyleGroup) {
                this.rootCellStyleGroup = this.defaultReader.rootCellStyleGroup();
            }
            return this.rootCellStyleGroup;
        }

        @Override
        public StyleDefinition.Group rootTableStyleGroup() throws XMLStreamException {
            if (null == this.rootCellStyleGroup) {
                this.rootCellStyleGroup();
            }
            if (null == this.rootTableStyleGroup) {
                this.rootTableStyleGroup = this.defaultReader.rootTableStyleGroup();
            }
            return this.rootTableStyleGroup;
        }

        @Override
        public StyleDefinition.Group rootObjectStyleGroup() throws XMLStreamException {
            if (null == this.rootTableStyleGroup) {
                this.rootTableStyleGroup();
            }
            if (null == this.rootObjectStyleGroup) {
                this.rootObjectStyleGroup = this.defaultReader.rootObjectStyleGroup();
            }
            return this.rootObjectStyleGroup;
        }

        @Override
        public List<StyleDefinition.Style> trapPresets() throws XMLStreamException {
            if (null == this.rootObjectStyleGroup) {
                this.rootObjectStyleGroup();
            }
            if (null == this.trapPresets) {
                this.trapPresets = this.defaultReader.trapPresets();
            }
            return this.trapPresets;
        }

        @Override
        public EndElement endElement() throws XMLStreamException {
            if (null == this.trapPresets) {
                this.trapPresets();
            }
            if (null == this.endElement) {
                this.endElement = this.defaultReader.endElement();
            }
            return this.endElement;
        }

        @Override
        public EndDocument endDocument() throws XMLStreamException {
            if (null == this.endElement) {
                this.endElement();
            }
            if (null == this.endDocument) {
                this.endDocument = this.defaultReader.endDocument();
            }
            return this.endDocument;
        }
    }

    public static class Default
    implements StyleDefinitionsReader {
        private static final String UNEXPECTED_STRUCTURE = "Unexpected styles structure: %s";
        private static final String STYLES = "Styles";
        private static final String CHARACTER_STYLE = "CharacterStyle";
        private static final String CHARACTER_STYLE_GROUP = "CharacterStyle".concat("Group");
        private static final String ROOT_CHARACTER_STYLE_GROUP = "Root".concat(CHARACTER_STYLE_GROUP);
        private static final String PARAGRAPH_STYLE = "ParagraphStyle";
        private static final String PARAGRAPH_STYLE_GROUP = "ParagraphStyle".concat("Group");
        private static final String ROOT_PARAGRAPH_STYLE_GROUP = "Root".concat(PARAGRAPH_STYLE_GROUP);
        private static final String TABLE_OF_CONTENT_STYLE = "TOCStyle";
        private static final String TABLE_OF_CONTENT_STYLE_ENTRY = "TOCStyle".concat("Entry");
        private static final String CELL_STYLE = "CellStyle";
        private static final String CELL_STYLE_GROUP = "CellStyle".concat("Group");
        private static final String ROOT_CELL_STYLE_GROUP = "Root".concat(CELL_STYLE_GROUP);
        private static final String TABLE_STYLE = "TableStyle";
        private static final String TABLE_STYLE_GROUP = "TableStyle".concat("Group");
        private static final String ROOT_TABLE_STYLE_GROUP = "Root".concat(TABLE_STYLE_GROUP);
        private static final String OBJECT_STYLE = "ObjectStyle";
        private static final String OBJECT_STYLE_GROUP = "ObjectStyle".concat("Group");
        private static final String ROOT_OBJECT_STYLE_GROUP = "Root".concat(OBJECT_STYLE_GROUP);
        private static final String TRAP_PRESET = "TrapPreset";
        private final XMLEventReader eventReader;
        private final XMLEventFactory eventFactory;
        private StartElement rootCellStyleGroupStartElement;
        private EndElement endElement;

        Default(XMLEventReader eventReader, XMLEventFactory eventFactory) {
            this.eventReader = eventReader;
            this.eventFactory = eventFactory;
        }

        @Override
        public StartDocument startDocument() throws XMLStreamException {
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (!event.isStartDocument()) continue;
                return (StartDocument)event;
            }
            throw new IllegalStateException(String.format(UNEXPECTED_STRUCTURE, "the start document event is absent"));
        }

        @Override
        public StartElement startElement() throws XMLStreamException {
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (!event.isStartElement() || !STYLES.equals(event.asStartElement().getName().getLocalPart())) continue;
                return event.asStartElement();
            }
            throw new IllegalStateException(String.format(UNEXPECTED_STRUCTURE, "the start element event is absent"));
        }

        @Override
        public StyleDefinition.Group rootCharacterStyleGroup() throws XMLStreamException {
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (!event.isStartElement() || !ROOT_CHARACTER_STYLE_GROUP.equals(event.asStartElement().getName().getLocalPart())) continue;
                StyleDefinition.Group.Default group = new StyleDefinition.Group.Default(event.asStartElement(), CHARACTER_STYLE, CHARACTER_STYLE_GROUP, new LinkedList<StyleDefinition.Style>(), new LinkedList<StyleDefinition.Group>(), this.eventFactory);
                group.from(this.eventReader);
                return group;
            }
            throw new IllegalStateException(String.format(UNEXPECTED_STRUCTURE, "the root character style group is absent"));
        }

        @Override
        public StyleDefinition.Group rootParagraphStyleGroup() throws XMLStreamException {
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (!event.isStartElement() || !ROOT_PARAGRAPH_STYLE_GROUP.equals(event.asStartElement().getName().getLocalPart())) continue;
                StyleDefinition.Group.Default group = new StyleDefinition.Group.Default(event.asStartElement(), PARAGRAPH_STYLE, PARAGRAPH_STYLE_GROUP, new LinkedList<StyleDefinition.Style>(), new LinkedList<StyleDefinition.Group>(), this.eventFactory);
                group.from(this.eventReader);
                return group;
            }
            throw new IllegalStateException(String.format(UNEXPECTED_STRUCTURE, "the root paragraph style group is absent"));
        }

        @Override
        public List<StyleDefinition.Style> tablesOfContents() throws XMLStreamException {
            LinkedList<StyleDefinition.Style> tablesOfContents = new LinkedList<StyleDefinition.Style>();
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (event.isStartElement() && TABLE_OF_CONTENT_STYLE.equals(event.asStartElement().getName().getLocalPart())) {
                    StyleDefinition.Style.Default group = new StyleDefinition.Style.Default(event.asStartElement(), new LinkedList<Element>(), this.eventFactory);
                    group.from(this.eventReader);
                    tablesOfContents.add(group);
                }
                if (!event.isStartElement() || !ROOT_CELL_STYLE_GROUP.equals(event.asStartElement().getName().getLocalPart())) continue;
                this.rootCellStyleGroupStartElement = event.asStartElement();
                break;
            }
            return tablesOfContents;
        }

        @Override
        public StyleDefinition.Group rootCellStyleGroup() throws XMLStreamException {
            if (null != this.rootCellStyleGroupStartElement) {
                StyleDefinition.Group.Default group = new StyleDefinition.Group.Default(this.rootCellStyleGroupStartElement, CELL_STYLE, CELL_STYLE_GROUP, new LinkedList<StyleDefinition.Style>(), new LinkedList<StyleDefinition.Group>(), this.eventFactory);
                group.from(this.eventReader);
                return group;
            }
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (!event.isStartElement() || !ROOT_CELL_STYLE_GROUP.equals(event.asStartElement().getName().getLocalPart())) continue;
                StyleDefinition.Group.Default group = new StyleDefinition.Group.Default(event.asStartElement(), CELL_STYLE, CELL_STYLE_GROUP, new LinkedList<StyleDefinition.Style>(), new LinkedList<StyleDefinition.Group>(), this.eventFactory);
                group.from(this.eventReader);
                return group;
            }
            throw new IllegalStateException(String.format(UNEXPECTED_STRUCTURE, "the root cell style group is absent"));
        }

        @Override
        public StyleDefinition.Group rootTableStyleGroup() throws XMLStreamException {
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (!event.isStartElement() || !ROOT_TABLE_STYLE_GROUP.equals(event.asStartElement().getName().getLocalPart())) continue;
                StyleDefinition.Group.Default group = new StyleDefinition.Group.Default(event.asStartElement(), TABLE_STYLE, TABLE_STYLE_GROUP, new LinkedList<StyleDefinition.Style>(), new LinkedList<StyleDefinition.Group>(), this.eventFactory);
                group.from(this.eventReader);
                return group;
            }
            throw new IllegalStateException(String.format(UNEXPECTED_STRUCTURE, "the root table style group is absent"));
        }

        @Override
        public StyleDefinition.Group rootObjectStyleGroup() throws XMLStreamException {
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (!event.isStartElement() || !ROOT_OBJECT_STYLE_GROUP.equals(event.asStartElement().getName().getLocalPart())) continue;
                StyleDefinition.Group.Default group = new StyleDefinition.Group.Default(event.asStartElement(), OBJECT_STYLE, OBJECT_STYLE_GROUP, new LinkedList<StyleDefinition.Style>(), new LinkedList<StyleDefinition.Group>(), this.eventFactory);
                group.from(this.eventReader);
                return group;
            }
            throw new IllegalStateException(String.format(UNEXPECTED_STRUCTURE, "the root object style group is absent"));
        }

        @Override
        public List<StyleDefinition.Style> trapPresets() throws XMLStreamException {
            LinkedList<StyleDefinition.Style> trapPresets = new LinkedList<StyleDefinition.Style>();
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (event.isStartElement() && TRAP_PRESET.equals(event.asStartElement().getName().getLocalPart())) {
                    StyleDefinition.Style.Default style = new StyleDefinition.Style.Default(event.asStartElement(), new LinkedList<Element>(), this.eventFactory);
                    style.from(this.eventReader);
                    trapPresets.add(style);
                }
                if (!event.isEndElement() || !STYLES.equals(event.asEndElement().getName().getLocalPart())) continue;
                this.endElement = event.asEndElement();
                break;
            }
            return trapPresets;
        }

        @Override
        public EndElement endElement() throws XMLStreamException {
            if (null != this.endElement) {
                return this.endElement;
            }
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (!event.isEndElement() || !STYLES.equals(event.asEndElement().getName().getLocalPart())) continue;
                return event.asEndElement();
            }
            throw new IllegalStateException(String.format(UNEXPECTED_STRUCTURE, "the end element event is absent"));
        }

        @Override
        public EndDocument endDocument() throws XMLStreamException {
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (!event.isEndDocument()) continue;
                return (EndDocument)event;
            }
            throw new IllegalStateException(String.format(UNEXPECTED_STRUCTURE, "the end document event is absent"));
        }
    }
}

