/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import net.sf.okapi.common.DefaultLocalePair;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.idml.MarkupZipSkeleton;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.ReferenceableEventsMerger;
import net.sf.okapi.filters.idml.ReferenceableEventsWriter;
import net.sf.okapi.filters.idml.StyleRangeEventsGenerator;
import net.sf.okapi.filters.idml.SubDocumentWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDMLFilterWriter
implements IFilterWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Parameters parameters;
    private final XMLOutputFactory outputFactory;
    private final XMLEventFactory eventFactory;
    private final String encoding;
    private final String lineBreak;
    private String outputPath;
    private ZipFile zipOriginal;
    private ZipOutputStream zipOutputStream;
    private byte[] buffer;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private File tempFile;
    private EncoderManager encoderManager;
    private ZipEntry subDocEntry;
    private IFilterWriter subDocWriter;
    private TreeMap<Integer, SubDocumentValues> tmSubDoc = new TreeMap();
    private int ndxSubDoc = 0;
    private OutputStream outputStream;

    IDMLFilterWriter(Parameters parameters, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, String encoding, String lineBreak) {
        this.parameters = parameters;
        this.outputFactory = outputFactory;
        this.eventFactory = eventFactory;
        this.encoding = encoding;
        this.lineBreak = lineBreak;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.zipOutputStream == null) {
            return;
        }
        try {
            if (this.zipOriginal != null) {
                this.zipOriginal.close();
                this.zipOriginal = null;
            }
            this.zipOutputStream.close();
            this.zipOutputStream = null;
            if (this.tempFile != null) {
                StreamUtil.copy((InputStream)new FileInputStream(this.tempFile), this.outputPath);
                this.tempFile.delete();
            }
            this.buffer = null;
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing IDML output.\n" + e.getMessage(), e);
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public String getName() {
        return "IDMLFilterWriter";
    }

    @Override
    public IParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event.getStartDocument());
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument((StartSubDocument)event.getResource());
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument((Ending)event.getResource());
                break;
            }
            case TEXT_UNIT: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: {
                try {
                    this.subDocWriter.handleEvent(event);
                    break;
                }
                catch (Throwable e) {
                    String mess = e.getMessage();
                    throw new OkapiNotImplementedException(mess, e);
                }
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.targetLocale = locale;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    private void processStartDocument(StartDocument res) {
        try {
            this.sourceLocale = res.getLocale();
            ZipFile zipFile = ((ZipSkeleton)res.getSkeleton()).getOriginal();
            this.zipOriginal = new ZipFile(new File(zipFile.getName()), 1);
            File tempZip = null;
            boolean useTemp = false;
            OutputStream os = this.outputStream;
            if (this.outputStream == null) {
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    tempZip = File.createTempFile("~okapi-22_idmlTmpZip_", null);
                    os = new FileOutputStream(tempZip.getAbsolutePath());
                } else {
                    Util.createDirectories(this.outputPath);
                    os = new FileOutputStream(this.outputPath);
                }
            }
            this.zipOutputStream = new ZipOutputStream(os);
            this.buffer = new byte[2048];
        }
        catch (IOException e) {
            throw new OkapiIOException("Error creating output IDML.\n" + e.getMessage(), e);
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processDocumentPart(Event event) {
        DocumentPart documentPart = (DocumentPart)event.getResource();
        if (!(documentPart.getSkeleton() instanceof ZipSkeleton)) {
            this.subDocWriter.handleEvent(event);
            return;
        }
        ZipSkeleton skeleton = (ZipSkeleton)documentPart.getSkeleton();
        if (skeleton instanceof MarkupZipSkeleton) {
            ((MarkupZipSkeleton)skeleton).markup().apply(this.parameters.fontMappings().applicableTo(new DefaultLocalePair(this.sourceLocale, this.targetLocale)));
        }
        try {
            this.zipOutputStream.putNextEntry(new ZipEntry(skeleton.getEntry().getName()));
            String modifiedContents = skeleton.getModifiedContents();
            if (modifiedContents != null) {
                this.zipOutputStream.write(modifiedContents.getBytes(this.encoding));
            } else {
                int len;
                InputStream input = this.zipOriginal.getInputStream(skeleton.getEntry());
                while ((len = input.read(this.buffer)) > 0) {
                    this.zipOutputStream.write(this.buffer, 0, len);
                }
                input.close();
            }
            this.zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing zip file entry.");
        }
    }

    private void processStartSubDocument(StartSubDocument res) {
        ++this.ndxSubDoc;
        try {
            this.tempFile = File.createTempFile("~okapi-22_idmlTmp" + this.ndxSubDoc + "_", null);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error opening temporary zip output file.");
        }
        this.subDocEntry = ((ZipSkeleton)res.getSkeleton()).getEntry();
        this.subDocWriter = new SubDocumentWriter(this.parameters, this.outputFactory, this.encoding, this.tempFile.getAbsolutePath(), new ReferenceableEventsWriter(new ReferenceableEventsMerger(this.eventFactory, new DefaultLocalePair(this.sourceLocale, this.targetLocale), this.parameters.fontMappings()), new StyleRangeEventsGenerator(this.eventFactory)));
        StartDocument sd = new StartDocument("sd");
        sd.setLineBreak(this.lineBreak);
        sd.setSkeleton(res.getSkeleton());
        sd.setLocale(this.sourceLocale);
        this.subDocWriter.handleEvent(new Event(EventType.START_DOCUMENT, sd));
        SubDocumentValues subDocumentValues = new SubDocumentValues(this.subDocEntry, this.subDocWriter, this.tempFile);
        this.tmSubDoc.put(this.ndxSubDoc, subDocumentValues);
    }

    private void processEndSubDocument(Ending res) {
        try {
            int len;
            SubDocumentValues subDocumentValues = this.tmSubDoc.get(this.ndxSubDoc--);
            this.subDocWriter = subDocumentValues.getFilterWriter();
            this.subDocEntry = subDocumentValues.getZipEntry();
            this.tempFile = subDocumentValues.getTempFile();
            this.subDocWriter.handleEvent(new Event(EventType.END_DOCUMENT, res));
            this.subDocWriter.close();
            this.zipOutputStream.putNextEntry(new ZipEntry(this.subDocEntry.getName()));
            FileInputStream input = new FileInputStream(this.tempFile);
            while ((len = ((InputStream)input).read(this.buffer)) > 0) {
                this.zipOutputStream.write(this.buffer, 0, len);
            }
            ((InputStream)input).close();
            this.zipOutputStream.closeEntry();
            this.tempFile.delete();
            this.tempFile = null;
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing zip output file.");
        }
    }

    private static class SubDocumentValues {
        private final ZipEntry zipEntry;
        private final IFilterWriter filterWriter;
        private final File tempFile;

        SubDocumentValues(ZipEntry zipEntry, IFilterWriter filterWriter, File tempFile) {
            this.zipEntry = zipEntry;
            this.filterWriter = filterWriter;
            this.tempFile = tempFile;
        }

        ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        IFilterWriter getFilterWriter() {
            return this.filterWriter;
        }

        File getTempFile() {
            return this.tempFile;
        }
    }
}

