/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.bifile;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.bifile.Parameters;
import net.sf.okapi.connectors.pensieve.PensieveTMConnector;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.tmimport.TMImportStep;

public class BilingualFileConnector
extends PensieveTMConnector {
    private Parameters params = new Parameters();
    private Path tmpTm;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private boolean inited = false;

    @Override
    public String getName() {
        return "Bilingual File";
    }

    @Override
    public String getSettingsDisplay() {
        return "File: " + (Util.isEmpty(this.params.getBiFile()) ? "<To be specified>" : this.params.getBiFile());
    }

    @Override
    public int query(String plainText) {
        if (!this.inited) {
            this.init();
        }
        return super.query(plainText);
    }

    @Override
    public int query(TextFragment text) {
        if (!this.inited) {
            this.init();
        }
        return super.query(text);
    }

    private void init() {
        this.makeTempTM();
        net.sf.okapi.connectors.pensieve.Parameters p = new net.sf.okapi.connectors.pensieve.Parameters();
        p.setDbDirectory(this.tmpTm.toString());
        super.setParameters(p);
        super.open();
        this.inited = true;
    }

    private void makeTempTM() {
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(fcMapper, false, true);
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(fcMapper);
        driver.addStep(new RawDocumentToFilterEventsStep());
        TMImportStep tmImport = new TMImportStep();
        driver.addStep(tmImport);
        try {
            this.tmpTm = Files.createTempDirectory("okapi-connector-bitext", new FileAttribute[0]).toAbsolutePath();
        }
        catch (IOException e) {
            throw new OkapiIOException("Could not create temp file for Pensieve TM.", e);
        }
        net.sf.okapi.steps.tmimport.Parameters p = tmImport.getParameters();
        p.setTmDirectory(this.tmpTm.toString());
        File file = new File(this.params.getBiFile());
        if (!file.exists()) {
            throw new OkapiBadStepInputException("Bilingual file for leveraging not found.");
        }
        FilterConfiguration fc = fcMapper.getDefaultConfigurationFromExtension(Util.getExtension(file.getName()));
        if (fc == null) {
            throw new OkapiBadStepInputException("Could not auto-detect filter configuration for bilingual input file.");
        }
        try (RawDocument rawDoc = new RawDocument(file.toURI(), this.params.getInputEncoding(), this.sourceLocale, this.targetLocale, fc.configId);){
            driver.addBatchItem(rawDoc, (URI)null, (String)null);
            driver.processBatch();
            driver.clearItems();
        }
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        super.close();
        if (!this.inited || this.tmpTm == null) {
            return;
        }
        File dir = this.tmpTm.toFile();
        if (!dir.exists()) {
            return;
        }
        try {
            for (File f : dir.listFiles()) {
                f.delete();
            }
            dir.delete();
        }
        catch (Exception e) {
            throw new OkapiIOException("Could not clean up temporary TM.", e);
        }
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        super.setLanguages(sourceLocale, targetLocale);
        this.sourceLocale = sourceLocale;
        this.targetLocale = targetLocale;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }
}

