/* JsonParser.java */
/* Generated By:JavaCC: Do not edit this line. JsonParser.java */
package net.sf.okapi.filters.json.parser;
import java.util.ArrayList;
import java.util.List;

/**
//* Basic JSON parser.
*/
public class JsonParser implements JsonParserConstants {
  private IJsonHandler handler = null;

  private JsonValueTypes valueType = JsonValueTypes.DEFAULT;

  public void setHandler(IJsonHandler handler)
  {
    this.handler = handler;
  }

  public void parse() throws ParseException
  {
    handler.handleStart();
    json();
    if (!ensureEOF()) throw new ParseException("Expected EOF, but still had content to parse");
    handler.handleEnd();
  }

  public int getLine()
  {
    return jj_input_stream.line;
  }

  public int getColumn()
  {
    return jj_input_stream.column;
  }

  public void handleIgnorable(Token t)
  {
    List < Token > specialTokenList = getSpecialTokensBefore(t);
    if (specialTokenList != null)
    {
      for (Token st : specialTokenList)
      {
        switch (st.kind)
        {
          case JsonParserConstants.C_SINGLE_COMMENT:
          case JsonParserConstants.SH_SINGLE_COMMENT:
            handler.handleComment(st.image);
            break;
          case JsonParserConstants.C_MULTILINE_COMMENT_END:
            handler.handleComment(token_source.multiLineComment.toString());
            token_source.multiLineComment.setLength(0);
            break;
          case JsonParserConstants.HTML_MULTILINE_COMMENT_END:
            handler.handleComment("<!--"+st.image);
            break;
          case JsonParserConstants.WHITESPACE:
            handler.handleWhitespace(st.image);
            break;
        }
      }
    }
  }

  private List < Token > getSpecialTokensBefore(Token t)
  {
    if (t.specialToken == null) return null;
    List < Token > specialTokensList = new ArrayList<>();
    // The above statement determines that there are no special tokens
    // and returns control to the caller.
    Token tmp_t = t.specialToken;
    while (tmp_t.specialToken != null) tmp_t = tmp_t.specialToken;
    // The above line walks back the special token chain until it
    // reaches the first special token after the previous regular
    // token.
    while (tmp_t != null)
    {
      specialTokensList.add(tmp_t);
      tmp_t = tmp_t.next;
    }
    // The above loop now walks the special token chain in the forward
    // direction
    return specialTokensList;
  }

  private JsonKeyTypes getKeyType(Token nextToken)
  {
     switch (nextToken.kind)
        {
          case JsonParserConstants.BRACE_OPEN:
            return JsonKeyTypes.OBJECT;
          case JsonParserConstants.BRACKET_OPEN:
            return JsonKeyTypes.LIST;
          default:
            return JsonKeyTypes.VALUE;
        }
  }

  private static String substringBefore(String str, char delim)
  {
    int pos = str.indexOf(delim);
    if (pos == - 1) return str;
    return str.substring(0, pos);
  }

  final public boolean ensureEOF() throws ParseException {
    jj_consume_token(0);
return true;
}

  final public void json() throws ParseException {
handleIgnorable(getToken(1));
    switch (jj_nt.kind) {
    case BRACE_OPEN:{
      object();
      break;
      }
    case BRACKET_OPEN:{
      list();
      break;
      }
    case NUMBER:
    case TRUE:
    case FALSE:
    case NULL:
    case SYMBOL:
    case STRING_SINGLE_EMPTY:
    case STRING_DOUBLE_EMPTY:
    case STRING_SINGLE_NONEMPTY:
    case STRING_DOUBLE_NONEMPTY:{
      value();
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
handleIgnorable(getToken(1));
}

  final public void object() throws ParseException {String key;
    jj_consume_token(BRACE_OPEN);
handler.handleObjectStart();
    switch (jj_nt.kind) {
    case NUMBER:
    case TRUE:
    case FALSE:
    case NULL:
    case SYMBOL:
    case STRING_SINGLE_EMPTY:
    case STRING_DOUBLE_EMPTY:
    case STRING_SINGLE_NONEMPTY:
    case STRING_DOUBLE_NONEMPTY:{
      key = objectKey();
handleIgnorable(token);
      handler.handleKey(key, valueType, getKeyType(getToken(2)));
      valueType = JsonValueTypes.DEFAULT;
      handleIgnorable(getToken(1));
      jj_consume_token(COLON);
handler.handleSeparator(token.image);
      json();
      label_1:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          break label_1;
        }
        jj_consume_token(COMMA);
handleIgnorable(token);
        handler.handleSeparator(token.image);
        handleIgnorable(getToken(1));
        key = objectKey();
handler.handleKey(key, valueType, getKeyType(getToken(2)));
        valueType = JsonValueTypes.DEFAULT;
        jj_consume_token(COLON);
handler.handleSeparator(token.image);
        json();
      }
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    jj_consume_token(BRACE_CLOSE);
handler.handleObjectEnd();
}

  final public void list() throws ParseException {
    jj_consume_token(BRACKET_OPEN);
handler.handleListStart();
    switch (jj_nt.kind) {
    case BRACE_OPEN:
    case BRACKET_OPEN:
    case NUMBER:
    case TRUE:
    case FALSE:
    case NULL:
    case SYMBOL:
    case STRING_SINGLE_EMPTY:
    case STRING_DOUBLE_EMPTY:
    case STRING_SINGLE_NONEMPTY:
    case STRING_DOUBLE_NONEMPTY:{
      json();
      label_2:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          break label_2;
        }
        jj_consume_token(COMMA);
handler.handleSeparator(token.image);
        json();
      }
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    jj_consume_token(BRACKET_CLOSE);
handler.handleListEnd();
}

  final public String objectKey() throws ParseException {String key;
    switch (jj_nt.kind) {
    case STRING_SINGLE_EMPTY:
    case STRING_DOUBLE_EMPTY:
    case STRING_SINGLE_NONEMPTY:
    case STRING_DOUBLE_NONEMPTY:{
      key = string();
      break;
      }
    case SYMBOL:{
      key = symbol();
      break;
      }
    case NULL:{
      key = nullValue();
      break;
      }
    case NUMBER:
    case TRUE:
    case FALSE:{
      switch (jj_nt.kind) {
      case TRUE:
      case FALSE:{
        key = booleanValue();
        break;
        }
      case NUMBER:{
        key = number();
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return key;
}

  final public void value() throws ParseException {String s;
    switch (jj_nt.kind) {
    case NUMBER:{
      s = number();
      break;
      }
    case TRUE:
    case FALSE:{
      s = booleanValue();
      break;
      }
    case NULL:{
      s = nullValue();
      break;
      }
    case SYMBOL:{
      s = symbol();
      break;
      }
    case STRING_SINGLE_EMPTY:
    case STRING_DOUBLE_EMPTY:
    case STRING_SINGLE_NONEMPTY:
    case STRING_DOUBLE_NONEMPTY:{
      s = string();
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
handler.handleValue(s, valueType);
    valueType = JsonValueTypes.DEFAULT;
}

  final public String nullValue() throws ParseException {
    jj_consume_token(NULL);
valueType = JsonValueTypes.NULL;
    return token.image;
}

  final public String booleanValue() throws ParseException {
    switch (jj_nt.kind) {
    case TRUE:{
      jj_consume_token(TRUE);
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
valueType = JsonValueTypes.BOOLEAN;
    return token.image;
}

  final public String number() throws ParseException {
    jj_consume_token(NUMBER);
valueType = JsonValueTypes.NUMBER;
    return token.image;
}

  final public String string() throws ParseException {String s;
    switch (jj_nt.kind) {
    case STRING_DOUBLE_EMPTY:
    case STRING_DOUBLE_NONEMPTY:{
      s = doubleQuoteString();
      break;
      }
    case STRING_SINGLE_EMPTY:
    case STRING_SINGLE_NONEMPTY:{
      s = singleQuoteString();
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return s;
}

  final public String doubleQuoteString() throws ParseException {String value = "";
    switch (jj_nt.kind) {
    case STRING_DOUBLE_EMPTY:{
      jj_consume_token(STRING_DOUBLE_EMPTY);
valueType = JsonValueTypes.DOUBLE_QUOTED_STRING;
      break;
      }
    case STRING_DOUBLE_NONEMPTY:{
      jj_consume_token(STRING_DOUBLE_NONEMPTY);
valueType = JsonValueTypes.DOUBLE_QUOTED_STRING;
      String image = token.image;
      value = image.substring(1, image.length() - 1);
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return value;
}

  final public String singleQuoteString() throws ParseException {String value = "";
    switch (jj_nt.kind) {
    case STRING_SINGLE_EMPTY:{
      jj_consume_token(STRING_SINGLE_EMPTY);
valueType = JsonValueTypes.SINGLE_QUOTED_STRING;
      break;
      }
    case STRING_SINGLE_NONEMPTY:{
      jj_consume_token(STRING_SINGLE_NONEMPTY);
valueType = JsonValueTypes.SINGLE_QUOTED_STRING;
      String image = token.image;
      value = image.substring(1, image.length() - 1);
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return value;
}

  final public String symbol() throws ParseException {
    jj_consume_token(SYMBOL);
valueType = JsonValueTypes.SYMBOL;
    return token.image;
}

  /** Generated Token Manager. */
  public JsonParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_gen;
  final private int[] jj_la1 = new int[12];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0xf0812000,0x1000,0xf0800000,0x1000,0xf0812000,0x30800000,0xf0800000,0xf0800000,0x30000000,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x198,0x0,0x198,0x0,0x198,0x0,0x198,0x198,0x0,0x198,0x110,0x88,};
	}

  /** Constructor. */
  public JsonParser(Provider stream) {
	 jj_input_stream = new JavaCharStream(stream, 1, 1);
	 token_source = new JsonParserTokenManager(jj_input_stream);
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 12; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public JsonParser(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new JavaCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new JsonParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 12; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public JsonParser(JsonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 12; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(JsonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 12; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken = token;
	 if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
	 else jj_nt = jj_nt.next = token_source.getNextToken();
	 if (token.kind == kind) {
	   jj_gen++;
	   return token;
	 }
	 jj_nt = token;
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
	 else jj_nt = jj_nt.next = token_source.getNextToken();
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[41];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 12; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 41; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : JsonParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private int trace_indent = 0;
  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
