package net.sf.okapi.connectors.microsoft;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import net.sf.okapi.common.XMLWriter;

class GetTranslationsArrayRequest {
	private String category;
	private List<String> texts;
	private String srcLang;
	private String trgLang;
	private int maxHits;
	private static final String XML_MIME_TYPE = "text/html";

	GetTranslationsArrayRequest(List<String> texts, String srcLang, String trgLang, int maxHits, String category) {
		this.texts = texts;
		this.category = category;
		this.srcLang = srcLang;
		this.trgLang = trgLang;
		this.maxHits = maxHits;
	}

	@Override
	public boolean equals(Object o) {
		if (o == this) return true;
		if (o == null || !(o instanceof GetTranslationsArrayRequest)) return false;
		GetTranslationsArrayRequest r = (GetTranslationsArrayRequest)o;
		return Objects.equals(category, r.category) &&
			   Objects.equals(texts, r.texts) &&
			   Objects.equals(srcLang, r.srcLang) &&
			   Objects.equals(trgLang, r.trgLang) &&
			   Objects.equals(maxHits, r.maxHits);
	}

	@Override
	public int hashCode() {
		return Objects.hash(category, texts, srcLang, trgLang, maxHits);
	}

	@Deprecated // This is for API v2 which retires on 2019-4-30
	public String toXML() {
		StringWriter sw = new StringWriter();
		XMLWriter xmlWriter = new XMLWriter(sw);
		xmlWriter.writeStartDocument();
		xmlWriter.writeStartElement("GetTranslationsArrayRequest");
		xmlWriter.writeElementString("AppId", "");
		xmlWriter.writeElementString("From", srcLang);
		xmlWriter.writeStartElement("Options");
		xmlWriter.writeAttributeString("xmlns:o", "http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2");
		xmlWriter.writeElementString("o:Category", category);
		xmlWriter.writeElementString("o:ContentType", XML_MIME_TYPE);
		xmlWriter.writeElementString("o:ReservedFlags", "");
		xmlWriter.writeElementString("o:State", "");
		xmlWriter.writeElementString("o:Uri", "");
		xmlWriter.writeElementString("o:User", "");
		xmlWriter.writeEndElement(); // Options
		xmlWriter.writeStartElement("Texts");
		xmlWriter.writeAttributeString("xmlns:s", "http://schemas.microsoft.com/2003/10/Serialization/Arrays");
		for (String text : texts) {
			xmlWriter.writeStartElement("s:string");
			xmlWriter.writeString(text);
			xmlWriter.writeEndElement();
		}
		xmlWriter.writeEndElement(); // !Texts
		xmlWriter.writeElementString("To", trgLang);
		xmlWriter.writeElementString("MaxTranslations", String.valueOf(maxHits));
		xmlWriter.writeEndElement(); // !GetTranslationsArrayRequest
		xmlWriter.writeEndDocument();
		xmlWriter.close();
		return sw.toString();
	}
	
	public String toJSON() throws JsonProcessingException {
	    ObjectMapper objectMapper = new ObjectMapper();
        List<TranslateRequest> translateRequests = new ArrayList<>();
        for (String text : texts) {
            translateRequests.add(new TranslateRequest(text));
        }
		return objectMapper.writeValueAsString(translateRequests);
	}

	public String toString() {
		try {
			return toJSON();
		} catch (JsonProcessingException e) {
			return "(deserialization error):" + e.toString();
		}
	}
	public int getNumRequests() {
		return texts.size();
	}

	public String getText(int index) {
		return texts.get(index);
	}
}
