/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.XMLEvents;

class StringItem
implements XMLEvents {
    private final List<Chunk> chunks;
    private final StyleOptimisation styleOptimisation;
    private final QName runName;
    private final QName textName;

    StringItem(List<Chunk> chunks, StyleOptimisation styleOptimisation, QName runName, QName textName) {
        this.chunks = chunks;
        this.styleOptimisation = styleOptimisation;
        this.runName = runName;
        this.textName = textName;
    }

    void optimiseStyles() throws XMLStreamException {
        this.styleOptimisation.applyTo(this.chunks);
    }

    QName getRunName() {
        return this.runName;
    }

    QName getTextName() {
        return this.textName;
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        for (XMLEvents xMLEvents : this.chunks) {
            events.addAll(xMLEvents.getEvents());
        }
        return events;
    }

    public List<Chunk> getChunks() {
        return this.chunks;
    }

    Block getBlock() {
        return new Block(this.chunks, this.styleOptimisation, this.runName, this.textName, false, false, false, Collections.emptyList());
    }

    boolean isStyled() {
        for (Chunk chunk : this.chunks) {
            if (!(chunk instanceof Run)) continue;
            return true;
        }
        return false;
    }

    static class Builder {
        private List<Chunk> chunks = new ArrayList<Chunk>();
        private StyleOptimisation styleOptimisation;
        private QName name;
        private QName textName;
        private MarkupBuilder markupBuilder = new MarkupBuilder(new Block.Markup(new Markup.General(new ArrayList<MarkupComponent>())));

        Builder() {
        }

        void addChunk(Chunk chunk) {
            this.flushMarkup();
            this.chunks.add(chunk);
        }

        void styleOptimisation(StyleOptimisation styleOptimisation) {
            this.styleOptimisation = styleOptimisation;
        }

        void runName(QName name) {
            this.name = name;
        }

        void textName(QName textName) {
            this.textName = textName;
        }

        void addToMarkup(XMLEvent event) {
            this.markupBuilder.add(event);
        }

        void addToMarkup(MarkupComponent markupComponent) {
            this.markupBuilder.add(markupComponent);
        }

        void flushMarkup() {
            Block.Markup markup = (Block.Markup)this.markupBuilder.build();
            if (!markup.components().isEmpty()) {
                this.chunks.add(markup);
                this.markupBuilder = new MarkupBuilder(new Block.Markup(new Markup.General(new ArrayList<MarkupComponent>())));
            }
        }

        StringItem build() {
            this.flushMarkup();
            return new StringItem(this.chunks, this.styleOptimisation, this.name, this.textName);
        }
    }
}

