/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;

class RunMerger {
    private static final String UNSUPPORTED_RUN_CHUNKS_PROVIDED = "Unsupported run chunks provided";
    private static final Pattern ASCII_CHARACTERS = Pattern.compile(".*[\u0000-\u007f].*");
    private static final Pattern LATIN_CHARACTERS = Pattern.compile(".*[\u0080-\u00a6\u00a9-\u00af\u00b2-\u00b3\u00b5-\u00d6\u00d8-\u00f6\u00f8-\u058f\u10a0-\u10ff\u1200-\u137f\u13a0-\u177f\u1d00-\u1d7f\u1e00-\u1fff\u2000-\u200b\u2010-\u2017\u201f-\u2029\u2030-\u2046\u204a-\u245f\u27c0-\u2bff\ud835\ufb00-\ufb17\ufe50-\ufe6f].*");
    private static final Pattern SYMBOLS = Pattern.compile(".*[\uf000-\uf0ff].*");
    private static final Pattern SHARED_CHARACTERS = Pattern.compile(".*[\u2018-\u201e].*");
    private static final Pattern COMPLEX_SCRIPT_CHARACTERS = Pattern.compile(".*[\u0590-\u074f\u0780-\u07bf\u0900-\u109f\u1780-\u18af\u200c-\u200f\u202a-\u202f\u2670-\u2671\ufb1d-\ufb4f].*");
    private static final Pattern EAST_ASIA_CHARACTERS = Pattern.compile(".*[\u3099-\u309a].*");
    private static final List<LocaleId> EAST_ASIAN_LOCALES = Arrays.asList(LocaleId.fromBCP47("ii-CN"), LocaleId.fromBCP47("ja-JP"), LocaleId.fromBCP47("ko-KR"), LocaleId.fromBCP47("zh-CN"), LocaleId.fromBCP47("zh-HK"), LocaleId.fromBCP47("zh-MO"), LocaleId.fromBCP47("zh-SG"), LocaleId.fromBCP47("zh-TW"));
    private String paragraphStyle;
    private RunBuilder runBuilder;
    private List<Block.BlockChunk> completedRuns = new ArrayList<Block.BlockChunk>();

    RunMerger() {
    }

    void setParagraphStyle(String paragraphStyle) {
        this.paragraphStyle = paragraphStyle;
    }

    boolean hasRunBuilder() {
        return this.runBuilder != null;
    }

    List<Block.BlockChunk> getRuns() throws XMLStreamException {
        if (this.runBuilder != null) {
            this.completedRuns.add(this.runBuilder.build());
            this.runBuilder = null;
        }
        return this.completedRuns;
    }

    void add(RunBuilder otherRunBuilder) throws XMLStreamException {
        if (null == this.runBuilder) {
            otherRunBuilder.resetCombinedRunProperties(this.paragraphStyle);
            this.runBuilder = otherRunBuilder;
            return;
        }
        if (this.canMergeWith(otherRunBuilder)) {
            this.mergeWith(otherRunBuilder);
        } else {
            this.completedRuns.add(this.runBuilder.build());
            this.runBuilder = otherRunBuilder;
        }
    }

    private boolean canMergeWith(RunBuilder otherRunBuilder) {
        RunProperties combinedRunProperties = this.runBuilder.getCombinedRunProperties(this.paragraphStyle);
        RunProperties combinedOtherRunProperties = otherRunBuilder.getCombinedRunProperties(this.paragraphStyle);
        if (this.runBuilder.isHidden() || otherRunBuilder.isHidden()) {
            return false;
        }
        if (Namespaces.Math.containsName(this.runBuilder.getStartElementContext().getStartElement().getName())) {
            return false;
        }
        if (this.runBuilder.containsNestedItems() || otherRunBuilder.containsNestedItems()) {
            return false;
        }
        if (this.runBuilder.containsComplexFields() || otherRunBuilder.containsComplexFields()) {
            return false;
        }
        this.detectRunFontsContentCategories(this.runBuilder, combinedRunProperties);
        this.detectRunFontsContentCategories(otherRunBuilder, combinedOtherRunProperties);
        return this.canRunPropertiesBeMerged(combinedRunProperties, combinedOtherRunProperties);
    }

    private void detectRunFontsContentCategories(RunBuilder runBuilder, RunProperties combinedRunProperties) {
        LocaleId sourceLanguage = runBuilder.getStartElementContext().getSourceLanguage();
        Run.RunText runText = runBuilder.firstRunText();
        if (runText == null) {
            return;
        }
        for (RunProperty runProperty : combinedRunProperties.getProperties()) {
            RunProperty.FontsRunProperty fontsRunProperty;
            RunFonts runFonts;
            if (!(runProperty instanceof RunProperty.FontsRunProperty) || (runFonts = (fontsRunProperty = (RunProperty.FontsRunProperty)runProperty).getRunFonts()).containsDetectedContentCategories()) continue;
            this.detectAndAddRunFontsContentCategories(sourceLanguage, runText.characters().getData(), runFonts);
        }
    }

    private void detectAndAddRunFontsContentCategories(LocaleId sourceLanguage, String runText, RunFonts runFonts) {
        if (ASCII_CHARACTERS.matcher(runText).matches()) {
            runFonts.addDetectedContentCategory(runFonts.getContentCategory(RunFonts.ContentCategory.ASCII_THEME, RunFonts.ContentCategory.ASCII));
        }
        if (SHARED_CHARACTERS.matcher(runText).matches()) {
            if (EAST_ASIAN_LOCALES.contains(sourceLanguage)) {
                runFonts.addDetectedContentCategory(runFonts.getContentCategory(RunFonts.ContentCategory.EAST_ASIAN_THEME, RunFonts.ContentCategory.EAST_ASIAN));
            } else {
                runFonts.addDetectedContentCategory(runFonts.getContentCategory(RunFonts.ContentCategory.HIGH_ANSI_THEME, RunFonts.ContentCategory.HIGH_ANSI));
            }
        }
        if (LATIN_CHARACTERS.matcher(runText).matches() || SYMBOLS.matcher(runText).matches()) {
            runFonts.addDetectedContentCategory(runFonts.getContentCategory(RunFonts.ContentCategory.HIGH_ANSI_THEME, RunFonts.ContentCategory.HIGH_ANSI));
        }
        if (COMPLEX_SCRIPT_CHARACTERS.matcher(runText).matches()) {
            runFonts.addDetectedContentCategory(runFonts.getContentCategory(RunFonts.ContentCategory.COMPLEX_SCRIPT_THEME, RunFonts.ContentCategory.COMPLEX_SCRIPT));
        }
        if (EAST_ASIA_CHARACTERS.matcher(runText).matches() || this.matchesOtherCharacters(runText)) {
            runFonts.addDetectedContentCategory(runFonts.getContentCategory(RunFonts.ContentCategory.EAST_ASIAN_THEME, RunFonts.ContentCategory.EAST_ASIAN));
        }
    }

    private boolean matchesOtherCharacters(String text) {
        return !ASCII_CHARACTERS.matcher(text).matches() && !LATIN_CHARACTERS.matcher(text).matches() && !SYMBOLS.matcher(text).matches() && !SHARED_CHARACTERS.matcher(text).matches() && !COMPLEX_SCRIPT_CHARACTERS.matcher(text).matches() && !EAST_ASIA_CHARACTERS.matcher(text).matches();
    }

    private boolean canRunPropertiesBeMerged(RunProperties currentProperties, RunProperties otherProperties) {
        if (currentProperties.count() != otherProperties.count()) {
            return false;
        }
        int numberOfMatchedProperties = 0;
        block0: for (RunProperty currentProperty : currentProperties.getProperties()) {
            QName currentPropertyStartElementName = currentProperty.getName();
            for (RunProperty otherProperty : otherProperties.getProperties()) {
                QName otherPropertyStartElementName = otherProperty.getName();
                if (!currentPropertyStartElementName.equals(otherPropertyStartElementName)) continue;
                if (currentProperty instanceof MergeableRunProperty && otherProperty instanceof MergeableRunProperty ? !((MergeableRunProperty)((Object)currentProperty)).canBeMerged((MergeableRunProperty)((Object)otherProperty)) : !currentProperty.canBeReplaced(otherProperty)) {
                    return false;
                }
                ++numberOfMatchedProperties;
                continue block0;
            }
        }
        return numberOfMatchedProperties >= currentProperties.count();
    }

    private void mergeWith(RunBuilder otherRunBuilder) {
        this.runBuilder.setRunProperties(this.mergeRunProperties(this.runBuilder.getRunProperties(), otherRunBuilder.getRunProperties(), this.runBuilder.getCombinedRunProperties(this.paragraphStyle), otherRunBuilder.getCombinedRunProperties(this.paragraphStyle)));
        this.runBuilder.resetCombinedRunProperties(this.paragraphStyle);
        this.runBuilder.setTextPreservingWhitespace(this.runBuilder.isTextPreservingWhitespace() || otherRunBuilder.isTextPreservingWhitespace());
        this.runBuilder.setRunBodyChunks(this.mergeRunBodyChunks(this.runBuilder.getRunBodyChunks(), otherRunBuilder.getRunBodyChunks()));
    }

    private RunProperties mergeRunProperties(RunProperties runProperties, RunProperties otherRunProperties, RunProperties combinedRunProperties, RunProperties otherCombinedRunProperties) {
        List<RunProperty> mergeableRunProperties = runProperties.getMergeableRunProperties();
        List<RunProperty> otherMergeableRunProperties = otherRunProperties.getMergeableRunProperties();
        if (mergeableRunProperties.isEmpty() && otherMergeableRunProperties.isEmpty()) {
            return runProperties.count() <= otherRunProperties.count() ? runProperties : otherRunProperties;
        }
        if (mergeableRunProperties.size() >= otherMergeableRunProperties.size()) {
            List<RunProperty> remainedOtherMergeableRunProperties = this.mergeMergeableRunProperties(mergeableRunProperties, otherMergeableRunProperties);
            runProperties.refine(mergeableRunProperties);
            runProperties.getProperties().addAll(remainedOtherMergeableRunProperties);
            this.clarifyFontsRunProperties(runProperties, this.mergeCombinedRunProperties(combinedRunProperties, otherCombinedRunProperties));
            return runProperties;
        }
        List<RunProperty> remainedMergeableRunProperties = this.mergeMergeableRunProperties(otherMergeableRunProperties, mergeableRunProperties);
        otherRunProperties.refine(otherMergeableRunProperties);
        otherRunProperties.getProperties().addAll(remainedMergeableRunProperties);
        this.clarifyFontsRunProperties(otherRunProperties, this.mergeCombinedRunProperties(combinedRunProperties, otherCombinedRunProperties));
        return otherRunProperties;
    }

    private RunProperties mergeCombinedRunProperties(RunProperties combinedRunProperties, RunProperties otherCombinedRunProperties) {
        List<RunProperty> mergeableCombinedRunProperties = combinedRunProperties.getMergeableRunProperties();
        List<RunProperty> otherMergeableCombinedRunProperties = otherCombinedRunProperties.getMergeableRunProperties();
        if (mergeableCombinedRunProperties.size() >= otherMergeableCombinedRunProperties.size()) {
            List<RunProperty> remainedOtherMergeableCombinedRunProperties = this.mergeMergeableRunProperties(mergeableCombinedRunProperties, otherMergeableCombinedRunProperties);
            combinedRunProperties.refine(mergeableCombinedRunProperties);
            combinedRunProperties.getProperties().addAll(remainedOtherMergeableCombinedRunProperties);
            return combinedRunProperties;
        }
        List<RunProperty> remainedMergeableCombinedRunProperties = this.mergeMergeableRunProperties(otherMergeableCombinedRunProperties, mergeableCombinedRunProperties);
        otherCombinedRunProperties.refine(otherMergeableCombinedRunProperties);
        otherCombinedRunProperties.getProperties().addAll(remainedMergeableCombinedRunProperties);
        return otherCombinedRunProperties;
    }

    private List<RunProperty> mergeMergeableRunProperties(List<RunProperty> mergeableRunProperties, List<RunProperty> otherMergeableRunProperties) {
        ArrayList<RunProperty> remainedOtherMergeableRunProperties = new ArrayList<RunProperty>(otherMergeableRunProperties);
        ListIterator<RunProperty> mergeableRunPropertiesIterator = mergeableRunProperties.listIterator();
        block0: while (mergeableRunPropertiesIterator.hasNext()) {
            RunProperty runProperty = mergeableRunPropertiesIterator.next();
            QName currentPropertyStartElementName = runProperty.getName();
            Iterator remainedOtherMergeableRunPropertyIterator = remainedOtherMergeableRunProperties.iterator();
            while (remainedOtherMergeableRunPropertyIterator.hasNext()) {
                RunProperty otherRunProperty = (RunProperty)remainedOtherMergeableRunPropertyIterator.next();
                QName otherPropertyStartElementName = otherRunProperty.getName();
                if (!currentPropertyStartElementName.equals(otherPropertyStartElementName)) continue;
                mergeableRunPropertiesIterator.set((RunProperty)((Object)((MergeableRunProperty)((Object)runProperty)).merge((MergeableRunProperty)((Object)otherRunProperty))));
                remainedOtherMergeableRunPropertyIterator.remove();
                continue block0;
            }
        }
        return remainedOtherMergeableRunProperties;
    }

    private void clarifyFontsRunProperties(RunProperties runProperties, RunProperties combinedRunProperties) {
        for (RunProperty combinedRunProperty : combinedRunProperties.getProperties()) {
            if (!(combinedRunProperty instanceof RunProperty.FontsRunProperty)) continue;
            ListIterator<RunProperty> runPropertyIterator = runProperties.getProperties().listIterator();
            while (runPropertyIterator.hasNext()) {
                RunProperty runProperty = runPropertyIterator.next();
                if (!(runProperty instanceof RunProperty.FontsRunProperty)) continue;
                runPropertyIterator.set(combinedRunProperty);
                return;
            }
            runPropertyIterator.add(combinedRunProperty);
            return;
        }
    }

    private List<Chunk> mergeRunBodyChunks(List<Chunk> chunks, List<Chunk> otherChunks) {
        Chunk otherChunk;
        if (chunks.isEmpty()) {
            return otherChunks;
        }
        if (otherChunks.isEmpty()) {
            return chunks;
        }
        ArrayList<Chunk> mergedChunks = new ArrayList<Chunk>(chunks.size() + otherChunks.size());
        ListIterator<Chunk> chunksIterator = chunks.listIterator(chunks.size() - 1);
        ListIterator<Chunk> otherChunksIterator = otherChunks.listIterator(0);
        Chunk chunk = chunksIterator.next();
        if (!RunMerger.canRunBodyChunksBeMerged(chunk, otherChunk = otherChunksIterator.next())) {
            mergedChunks.addAll(chunks);
            mergedChunks.addAll(otherChunks);
            return mergedChunks;
        }
        if (-1 < chunksIterator.previousIndex()) {
            mergedChunks.addAll(chunks.subList(0, chunksIterator.previousIndex()));
        }
        mergedChunks.add(this.mergeRunBodyChunks(chunk, otherChunk));
        if (otherChunks.size() > otherChunksIterator.nextIndex()) {
            mergedChunks.addAll(otherChunks.subList(otherChunksIterator.nextIndex(), otherChunks.size()));
        }
        return mergedChunks;
    }

    private static boolean canRunBodyChunksBeMerged(Chunk chunk, Chunk otherChunk) {
        return chunk instanceof Run.Markup && otherChunk instanceof Run.Markup || chunk instanceof Run.RunText && otherChunk instanceof Run.RunText;
    }

    private Chunk mergeRunBodyChunks(Chunk chunk, Chunk otherChunk) {
        if (chunk instanceof Run.Markup && otherChunk instanceof Run.Markup) {
            return this.mergeRunMarkups((Run.Markup)chunk, (Run.Markup)otherChunk);
        }
        if (chunk instanceof Run.RunText && otherChunk instanceof Run.RunText) {
            return this.mergeRunTexts((Run.RunText)chunk, (Run.RunText)otherChunk);
        }
        throw new IllegalArgumentException(UNSUPPORTED_RUN_CHUNKS_PROVIDED);
    }

    private Run.Markup mergeRunMarkups(Run.Markup markup, Run.Markup otherMarkup) {
        Run.Markup runMarkup = new Run.Markup(new Markup.General(new ArrayList<MarkupComponent>(markup.components().size() + otherMarkup.components().size())));
        runMarkup.addComponents(markup.components());
        runMarkup.addComponents(otherMarkup.components());
        return runMarkup;
    }

    private Chunk mergeRunTexts(Run.RunText text, Run.RunText otherText) {
        return new Run.RunText(RunMerger.mergeStartElements(text.startElement(), otherText.startElement()), this.mergeCharacters(text.characters(), otherText.characters()), text.endElement());
    }

    private static StartElement mergeStartElements(StartElement startElement, StartElement otherStartElement) {
        return RunMerger.numberOfIterables(startElement.getAttributes()) >= RunMerger.numberOfIterables(otherStartElement.getAttributes()) ? startElement : otherStartElement;
    }

    private static int numberOfIterables(Iterator iterator) {
        int number = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++number;
        }
        return number;
    }

    private Characters mergeCharacters(Characters characters, Characters otherCharacters) {
        return this.runBuilder.getStartElementContext().getEventFactory().createCharacters(characters.getData().concat(otherCharacters.getData()));
    }

    void reset() {
        this.completedRuns.clear();
        this.runBuilder = null;
    }

    void addToRunTextInRunBuilder(String text) {
        this.runBuilder.addToFirstRunText(text);
    }
}

