/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.BlockPropertyFactory;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.SchemaDefinition;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventsReader;

interface ParagraphBlockProperties
extends BlockProperties {
    public static final String PPR = "pPr";

    public boolean containsRunPropertyDeletedParagraphMark();

    public String paragraphStyle();

    public String highlightColor();

    public String textColor();

    public void refine(QName var1, String var2, List<RunProperty> var3) throws XMLStreamException;

    public static class Word
    implements ParagraphBlockProperties {
        private static final String PARAGRAPH_STYLE = "pStyle";
        private static final String VAL = "val";
        private final BlockProperties.Default defaultBlockProperties;
        private final XMLEventFactory eventFactory;

        public Word(BlockProperties.Default defaultBlockProperties, XMLEventFactory eventFactory) {
            this.defaultBlockProperties = defaultBlockProperties;
            this.eventFactory = eventFactory;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.defaultBlockProperties.getEvents();
        }

        @Override
        public QName getName() {
            return this.defaultBlockProperties.getName();
        }

        @Override
        public StartElement startElement() {
            return this.defaultBlockProperties.startElement();
        }

        @Override
        public List<Attribute> attributes() {
            return this.defaultBlockProperties.attributes();
        }

        @Override
        public List<BlockProperty> properties() {
            return this.defaultBlockProperties.properties();
        }

        @Override
        public boolean isEmpty() {
            return this.defaultBlockProperties.isEmpty();
        }

        @Override
        public boolean containsRunPropertyDeletedParagraphMark() {
            return this.defaultBlockProperties.properties().stream().filter(bp -> "rPr".equals(bp.getName().getLocalPart())).map(rp -> rp.getEvents()).flatMap(events -> events.stream()).filter(e -> e.isStartElement()).map(e -> e.asStartElement().getName()).anyMatch(n -> SkippableElement.RevisionProperty.RUN_PROPERTY_DELETED_PARAGRAPH_MARK.toName().equals(n));
        }

        @Override
        public String paragraphStyle() {
            BlockProperty paragraphStyleProperty = this.paragraphStyleProperty();
            if (null != paragraphStyleProperty) {
                return XMLEventHelpers.getAttributeValue(paragraphStyleProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
            }
            return null;
        }

        private BlockProperty paragraphStyleProperty() {
            return this.blockProperty(PARAGRAPH_STYLE);
        }

        private BlockProperty blockProperty(String localPart) {
            QName name = new QName(this.defaultBlockProperties.getName().getNamespaceURI(), localPart);
            for (BlockProperty property : this.defaultBlockProperties.properties()) {
                if (!property.getName().equals(name)) continue;
                return property;
            }
            return null;
        }

        @Override
        public String highlightColor() {
            BlockProperty highlightColorProperty = this.highlightColorProperty();
            if (null != highlightColorProperty) {
                return XMLEventHelpers.getAttributeValue(highlightColorProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
            }
            return null;
        }

        private BlockProperty highlightColorProperty() {
            return this.blockProperty("highlight");
        }

        @Override
        public String textColor() {
            BlockProperty colorProperty = this.textColorProperty();
            if (null != colorProperty) {
                return XMLEventHelpers.getAttributeValue(colorProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
            }
            return null;
        }

        private BlockProperty textColorProperty() {
            return this.blockProperty("color");
        }

        @Override
        public void refine(QName innerBlockPropertyName, String styleId, List<RunProperty> commonRunProperties) throws XMLStreamException {
            ListIterator<BlockProperty> propertiesIterator = this.defaultBlockProperties.properties().listIterator();
            while (propertiesIterator.hasNext()) {
                BlockProperty blockProperty = propertiesIterator.next();
                if (!PARAGRAPH_STYLE.equals(blockProperty.getName().getLocalPart())) continue;
                this.updateProperty(propertiesIterator, innerBlockPropertyName, styleId);
                return;
            }
            this.addProperty(propertiesIterator, innerBlockPropertyName, styleId);
        }

        private void updateProperty(ListIterator<BlockProperty> propertiesIterator, QName innerBlockPropertyName, String styleId) {
            propertiesIterator.set(this.blockProperty(innerBlockPropertyName, styleId));
        }

        private void addProperty(ListIterator<BlockProperty> propertiesIterator, QName innerBlockPropertyName, String styleId) {
            propertiesIterator.add(this.blockProperty(innerBlockPropertyName, styleId));
        }

        private BlockProperty blockProperty(QName innerBlockPropertyName, String styleId) {
            return BlockPropertyFactory.createBlockProperty(new CreationalParameters(this.eventFactory, innerBlockPropertyName.getPrefix(), innerBlockPropertyName.getNamespaceURI()), PARAGRAPH_STYLE, Collections.singletonMap(VAL, styleId));
        }
    }

    public static class Drawing
    implements ParagraphBlockProperties {
        private static final String LOCAL_LEVEL = "lvl";
        private final BlockProperties.Default defaultBlockProperties;
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StrippableAttributes.General generalStrippableAttributes;
        private final SchemaDefinition.Component schemaDefinition;

        Drawing(BlockProperties.Default defaultBlockProperties, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StrippableAttributes.General generalStrippableAttributes, SchemaDefinition.Component schemaDefinition) {
            this.defaultBlockProperties = defaultBlockProperties;
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.generalStrippableAttributes = generalStrippableAttributes;
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.defaultBlockProperties.getEvents();
        }

        @Override
        public QName getName() {
            return this.defaultBlockProperties.getName();
        }

        @Override
        public StartElement startElement() {
            return this.defaultBlockProperties.startElement();
        }

        @Override
        public List<Attribute> attributes() {
            return this.defaultBlockProperties.attributes();
        }

        @Override
        public List<BlockProperty> properties() {
            return this.defaultBlockProperties.properties();
        }

        @Override
        public boolean isEmpty() {
            return this.defaultBlockProperties.isEmpty();
        }

        @Override
        public boolean containsRunPropertyDeletedParagraphMark() {
            return false;
        }

        @Override
        public String paragraphStyle() {
            Attribute paragraphLevelAttribute = this.paragraphLevelAttribute();
            if (null != paragraphLevelAttribute) {
                return paragraphLevelAttribute.getValue();
            }
            return null;
        }

        private Attribute paragraphLevelAttribute() {
            for (Attribute attribute : this.defaultBlockProperties.attributes()) {
                if (!LOCAL_LEVEL.equals(attribute.getName().getLocalPart())) continue;
                return attribute;
            }
            return null;
        }

        @Override
        public String highlightColor() {
            return null;
        }

        @Override
        public String textColor() {
            return null;
        }

        @Override
        public void refine(QName innerBlockPropertyName, String styleId, List<RunProperty> commonRunProperties) throws XMLStreamException {
            ListIterator<BlockProperty> propertiesIterator = this.defaultBlockProperties.properties().listIterator();
            while (propertiesIterator.hasNext()) {
                BlockProperty blockProperty = propertiesIterator.next();
                if (!blockProperty.getName().equals(innerBlockPropertyName)) continue;
                this.updateProperty(propertiesIterator, blockProperty, commonRunProperties);
                return;
            }
            this.addProperty(propertiesIterator, innerBlockPropertyName, commonRunProperties);
        }

        private void updateProperty(ListIterator<BlockProperty> propertiesIterator, BlockProperty blockProperty, List<RunProperty> commonRunProperties) throws XMLStreamException {
            RunProperties runProperties = this.asRunProperties(blockProperty);
            runProperties.refine(commonRunProperties);
            runProperties.alignWith(this.schemaDefinition);
            propertiesIterator.set(BlockPropertyFactory.createBlockProperty(runProperties.getEvents()));
        }

        private RunProperties asRunProperties(BlockProperty blockProperty) throws XMLStreamException {
            XMLEventsReader eventReader = new XMLEventsReader(blockProperty.getEvents());
            StartElement startElement = eventReader.nextEvent().asStartElement();
            StartElementContext initialStartElementContext = StartElementContextFactory.createStartElementContext(startElement, this.defaultBlockProperties.startElement(), eventReader, this.eventFactory, this.conditionalParameters, null);
            StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(this.generalStrippableAttributes.strip(initialStartElementContext), initialStartElementContext);
            RunProperties runProperties = new RunPropertiesParser(startElementContext, new RunSkippableElements(startElementContext)).parse();
            if (runProperties.getProperties().isEmpty()) {
                return new RunProperties.Default(this.eventFactory, blockProperty.getEvents().get(0).asStartElement(), blockProperty.getEvents().get(blockProperty.getEvents().size() - 1).asEndElement(), new ArrayList<RunProperty>());
            }
            return runProperties;
        }

        private void addProperty(ListIterator<BlockProperty> propertiesIterator, QName innerBlockPropertyName, List<RunProperty> commonRunProperties) {
            List<Attribute> attributes = this.asAttributes(commonRunProperties);
            List<RunProperty> properties = this.asProperties(commonRunProperties);
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.eventFactory.createStartElement(innerBlockPropertyName, attributes.iterator(), null));
            events.addAll(Drawing.asXMLEvents(properties));
            events.add(this.eventFactory.createEndElement(innerBlockPropertyName, null));
            this.rewindToSchemaDefinedPlace(propertiesIterator, innerBlockPropertyName).add(BlockPropertyFactory.createBlockProperty(events));
        }

        private List<Attribute> asAttributes(List<RunProperty> commonRunProperties) {
            return commonRunProperties.stream().filter(runProperty -> runProperty instanceof RunProperty.AttributeRunProperty).map(runProperty -> this.eventFactory.createAttribute(runProperty.getName(), runProperty.getValue())).collect(Collectors.toList());
        }

        private List<RunProperty> asProperties(List<RunProperty> commonRunProperties) {
            return commonRunProperties.stream().filter(runProperty -> !(runProperty instanceof RunProperty.AttributeRunProperty)).collect(Collectors.toList());
        }

        private static List<XMLEvent> asXMLEvents(List<RunProperty> commonRunProperties) {
            return commonRunProperties.stream().map(RunProperty::getEvents).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private ListIterator<BlockProperty> rewindToSchemaDefinedPlace(ListIterator<BlockProperty> propertiesIterator, QName innerBlockPropertyName) {
            if (!propertiesIterator.hasPrevious()) {
                return propertiesIterator;
            }
            ListIterator<SchemaDefinition.Component> iterator = this.schemaDefinition.listIteratorAfter(innerBlockPropertyName);
            if (!iterator.hasNext()) {
                return propertiesIterator;
            }
            while (iterator.hasNext()) {
                SchemaDefinition.Component component = (SchemaDefinition.Component)iterator.next();
                while (propertiesIterator.hasPrevious()) {
                    BlockProperty blockProperty = propertiesIterator.previous();
                    if (!blockProperty.getName().equals(component.name())) continue;
                    return propertiesIterator;
                }
                this.rewindToEndOfProperties(propertiesIterator);
            }
            return propertiesIterator;
        }

        private void rewindToEndOfProperties(ListIterator<BlockProperty> propertiesIterator) {
            while (propertiesIterator.hasNext()) {
                propertiesIterator.next();
            }
        }
    }
}

