/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.MarkupZipSkeleton;
import net.sf.okapi.filters.openxml.NonTranslatablePart;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModifiablePart
extends NonTranslatablePart {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Document.General generalDocument;
    private final ZipEntry entry;
    private final InputStream inputStream;

    ModifiablePart(Document.General generalDocument, ZipEntry entry, InputStream inputStream) {
        this.generalDocument = generalDocument;
        this.entry = entry;
        this.inputStream = inputStream;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        XMLEventReader xmlEventReader = this.generalDocument.inputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.inputStream), StandardCharsets.UTF_8));
        return this.open(xmlEventReader);
    }

    private Event open(XMLEventReader xmlEventReader) throws XMLStreamException {
        DocumentPart documentPart;
        try {
            documentPart = this.handlePart(xmlEventReader);
        }
        finally {
            if (null != xmlEventReader) {
                xmlEventReader.close();
            }
        }
        return new Event(EventType.DOCUMENT_PART, documentPart);
    }

    private DocumentPart handlePart(XMLEventReader xmlEventReader) throws XMLStreamException {
        MarkupBuilder markupBuilder = new MarkupBuilder();
        while (xmlEventReader.hasNext()) {
            XMLEvent event = xmlEventReader.nextEvent();
            if (XMLEventHelpers.isPresentationStartEvent(event) || XMLEventHelpers.isSheetViewStartEvent(event)) {
                markupBuilder.addMarkupComponent(MarkupComponentFactory.createStartMarkupComponent(this.generalDocument.eventFactory(), event.asStartElement()));
                continue;
            }
            if (XMLEventHelpers.isPresentationEndEvent(event) || XMLEventHelpers.isSheetViewEndEvent(event)) {
                markupBuilder.addMarkupComponent(MarkupComponentFactory.createEndMarkupComponent(event.asEndElement()));
                continue;
            }
            if (XMLEventHelpers.isAlignmentStartEvent(event)) {
                markupBuilder.addMarkupComponent(new MarkupComponentParser().parseEmptyElementMarkupComponent(xmlEventReader, this.generalDocument.eventFactory(), event.asStartElement()));
                continue;
            }
            markupBuilder.addEvent(event);
        }
        DocumentPart documentPart = new DocumentPart(this.entry.getName(), false);
        documentPart.setSkeleton(new MarkupZipSkeleton(this.generalDocument.zipFile(), this.entry, this.generalDocument.outputFactory(), this.generalDocument.encoding(), markupBuilder.build()));
        return documentPart;
    }

    @Override
    public void logEvent(Event e) {
        this.LOGGER.trace("[[ {}: {} ]]", (Object)this.getClass().getSimpleName(), (Object)this.entry.getName());
    }

    private static class MarkupBuilder {
        private List<XMLEvent> events = new ArrayList<XMLEvent>();
        private Markup markup = new Block.Markup(new Markup.General(new ArrayList<MarkupComponent>()));

        private MarkupBuilder() {
        }

        void addEvent(XMLEvent event) {
            this.events.add(event);
        }

        void addMarkupComponent(MarkupComponent markupComponent) {
            this.flushEvents();
            this.markup.addComponent(markupComponent);
        }

        private void flushEvents() {
            if (!this.events.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.events));
                this.events = new ArrayList<XMLEvent>();
            }
        }

        Markup build() {
            this.flushEvents();
            return this.markup;
        }
    }
}

