/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.zip.ZipEntry;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;

class MasterPart
extends StyledTextPart {
    private boolean withinShape = false;
    private boolean withinNonVisualProperties = false;
    private boolean withinPlaceholder = false;
    private boolean currentBlockTranslatable;

    MasterPart(Document.General generalDocument, ZipEntry entry, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation) {
        super(generalDocument, entry, styleDefinitions, styleOptimisation);
    }

    @Override
    protected void preHandleNextEvent(XMLEvent e) {
        if (e.isStartElement()) {
            String localPartOfStartElement = e.asStartElement().getName().getLocalPart();
            if (localPartOfStartElement.equals("sp")) {
                this.withinShape = true;
            }
            if (this.withinShape && localPartOfStartElement.equals("nvPr")) {
                this.withinNonVisualProperties = true;
            }
            if (this.withinNonVisualProperties && localPartOfStartElement.equals("ph")) {
                this.withinPlaceholder = true;
            }
        }
        if (e.isEndElement()) {
            String localPartOfEndElement = e.asEndElement().getName().getLocalPart();
            if (localPartOfEndElement.equals("sp")) {
                this.withinShape = false;
                this.withinNonVisualProperties = false;
                this.withinPlaceholder = false;
            }
            if (localPartOfEndElement.equals("nvPr")) {
                this.withinNonVisualProperties = false;
            }
        }
        this.currentBlockTranslatable = true;
        if (this.generalDocument.conditionalParameters().getIgnorePlaceholdersInPowerpointMasters() && this.withinShape) {
            this.currentBlockTranslatable = !this.withinPlaceholder;
        }
    }

    @Override
    protected boolean isCurrentBlockTranslatable() {
        return this.currentBlockTranslatable;
    }
}

