/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentClarifierStrategy;
import net.sf.okapi.filters.openxml.MarkupComponentClarifierStrategyFactory;

class MarkupComponentClarifier {
    private MarkupComponentClarifierStrategy strategy;

    MarkupComponentClarifier(MarkupComponentClarifierStrategy strategy) {
        this.strategy = strategy;
    }

    void clarify(MarkupComponent markupComponent) {
        this.strategy.clarifyMarkupComponent(markupComponent);
    }

    static class AlignmentClarifier
    extends MarkupComponentClarifier {
        AlignmentClarifier(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
            super(MarkupComponentClarifierStrategyFactory.createAlignmentMarkupComponentClarifierStrategy(conditionalParameters, creationalParameters, clarificationParameters));
        }
    }

    static class SheetViewClarifier
    extends MarkupComponentClarifier {
        SheetViewClarifier(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
            super(MarkupComponentClarifierStrategyFactory.createSheetViewMarkupComponentClarifierStrategy(conditionalParameters, creationalParameters, clarificationParameters));
        }
    }

    static class PresentationClarifier
    extends MarkupComponentClarifier {
        PresentationClarifier(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
            super(MarkupComponentClarifierStrategyFactory.createPresentationMarkupComponentClarifierStrategy(conditionalParameters, creationalParameters, clarificationParameters));
        }
    }
}

