/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.mif.CharLiteralToken;
import net.sf.okapi.filters.mif.Document;
import net.sf.okapi.filters.mif.Extracts;
import net.sf.okapi.filters.mif.Hexadecimal;
import net.sf.okapi.filters.mif.MIFEncoder;
import net.sf.okapi.filters.mif.Parameters;
import net.sf.okapi.filters.mif.Statement;
import net.sf.okapi.filters.mif.Statements;
import net.sf.okapi.filters.mif.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class MIFFilter
implements IFilter {
    private final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TOPSTATEMENTSTOSKIP = "ColorCatalog;ConditionCatalog;BoolCondCatalog;CombinedFontCatalog;ElementDefCatalog;FmtChangeListCatalog;DefAttrValuesCatalog;AttrCondExprCatalog;FontCatalog;RulingCatalog;TblCatalog;KumihanCatalog;Views;MarkerTypeCatalog;XRefFormats;Document;BookComponent;InitialAutoNums;Dictionary;AFrames;Page;";
    private static final String IMPORTOBJECT = "ImportObject";
    private Parameters params = new Parameters();
    private String lineBreak;
    private String docName;
    private BufferedReader reader;
    private Document document;
    private StringBuilder tagBuffer;
    private StringBuilder strBuffer;
    private int tuId;
    private int otherId;
    private int grpId;
    private boolean canceled;
    private LinkedList<Event> queue;
    private LocaleId srcLang;
    private GenericSkeleton skel;
    private boolean hasNext;
    private EncoderManager encoderManager;
    private int inBlock;
    private boolean inPgfCatalog;
    private int pgfCatalogLevel;
    private boolean inPgf;
    private boolean extractedPgfNumFormat;
    private int blockLevel;
    private int paraLevel;
    private StringBuilder paraSkelBuf;
    private StringBuilder paraTextBuf;
    private StringBuilder paraCodeBuf;
    private StringBuilder paraCodeTypes;
    private int tableGroupLevel;
    private int rowGroupLevel;
    private int cellGroupLevel;
    private int fnoteGroupLevel;
    private Stack<String> parentIds;
    private Extracts extracts;
    private MIFEncoder encoder;
    private String encoding;
    private String resname;
    private int footnotesLevel;
    private int textFlowNumber;
    private ITextUnit refTU;
    private RawDocument rawDocument;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.rawDocument != null) {
            this.rawDocument.close();
        }
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
            this.docName = null;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_mif";
    }

    @Override
    public String getDisplayName() {
        return "MIF Filter";
    }

    @Override
    public String getMimeType() {
        return "application/vnd.mif";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/vnd.mif", this.getClass().getName(), "MIF (BETA)", "Adobe FrameMaker MIF documents", null, ".mif;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/vnd.mif", "net.sf.okapi.filters.mif.MIFEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument rawDocument, boolean generateSkeleton) {
        this.rawDocument = rawDocument;
        if (rawDocument.getInputURI() == null && rawDocument.getInputCharSequence() == null) {
            throw new OkapiBadFilterInputException("Direct stream input not supported for MIF.");
        }
        this.srcLang = rawDocument.getSourceLocale();
        if (rawDocument.getInputURI() != null) {
            this.docName = rawDocument.getInputURI().getPath();
        }
        try {
            BOMAwareInputStream bis = new BOMAwareInputStream(rawDocument.getStream(), this.DEFAULT_ENCODING);
            this.encoding = bis.detectEncoding();
            this.reader = new BufferedReader(new InputStreamReader((InputStream)bis, this.encoding));
            this.initialize();
            this.extracts = new Extracts(this.params, new LinkedHashSet<String>(), new LinkedHashSet<String>(), new LinkedHashSet<String>());
            this.extracts.from(this.document);
            this.lineBreak = this.extracts.lineBreak();
            this.encoder = new MIFEncoder();
            this.encoder.setOptions(this.params, this.encoding, this.lineBreak);
            this.reader.close();
            rawDocument.close();
            bis = new BOMAwareInputStream(rawDocument.getStream(), this.DEFAULT_ENCODING);
            this.encoding = bis.detectEncoding();
            this.reader = new BufferedReader(new InputStreamReader((InputStream)bis, this.encoding));
            this.initialize();
            String sdId = rawDocument.getId();
            if (Util.isEmpty(sdId)) {
                sdId = "sd1";
            }
            this.parentIds.push(sdId);
            if (this.params.getUseCodeFinder()) {
                this.params.getCodeFinder().compile();
            }
            this.queue = new LinkedList();
            StartDocument startDoc = new StartDocument(sdId);
            startDoc.setName(this.docName);
            startDoc.setLineBreak(this.lineBreak);
            startDoc.setEncoding(this.encoding, false);
            startDoc.setLocale(this.srcLang);
            startDoc.setFilterId(this.getName());
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setType(this.getMimeType());
            startDoc.setMimeType(this.getMimeType());
            this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
            if (!Util.isEmpty(this.getParameters().getSimplifierRules())) {
                Event cs = FilterUtil.createCodeSimplifierEvent(this.getParameters().getSimplifierRules());
                this.queue.add(cs);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException("Error reading MIF input.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading MIF input.", e);
        }
    }

    private void initialize() {
        this.document = new Document.Default(new Statements(this.reader), this.reader, new LinkedList<Statement>());
        this.tagBuffer = new StringBuilder();
        this.strBuffer = new StringBuilder();
        this.paraSkelBuf = new StringBuilder();
        this.paraCodeBuf = new StringBuilder();
        this.paraCodeTypes = new StringBuilder();
        this.paraTextBuf = new StringBuilder();
        this.tuId = 0;
        this.otherId = 0;
        this.grpId = 0;
        this.canceled = false;
        this.hasNext = true;
        this.inBlock = 0;
        this.blockLevel = 0;
        this.tableGroupLevel = -1;
        this.rowGroupLevel = -1;
        this.cellGroupLevel = -1;
        this.fnoteGroupLevel = -1;
        this.parentIds = new Stack();
        this.footnotesLevel = -1;
        this.textFlowNumber = 0;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.queue.clear();
            this.queue.add(new Event(EventType.CANCELED));
            this.hasNext = false;
        }
        if (this.queue.isEmpty()) {
            this.read();
        }
        if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
            this.hasNext = false;
        }
        return this.queue.poll();
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    private void read() {
        try {
            int c;
            this.skel = new GenericSkeleton();
            if (this.inBlock > 0) {
                this.processBlock(this.inBlock, false);
                return;
            }
            block7: while ((c = this.reader.read()) != -1) {
                switch (c) {
                    case 35: {
                        this.skel.append((char)c);
                        this.readComment(true, null);
                        continue block7;
                    }
                    case 60: {
                        this.skel.append((char)c);
                        ++this.blockLevel;
                        String tag = this.readTag(true, true, null);
                        if (TOPSTATEMENTSTOSKIP.contains(tag + ";")) {
                            this.skipOverContent(true, null);
                            --this.blockLevel;
                        } else {
                            if ("PgfCatalog".equals(tag)) {
                                this.inPgfCatalog = true;
                                this.pgfCatalogLevel = this.blockLevel;
                                continue block7;
                            }
                            if (this.inPgfCatalog && "Pgf".equals(tag)) {
                                if (this.startBlock(this.blockLevel, BlockType.PARAGRAPH_STYLE)) {
                                    return;
                                }
                            } else if ("TextFlow".equals(tag)) {
                                ++this.textFlowNumber;
                                if (this.startBlock(this.blockLevel, BlockType.TEXT_FLOW)) {
                                    return;
                                }
                            } else {
                                if ("Tbls".equals(tag)) continue block7;
                                if ("Tbl".equals(tag)) {
                                    if (this.startBlock(this.blockLevel, BlockType.TABLE)) {
                                        return;
                                    }
                                } else if ("VariableFormats".equals(tag)) {
                                    if (this.params.getExtractVariables()) {
                                        this.processVariables();
                                    } else {
                                        this.skipOverContent(true, null);
                                        --this.blockLevel;
                                    }
                                } else {
                                    this.skipOverContent(true, null);
                                    --this.blockLevel;
                                }
                            }
                        }
                        this.queue.add(new Event(EventType.DOCUMENT_PART, new DocumentPart(String.valueOf(++this.otherId), false), this.skel));
                        return;
                    }
                    case 62: {
                        this.skel.append((char)c);
                        --this.blockLevel;
                        if (this.inPgfCatalog && this.pgfCatalogLevel > this.blockLevel) {
                            this.inPgfCatalog = false;
                        }
                        DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false, this.skel);
                        this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                        return;
                    }
                }
                this.skel.append((char)c);
            }
            Ending ending = new Ending(String.valueOf(++this.otherId));
            this.queue.add(new Event(EventType.END_DOCUMENT, ending, this.skel));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private void skipOverContent(boolean store, StringBuilder buffer) throws IOException {
        int c;
        int baseLevel = 1;
        int state = 0;
        block16: while ((c = this.reader.read()) != -1) {
            if (store) {
                if (buffer != null) {
                    buffer.append((char)c);
                } else {
                    this.skel.append((char)c);
                }
            }
            switch (state) {
                case 0: {
                    switch (c) {
                        case 96: {
                            state = 1;
                            continue block16;
                        }
                        case 92: {
                            state = 2;
                            continue block16;
                        }
                        case 60: {
                            ++baseLevel;
                            this.tagBuffer.setLength(0);
                            state = 3;
                            continue block16;
                        }
                        case 62: {
                            if (--baseLevel != 0) continue block16;
                            return;
                        }
                    }
                    continue block16;
                }
                case 1: {
                    if (c != 39) continue block16;
                    state = 0;
                    continue block16;
                }
                case 2: {
                    state = 0;
                    continue block16;
                }
                case 3: {
                    switch (c) {
                        case 62: {
                            if (--baseLevel == 0) {
                                return;
                            }
                        }
                        case 9: 
                        case 32: {
                            if (this.tagBuffer.toString().equals(IMPORTOBJECT)) {
                                this.skipOverImportObject(store, buffer);
                                --baseLevel;
                            }
                            state = 0;
                            continue block16;
                        }
                    }
                    this.tagBuffer.append((char)c);
                    continue block16;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException(String.format("Unexpected end of input at state = %d", state));
    }

    private void readComment(boolean store, StringBuilder sb) throws IOException {
        int c;
        while ((c = this.reader.read()) != -1) {
            if (store) {
                if (sb != null) {
                    sb.append((char)c);
                } else {
                    this.skel.append((char)c);
                }
            }
            switch (c) {
                case 10: 
                case 13: {
                    return;
                }
            }
        }
    }

    private boolean startBlock(int stopLevel, BlockType type) throws IOException {
        if (type == BlockType.TABLE) {
            String tag = this.readUntil("TblID;", true, null, stopLevel, true);
            if (tag == null) {
                throw new OkapiIOException("Missing id for the table.");
            }
            Token token = this.firstLiteralTokenInStatement(true, true);
            if (token.toString().isEmpty()) {
                throw new OkapiIOException("Missing id value for the table.");
            }
            if (!this.extracts.isTableExtractable(token.toString())) {
                this.skipOverContent(true, null);
                --this.blockLevel;
                return false;
            }
            this.tableGroupLevel = this.blockLevel;
            StartGroup sg = new StartGroup(this.parentIds.peek());
            sg.setId(this.parentIds.push(String.valueOf(++this.grpId)));
            sg.setType("table");
            this.queue.add(new Event(EventType.START_GROUP, sg));
            this.resname = null;
        } else if (type == BlockType.TEXT_FLOW) {
            if (!this.extracts.isTextFlowExtractable(String.valueOf(this.textFlowNumber))) {
                this.skipOverContent(true, null);
                --this.blockLevel;
                return false;
            }
            this.resname = null;
        } else if (type == BlockType.PARAGRAPH_STYLE) {
            String tag = this.readUntil("PgfTag;", true, null, stopLevel, true);
            if (tag == null) {
                throw new OkapiIOException("Missing PgfTag for the Pgf.");
            }
            Token token = this.firstLiteralTokenInStatement(true, true);
            if (token.toString().isEmpty()) {
                throw new OkapiIOException("Missing the PgfTag value.");
            }
            if (!this.extracts.isParagraphFormatTagExtractable(token.toString())) {
                this.skipOverContent(true, null);
                --this.blockLevel;
                return false;
            }
            this.processBlock(stopLevel, true);
            return true;
        }
        this.processBlock(stopLevel, false);
        return true;
    }

    private void processBlock(int stopLevel, boolean inPara) throws IOException {
        if (inPara) {
            this.inBlock = stopLevel;
            this.processPara();
            --this.blockLevel;
        } else if (this.readUntil("Para;", true, null, stopLevel, false) != null) {
            this.inBlock = stopLevel;
            this.processPara();
            --this.blockLevel;
        } else {
            this.inBlock = 0;
        }
        if (!this.skel.isEmpty()) {
            this.queue.add(new Event(EventType.DOCUMENT_PART, new DocumentPart(String.valueOf(++this.otherId), false), this.skel));
        }
    }

    private void processPara() throws IOException {
        TextFragment tf = new TextFragment();
        boolean first = true;
        this.paraLevel = 1;
        this.paraSkelBuf.setLength(0);
        this.paraTextBuf.setLength(0);
        this.paraCodeBuf.setLength(0);
        this.paraCodeTypes.setLength(0);
        String endString = "";
        Code code = null;
        boolean extractedReferent = false;
        String extractedStringTag = "";
        int res = this.readUntilText(first, false);
        while (res > 0) {
            String type;
            switch (res) {
                case 2: {
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "index", endString.concat(TextFragment.makeRefMarker(this.refTU.getId())));
                    code.setReferenceFlag(true);
                    extractedReferent = true;
                    this.refTU = null;
                    break;
                }
                case 3: {
                    if (!this.params.getExtractPgfNumFormatsInline() && !this.inPgfCatalog && null != this.refTU) {
                        code = new Code(TextFragment.TagType.PLACEHOLDER, "ref", TextFragment.makeRefMarker(this.refTU.getId()));
                        code.setReferenceFlag(true);
                        extractedReferent = true;
                        this.refTU = null;
                    } else {
                        extractedReferent = false;
                    }
                    extractedStringTag = "<PgfNumFormat `";
                    endString = "'>";
                    break;
                }
                default: {
                    extractedReferent = false;
                    extractedStringTag = "<String `";
                    endString = "'>";
                }
            }
            if (first) {
                if (this.paraSkelBuf.length() > 0) {
                    this.skel.append(this.paraSkelBuf.toString());
                    if (this.paraCodeBuf.length() > 0) {
                        type = this.paraCodeTypes.length() > 0 ? this.paraCodeTypes.toString() : "code";
                        Code code2 = new Code(TextFragment.TagType.PLACEHOLDER, type, this.paraCodeBuf.toString().concat(extractedStringTag));
                        this.paraCodeBuf.setLength(0);
                        tf.append(code2);
                    } else if (null == code) {
                        this.skel.append(extractedStringTag);
                    }
                }
                first = false;
            }
            if (this.paraCodeBuf.length() > 0) {
                String codedText;
                String string = type = this.paraCodeTypes.length() > 0 ? this.paraCodeTypes.toString() : "code";
                String data = tf.hasCode() ? (TextFragment.isMarker((codedText = tf.getCodedText()).charAt(codedText.length() - 2)) ? "" : endString) : endString;
                Code code2 = new Code(TextFragment.TagType.PLACEHOLDER, type, data.concat(this.paraCodeBuf.toString()).concat(extractedStringTag));
                tf.append(code2);
            }
            if (code != null) {
                tf.append(code);
                code = null;
            }
            if (this.paraTextBuf.length() > 0) {
                tf.append(this.paraTextBuf.toString());
            }
            this.paraSkelBuf.setLength(0);
            this.paraTextBuf.setLength(0);
            this.paraCodeBuf.setLength(0);
            this.paraCodeTypes.setLength(0);
            res = this.readUntilText(first, extractedReferent);
        }
        this.checkInlineCodes(tf);
        TextUnit tu = null;
        if (!tf.isEmpty()) {
            if (tf.hasText() || extractedReferent) {
                tu = new TextUnit(String.valueOf(++this.tuId));
                tu.setPreserveWhitespaces(true);
                tu.setSourceContent(tf);
                tu.setMimeType("application/vnd.mif");
                tu.setName(this.resname);
                this.resname = null;
                this.processILC(tu);
                this.queue.add(new Event(EventType.TEXT_UNIT, tu, this.skel));
                this.skel.addContentPlaceholder(tu);
                TextUnitUtil.simplifyCodes(tu, this.params.getSimplifierRules(), true, true);
            } else {
                this.skel.append(this.toMIFString(tf));
            }
        }
        this.skel.append(endString);
        if (this.paraSkelBuf.length() > 0) {
            this.skel.append(this.paraSkelBuf.toString());
        }
        if (this.paraCodeBuf.length() > 0) {
            this.skel.append(this.paraCodeBuf.toString());
        }
        if (tu != null) {
            this.skel = new GenericSkeleton();
        }
    }

    private Token firstLiteralTokenInStatement(boolean store, boolean updateBlockLevel) throws IOException {
        Statement statement = this.document.currentMarkup();
        if (store) {
            this.skel.add(statement.toString());
        }
        if (updateBlockLevel) {
            --this.blockLevel;
        }
        return statement.firstTokenOf(Token.Type.LITERAL);
    }

    private Object[] processMarker(String startTag) throws IOException {
        this.refTU = null;
        int level = this.blockLevel;
        StringBuilder sb = new StringBuilder(startTag);
        Object[] res = new Object[]{sb, null};
        String tag = this.readUntil("MTypeName;", true, sb, -1, true);
        if (tag == null) {
            this.logger.warn("Marker without type or text found. It will be skipped.");
            this.skipOverContent(true, sb);
            return res;
        }
        String type = this.processString(true, sb);
        String resType = null;
        if ("Index".equals(type)) {
            if (this.params.getExtractIndexMarkers()) {
                resType = "x-index";
            }
        } else if ("Hypertext".equals(type) && this.params.getExtractLinks()) {
            resType = "link";
        }
        if (resType == null) {
            this.skipOverContent(true, sb);
            this.blockLevel = level;
            return res;
        }
        tag = this.readUntil("MText;", true, sb, -1, true);
        if (tag == null) {
            this.skipOverContent(true, sb);
            this.blockLevel = level;
            return res;
        }
        TextFragment tf = new TextFragment(this.processString(true, sb));
        this.checkInlineCodes(tf);
        if (tf.hasText()) {
            this.addReferentTextUnit(tf, sb, resType);
            res[1] = this.refTU;
        } else {
            this.skipOverContent(true, sb);
        }
        this.blockLevel = level;
        return res;
    }

    private void addReferentTextUnit(TextFragment textFragment, StringBuilder stringBuilder, String type) throws IOException {
        this.refTU = new TextUnit(String.valueOf(++this.tuId));
        this.refTU.setPreserveWhitespaces(true);
        this.refTU.setSourceContent(textFragment);
        this.refTU.setType(type);
        this.refTU.setIsReferent(true);
        this.refTU.setMimeType("application/vnd.mif");
        int n = stringBuilder.lastIndexOf("`");
        stringBuilder.delete(n + 1, stringBuilder.length());
        GenericSkeleton refSkel = new GenericSkeleton(stringBuilder.toString());
        refSkel.addContentPlaceholder(this.refTU);
        stringBuilder.setLength(0);
        stringBuilder.append("'>");
        this.skipOverContent(true, stringBuilder);
        refSkel.add(stringBuilder.toString());
        this.processILC(this.refTU);
        this.queue.add(new Event(EventType.TEXT_UNIT, this.refTU, refSkel));
        TextUnitUtil.simplifyCodes(this.refTU, this.params.getSimplifierRules(), true);
        stringBuilder.setLength(0);
    }

    private int readUntilText(boolean startOfPara, boolean significant) throws IOException {
        int c;
        StringBuilder sb = startOfPara ? this.paraSkelBuf : this.paraCodeBuf;
        block5: while ((c = this.reader.read()) != -1) {
            switch (c) {
                case 35: {
                    sb.append((char)c);
                    this.readComment(true, sb);
                    continue block5;
                }
                case 60: {
                    ++this.paraLevel;
                    sb.append((char)c);
                    String tag = this.readTag(true, false, sb);
                    if ("ParaLine".equals(tag) || "Pgf".equals(tag)) {
                        if ("Pgf".equals(tag)) {
                            this.inPgf = true;
                            this.extractedPgfNumFormat = false;
                        }
                        if (!startOfPara) {
                            int n = sb.lastIndexOf("<");
                            if (significant) {
                                if (!this.extractedPgfNumFormat) {
                                    sb.delete(n, sb.length());
                                }
                            } else {
                                sb.setLength(0);
                            }
                        }
                        return this.readUntilText(startOfPara, significant);
                    }
                    if ("String".equals(tag) || "PgfNumFormat".equals(tag)) {
                        String text = this.processString(true, sb);
                        --this.paraLevel;
                        if (!Util.isEmpty(text)) {
                            if ("String".equals(tag)) {
                                int n = sb.lastIndexOf("<".concat(tag));
                                if (significant) {
                                    sb.delete(n, sb.length());
                                } else {
                                    sb.setLength(0);
                                }
                                this.paraTextBuf.append(text);
                                return 1;
                            }
                            if (this.params.getExtractPgfNumFormatsInline() || this.inPgfCatalog) {
                                int n = sb.lastIndexOf("<".concat(tag));
                                if (significant) {
                                    sb.delete(n, sb.length());
                                } else {
                                    sb.setLength(0);
                                }
                                this.paraTextBuf.append(text);
                                this.extractedPgfNumFormat = true;
                                return 3;
                            }
                            TextFragment tf = new TextFragment(text);
                            this.checkInlineCodes(tf);
                            if (tf.hasText()) {
                                this.addReferentTextUnit(tf, sb, "x-referent");
                                --this.paraLevel;
                                this.inPgf = false;
                                this.extractedPgfNumFormat = true;
                                return 3;
                            }
                            this.skipOverContent(true, sb);
                            --this.paraLevel;
                            this.inPgf = false;
                        }
                    } else if ("Char".equals(tag)) {
                        String text = new CharLiteralToken(this.firstLiteralTokenInStatement(false, false), this.logger).toString();
                        if (!significant) {
                            sb.setLength(0);
                        }
                        --this.paraLevel;
                        if (!text.isEmpty()) {
                            this.paraTextBuf.append(text);
                            return 1;
                        }
                    } else if ("Marker".equals(tag)) {
                        int n = sb.lastIndexOf("<".concat(tag));
                        String startTag = sb.substring(n);
                        if (significant) {
                            sb.delete(n, sb.length());
                        } else {
                            sb.setLength(0);
                        }
                        Object[] res = this.processMarker(startTag);
                        significant = true;
                        if (this.paraCodeTypes.length() > 0) {
                            this.paraCodeTypes.append(";");
                        }
                        this.paraCodeTypes.append(tag.toLowerCase());
                        --this.paraLevel;
                        if (res[1] != null) {
                            return 2;
                        }
                        sb.append(res[0]);
                    } else {
                        this.skipOverContent(true, sb);
                        significant = true;
                        if (this.paraCodeTypes.length() > 0) {
                            this.paraCodeTypes.append(";");
                        }
                        this.paraCodeTypes.append(tag.toLowerCase());
                        --this.paraLevel;
                    }
                    if (!startOfPara || !"Font;Marker;Conditional;Unconditional;ATbl;AFrame;FNote;Variable;XRef;XRefEnd;".contains(tag)) continue block5;
                    int n = sb.lastIndexOf("<".concat(tag));
                    this.paraCodeBuf.append(sb.substring(n));
                    sb.delete(n, sb.length());
                    sb = this.paraCodeBuf;
                    this.paraCodeTypes.setLength(0);
                    this.paraCodeTypes.append(tag.toLowerCase());
                    startOfPara = false;
                    continue block5;
                }
                case 62: {
                    --this.paraLevel;
                    if (this.paraLevel == 1 && this.inPgf) {
                        sb.append((char)c);
                        significant = true;
                        this.inPgf = false;
                    } else if (this.paraLevel != 1 && !this.inPgf) {
                        sb.append((char)c);
                        significant = true;
                    }
                    if (this.paraLevel == 0 && this.inPgfCatalog) {
                        return 0;
                    }
                    if (this.paraLevel != 0) continue block5;
                    int n = sb.lastIndexOf(" # end of ParaLine");
                    if (n > -1) {
                        sb.insert(n, '>');
                    } else {
                        sb.append(" # end of ParaLine").append(this.lineBreak).append(">");
                    }
                    return 0;
                }
            }
            sb.append((char)c);
        }
        return 0;
    }

    private String readUntil(String tagNames, boolean store, StringBuilder sb, int stopLevel, boolean skipNotesBlock) throws IOException {
        int c;
        int endNow = stopLevel;
        if (stopLevel == -1) {
            endNow = this.blockLevel;
        }
        while ((c = this.reader.read()) != -1) {
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            block0 : switch (c) {
                case 35: {
                    this.readComment(store, sb);
                    break;
                }
                case 60: {
                    do {
                        StartGroup sg;
                        ++this.blockLevel;
                        String tag = this.readTag(store, true, sb);
                        if (tagNames.contains(tag + ";")) {
                            if (skipNotesBlock && this.footnotesLevel != -1) break block0;
                            return tag;
                        }
                        if ("Tbl".equals(tag)) {
                            this.tableGroupLevel = this.blockLevel;
                            break block0;
                        }
                        if ("Row".equals(tag)) {
                            this.rowGroupLevel = this.blockLevel;
                            sg = new StartGroup(this.parentIds.peek());
                            sg.setId(this.parentIds.push(String.valueOf(++this.grpId)));
                            sg.setType("row");
                            this.queue.add(new Event(EventType.START_GROUP, sg));
                            break block0;
                        }
                        if ("Cell".equals(tag)) {
                            this.cellGroupLevel = this.blockLevel;
                            sg = new StartGroup(this.parentIds.peek(), String.valueOf(++this.grpId));
                            sg.setType("cell");
                            this.queue.add(new Event(EventType.START_GROUP, sg));
                            break block0;
                        }
                        if ("Notes".equals(tag)) {
                            this.footnotesLevel = this.blockLevel;
                            break block0;
                        }
                        if ("FNote".equals(tag)) {
                            if (this.footnotesLevel <= 0) break block0;
                            this.fnoteGroupLevel = this.blockLevel;
                            sg = new StartGroup(this.parentIds.peek(), String.valueOf(++this.grpId));
                            sg.setType("fn");
                            this.queue.add(new Event(EventType.START_GROUP, sg));
                            break block0;
                        }
                        if (!IMPORTOBJECT.equals(tag)) continue;
                        this.skipOverImportObject(store, sb);
                        --this.blockLevel;
                        break block0;
                    } while (this.readUntilOpenOrClose(store, sb));
                    --this.blockLevel;
                    break;
                }
                case 62: {
                    if (this.tableGroupLevel == this.blockLevel) {
                        this.tableGroupLevel = -1;
                        this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                        this.parentIds.pop();
                    } else if (this.rowGroupLevel == this.blockLevel) {
                        this.rowGroupLevel = -1;
                        this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                        this.parentIds.pop();
                    } else if (this.cellGroupLevel == this.blockLevel) {
                        this.cellGroupLevel = -1;
                        this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                    } else if (this.footnotesLevel == this.blockLevel) {
                        this.footnotesLevel = -1;
                    } else if (this.fnoteGroupLevel == this.blockLevel && this.footnotesLevel > 0) {
                        this.fnoteGroupLevel = -1;
                        this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                    }
                    --this.blockLevel;
                    if (this.blockLevel >= endNow) break;
                    return null;
                }
            }
        }
        return null;
    }

    private void skipOverImportObject(boolean store, StringBuilder buffer) throws IOException {
        int c;
        int state = 0;
        int baseLevel = 1;
        block19: while ((c = this.reader.read()) != -1) {
            if (store) {
                if (buffer != null) {
                    buffer.append((char)c);
                } else {
                    this.skel.append((char)c);
                }
            }
            switch (state) {
                case 0: {
                    switch (c) {
                        case 96: {
                            state = 1;
                            continue block19;
                        }
                        case 60: {
                            ++baseLevel;
                            continue block19;
                        }
                        case 62: {
                            if (--baseLevel == 0) {
                                return;
                            }
                        }
                        case 10: 
                        case 13: {
                            state = 3;
                            continue block19;
                        }
                    }
                    continue block19;
                }
                case 1: {
                    if (c != 39) continue block19;
                    state = 0;
                    continue block19;
                }
                case 2: {
                    state = 0;
                    continue block19;
                }
                case 3: {
                    switch (c) {
                        case 38: {
                            state = 4;
                            continue block19;
                        }
                        case 60: {
                            state = 0;
                            ++baseLevel;
                            continue block19;
                        }
                        case 62: {
                            state = 0;
                            if (--baseLevel != 0) continue block19;
                            return;
                        }
                        case 10: 
                        case 13: {
                            continue block19;
                        }
                    }
                    state = 0;
                    continue block19;
                }
                case 4: {
                    if (c != 13 && c != 10) continue block19;
                    state = 3;
                    continue block19;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException(String.format("Unexpected end of input at state = %d", state));
    }

    private boolean readUntilOpenOrClose(boolean store, StringBuilder sb) throws IOException {
        int c;
        boolean inEscape = false;
        boolean inString = false;
        while ((c = this.reader.read()) != -1) {
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            if (inString) {
                if (c != 39) continue;
                inString = false;
                continue;
            }
            if (inEscape) {
                inEscape = false;
                continue;
            }
            switch (c) {
                case 96: {
                    inString = true;
                    break;
                }
                case 92: {
                    inEscape = true;
                    break;
                }
                case 60: {
                    return true;
                }
                case 62: {
                    return false;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException("Unexpected end of input.");
    }

    private String readTag(boolean store, boolean storeCharStatement, StringBuilder sb) throws IOException {
        int c;
        this.tagBuffer.setLength(0);
        int wsStart = sb != null ? sb.length() - 1 : -1;
        boolean leadingWSDone = false;
        block7: do {
            c = this.reader.read();
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (!store) continue block7;
                    if (sb != null) {
                        sb.append((char)c);
                        break;
                    }
                    this.skel.add((char)c);
                    break;
                }
                default: {
                    leadingWSDone = true;
                }
            }
        } while (!leadingWSDone);
        while (true) {
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (store) {
                        if (!storeCharStatement && this.tagBuffer.toString().equals("Char")) {
                            if (wsStart > 0) {
                                sb.delete(wsStart, sb.length());
                            }
                        } else if (sb != null) {
                            sb.append(this.tagBuffer.toString());
                            sb.append((char)c);
                        } else {
                            this.skel.append(this.tagBuffer.toString());
                            this.skel.append((char)c);
                        }
                    }
                    return this.tagBuffer.toString();
                }
                case -1: {
                    throw new OkapiIllegalFilterOperationException("Unexpected end of input.");
                }
            }
            this.tagBuffer.append((char)c);
            c = this.reader.read();
        }
    }

    private void processVariables() throws IOException {
        boolean startGroupDone = false;
        String tag = null;
        TextUnit tu = null;
        do {
            if ((tag = this.readUntil("VariableFormat;", true, null, this.blockLevel - 1, true)) == null || (tag = this.readUntil("VariableDef;", true, null, this.blockLevel - 1, true)) == null) continue;
            String text = this.processString(false, null);
            TextFragment tf = new TextFragment(text);
            this.checkInlineCodes(tf);
            this.skel.append("`");
            if (tf.hasText()) {
                if (!startGroupDone) {
                    StartGroup sg = new StartGroup(this.parentIds.peek());
                    sg.setId(String.valueOf(++this.grpId));
                    sg.setType("variables");
                    this.queue.add(new Event(EventType.START_GROUP, sg));
                    startGroupDone = true;
                }
                tu = new TextUnit(String.valueOf(++this.tuId));
                tu.setPreserveWhitespaces(true);
                tu.setSourceContent(tf);
                tu.setName(this.resname);
                this.resname = null;
                tu.setMimeType("application/vnd.mif");
                this.processILC(tu);
                this.queue.add(new Event(EventType.TEXT_UNIT, tu, this.skel));
                this.skel.addContentPlaceholder(tu);
                TextUnitUtil.simplifyCodes(tu, this.params.getSimplifierRules(), true);
            } else {
                this.skel.append(this.toMIFString(tf));
            }
            this.skel.append("'>");
            if (tu == null) continue;
            this.skel = new GenericSkeleton();
            tu = null;
        } while (tag != null);
        if (startGroupDone) {
            this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
        }
    }

    private String toMIFString(TextFragment tf) {
        String ctext = tf.getCodedText();
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < ctext.length(); ++i) {
            char ch = ctext.charAt(i);
            if (TextFragment.isMarker(ch)) {
                tmp.append(tf.getCode(ctext.charAt(++i)));
                continue;
            }
            tmp.append(this.encoder.encode(ch, EncoderContext.TEXT));
        }
        return tmp.toString();
    }

    private void checkInlineCodes(TextFragment tf) {
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().process(tf);
        }
        List<Code> codes = tf.getCodes();
        for (Code code : codes) {
            if (!code.getType().equals("regxph")) continue;
            code.setData(this.encoder.encode(code.getData(), EncoderContext.INLINE));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String processString(boolean store, StringBuilder sb) throws IOException {
        this.strBuffer.setLength(0);
        int state = 0;
        while (true) {
            int c;
            if ((c = this.reader.read()) == -1) {
                throw new OkapiIllegalFilterOperationException("End of string is missing.");
            }
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case 96: {
                            state = 1;
                            break block0;
                        }
                        case 62: {
                            return this.strBuffer.toString();
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case 39: {
                            state = 0;
                            break block0;
                        }
                        case 92: {
                            state = 2;
                            break block0;
                        }
                    }
                    this.strBuffer.append((char)c);
                    break;
                }
                case 2: {
                    state = 1;
                    switch (c) {
                        case 62: 
                        case 92: {
                            this.strBuffer.append((char)c);
                            break;
                        }
                        case 116: {
                            this.strBuffer.append('\t');
                            break;
                        }
                        case 81: {
                            this.strBuffer.append('`');
                            break;
                        }
                        case 113: {
                            this.strBuffer.append('\'');
                            break;
                        }
                        case 117: {
                            c = this.readHexa(4, false, store, sb);
                            if (c == Integer.MAX_VALUE) break;
                            this.strBuffer.append((char)c);
                            break;
                        }
                        case 120: {
                            c = this.readHexa(2, true, store, sb);
                            if (c == Integer.MAX_VALUE) break;
                            this.strBuffer.append(new Hexadecimal(c, this.logger).toString());
                        }
                    }
                    break;
                }
            }
        }
    }

    private int readHexa(int length, boolean readExtraSpace, boolean store, StringBuilder sb) throws IOException {
        int c;
        this.tagBuffer.setLength(0);
        for (int i = 0; i < length; ++i) {
            c = this.reader.read();
            if (c == -1) {
                throw new OkapiIllegalFilterOperationException("Unexpected end of file.");
            }
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            this.tagBuffer.append((char)c);
        }
        if (readExtraSpace) {
            c = this.reader.read();
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
        }
        try {
            int n = Integer.valueOf(this.tagBuffer.toString(), 16);
            return n;
        }
        catch (NumberFormatException e) {
            this.logger.warn("Invalid escape sequence found: '{}'", (Object)this.tagBuffer.toString());
            return Integer.MAX_VALUE;
        }
    }

    private void processILC(ITextUnit tu) {
        TextFragment tf = tu.getSource().getFirstContent();
        String ct = tf.getCodedText();
        int start = 0;
        int diff = 0;
        while ((start = ct.indexOf("\u169b", start)) != -1) {
            int end = ct.indexOf("\u169c", start);
            if (end == -1) {
                throw new OkapiIllegalFilterOperationException("Expected ILC_END marker not found.");
            }
            diff = tf.changeToCode(start, end + 1, TextFragment.TagType.PLACEHOLDER, "ctrl");
            start = end + diff;
            ct = tf.getCodedText();
        }
        if (diff != 0) {
            for (Code code : tf.getCodes()) {
                if (!code.getData().startsWith("\u169b")) continue;
                String data = code.getData();
                code.setData(data.substring(1, data.length() - 1));
            }
        }
    }

    private static enum BlockType {
        TEXT_FLOW,
        TABLE,
        PARAGRAPH_STYLE;

    }
}

