/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.IOException;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.Spread;

class SpreadParser {
    private final Reader reader;
    private final XMLInputFactory inputFactory;
    private final String activeLayerId;

    SpreadParser(Reader reader, XMLInputFactory inputFactory, String activeLayerId) {
        this.reader = reader;
        this.inputFactory = inputFactory;
        this.activeLayerId = activeLayerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Spread parse(QName spreadName) throws XMLStreamException, IOException {
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(this.reader);
        Spread.SpreadBuilder spreadBuilder = new Spread.SpreadBuilder().setActiveLayerId(this.activeLayerId);
        try {
            while (eventReader.hasNext()) {
                StartElement element;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !spreadName.equals((element = event.asStartElement()).getName())) continue;
                spreadBuilder = this.parseSpread(element, eventReader, spreadBuilder);
                break;
            }
        }
        finally {
            this.reader.close();
        }
        return spreadBuilder.build();
    }

    private Spread.SpreadBuilder parseSpread(StartElement startElement, XMLEventReader eventReader, Spread.SpreadBuilder spreadBuilder) throws XMLStreamException {
        spreadBuilder.setId(startElement.getAttributeByName(ParsingIdioms.SELF).getValue());
        spreadBuilder.setTransformation(startElement.getAttributeByName(ParsingIdioms.ITEM_TRANSFORM).getValue());
        ParsingIdioms.parseSpreadItems(startElement, eventReader, spreadBuilder);
        return spreadBuilder;
    }
}

