/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.List;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.MarkupSkeleton;
import net.sf.okapi.filters.idml.StoryChildElement;

class DocumentPartEventBuilder
implements Builder<Event> {
    private final IdGenerator documentPartIdGenerator;
    private Markup.MarkupBuilder markupBuilder;

    DocumentPartEventBuilder(IdGenerator documentPartIdGenerator) {
        this.documentPartIdGenerator = documentPartIdGenerator;
        this.markupBuilder = new Markup.MarkupBuilder();
    }

    void addMarkupRange(List<XMLEvent> events) {
        this.markupBuilder.addMarkupRange(MarkupRange.getMarkupRange(events));
    }

    void addMarkupRangeStartElement(StartElement startElement) {
        this.markupBuilder.addMarkupRange(MarkupRange.getMarkupRangeStartElement(startElement));
    }

    void addMarkupRangeEndElement(EndElement endElement) {
        this.markupBuilder.addMarkupRange(MarkupRange.getMarkupRangeEndElement(endElement));
    }

    void addMarkupRangeElement(StoryChildElement storyChildElement) {
        this.markupBuilder.addMarkupRange(storyChildElement);
    }

    @Override
    public Event build() {
        Markup markup = this.markupBuilder.build();
        if (markup.getMarkupRanges().isEmpty()) {
            return null;
        }
        DocumentPart documentPart = new DocumentPart(this.documentPartIdGenerator.createId(), false);
        documentPart.setSkeleton(new MarkupSkeleton(markup));
        return new Event(EventType.DOCUMENT_PART, documentPart);
    }
}

