/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class FileCachedInputStream
extends InputStream
implements WritableByteChannel {
    public static final boolean DEBUG = false;
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    public byte[] buffer;
    public int inspectable;
    private File overflowFile;
    private RandomAccessFile randomAccessFile;
    private FileChannel fileChannel;
    private long position;
    private long mark;
    private long writePosition;

    public FileCachedInputStream(int bufferSize, File overflowFile) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Illegal buffer size " + bufferSize);
        }
        if (overflowFile != null) {
            this.overflowFile = overflowFile;
        }
        this.buffer = new byte[bufferSize];
        this.mark = -1L;
    }

    public FileCachedInputStream(int bufferSize) {
        this(bufferSize, null);
    }

    public FileCachedInputStream() {
        this(0x100000);
    }

    private void ensureOpen() throws IOException {
        if (this.position == -1L) {
            throw new IOException("This " + this.getClass().getSimpleName() + " is closed");
        }
    }

    public void clear() throws IOException {
        if (!this.fileChannel.isOpen()) {
            throw new IOException("This " + this.getClass().getSimpleName() + " is closed");
        }
        this.inspectable = 0;
        this.writePosition = this.position = (long)0;
        this.mark = -1L;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        int remaining = byteBuffer.remaining();
        if (this.inspectable < this.buffer.length) {
            int toBuffer = Math.min(this.buffer.length - this.inspectable, remaining);
            byteBuffer.get(this.buffer, this.inspectable, toBuffer);
            this.inspectable += toBuffer;
        }
        if (byteBuffer.hasRemaining()) {
            if (this.overflowFile == null) {
                this.overflowFile = File.createTempFile("~okapi-10_" + this.getClass().getSimpleName(), "overflow");
                this.randomAccessFile = new RandomAccessFile(this.overflowFile, "rw");
                this.fileChannel = this.randomAccessFile.getChannel();
            }
            this.fileChannel.position(this.writePosition);
            this.writePosition += (long)this.fileChannel.write(byteBuffer);
        }
        return remaining;
    }

    public void truncate(long size) throws FileNotFoundException, IOException {
        this.fileChannel.truncate(Math.max(size, this.writePosition));
    }

    @Override
    public void close() {
        this.position = -1L;
    }

    public void reopen() throws IOException {
        if (this.fileChannel != null && !this.fileChannel.isOpen()) {
            throw new IOException("This " + this.getClass().getSimpleName() + " is closed");
        }
        this.position = 0L;
    }

    public void dispose() throws IOException {
        this.position = -1L;
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
        }
        if (this.overflowFile != null) {
            this.overflowFile.delete();
        }
        this.buffer = null;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return (int)Math.min(Integer.MAX_VALUE, this.length() - this.position);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        this.ensureOpen();
        if (length == 0) {
            return 0;
        }
        if (this.position == this.length()) {
            return -1;
        }
        this.ensureOffsetLength(b.length, offset, length);
        int read = 0;
        if (this.position < (long)this.inspectable) {
            int toCopy = Math.min(this.inspectable - (int)this.position, length);
            System.arraycopy(this.buffer, (int)this.position, b, offset, toCopy);
            length -= toCopy;
            offset += toCopy;
            this.position += (long)toCopy;
            read = toCopy;
        }
        if (length > 0) {
            if (this.position == this.length()) {
                return read != 0 ? read : -1;
            }
            this.fileChannel.position(this.position - (long)this.inspectable);
            int toRead = (int)Math.min(this.length() - this.position, (long)length);
            int t = this.randomAccessFile.read(b, offset, toRead);
            this.position += (long)t;
            read += t;
        }
        return read;
    }

    private void ensureOffsetLength(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than array length (" + arrayLength + ")");
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        long toSkip = Math.min(n, this.length() - this.position);
        this.position += toSkip;
        return toSkip;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.position == this.length()) {
            return -1;
        }
        if (this.position < (long)this.inspectable) {
            return this.buffer[(int)this.position++] & 0xFF;
        }
        this.fileChannel.position(this.position - (long)this.inspectable);
        ++this.position;
        return this.randomAccessFile.read();
    }

    public long length() throws IOException {
        this.ensureOpen();
        return (long)this.inspectable + this.writePosition;
    }

    public long position() throws IOException {
        this.ensureOpen();
        return this.position;
    }

    public void position(long position) throws IOException {
        this.position = Math.min(position, this.length());
    }

    @Override
    public boolean isOpen() {
        return this.position != -1L;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.position;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (this.mark == -1L) {
            throw new IOException("Mark has not been set");
        }
        this.position(this.mark);
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

