/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.engine;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.util.ULocale;
import java.util.TreeMap;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.steps.tokenization.common.AbstractLexer;
import net.sf.okapi.steps.tokenization.common.Lexem;
import net.sf.okapi.steps.tokenization.common.Lexems;
import net.sf.okapi.steps.tokenization.common.LexerRule;
import net.sf.okapi.steps.tokenization.tokens.Tokens;

public class RbbiLexer
extends AbstractLexer {
    private TreeMap<LocaleId, RuleBasedBreakIterator> iterators = new TreeMap();
    private RuleBasedBreakIterator iterator = null;
    private int start;
    private int end;
    private String text;

    @Override
    public void lexer_init() {
    }

    @Override
    public boolean lexer_hasNext() {
        return this.end != -1;
    }

    @Override
    public Lexem lexer_next() {
        this.end = this.iterator.next();
        if (this.end == -1) {
            return null;
        }
        if (this.start >= this.end) {
            return null;
        }
        int lexemId = this.iterator.getRuleStatus();
        Lexem lexem = new Lexem(lexemId, this.text.substring(this.start, this.end), this.start, this.end);
        this.start = this.end;
        return lexem;
    }

    public static String formatRule(String buffer, String name, String description, String rule, int lexemId) {
        buffer = Util.normalizeNewlines(buffer);
        rule = rule.replace("\\", "\\\\");
        String part1 = String.format("\\$%s = %s;", name, rule);
        String part2 = String.format("\\$%s {%d};", name, lexemId);
        buffer = buffer.replaceFirst("(\\.;)", String.format("%s$0", part1));
        buffer = buffer.replaceFirst("(\\.;)", String.format("%s$0", part2));
        return buffer;
    }

    @Override
    public void lexer_open(String text, LocaleId language, Tokens tokens) {
        if (Util.isEmpty(text)) {
            this.cancel();
            return;
        }
        this.text = text;
        if (this.iterators.containsKey(language)) {
            this.iterator = this.iterators.get(language);
        } else {
            String defaultRules;
            this.iterator = (RuleBasedBreakIterator)BreakIterator.getWordInstance((ULocale)ULocale.createCanonical((String)language.toString()));
            String newRules = defaultRules = this.iterator.toString();
            for (LexerRule rule : this.getRules()) {
                boolean isInternal = Util.isEmpty(rule.getPattern());
                if (!this.checkRule(rule, language) || isInternal) continue;
                newRules = RbbiLexer.formatRule(newRules, rule.getName(), rule.getDescription(), rule.getPattern(), rule.getLexemId());
            }
            this.iterator = new RuleBasedBreakIterator(newRules);
            this.iterators.put(language, this.iterator);
        }
        if (this.iterator == null) {
            return;
        }
        this.iterator.setText(text);
        this.end = this.start = this.iterator.first();
    }

    @Override
    public Lexems process(String text, LocaleId language, Tokens tokens) {
        return null;
    }
}

