/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.ReferenceParameter;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.lib.verification.PatternItem;

public class Parameters
extends StringParameters {
    public static final String FILE_EXTENSION = ".qccfg";
    public static final int SCOPE_ALL = 0;
    public static final int SCOPE_APPROVEDONLY = 1;
    public static final int SCOPE_NOTAPPROVEDONLY = 2;
    private static final String OUTPUTPATH = "outputPath";
    private static final String OUTPUTTYPE = "outputType";
    private static final String AUTOOPEN = "autoOpen";
    private static final String LEADINGWS = "leadingWS";
    private static final String TRAILINGWS = "trailingWS";
    private static final String EMPTYTARGET = "emptyTarget";
    private static final String EMPTYSOURCE = "emptySource";
    private static final String TARGETSAMEASSOURCE = "targetSameAsSource";
    private static final String TARGETSAMEASSOURCE_FORSAMELANGUAGE = "targetSameAsSourceForSameLanguage";
    private static final String TARGETSAMEASSOURCE_WITHCODES = "targetSameAsSourceWithCodes";
    private static final String TARGETSAMEASSOURCE_WITHNUMBERS = "targetSameAsSourceWithNumbers";
    private static final String CODEDIFFERENCE = "codeDifference";
    private static final String GUESSOPENCLOSE = "guessOpenClose";
    private static final String STRICTCODEORDER = "strictCodeOrder";
    private static final String CHECKXLIFFSCHEMA = "checkXliffSchema";
    private static final String CHECKPATTERNS = "checkPatterns";
    private static final String PATTERNCOUNT = "patternCount";
    private static final String USEPATTERN = "usePattern";
    private static final String FROMSOURCEPATTERN = "fromSourcePattern";
    private static final String SINGLEPATTERN = "singlePattern";
    private static final String SEVERITYPATTERN = "severityPattern";
    private static final String SOURCEPATTERN = "sourcePattern";
    private static final String TARGETPATTERN = "targetPattern";
    private static final String DESCPATTERN = "descPattern";
    private static final String SHOWONLYPATTERNDESCRIPTION = "showOnlyPatternDescription";
    private static final String CHECKWITHLT = "checkWithLT";
    private static final String SERVERURL = "serverURL";
    private static final String LTBILINGUALMODE = "ltBilingualMode";
    private static final String SAVESESSION = "saveSession";
    private static final String SESSIONPATH = "sessionPath";
    private static final String DOUBLEDWORD = "doubledWord";
    private static final String DOUBLEDWORDEXCEPTIONS = "doubledWordExceptions";
    private static final String CHECKSTORAGESIZE = "checkStorageSize";
    private static final String CHECKMAXCHARLENGTH = "checkMaxCharLength";
    private static final String MAXCHARLENGTHBREAK = "maxCharLengthBreak";
    private static final String MAXCHARLENGTHABOVE = "maxCharLengthAbove";
    private static final String MAXCHARLENGTHBELOW = "maxCharLengthBelow";
    private static final String CHECKMINCHARLENGTH = "checkMinCharLength";
    private static final String MINCHARLENGTHBREAK = "minCharLengthBreak";
    private static final String MINCHARLENGTHABOVE = "minCharLengthAbove";
    private static final String MINCHARLENGTHBELOW = "minCharLengthBelow";
    private static final String CHECKABSOLUTEMAXCHARLENGTH = "checkAbsoluteMaxCharLength";
    private static final String ABSOLUTEMAXCHARLENGTH = "absoluteMaxCharLength";
    private static final String CHECKCHARACTERS = "checkCharacters";
    private static final String CHECKALLOWEDCHARACTERS = "checkAllowedCharacters";
    private static final String CHARSET = "charset";
    private static final String EXTRACHARSALLOWED = "extraCharsAllowed";
    private static final String CORRUPTEDCHARACTERS = "corruptedCharacters";
    private static final String SCOPE = "scope";
    private static final String EXTRACODESALLOWED = "extraCodesAllowed";
    private static final String MISSINGCODESALLOWED = "missingCodesAllowed";
    private static final String CHECKTERMS = "checkTerms";
    private static final String TERMSPATH = "termsPath";
    private static final String CHECKBLACKLIST = "checkBlacklist";
    private static final String ALLOWBLACKLISTSUB = "allowBlacklistSub";
    private static final String BLACKLISTSRC = "blacklistSrc";
    private static final String BLACKLISTPATH = "blacklistPath";
    private static final String STRINGMODE = "stringMode";
    private static final String BETWEENCODES = "betweenCodes";
    private static final String TYPESTOIGNORE = "typesToIgnore";
    private static final String SHOWFULLPATH = "showFullPath";
    private static final String INCLUDETEXTCONTAINERS = "includeTextContainers";
    List<PatternItem> patterns;
    List<String> extraCodesAllowed;
    List<String> missingCodesAllowed;
    InputStream blacklistStream;

    public List<String> getExtraCodesAllowed() {
        return this.extraCodesAllowed;
    }

    public List<String> getMissingCodesAllowed() {
        return this.missingCodesAllowed;
    }

    public String getTypesToIgnore() {
        return this.getString(TYPESTOIGNORE);
    }

    public void setTypesToIgnore(String typesToIgnore) {
        this.setString(TYPESTOIGNORE, typesToIgnore);
    }

    public int getScope() {
        return this.getInteger(SCOPE);
    }

    public void setScope(int scope) {
        this.setInteger(SCOPE, scope);
    }

    public boolean getCorruptedCharacters() {
        return this.getBoolean(CORRUPTEDCHARACTERS);
    }

    public void setCorruptedCharacters(boolean corruptedCharacters) {
        this.setBoolean(CORRUPTEDCHARACTERS, corruptedCharacters);
    }

    public boolean getCheckAllowedCharacters() {
        return this.getBoolean(CHECKALLOWEDCHARACTERS);
    }

    public void setCheckAllowedCharacters(boolean checkAllowedCharacters) {
        this.setBoolean(CHECKALLOWEDCHARACTERS, checkAllowedCharacters);
    }

    public boolean getCheckCharacters() {
        return this.getBoolean(CHECKCHARACTERS);
    }

    public void setCheckCharacters(boolean checkCharacters) {
        this.setBoolean(CHECKCHARACTERS, checkCharacters);
    }

    public String getCharset() {
        return this.getString(CHARSET);
    }

    public void setCharset(String charset) {
        this.setString(CHARSET, charset);
    }

    public String getExtraCharsAllowed() {
        return this.getString(EXTRACHARSALLOWED);
    }

    public void setExtraCharsAllowed(String extraCharsAllowed) {
        this.setString(EXTRACHARSALLOWED, extraCharsAllowed);
    }

    public boolean getCheckStorageSize() {
        return this.getBoolean(CHECKSTORAGESIZE);
    }

    public void setCheckStorageSize(boolean checkStorageSize) {
        this.setBoolean(CHECKSTORAGESIZE, checkStorageSize);
    }

    public boolean getCheckMaxCharLength() {
        return this.getBoolean(CHECKMAXCHARLENGTH);
    }

    public void setCheckMaxCharLength(boolean checkMaxCharLength) {
        this.setBoolean(CHECKMAXCHARLENGTH, checkMaxCharLength);
    }

    public int getMaxCharLengthBreak() {
        return this.getInteger(MAXCHARLENGTHBREAK);
    }

    public void setMaxCharLengthBreak(int maxCharLengthBreak) {
        this.setInteger(MAXCHARLENGTHBREAK, maxCharLengthBreak);
    }

    public int getMaxCharLengthAbove() {
        return this.getInteger(MAXCHARLENGTHABOVE);
    }

    public void setMaxCharLengthAbove(int maxCharLengthAbove) {
        this.setInteger(MAXCHARLENGTHABOVE, maxCharLengthAbove);
    }

    public int getMaxCharLengthBelow() {
        return this.getInteger(MAXCHARLENGTHBELOW);
    }

    public void setMaxCharLengthBelow(int maxCharLengthBelow) {
        this.setInteger(MAXCHARLENGTHBELOW, maxCharLengthBelow);
    }

    public boolean getCheckMinCharLength() {
        return this.getBoolean(CHECKMINCHARLENGTH);
    }

    public void setCheckMinCharLength(boolean checkMinCharLength) {
        this.setBoolean(CHECKMINCHARLENGTH, checkMinCharLength);
    }

    public int getMinCharLengthBreak() {
        return this.getInteger(MINCHARLENGTHBREAK);
    }

    public void setMinCharLengthBreak(int minCharLengthBreak) {
        this.setInteger(MINCHARLENGTHBREAK, minCharLengthBreak);
    }

    public int getMinCharLengthAbove() {
        return this.getInteger(MINCHARLENGTHABOVE);
    }

    public void setMinCharLengthAbove(int minCharLengthAbove) {
        this.setInteger(MINCHARLENGTHABOVE, minCharLengthAbove);
    }

    public int getMinCharLengthBelow() {
        return this.getInteger(MINCHARLENGTHBELOW);
    }

    public void setMinCharLengthBelow(int minCharLengthBelow) {
        this.setInteger(MINCHARLENGTHBELOW, minCharLengthBelow);
    }

    public boolean getCheckAbsoluteMaxCharLength() {
        return this.getBoolean(CHECKABSOLUTEMAXCHARLENGTH);
    }

    public void setCheckAbsoluteMaxCharLength(boolean checkAbsoluteMaxCharLength) {
        this.setBoolean(CHECKABSOLUTEMAXCHARLENGTH, checkAbsoluteMaxCharLength);
    }

    public int getAbsoluteMaxCharLength() {
        return this.getInteger(ABSOLUTEMAXCHARLENGTH);
    }

    public void setAbsoluteMaxCharLength(int absoluteMaxCharLength) {
        this.setInteger(ABSOLUTEMAXCHARLENGTH, absoluteMaxCharLength);
    }

    public boolean getDoubledWord() {
        return this.getBoolean(DOUBLEDWORD);
    }

    public void setDoubledWord(boolean doubledWord) {
        this.setBoolean(DOUBLEDWORD, doubledWord);
    }

    public String getDoubledWordExceptions() {
        return this.getString(DOUBLEDWORDEXCEPTIONS);
    }

    public void setDoubledWordExceptions(String doubledWordExceptions) {
        this.setString(DOUBLEDWORDEXCEPTIONS, doubledWordExceptions);
    }

    public boolean getSaveSession() {
        return this.getBoolean(SAVESESSION);
    }

    public void setSaveSession(boolean saveSession) {
        this.setBoolean(SAVESESSION, saveSession);
    }

    public String getSessionPath() {
        return this.getString(SESSIONPATH);
    }

    public void setSessionPath(String sessionPath) {
        this.setString(SESSIONPATH, sessionPath);
    }

    public String getOutputPath() {
        return this.getString(OUTPUTPATH);
    }

    public void setOutputPath(String outputPath) {
        this.setString(OUTPUTPATH, outputPath);
    }

    public int getOutputType() {
        return this.getInteger(OUTPUTTYPE);
    }

    public void setOutputType(int outputType) {
        this.setInteger(OUTPUTTYPE, outputType);
    }

    public boolean getAutoOpen() {
        return this.getBoolean(AUTOOPEN);
    }

    public void setAutoOpen(boolean autoOpen) {
        this.setBoolean(AUTOOPEN, autoOpen);
    }

    public boolean getLeadingWS() {
        return this.getBoolean(LEADINGWS);
    }

    public void setLeadingWS(boolean leadingWS) {
        this.setBoolean(LEADINGWS, leadingWS);
    }

    public boolean getTrailingWS() {
        return this.getBoolean(TRAILINGWS);
    }

    public void setTrailingWS(boolean trailingWS) {
        this.setBoolean(TRAILINGWS, trailingWS);
    }

    public boolean getEmptyTarget() {
        return this.getBoolean(EMPTYTARGET);
    }

    public void setEmptyTarget(boolean emptyTarget) {
        this.setBoolean(EMPTYTARGET, emptyTarget);
    }

    public boolean getEmptySource() {
        return this.getBoolean(EMPTYSOURCE);
    }

    public void setEmptySource(boolean emptySource) {
        this.setBoolean(EMPTYSOURCE, emptySource);
    }

    public boolean getTargetSameAsSource() {
        return this.getBoolean(TARGETSAMEASSOURCE);
    }

    public void setTargetSameAsSource(boolean targetSameAsSource) {
        this.setBoolean(TARGETSAMEASSOURCE, targetSameAsSource);
    }

    public boolean getTargetSameAsSourceForSameLanguage() {
        return this.getBoolean(TARGETSAMEASSOURCE_FORSAMELANGUAGE);
    }

    public void setTargetSameAsSourceForSameLanguage(boolean targetSameAsSourceForSameLanguage) {
        this.setBoolean(TARGETSAMEASSOURCE_FORSAMELANGUAGE, targetSameAsSourceForSameLanguage);
    }

    public boolean getTargetSameAsSourceWithCodes() {
        return this.getBoolean(TARGETSAMEASSOURCE_WITHCODES);
    }

    public void setTargetSameAsSourceWithCodes(boolean targetSameAsSourceWithCodes) {
        this.setBoolean(TARGETSAMEASSOURCE_WITHCODES, targetSameAsSourceWithCodes);
    }

    public boolean getTargetSameAsSourceWithNumbers() {
        return this.getBoolean(TARGETSAMEASSOURCE_WITHNUMBERS);
    }

    public void setTargetSameAsSourceWithNumbers(boolean targetSameAsSourceWithNumbers) {
        this.setBoolean(TARGETSAMEASSOURCE_WITHNUMBERS, targetSameAsSourceWithNumbers);
    }

    public boolean getCodeDifference() {
        return this.getBoolean(CODEDIFFERENCE);
    }

    public void setCodeDifference(boolean codeDifference) {
        this.setBoolean(CODEDIFFERENCE, codeDifference);
    }

    public boolean getGuessOpenClose() {
        return this.getBoolean(GUESSOPENCLOSE);
    }

    public void setGuessOpenClose(boolean guessOpenClose) {
        this.setBoolean(GUESSOPENCLOSE, guessOpenClose);
    }

    public boolean getStrictCodeOrder() {
        return this.getBoolean(STRICTCODEORDER);
    }

    public void setStrictCodeOrder(boolean strictCodeOrder) {
        this.setBoolean(STRICTCODEORDER, strictCodeOrder);
    }

    public boolean getCheckXliffSchema() {
        return this.getBoolean(CHECKXLIFFSCHEMA);
    }

    public void setCheckXliffSchema(boolean schema) {
        this.setBoolean(CHECKXLIFFSCHEMA, schema);
    }

    public boolean getCheckPatterns() {
        return this.getBoolean(CHECKPATTERNS);
    }

    public void setCheckPatterns(boolean patterns) {
        this.setBoolean(CHECKPATTERNS, patterns);
    }

    public List<PatternItem> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<PatternItem> patterns) {
        this.patterns = patterns;
    }

    public boolean getShowOnlyPatternDescription() {
        return this.getBoolean(SHOWONLYPATTERNDESCRIPTION);
    }

    public void setShowOnlyPatternDescription(boolean showOnlyPatterndescription) {
        this.setBoolean(SHOWONLYPATTERNDESCRIPTION, showOnlyPatterndescription);
    }

    public boolean getCheckWithLT() {
        return this.getBoolean(CHECKWITHLT);
    }

    public void setCheckWithLT(boolean checkWithLT) {
        this.setBoolean(CHECKWITHLT, checkWithLT);
    }

    public String getServerURL() {
        return this.getString(SERVERURL);
    }

    public void setServerURL(String serverURL) {
        this.setString(SERVERURL, serverURL);
    }

    public boolean getLtBilingualMode() {
        return this.getBoolean(LTBILINGUALMODE);
    }

    public void setLtBilingualMode(boolean ltBilingualMode) {
        this.setBoolean(LTBILINGUALMODE, ltBilingualMode);
    }

    public boolean getCheckTerms() {
        return this.getBoolean(CHECKTERMS);
    }

    public void setCheckTerms(boolean checkTerms) {
        this.setBoolean(CHECKTERMS, checkTerms);
    }

    public boolean getCheckBlacklist() {
        return this.getBoolean(CHECKBLACKLIST);
    }

    public boolean getAllowBlacklistSub() {
        return this.getBoolean(ALLOWBLACKLISTSUB);
    }

    public boolean getBlacklistSrc() {
        return this.getBoolean(BLACKLISTSRC);
    }

    public void setCheckBlacklist(boolean checkBlacklist) {
        this.setBoolean(CHECKBLACKLIST, checkBlacklist);
    }

    public void setAllowBlacklistSub(boolean allowBlacklistSub) {
        this.setBoolean(ALLOWBLACKLISTSUB, allowBlacklistSub);
    }

    public void setBlacklistSrc(boolean blacklistSrc) {
        this.setBoolean(BLACKLISTSRC, blacklistSrc);
    }

    public boolean getStringMode() {
        return this.getBoolean(STRINGMODE);
    }

    public void setStringMode(boolean stringMode) {
        this.setBoolean(STRINGMODE, stringMode);
    }

    public boolean getBetweenCodes() {
        return this.getBoolean(BETWEENCODES);
    }

    public void setBetweenCodes(boolean betweenCodes) {
        this.setBoolean(BETWEENCODES, betweenCodes);
    }

    public boolean getShowFullPath() {
        return this.getBoolean(SHOWFULLPATH);
    }

    public void setShowFullPath(boolean showFullPath) {
        this.setBoolean(SHOWFULLPATH, showFullPath);
    }

    public boolean getIncludeTextContainers() {
        return this.getBoolean(INCLUDETEXTCONTAINERS);
    }

    public void setIncludeTextContainers(boolean includeTextContainers) {
        this.setBoolean(INCLUDETEXTCONTAINERS, includeTextContainers);
    }

    @ReferenceParameter
    public String getTermsPath() {
        return this.getString(TERMSPATH);
    }

    public void setTermsPath(String termsPath) {
        this.setString(TERMSPATH, termsPath);
    }

    @ReferenceParameter
    public String getBlacklistPath() {
        return this.getString(BLACKLISTPATH);
    }

    public void setblacklistPath(String blacklistPath) {
        this.setString(BLACKLISTPATH, blacklistPath);
    }

    public InputStream getBlacklistStream() {
        return this.blacklistStream;
    }

    public void setBlacklistStream(InputStream blacklistStream) {
        this.blacklistStream = blacklistStream;
    }

    @Override
    public void reset() {
        super.reset();
        this.setIncludeTextContainers(false);
        this.setOutputPath("${rootDir}/qa-report.html");
        this.setOutputType(0);
        this.setAutoOpen(true);
        this.setLeadingWS(true);
        this.setTrailingWS(true);
        this.setEmptyTarget(true);
        this.setEmptySource(true);
        this.setTargetSameAsSource(true);
        this.setTargetSameAsSourceForSameLanguage(true);
        this.setTargetSameAsSourceWithCodes(true);
        this.setTargetSameAsSourceWithNumbers(true);
        this.setCodeDifference(true);
        this.setGuessOpenClose(true);
        this.setStrictCodeOrder(false);
        this.setCheckXliffSchema(true);
        this.setCheckPatterns(true);
        this.setCheckWithLT(false);
        this.setServerURL("http://localhost:8081/");
        this.setLtBilingualMode(false);
        this.setSaveSession(true);
        this.setSessionPath("${rootDir}/qa-session.qcs");
        this.setDoubledWord(true);
        this.setDoubledWordExceptions("sie;vous;nous");
        this.setCorruptedCharacters(true);
        this.setScope(0);
        this.setCheckMaxCharLength(true);
        this.setMaxCharLengthBreak(20);
        this.setMaxCharLengthAbove(200);
        this.setMaxCharLengthBelow(350);
        this.setCheckMinCharLength(true);
        this.setMinCharLengthBreak(20);
        this.setMinCharLengthAbove(45);
        this.setMinCharLengthBelow(30);
        this.setCheckStorageSize(true);
        this.setCheckAbsoluteMaxCharLength(false);
        this.setAbsoluteMaxCharLength(255);
        this.setCheckAllowedCharacters(true);
        this.setCheckCharacters(false);
        this.setCharset("ISO-8859-1");
        this.setExtraCharsAllowed("");
        this.setCheckTerms(false);
        this.setTermsPath("");
        this.setStringMode(false);
        this.setBetweenCodes(false);
        this.setShowFullPath(true);
        this.setCheckBlacklist(false);
        this.setAllowBlacklistSub(false);
        this.setBlacklistSrc(false);
        this.setblacklistPath("");
        this.setBlacklistStream(null);
        this.setShowOnlyPatternDescription(false);
        this.patterns = new ArrayList<PatternItem>();
        this.patterns.add(new PatternItem("[\\(\\uFF08]", "[\\(\\uFF08]", true, 0, "Opening parenthesis"));
        this.patterns.add(new PatternItem("[\\)\\uFF09]", "[\\)\\uFF09]", true, 0, "Closing parenthesis"));
        this.patterns.add(new PatternItem("[\\p{Ps}\\p{Pe}&&[^\\(\\)\\uFF08\\uFF09]]", "<same>", true, 0, "Bracketing characters (except parentheses)"));
        this.patterns.add(new PatternItem("[\\w\\.\\-]+@[\\w\\.\\-]+", "<same>", true, 1, "Email addresses"));
        this.patterns.add(new PatternItem("https?:[\\w/\\.:;+\\-~\\%#\\$?=&,()]+[\\w/:;+\\-~\\%#\\$?=&,()]+|www\\.[\\w/\\.:;+\\-~\\%#\\$?=&,()]+|ftp:[\\w/\\.:;+\\-~\\%#?=&,]+", "<same>", true, 1, "URLs"));
        this.patterns.add(new PatternItem("\\b(?:\\d{1,3}\\.){3}\\d{1,3}\\b", "<same>", true, 2, "IP addresses"));
        this.patterns.add(new PatternItem("%(([-0+#]?)[-0+#]?)((\\d\\$)?)(([\\d\\*]*)(\\.[\\d\\*]*)?)[dioxXucsfeEgGpn]", "<same>", true, 2, "C-style printf codes"));
        PatternItem item = new PatternItem("<same>", "([\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}])\\1\\1", true, 1, "Tripled letter");
        item.fromSource = false;
        this.patterns.add(item);
        this.extraCodesAllowed = new ArrayList<String>();
        this.missingCodesAllowed = new ArrayList<String>();
        this.setTypesToIgnore("mrk;x-df-s;");
    }

    @Override
    public void fromString(String data) {
        int i;
        super.fromString(data);
        int count = this.buffer.getInteger(PATTERNCOUNT, 0);
        if (count > 0) {
            this.patterns.clear();
        }
        for (i = 0; i < count; ++i) {
            boolean enabled = this.buffer.getBoolean(String.format("%s%d", USEPATTERN, i), true);
            int severity = this.buffer.getInteger(String.format("%s%d", SEVERITYPATTERN, i), 1);
            boolean fromSource = this.buffer.getBoolean(String.format("%s%d", FROMSOURCEPATTERN, i), true);
            boolean singlePattern = this.buffer.getBoolean(String.format("%s%d", SINGLEPATTERN, i), false);
            String source = this.buffer.getString(String.format("%s%d", SOURCEPATTERN, i), "");
            String target = this.buffer.getString(String.format("%s%d", TARGETPATTERN, i), "<same>");
            String desc = this.buffer.getString(String.format("%s%d", DESCPATTERN, i), "");
            PatternItem item = new PatternItem(source, target, enabled, severity, fromSource, desc);
            item.singlePattern = singlePattern;
            this.patterns.add(item);
        }
        count = this.buffer.getInteger(EXTRACODESALLOWED, 0);
        if (count > 0) {
            this.extraCodesAllowed.clear();
        }
        for (i = 0; i < count; ++i) {
            this.extraCodesAllowed.add(this.buffer.getString(String.format("%s%d", EXTRACODESALLOWED, i), ""));
        }
        count = this.buffer.getInteger(MISSINGCODESALLOWED, 0);
        if (count > 0) {
            this.missingCodesAllowed.clear();
        }
        for (i = 0; i < count; ++i) {
            this.missingCodesAllowed.add(this.buffer.getString(String.format("%s%d", MISSINGCODESALLOWED, i), ""));
        }
    }

    @Override
    public void fromString(String data, boolean clearParameters) {
        int i;
        super.fromString(data, clearParameters);
        int count = this.buffer.getInteger(PATTERNCOUNT, 0);
        if (count > 0) {
            this.patterns.clear();
        }
        for (i = 0; i < count; ++i) {
            boolean enabled = this.buffer.getBoolean(String.format("%s%d", USEPATTERN, i), true);
            int severity = this.buffer.getInteger(String.format("%s%d", SEVERITYPATTERN, i), 1);
            boolean fromSource = this.buffer.getBoolean(String.format("%s%d", FROMSOURCEPATTERN, i), true);
            boolean singlePattern = this.buffer.getBoolean(String.format("%s%d", SINGLEPATTERN, i), false);
            String source = this.buffer.getString(String.format("%s%d", SOURCEPATTERN, i), "");
            String target = this.buffer.getString(String.format("%s%d", TARGETPATTERN, i), "<same>");
            String desc = this.buffer.getString(String.format("%s%d", DESCPATTERN, i), "");
            PatternItem item = new PatternItem(source, target, enabled, severity, fromSource, desc);
            item.singlePattern = singlePattern;
            this.patterns.add(item);
        }
        count = this.buffer.getInteger(EXTRACODESALLOWED, 0);
        if (count > 0) {
            this.extraCodesAllowed.clear();
        }
        for (i = 0; i < count; ++i) {
            this.extraCodesAllowed.add(this.buffer.getString(String.format("%s%d", EXTRACODESALLOWED, i), ""));
        }
        count = this.buffer.getInteger(MISSINGCODESALLOWED, 0);
        if (count > 0) {
            this.missingCodesAllowed.clear();
        }
        for (i = 0; i < count; ++i) {
            this.missingCodesAllowed.add(this.buffer.getString(String.format("%s%d", MISSINGCODESALLOWED, i), ""));
        }
    }

    @Override
    public String toString() {
        int i;
        this.buffer.setInteger(PATTERNCOUNT, this.patterns.size());
        for (i = 0; i < this.patterns.size(); ++i) {
            this.buffer.setBoolean(String.format("%s%d", USEPATTERN, i), this.patterns.get((int)i).enabled);
            this.buffer.setBoolean(String.format("%s%d", FROMSOURCEPATTERN, i), this.patterns.get((int)i).fromSource);
            this.buffer.setBoolean(String.format("%s%d", SINGLEPATTERN, i), this.patterns.get((int)i).singlePattern);
            this.buffer.setInteger(String.format("%s%d", SEVERITYPATTERN, i), this.patterns.get((int)i).severity);
            this.buffer.setString(String.format("%s%d", SOURCEPATTERN, i), this.patterns.get((int)i).source);
            this.buffer.setString(String.format("%s%d", TARGETPATTERN, i), this.patterns.get((int)i).target);
            this.buffer.setString(String.format("%s%d", DESCPATTERN, i), this.patterns.get((int)i).description);
        }
        this.buffer.setInteger(EXTRACODESALLOWED, this.extraCodesAllowed.size());
        for (i = 0; i < this.extraCodesAllowed.size(); ++i) {
            this.buffer.setString(String.format("%s%d", EXTRACODESALLOWED, i), this.extraCodesAllowed.get(i));
        }
        this.buffer.setInteger(MISSINGCODESALLOWED, this.missingCodesAllowed.size());
        for (i = 0; i < this.missingCodesAllowed.size(); ++i) {
            this.buffer.setString(String.format("%s%d", MISSINGCODESALLOWED, i), this.missingCodesAllowed.get(i));
        }
        return super.toString();
    }
}

