/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockPropertiesFactory;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunProperty;

interface StyleOptimisation {
    public List<Chunk> applyTo(List<Chunk> var1) throws XMLStreamException;

    public static final class Default
    implements StyleOptimisation {
        private final Bypass bypassOptimisation;
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final QName blockPropertiesName;
        private final QName innerBlockPropertyName;

        Default(Bypass bypassOptimisation, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, QName blockPropertiesName, QName innerBlockPropertyName) {
            this.bypassOptimisation = bypassOptimisation;
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.blockPropertiesName = blockPropertiesName;
            this.innerBlockPropertyName = innerBlockPropertyName;
        }

        @Override
        public List<Chunk> applyTo(List<Chunk> chunks) throws XMLStreamException {
            if (chunks.size() <= 2) {
                return this.bypassOptimisation.applyTo(chunks);
            }
            List<Chunk> innerChunks = chunks.subList(1, chunks.size() - 1);
            List<RunProperty> commonRunProperties = Default.commonRunPropertiesOf(innerChunks);
            if (commonRunProperties.isEmpty()) {
                return this.bypassOptimisation.applyTo(chunks);
            }
            Block.BlockMarkup firstMarkup = (Block.BlockMarkup)chunks.get(0);
            BlockProperties blockProperties = this.blockPropertiesOf(firstMarkup);
            blockProperties.refine(this.innerBlockPropertyName, commonRunProperties);
            firstMarkup.updateOrAddComponent(blockProperties);
            this.refineRuns(innerChunks, commonRunProperties);
            return chunks;
        }

        private BlockProperties blockPropertiesOf(Block.BlockMarkup markup) {
            BlockProperties blockProperties = markup.blockProperties();
            if (null == blockProperties) {
                StartElement startElement = this.eventFactory.createStartElement(this.blockPropertiesName.getPrefix(), this.blockPropertiesName.getNamespaceURI(), this.blockPropertiesName.getLocalPart());
                EndElement endElement = this.eventFactory.createEndElement(this.blockPropertiesName.getPrefix(), this.blockPropertiesName.getNamespaceURI(), this.blockPropertiesName.getLocalPart());
                return BlockPropertiesFactory.createBlockProperties(this.conditionalParameters, this.eventFactory, startElement, endElement, new ArrayList<BlockProperty>());
            }
            return blockProperties;
        }

        private static List<RunProperty> commonRunPropertiesOf(List<Chunk> chunks) {
            ArrayList<RunProperty> commonRunProperties = new ArrayList<RunProperty>();
            for (Chunk chunk : chunks) {
                if (!(chunk instanceof Run)) continue;
                if (commonRunProperties.isEmpty()) {
                    commonRunProperties.addAll(((Run)chunk).getProperties().getProperties());
                    continue;
                }
                commonRunProperties.retainAll(((Run)chunk).getProperties().getProperties());
            }
            return commonRunProperties;
        }

        private void refineRuns(List<Chunk> chunks, List<RunProperty> commonRunProperties) {
            for (Chunk chunk : chunks) {
                if (!(chunk instanceof Run)) continue;
                ((Run)chunk).refineRunProperties(commonRunProperties);
            }
        }
    }

    public static final class Bypass
    implements StyleOptimisation {
        @Override
        public List<Chunk> applyTo(List<Chunk> chunks) {
            return chunks;
        }
    }
}

