/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.Parser;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunBuilderSkipper;
import net.sf.okapi.filters.openxml.RunMerger;
import net.sf.okapi.filters.openxml.RunParser;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.Text;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

final class StringItemParser
implements Parser<StringItem> {
    private final StartElementContext startElementContext;
    private final IdGenerator nestedBlockIdGenerator;
    private final StyleDefinitions styleDefinitions;
    private final StyleOptimisation styleOptimisation;
    private final RunBuilderSkipper runBuilderSkipper;
    private StringItemBuilder builder;
    private SkippableElements phoneticRunAndPropertySkippableElements;

    StringItemParser(StartElementContext startElementContext, IdGenerator nestedBlockIdGenerator, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation) {
        this.startElementContext = startElementContext;
        this.nestedBlockIdGenerator = nestedBlockIdGenerator;
        this.styleDefinitions = styleDefinitions;
        this.styleOptimisation = styleOptimisation;
        this.builder = new StringItemBuilder();
        this.runBuilderSkipper = new RunBuilderSkipper();
        this.phoneticRunAndPropertySkippableElements = new SkippableElements.Inline(new SkippableElements.Default(SkippableElement.PhoneticInline.PHONETIC_RUN, SkippableElement.PhoneticInline.PHONETIC_PROPERTY));
    }

    @Override
    public StringItem parse() throws XMLStreamException {
        XMLEvent e;
        this.builder.addMarkupComponent(MarkupComponentFactory.createStartMarkupComponent(this.startElementContext.getEventFactory(), this.startElementContext.getStartElement()));
        RunMerger runMerger = new RunMerger();
        do {
            if (XMLEventHelpers.isRunStartEvent(e = this.startElementContext.getEventReader().nextEvent())) {
                this.processRun(this.builder, runMerger, e.asStartElement());
                continue;
            }
            if (XMLEventHelpers.isTextStartEvent(e)) {
                this.addRunsToBuilder(this.builder, runMerger);
                this.processText(e.asStartElement(), this.builder);
                continue;
            }
            if (e.isStartElement() && this.phoneticRunAndPropertySkippableElements.canBeSkipped(e.asStartElement(), this.startElementContext.getStartElement())) {
                this.phoneticRunAndPropertySkippableElements.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext));
                continue;
            }
            if (XMLEventHelpers.isWhitespace(e)) continue;
            this.addRunsToBuilder(this.builder, runMerger);
            if (e.isEndElement() && this.startElementContext.getStartElement().getName().equals(e.asEndElement().getName())) {
                this.builder.addMarkupComponent(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                return this.builder.buildWith(this.styleOptimisation);
            }
            this.builder.addEvent(e);
        } while (this.startElementContext.getEventReader().hasNext() && !XMLEventHelpers.isStringItemEndEvent(e));
        throw new IllegalStateException("Invalid content? Unterminated string item");
    }

    private void processRun(StringItemBuilder builder, RunMerger runMerger, StartElement startEl) throws XMLStreamException {
        StartElementContext runElementContext = StartElementContextFactory.createStartElementContext(startEl, this.startElementContext);
        RunBuilder runBuilder = new RunParser(runElementContext, this.nestedBlockIdGenerator, this.styleDefinitions, this.styleOptimisation, null, false).parse();
        if (this.runBuilderSkipper.canSkip(runBuilder)) {
            return;
        }
        builder.setRunName(startEl.getName());
        builder.setTextName(runBuilder.getTextName());
        runMerger.add(runBuilder);
    }

    private void processText(StartElement startElement, StringItemBuilder builder) throws XMLStreamException {
        EndElement endElement;
        Characters characters;
        XMLEvent event = this.startElementContext.getEventReader().nextEvent();
        if (event.isEndElement()) {
            characters = this.startElementContext.getEventFactory().createCharacters("");
            endElement = event.asEndElement();
        } else {
            characters = event.asCharacters();
            endElement = this.startElementContext.getEventReader().nextEvent().asEndElement();
        }
        Text text = new Text(startElement, characters, endElement);
        builder.addChunk(text);
    }

    private void addRunsToBuilder(StringItemBuilder builder, RunMerger runMerger) throws XMLStreamException {
        for (Block.BlockChunk chunk : runMerger.getRuns()) {
            builder.addChunk(chunk);
        }
        runMerger.reset();
    }

    private static class StringItemBuilder {
        private QName name;
        private QName textName;
        private List<Chunk> chunks = new ArrayList<Chunk>();
        private List<XMLEvent> currentMarkupComponentEvents = new ArrayList<XMLEvent>();
        private Markup markup = new Block.BlockMarkup();

        private StringItemBuilder() {
        }

        void setRunName(QName name) {
            this.name = name;
        }

        void setTextName(QName textName) {
            this.textName = textName;
        }

        void flushMarkup() {
            if (!this.currentMarkupComponentEvents.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupComponentEvents));
                this.currentMarkupComponentEvents = new ArrayList<XMLEvent>();
            }
            if (!this.markup.getComponents().isEmpty()) {
                this.chunks.add(this.markup);
                this.markup = new Block.BlockMarkup();
            }
        }

        void addChunk(Chunk chunk) {
            this.flushMarkup();
            this.chunks.add(chunk);
        }

        StringItem buildWith(StyleOptimisation styleOptimisation) throws XMLStreamException {
            this.flushMarkup();
            return new StringItem(styleOptimisation.applyTo(this.chunks), this.name, this.textName);
        }

        void addMarkupComponent(MarkupComponent markupComponent) {
            if (!this.currentMarkupComponentEvents.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupComponentEvents));
                this.currentMarkupComponentEvents = new ArrayList<XMLEvent>();
            }
            this.markup.addComponent(markupComponent);
        }

        void addEvent(XMLEvent event) {
            this.currentMarkupComponentEvents.add(event);
        }
    }
}

