/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Namespaces2;
import net.sf.okapi.filters.openxml.PresentationNotesStyleDefinitions;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunPropertyFactory;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleDefinitionsParser;

class PresentationNotesStylesParser
implements StyleDefinitionsParser {
    private static final String UNEXPECTED_STRUCTURE = "Unexpected structure";
    private static final String NOTES_MASTER = "notesMaster";
    private static final String NOTES_STYLE = "notesStyle";
    private static final String DEFAULT_RPR = "defRPr";
    private static final int INVALID_PARAGRAPH_LEVEL_ID = -1;
    static final String DEFAULT_PARAGRAPH_LEVEL_ID = "0";
    private final XMLEventFactory eventFactory;
    private final XMLInputFactory inputFactory;
    private final Reader reader;
    private final ConditionalParameters conditionalParameters;
    private Namespaces2 namespaces;
    private QName notesStyle;
    private QName defaultRPr;
    private List<QName> paragraphLevelNames;

    PresentationNotesStylesParser(XMLEventFactory eventFactory, XMLInputFactory inputFactory, Reader reader, ConditionalParameters conditionalParameters) {
        this.eventFactory = eventFactory;
        this.inputFactory = inputFactory;
        this.reader = reader;
        this.conditionalParameters = conditionalParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StyleDefinitions parse() throws XMLStreamException, IOException {
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(this.reader);
        Map<String, RunProperties> runPropertiesByParagraphLevelIds = null;
        try {
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement element = event.asStartElement();
                if (NOTES_MASTER.equals(element.getName().getLocalPart())) {
                    this.namespaces = new Namespaces2.Default(element);
                    this.qualifyNames(element);
                    continue;
                }
                if (!this.notesStyle.equals(element.getName())) continue;
                runPropertiesByParagraphLevelIds = this.parseNotesStyle(element, eventReader);
                break;
            }
        }
        finally {
            this.reader.close();
        }
        if (null == runPropertiesByParagraphLevelIds) {
            runPropertiesByParagraphLevelIds = PresentationNotesStylesParser.defaultRunPropertiesByParagraphLevelId();
        }
        return new PresentationNotesStyleDefinitions(this.getExtraDocumentDefaultRunProperties(), runPropertiesByParagraphLevelIds);
    }

    private void qualifyNames(StartElement startElement) {
        this.notesStyle = new QName(startElement.getNamespaceURI("p"), NOTES_STYLE, "p");
        String namespaceUri = startElement.getNamespaceURI("a");
        String prefix = "a";
        this.defaultRPr = new QName(namespaceUri, DEFAULT_RPR, "a");
        this.paragraphLevelNames = Arrays.asList(new QName(namespaceUri, "lvl1pPr", "a"), new QName(namespaceUri, "lvl2pPr", "a"), new QName(namespaceUri, "lvl3pPr", "a"), new QName(namespaceUri, "lvl4pPr", "a"), new QName(namespaceUri, "lvl5pPr", "a"), new QName(namespaceUri, "lvl6pPr", "a"), new QName(namespaceUri, "lvl7pPr", "a"), new QName(namespaceUri, "lvl8pPr", "a"), new QName(namespaceUri, "lvl9pPr", "a"));
    }

    private RunProperties getExtraDocumentDefaultRunProperties() {
        return new RunProperties.DefaultRunProperties(this.eventFactory, null, null, Collections.singletonList(RunPropertyFactory.createRunProperty(new QName(null, "baseline"), DEFAULT_PARAGRAPH_LEVEL_ID)));
    }

    private Map<String, RunProperties> parseNotesStyle(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
        HashMap<String, RunProperties> runPropertiesByParagraphLevelIds = new HashMap<String, RunProperties>(this.paragraphLevelNames.size());
        while (reader.hasNext()) {
            StartElement element;
            int paragraphLevelId;
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                if (runPropertiesByParagraphLevelIds.isEmpty()) {
                    return PresentationNotesStylesParser.defaultRunPropertiesByParagraphLevelId();
                }
                return runPropertiesByParagraphLevelIds;
            }
            if (!event.isStartElement() || -1 == (paragraphLevelId = this.getParagraphLevelIdByName((element = event.asStartElement()).getName()))) continue;
            runPropertiesByParagraphLevelIds.put(String.valueOf(paragraphLevelId), this.parseParagraphLevelRunProperties(element, reader));
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE);
    }

    private static Map<String, RunProperties> defaultRunPropertiesByParagraphLevelId() {
        return Collections.singletonMap(DEFAULT_PARAGRAPH_LEVEL_ID, RunProperties.emptyRunProperties());
    }

    private int getParagraphLevelIdByName(QName name) {
        for (int id = 0; id < this.paragraphLevelNames.size(); ++id) {
            QName paragraphLevel = this.paragraphLevelNames.get(id);
            if (!name.equals(paragraphLevel)) continue;
            return id;
        }
        return -1;
    }

    private RunProperties parseParagraphLevelRunProperties(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
        RunProperties runProperties = null;
        while (reader.hasNext()) {
            StartElement element;
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                if (null == runProperties) {
                    return RunProperties.emptyRunProperties();
                }
                return runProperties;
            }
            if (!event.isStartElement() || !this.defaultRPr.equals((element = event.asStartElement()).getName())) continue;
            runProperties = this.parseDefaultRunProperties(element, reader);
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE);
    }

    private RunProperties parseDefaultRunProperties(StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(startElement, eventReader, this.eventFactory, this.conditionalParameters);
        RunSkippableElements runSkippableElements = new RunSkippableElements(startElementContext);
        return new RunPropertiesParser(startElementContext, runSkippableElements).parse();
    }
}

