/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.HashMap;
import java.util.Map;

public enum Color {
    BLUE("blue", "FF0070C0", "0070C0"),
    LIGHT_BLUE("light blue", "FF00B0F0", "00B0F0"),
    GREEN("green", "FF00B050", "00B050"),
    PURPLE("purple", "FF7030A0", "7030A0"),
    RED("red", "FFFF0000", "FF0000"),
    YELLOW("yellow", "FFFFFF00", "FFFF00"),
    DARK_RED("dark red", "FFC00000", "C00000"),
    LIGHT_GREEN("light green", "FF92D050", "92D050"),
    ORANGE("orange", "FFFFC000", "FFC000"),
    DARK_BLUE("dark blue", "FF002060", "002060");

    private static final Map<String, Color> map;
    private final String name;
    private final String excelColorCode;
    private final String wordColorCode;

    private Color(String name, String excelColorCode, String wordColorCode) {
        this.name = name;
        this.excelColorCode = excelColorCode;
        this.wordColorCode = wordColorCode;
    }

    public static Color fromName(String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        return null;
    }

    public static Color fromCode(String code) {
        for (Map.Entry<String, Color> e : map.entrySet()) {
            Color color = e.getValue();
            if (!color.getExcelColorCode().equals(code) && !color.getWordColorCode().equals(code)) continue;
            return e.getValue();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getExcelColorCode() {
        return this.excelColorCode;
    }

    public String getWordColorCode() {
        return this.wordColorCode;
    }

    static {
        map = new HashMap<String, Color>();
        for (Color color : Color.values()) {
            map.put(color.getName(), color);
        }
    }
}

