/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ListIterator;
import net.sf.okapi.filters.openxml.BlockPropertiesClarifierStrategy;
import net.sf.okapi.filters.openxml.BlockPropertiesClarifierStrategyFactory;
import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.MarkupComponent;

class BlockPropertiesClarifier {
    private BlockPropertiesClarifierStrategy strategy;

    BlockPropertiesClarifier(BlockPropertiesClarifierStrategy strategy) {
        this.strategy = strategy;
    }

    void clarify(ListIterator<MarkupComponent> markupComponentIterator) {
        this.strategy.clarifyBlockProperties(markupComponentIterator);
    }

    static class TablePropertiesClarifier
    extends BlockPropertiesClarifier {
        TablePropertiesClarifier(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
            super(BlockPropertiesClarifierStrategyFactory.createTablePropertiesClarifierStrategy(conditionalParameters, creationalParameters, clarificationParameters));
        }
    }

    static class TextBodyPropertiesClarifier
    extends BlockPropertiesClarifier {
        TextBodyPropertiesClarifier(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
            super(BlockPropertiesClarifierStrategyFactory.createTextBodyPropertiesClarifierStrategy(conditionalParameters, creationalParameters, clarificationParameters));
        }
    }

    static class ParagraphPropertiesClarifier
    extends BlockPropertiesClarifier {
        ParagraphPropertiesClarifier(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
            super(BlockPropertiesClarifierStrategyFactory.createParagraphPropertiesClarifierStrategy(conditionalParameters, creationalParameters, clarificationParameters));
        }
    }
}

