/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ListIterator;
import net.sf.okapi.filters.openxml.BlockPropertiesClarifier;
import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentClarifier;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesClarifier;

class BidirectionalityClarifier {
    private final ConditionalParameters conditionalParameters;
    private final CreationalParameters creationalParameters;
    private final ClarificationParameters clarificationParameters;

    BidirectionalityClarifier(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
        this.conditionalParameters = conditionalParameters;
        this.creationalParameters = creationalParameters;
        this.clarificationParameters = clarificationParameters;
    }

    void clarifyMarkup(Markup markup) {
        ListIterator<MarkupComponent> markupComponentIterator = markup.getComponents().listIterator();
        while (markupComponentIterator.hasNext()) {
            MarkupComponent markupComponent = markupComponentIterator.next();
            if (MarkupComponent.isSheetViewMarkupComponent(markupComponent)) {
                this.clarifySheetViewMarkupComponent(markupComponent);
                continue;
            }
            if (MarkupComponent.isAlignmentEmptyElementMarkupComponent(markupComponent)) {
                this.clarifyAlignmentEmptyElementMarkupComponent(markupComponent);
                continue;
            }
            if (MarkupComponent.isPresentationStartMarkupComponent(markupComponent)) {
                this.clarifyPresentationMarkupComponent(markupComponent);
                continue;
            }
            if (MarkupComponent.isTableStartMarkupComponent(markupComponent)) {
                this.clarifyTableProperties(markupComponentIterator);
                continue;
            }
            if (MarkupComponent.isTextBodyStartMarkupComponent(markupComponent)) {
                this.clarifyTextBodyProperties(markupComponentIterator);
                continue;
            }
            if (!MarkupComponent.isParagraphStartMarkupComponent(markupComponent)) continue;
            this.clarifyParagraphProperties(markupComponentIterator);
        }
    }

    private void clarifySheetViewMarkupComponent(MarkupComponent markupComponent) {
        new MarkupComponentClarifier.SheetViewClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponent);
    }

    private void clarifyAlignmentEmptyElementMarkupComponent(MarkupComponent markupComponent) {
        new MarkupComponentClarifier.AlignmentClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponent);
    }

    private void clarifyPresentationMarkupComponent(MarkupComponent markupComponent) {
        new MarkupComponentClarifier.PresentationClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponent);
    }

    private void clarifyTableProperties(ListIterator<MarkupComponent> markupComponentIterator) {
        new BlockPropertiesClarifier.TablePropertiesClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponentIterator);
    }

    private void clarifyTextBodyProperties(ListIterator<MarkupComponent> markupComponentIterator) {
        new BlockPropertiesClarifier.TextBodyPropertiesClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponentIterator);
    }

    private void clarifyParagraphProperties(ListIterator<MarkupComponent> markupComponentIterator) {
        new BlockPropertiesClarifier.ParagraphPropertiesClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponentIterator);
    }

    RunProperties clarifyRunProperties(RunProperties runProperties) {
        return new RunPropertiesClarifier(this.creationalParameters, this.clarificationParameters).clarify(runProperties);
    }
}

