/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.Property;

class StyleRange {
    static final String APPLIED_PARAGRAPH_STYLE = "AppliedParagraphStyle";
    static final String APPLIED_PARAGRAPH_STYLE_DEFAULT_VALUE = "ParagraphStyle/$ID/NormalParagraphStyle";
    static final String APPLIED_CHARACTER_STYLE = "AppliedCharacterStyle";
    static final String APPLIED_CHARACTER_STYLE_DEFAULT_VALUE = "CharacterStyle/$ID/[No character style]";
    private final List<Attribute> attributes;
    private final Properties properties;

    StyleRange(List<Attribute> attributes, Properties properties) {
        this.attributes = attributes;
        this.properties = properties;
    }

    static StyleRange getDefaultParagraphStyleRange(XMLEventFactory eventFactory) {
        List<Attribute> attributes = Collections.singletonList(eventFactory.createAttribute(APPLIED_PARAGRAPH_STYLE, APPLIED_PARAGRAPH_STYLE_DEFAULT_VALUE));
        Properties properties = Properties.getEmptyProperties();
        return new StyleRange(attributes, properties);
    }

    static StyleRange getDefaultCharacterStyleRange(XMLEventFactory eventFactory) {
        List<Attribute> attributes = Collections.singletonList(eventFactory.createAttribute(APPLIED_CHARACTER_STYLE, APPLIED_CHARACTER_STYLE_DEFAULT_VALUE));
        Properties properties = Properties.getEmptyProperties();
        return new StyleRange(attributes, properties);
    }

    List<Attribute> getAttributes() {
        return this.attributes;
    }

    Properties getProperties() {
        return this.properties;
    }

    boolean isSubsetOf(StyleRange other) {
        if (this.getAttributes().isEmpty() && !other.getAttributes().isEmpty() || this.getProperties().isEmpty() && !other.getProperties().isEmpty()) {
            return false;
        }
        block0: for (Attribute attribute : this.getAttributes()) {
            for (Attribute otherAttribute : other.getAttributes()) {
                if (!otherAttribute.equals(attribute)) continue;
                continue block0;
            }
            return false;
        }
        block2: for (Property property : this.getProperties().getProperties()) {
            for (Property otherProperty : other.getProperties().getProperties()) {
                if (!otherProperty.equals(property)) continue;
                continue block2;
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        StyleRange that = (StyleRange)o;
        return this.areAttributesEqual(this.getAttributes(), that.getAttributes()) && Objects.equals(this.getProperties(), that.getProperties());
    }

    private boolean areAttributesEqual(List<Attribute> thisAttributes, List<Attribute> thatAttributes) {
        if (thisAttributes == thatAttributes) {
            return true;
        }
        if (null == thisAttributes || null == thatAttributes) {
            return false;
        }
        if (thisAttributes.size() != thatAttributes.size()) {
            return false;
        }
        Iterator<Attribute> thisAttributesIterator = thisAttributes.iterator();
        Iterator<Attribute> thatAttributesIterator = thatAttributes.iterator();
        while (thisAttributesIterator.hasNext() && thatAttributesIterator.hasNext()) {
            Attribute thisAttribute = thisAttributesIterator.next();
            Attribute thatAttribute = thatAttributesIterator.next();
            if (thisAttribute.getName().equals(thatAttribute.getName()) && thisAttribute.getValue().equals(thatAttribute.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.getAttributes(), this.getProperties());
    }

    static class StyleRangeBuilder
    implements Builder<StyleRange> {
        private List<Attribute> attributes;
        private Properties properties;

        StyleRangeBuilder() {
        }

        StyleRangeBuilder setAttributes(List<Attribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        StyleRangeBuilder setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public StyleRange build() {
            return new StyleRange(this.attributes, this.properties);
        }
    }
}

