/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.Property;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyleDefinitions;
import net.sf.okapi.filters.idml.StyleIgnorances;
import net.sf.okapi.filters.idml.StyleRange;

final class StoryChildElementsMerger {
    private static final String UNEXPECTED_ELEMENT_TYPE = "Unexpected element type: ";
    private static final int MIN_NUMBER_OF_CHILD_ELEMENTS_TO_MERGE = 2;
    private static final int CURRENT_ELEMENT_INDEX = 0;
    private static final int NEXT_ELEMENT_INDEX = 1;
    private final Parameters parameters;

    StoryChildElementsMerger(Parameters parameters) {
        this.parameters = parameters;
    }

    List<StoryChildElement> merge(List<StoryChildElement> storyChildElements) {
        if (!this.neededToBeMerged(storyChildElements)) {
            return storyChildElements;
        }
        ArrayList<StoryChildElement> mergedStoryChildElements = new ArrayList<StoryChildElement>(storyChildElements.size());
        Iterator<StoryChildElement> elementIterator = storyChildElements.iterator();
        StoryChildElement currentElement = elementIterator.next();
        do {
            boolean elementsStyleDefinitionsCanBeMerged;
            StoryChildElement nextElement;
            if (this.canElementsBeMerged(currentElement, nextElement = elementIterator.next(), elementsStyleDefinitionsCanBeMerged = this.canElementsStyleDefinitionsBeMerged(currentElement, nextElement))) {
                currentElement = StoryChildElementsMerger.mergeElements(currentElement, nextElement);
                continue;
            }
            if (elementsStyleDefinitionsCanBeMerged) {
                List<StoryChildElement> elements = StoryChildElementsMerger.mergeElementsStyleDefinitions(currentElement, nextElement);
                mergedStoryChildElements.add(elements.get(0));
                currentElement = elements.get(1);
                continue;
            }
            mergedStoryChildElements.add(currentElement);
            currentElement = nextElement;
        } while (elementIterator.hasNext());
        mergedStoryChildElements.add(currentElement);
        return mergedStoryChildElements;
    }

    private boolean neededToBeMerged(List<StoryChildElement> storyChildElements) {
        return 2 <= storyChildElements.size() && (this.parameters.getIgnoreCharacterKerning() || this.parameters.getIgnoreCharacterTracking() || this.parameters.getIgnoreCharacterLeading() || this.parameters.getIgnoreCharacterBaselineShift());
    }

    private boolean canElementsBeMerged(StoryChildElement currentElement, StoryChildElement nextElement, boolean elementsStyleDefinitionsCanBeMerged) {
        return this.isContent(currentElement) && this.isContent(nextElement) && elementsStyleDefinitionsCanBeMerged;
    }

    private boolean isContent(StoryChildElement element) {
        return element instanceof StoryChildElement.StyledTextElement.Content;
    }

    private boolean canElementsStyleDefinitionsBeMerged(StoryChildElement currentElement, StoryChildElement nextElement) {
        if (!this.hasElementStyleDefinitions(currentElement) || !this.hasElementStyleDefinitions(nextElement)) {
            return false;
        }
        return this.canStyleRangesBeMerged(this.elementStyleDefinitions(currentElement).getCombinedStyleRange(), this.elementStyleDefinitions(nextElement).getCombinedStyleRange());
    }

    private boolean hasElementStyleDefinitions(StoryChildElement element) {
        return element instanceof StoryChildElement.StyledTextElement && null != ((StoryChildElement.StyledTextElement)element).getStyleDefinitions();
    }

    private StyleDefinitions elementStyleDefinitions(StoryChildElement element) {
        if (!this.hasElementStyleDefinitions(element)) {
            throw new IllegalArgumentException(UNEXPECTED_ELEMENT_TYPE + element.getClass().getTypeName());
        }
        return ((StoryChildElement.StyledTextElement)element).getStyleDefinitions();
    }

    private boolean canStyleRangesBeMerged(StyleRange currentStyleRange, StyleRange nextStyleRange) {
        return this.canAttributesBeMerged(currentStyleRange.getAttributes(), nextStyleRange.getAttributes()) && this.canPropertiesBeMerged(currentStyleRange.getProperties(), nextStyleRange.getProperties());
    }

    private boolean canAttributesBeMerged(List<Attribute> currentAttributes, List<Attribute> nextAttributes) {
        Set<Attribute> nextAttributesWithoutIgnorances;
        Map<QName, Attribute> currentAttributeIgnorancesByName = this.attributeIgnorancesByName(currentAttributes);
        Map<QName, Attribute> nextAttributeIgnorancesByName = this.attributeIgnorancesByName(nextAttributes);
        Set<Attribute> currentAttributesWithoutIgnorances = StoryChildElementsMerger.attributesWithoutIgnorances(currentAttributes, currentAttributeIgnorancesByName);
        return StoryChildElementsMerger.canAttributesWithoutIgnorancesBeMerged(currentAttributesWithoutIgnorances, nextAttributesWithoutIgnorances = StoryChildElementsMerger.attributesWithoutIgnorances(nextAttributes, nextAttributeIgnorancesByName)) && this.canAttributesWithIgnorancesBeMerged(currentAttributeIgnorancesByName, nextAttributeIgnorancesByName);
    }

    private Map<QName, Attribute> attributeIgnorancesByName(List<Attribute> attributes) {
        return attributes.stream().filter(attribute -> this.parameters.styleIgnorances().isAttributeNamePresent(attribute.getName())).collect(Collectors.toMap(Attribute::getName, Function.identity()));
    }

    private static Set<Attribute> attributesWithoutIgnorances(List<Attribute> attributes, Map<QName, Attribute> attributeIgnorancesByName) {
        return attributes.stream().filter(attribute -> !attributeIgnorancesByName.containsKey(attribute.getName())).collect(Collectors.toSet());
    }

    private static boolean canAttributesWithoutIgnorancesBeMerged(Set<Attribute> currentAttributesWithoutIgnorances, Set<Attribute> nextAttributesWithoutIgnorances) {
        return currentAttributesWithoutIgnorances.equals(nextAttributesWithoutIgnorances);
    }

    private boolean canAttributesWithIgnorancesBeMerged(Map<QName, Attribute> currentAttributeIgnorancesByName, Map<QName, Attribute> nextAttributeIgnorancesByName) {
        Set<QName> commonAttributeNameIgnorances = currentAttributeIgnorancesByName.keySet().stream().filter(nextAttributeIgnorancesByName::containsKey).collect(Collectors.toSet());
        return this.canCommonAttributeNameIgnorancesBeMerged(currentAttributeIgnorancesByName, nextAttributeIgnorancesByName, commonAttributeNameIgnorances) && this.canDistinctAttributeNameIgnorancesBeMerged(currentAttributeIgnorancesByName, commonAttributeNameIgnorances) && this.canDistinctAttributeNameIgnorancesBeMerged(nextAttributeIgnorancesByName, commonAttributeNameIgnorances);
    }

    private boolean canCommonAttributeNameIgnorancesBeMerged(Map<QName, Attribute> currentAttributeIgnorancesByName, Map<QName, Attribute> nextAttributeIgnorancesByName, Set<QName> commonAttributeNameIgnorances) {
        for (QName name : commonAttributeNameIgnorances) {
            if (this.canValuesBeIgnored(name, currentAttributeIgnorancesByName.get(name).getValue(), nextAttributeIgnorancesByName.get(name).getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean canDistinctAttributeNameIgnorancesBeMerged(Map<QName, Attribute> attributeIgnorancesByName, Set<QName> commonAttributeNameIgnorances) {
        Set attributeNameIgnorances = attributeIgnorancesByName.keySet().stream().filter(name -> !commonAttributeNameIgnorances.contains(name)).collect(Collectors.toSet());
        for (QName name2 : attributeNameIgnorances) {
            if (this.canValuesBeIgnored(name2, attributeIgnorancesByName.get(name2).getValue(), attributeIgnorancesByName.get(name2).getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean canValuesBeIgnored(QName name, String currentValue, String nextValue) {
        StyleIgnorances.Thresholds thresholds = this.parameters.styleIgnorances().thresholds(name);
        switch (thresholds.type()) {
            case INTEGER: {
                return this.canIntegerValuesBeIgnored(Integer.valueOf(currentValue), Integer.valueOf(nextValue), thresholds);
            }
            case DOUBLE: {
                return this.canDoubleValuesBeIgnored(Double.valueOf(currentValue), Double.valueOf(nextValue), thresholds);
            }
            case STRING: {
                return this.canStringValuesBeIgnored(thresholds);
            }
        }
        return false;
    }

    private boolean canIntegerValuesBeIgnored(int currentValue, int nextValue, StyleIgnorances.Thresholds thresholds) {
        if (!thresholds.min().isEmpty() && thresholds.max().isEmpty()) {
            int minThreshold = Integer.valueOf(thresholds.min());
            return minThreshold <= currentValue && minThreshold <= nextValue;
        }
        if (thresholds.min().isEmpty() && !thresholds.max().isEmpty()) {
            int maxThreshold = Integer.valueOf(thresholds.max());
            return currentValue <= maxThreshold && nextValue <= maxThreshold;
        }
        if (!thresholds.min().isEmpty() && !thresholds.max().isEmpty()) {
            int minThreshold = Integer.valueOf(thresholds.min());
            int maxThreshold = Integer.valueOf(thresholds.max());
            return minThreshold <= currentValue && minThreshold <= nextValue && currentValue <= maxThreshold && nextValue <= maxThreshold;
        }
        return true;
    }

    private boolean canDoubleValuesBeIgnored(double currentValue, double nextValue, StyleIgnorances.Thresholds thresholds) {
        if (!thresholds.min().isEmpty() && thresholds.max().isEmpty()) {
            double minThreshold = Double.valueOf(thresholds.min());
            return minThreshold <= currentValue && minThreshold <= nextValue;
        }
        if (thresholds.min().isEmpty() && !thresholds.max().isEmpty()) {
            double maxThreshold = Double.valueOf(thresholds.max());
            return currentValue <= maxThreshold && nextValue <= maxThreshold;
        }
        if (!thresholds.min().isEmpty() && !thresholds.max().isEmpty()) {
            double minThreshold = Double.valueOf(thresholds.min());
            double maxThreshold = Double.valueOf(thresholds.max());
            return minThreshold <= currentValue && minThreshold <= nextValue && currentValue <= maxThreshold && nextValue <= maxThreshold;
        }
        return true;
    }

    private boolean canStringValuesBeIgnored(StyleIgnorances.Thresholds thresholds) {
        return thresholds.areEmpty();
    }

    private boolean canPropertiesBeMerged(Properties currentProperties, Properties nextProperties) {
        Set<Property> nextAttributesWithoutIgnorances;
        Map<QName, Property> currentPropertyIgnorancesByName = this.propertyIgnorancesByName(currentProperties);
        Map<QName, Property> nextPropertyIgnorancesByName = this.propertyIgnorancesByName(nextProperties);
        Set<Property> currentPropertiesWithoutIgnorances = StoryChildElementsMerger.propertiesWithoutIgnorances(currentProperties, currentPropertyIgnorancesByName);
        return StoryChildElementsMerger.canPropertiesWithoutIgnorancesBeMerged(currentPropertiesWithoutIgnorances, nextAttributesWithoutIgnorances = StoryChildElementsMerger.propertiesWithoutIgnorances(nextProperties, nextPropertyIgnorancesByName)) && this.canPropertiesWithIgnorancesBeMerged(currentPropertyIgnorancesByName, nextPropertyIgnorancesByName);
    }

    private Map<QName, Property> propertyIgnorancesByName(Properties properties) {
        return properties.getProperties().stream().filter(property -> this.parameters.styleIgnorances().isPropertyNamePresent(property.getName())).collect(Collectors.toMap(MarkupRange.MarkupRangeElement::getName, Function.identity()));
    }

    private static Set<Property> propertiesWithoutIgnorances(Properties properties, Map<QName, Property> propertyIgnorancesByName) {
        return properties.getProperties().stream().filter(attribute -> !propertyIgnorancesByName.containsKey(attribute.getName())).collect(Collectors.toSet());
    }

    private static boolean canPropertiesWithoutIgnorancesBeMerged(Set<Property> currentPropertiesWithoutIgnorances, Set<Property> nextPropertiesWithoutIgnorances) {
        return currentPropertiesWithoutIgnorances.equals(nextPropertiesWithoutIgnorances);
    }

    private boolean canPropertiesWithIgnorancesBeMerged(Map<QName, Property> currentPropertyIgnorancesByName, Map<QName, Property> nextPropertyIgnorancesByName) {
        Set<QName> commonPropertyNameIgnorances = currentPropertyIgnorancesByName.keySet().stream().filter(nextPropertyIgnorancesByName::containsKey).collect(Collectors.toSet());
        return this.canCommonPropertyNameIgnorancesBeMerged(currentPropertyIgnorancesByName, nextPropertyIgnorancesByName, commonPropertyNameIgnorances) && this.canDistinctPropertyNameIgnorancesBeMerged(currentPropertyIgnorancesByName, commonPropertyNameIgnorances) && this.canDistinctPropertyNameIgnorancesBeMerged(nextPropertyIgnorancesByName, commonPropertyNameIgnorances);
    }

    private boolean canCommonPropertyNameIgnorancesBeMerged(Map<QName, Property> currentPropertyIgnorancesByName, Map<QName, Property> nextPropertyIgnorancesByName, Set<QName> commonPropertyNameIgnorances) {
        for (QName name : commonPropertyNameIgnorances) {
            if (this.canInnerEventsBeIgnored(name, currentPropertyIgnorancesByName.get(name).getInnerEvents(), nextPropertyIgnorancesByName.get(name).getInnerEvents())) continue;
            return false;
        }
        return true;
    }

    private boolean canDistinctPropertyNameIgnorancesBeMerged(Map<QName, Property> propertyIgnorancesByName, Set<QName> commonPropertyNameIgnorances) {
        Set propertyNameIgnorances = propertyIgnorancesByName.keySet().stream().filter(name -> !commonPropertyNameIgnorances.contains(name)).collect(Collectors.toSet());
        for (QName name2 : propertyNameIgnorances) {
            if (this.parameters.styleIgnorances().thresholds(name2).areEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean canInnerEventsBeIgnored(QName name, List<XMLEvent> currentPropertyInnerEvents, List<XMLEvent> nextPropertyInnerEvents) {
        return this.canValuesBeIgnored(name, StoryChildElementsMerger.eventsToString(currentPropertyInnerEvents), StoryChildElementsMerger.eventsToString(nextPropertyInnerEvents));
    }

    private static String eventsToString(List<XMLEvent> events) {
        return events.stream().map(event -> event.asCharacters().getData()).collect(Collectors.joining());
    }

    private static StoryChildElement mergeElements(StoryChildElement currentElement, StoryChildElement nextElement) {
        return new StoryChildElement.StyledTextElement.Content(currentElement.getStartElement(), StoryChildElementsMerger.mergeEvents(currentElement.getInnerEvents(), nextElement.getInnerEvents()), currentElement.getEndElement(), StoryChildElementsMerger.mergeStyleDefinitions(((StoryChildElement.StyledTextElement)currentElement).getStyleDefinitions(), ((StoryChildElement.StyledTextElement)nextElement).getStyleDefinitions()));
    }

    private static List<XMLEvent> mergeEvents(List<XMLEvent> currentEvents, List<XMLEvent> nextEvents) {
        return Stream.concat(currentEvents.stream(), nextEvents.stream()).collect(Collectors.toList());
    }

    private static List<StoryChildElement> mergeElementsStyleDefinitions(StoryChildElement currentElement, StoryChildElement nextElement) {
        return StoryChildElementsMerger.createElementsWithMergedStyleDefinitions(currentElement, nextElement, StoryChildElementsMerger.mergeStyleDefinitions(((StoryChildElement.StyledTextElement)currentElement).getStyleDefinitions(), ((StoryChildElement.StyledTextElement)nextElement).getStyleDefinitions()));
    }

    private static StyleDefinitions mergeStyleDefinitions(StyleDefinitions currentStyleDefinitions, StyleDefinitions nextStyleDefinitions) {
        return currentStyleDefinitions.amount() <= nextStyleDefinitions.amount() ? currentStyleDefinitions : nextStyleDefinitions;
    }

    private static List<StoryChildElement> createElementsWithMergedStyleDefinitions(StoryChildElement currentElement, StoryChildElement nextElement, StyleDefinitions styleDefinitions) {
        return Arrays.asList(((StoryChildElement.StyledTextElement)currentElement).copyWith(styleDefinitions), ((StoryChildElement.StyledTextElement)nextElement).copyWith(styleDefinitions));
    }
}

