/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.idml.Accumulator;
import net.sf.okapi.filters.idml.DocumentPartEventBuilder;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.TextUnitElementsAccumulator;
import net.sf.okapi.filters.idml.TextUnitElementsMapper;

class StoryChildElementsEventsAccumulator
implements Accumulator<Event> {
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final IdGenerator documentPartIdGenerator;
    private final IdGenerator textUnitIdGenerator;
    private final ListIterator<StoryChildElement> storyChildElementIterator;
    private List<Event> events;
    private List<Event> referentEvents;

    StoryChildElementsEventsAccumulator(Parameters parameters, XMLEventFactory eventFactory, IdGenerator documentPartIdGenerator, IdGenerator textUnitIdGenerator, ListIterator<StoryChildElement> storyChildElementIterator) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.documentPartIdGenerator = documentPartIdGenerator;
        this.textUnitIdGenerator = textUnitIdGenerator;
        this.storyChildElementIterator = storyChildElementIterator;
        this.events = new ArrayList<Event>();
        this.referentEvents = new ArrayList<Event>();
    }

    @Override
    public List<Event> accumulate() throws XMLStreamException {
        DocumentPartEventBuilder documentPartEventBuilder = new DocumentPartEventBuilder(this.documentPartIdGenerator);
        while (this.storyChildElementIterator.hasNext()) {
            StoryChildElement storyChildElement = this.storyChildElementIterator.next();
            if (storyChildElement instanceof StoryChildElement.StyledTextElement) {
                documentPartEventBuilder = this.addMarkupElementsEvent(documentPartEventBuilder);
                this.storyChildElementIterator.previous();
                this.addTextUnitElementsEvents(new TextUnitElementsAccumulator(this.storyChildElementIterator).accumulate());
                continue;
            }
            documentPartEventBuilder.addMarkupRangeElement(storyChildElement);
        }
        this.addMarkupElementsEvent(documentPartEventBuilder);
        this.events.addAll(this.referentEvents);
        return this.events;
    }

    private DocumentPartEventBuilder addMarkupElementsEvent(DocumentPartEventBuilder documentPartEventBuilder) {
        Event event = documentPartEventBuilder.build();
        if (null != event) {
            this.events.add(event);
            return new DocumentPartEventBuilder(this.documentPartIdGenerator);
        }
        return documentPartEventBuilder;
    }

    private void addTextUnitElementsEvents(List<StoryChildElement> textUnitElements) throws XMLStreamException {
        List<Event> currentEvents = new TextUnitElementsMapper(this.parameters, this.eventFactory, this.documentPartIdGenerator, this.textUnitIdGenerator).map(textUnitElements);
        this.events.add(currentEvents.get(0));
        this.referentEvents.addAll(currentEvents.subList(1, currentEvents.size()));
    }
}

