/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.translatetoolkit;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String SUPPORTCODES = "supportCodes";
    private static final String URL = "url";

    public Parameters() {
    }

    public Parameters(String initialData) {
        super(initialData);
    }

    @Override
    public void reset() {
        super.reset();
        this.setUrl("https://amagama-live.translatehouse.org/api/v1/");
        this.setSupportCodes(false);
        this.setHost("localhost");
        this.setPort(8080);
    }

    @Deprecated
    public String getHost() {
        return this.getString(HOST);
    }

    @Deprecated
    public void setHost(String host) {
        this.setString(HOST, host);
    }

    @Deprecated
    public int getPort() {
        return this.getInteger(PORT);
    }

    @Deprecated
    public void setPort(int port) {
        this.setInteger(PORT, port);
    }

    public String getUrl() {
        return this.getString(URL);
    }

    public void setUrl(String url) {
        this.setString(URL, url);
    }

    public boolean getSupportCodes() {
        return this.getBoolean(SUPPORTCODES);
    }

    public void setSupportCodes(boolean supportCodes) {
        this.setBoolean(SUPPORTCODES, supportCodes);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(URL, "URL", "The Base part of URL of the TM server");
        desc.add(SUPPORTCODES, "Inline codes are letter-coded (e.g. <x1/><g2></g2>)", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Translation Toolkit TM Connector Settings");
        desc.addTextInputPart(paramsDesc.get(URL));
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(SUPPORTCODES));
        cbp.setVertical(true);
        return desc;
    }
}

