/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class GoogleMTv2Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String APIKEY = "apiKey";
    private static final String RETRY_MS = "retryIntervalMs";
    private static final String RETRY_COUNT = "retryCount";
    private static final String USE_PBMT = "usePBMT";

    public String getApiKey() {
        return this.getString(APIKEY).trim();
    }

    public void setApiKey(String apiKey) {
        if (apiKey != null) {
            apiKey = apiKey.trim();
        }
        this.setString(APIKEY, apiKey);
    }

    public int getRetryIntervalMs() {
        return this.getInteger(RETRY_MS);
    }

    public void setRetryIntervalMs(int retryMs) {
        this.setInteger(RETRY_MS, retryMs);
    }

    public int getRetryCount() {
        return this.getInteger(RETRY_COUNT);
    }

    public void setRetryCount(int retryCount) {
        this.setInteger(RETRY_COUNT, retryCount);
    }

    public boolean getUsePBMT() {
        return this.getBoolean(USE_PBMT);
    }

    public void setUsePBMT(boolean usePBMT) {
        this.setBoolean(USE_PBMT, usePBMT);
    }

    @Override
    public void reset() {
        super.reset();
        this.setApiKey("");
        this.setUsePBMT(false);
        this.setRetryIntervalMs(10000);
        this.setRetryCount(10);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(APIKEY, "Google API key", "The Google API key to identify the application/user");
        desc.add(USE_PBMT, "Use Phrase-Based MT", "Use the legacy PBMT system rather than Neural MT");
        desc.add(RETRY_COUNT, "Retry Count", "Number of retries to attempt before failing");
        desc.add(RETRY_MS, "Retry Interval (ms)", "Time to wait before retrying a failed query");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Google Translate v2 Connector Settings", true, false);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(APIKEY));
        tip.setPassword(true);
        desc.addCheckboxPart(paramsDesc.get(USE_PBMT));
        desc.addTextInputPart(paramsDesc.get(RETRY_COUNT));
        desc.addTextInputPart(paramsDesc.get(RETRY_MS));
        return desc;
    }
}

