/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipelinedriver;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.ExecutionContext;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.IWorkQueueStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.pipeline.annotations.ConfigurationParameter;
import net.sf.okapi.common.pipeline.annotations.StepIntrospector;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.DocumentData;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.IPipelineDriver;
import net.sf.okapi.common.pipelinedriver.PipelineDriverUtils;
import net.sf.okapi.common.resource.RawDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineDriver
implements IPipelineDriver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPipeline pipeline = new Pipeline();
    private List<IBatchItemContext> batchItems = new ArrayList<IBatchItemContext>();
    private LinkedList<List<ConfigurationParameter>> paramList = new LinkedList();
    private IPipelineStep lastOutputStep;
    private int maxInputCount = 1;
    private IFilterConfigurationMapper fcMapper;
    private String rootDir;
    private String inputRootDir;
    private String outputDir;
    private Object uiParent;
    private ExecutionContext context;

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public void setRootDirectories(String rootDir, String inputRootDir) {
        this.rootDir = rootDir;
        this.inputRootDir = inputRootDir;
    }

    @Override
    public void setOutputDirectory(String outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void setUIParent(Object uiParent) {
        this.uiParent = uiParent;
    }

    @Override
    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    @Override
    public void setPipeline(IPipeline pipeline) {
        if (this.pipeline != null) {
            this.pipeline.cancel();
        }
        if (pipeline != null) {
            pipeline.cancel();
        }
        this.pipeline = new Pipeline();
        this.clearSteps();
        if (pipeline != null) {
            for (IPipelineStep step : pipeline.getSteps()) {
                this.addStep(step);
            }
        }
        this.pipeline = pipeline;
    }

    @Override
    public IPipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public void addStep(IPipelineStep step) {
        List<ConfigurationParameter> pList;
        this.pipeline.addStep(step);
        if (step instanceof IWorkQueueStep) {
            pList = StepIntrospector.getStepParameters(((IWorkQueueStep)step).getMainStep());
            for (ConfigurationParameter p : pList) {
                p.setStep(step);
            }
        } else {
            pList = StepIntrospector.getStepParameters(step);
        }
        this.paramList.add(pList);
        for (ConfigurationParameter p : pList) {
            if (p.getParameterType() == StepParameterType.OUTPUT_URI) {
                if (this.lastOutputStep != null) {
                    this.lastOutputStep.setLastOutputStep(false);
                }
                this.lastOutputStep = step;
                this.lastOutputStep.setLastOutputStep(true);
                continue;
            }
            if (p.getParameterType() == StepParameterType.SECOND_INPUT_RAWDOC) {
                this.maxInputCount = 2;
                continue;
            }
            if (p.getParameterType() != StepParameterType.THIRD_INPUT_RAWDOC) continue;
            this.maxInputCount = 3;
        }
    }

    @Override
    public void processBatch(List<IBatchItemContext> batchItems) {
        this.batchItems = batchItems;
        this.processBatch();
    }

    @Override
    public void processBatch() {
        if (this.batchItems.size() > 0) {
            PipelineDriverUtils.assignRuntimeParameters(this, this.paramList, this.batchItems.get(0));
        }
        this.pipeline.startBatch();
        for (IBatchItemContext item : this.batchItems) {
            this.displayInput(item);
            PipelineDriverUtils.assignRuntimeParameters(this, this.paramList, item);
            this.pipeline.process(item.getRawDocument(0));
        }
        this.pipeline.endBatch();
    }

    @Override
    public void addBatchItem(IBatchItemContext item) {
        this.batchItems.add(item);
    }

    @Override
    public void addBatchItem(RawDocument ... rawDocs) {
        BatchItemContext item = new BatchItemContext();
        for (RawDocument rawDoc : rawDocs) {
            DocumentData ddi = new DocumentData();
            ddi.rawDocument = rawDoc;
            item.add(ddi);
        }
        this.batchItems.add(item);
    }

    @Override
    public void addBatchItem(RawDocument rawDoc, URI outputURI, String outputEncoding) {
        DocumentData ddi = new DocumentData();
        ddi.rawDocument = rawDoc;
        ddi.outputURI = outputURI;
        ddi.outputEncoding = outputEncoding;
        BatchItemContext item = new BatchItemContext();
        item.add(ddi);
        this.batchItems.add(item);
    }

    @Override
    public void addBatchItem(URI inputURI, String defaultEncoding, String filterConfigId, LocaleId srcLoc, LocaleId trgLoc) {
        DocumentData ddi = new DocumentData();
        ddi.rawDocument = new RawDocument(inputURI, defaultEncoding, srcLoc, trgLoc);
        ddi.rawDocument.setFilterConfigId(filterConfigId);
        BatchItemContext item = new BatchItemContext();
        item.add(ddi);
        this.batchItems.add(item);
    }

    @Override
    public void clearItems() {
        this.batchItems.clear();
    }

    protected void displayInput(IBatchItemContext item) {
        if (item.getRawDocument(0).getInputURI() != null) {
            this.logger.info("Input: {}", (Object)item.getRawDocument(0).getInputURI().getPath());
        } else {
            this.logger.info("Input (No path available)");
        }
    }

    @Override
    public void clearSteps() {
        this.pipeline.clearSteps();
        this.paramList.clear();
        this.lastOutputStep = null;
        this.maxInputCount = 1;
    }

    @Override
    public int getRequestedInputCount() {
        return this.maxInputCount;
    }

    @Override
    public void destroy() {
        this.pipeline.destroy();
    }

    protected List<IBatchItemContext> getBatchItems() {
        return this.batchItems;
    }

    protected LinkedList<List<ConfigurationParameter>> getParamList() {
        return this.paramList;
    }

    protected IFilterConfigurationMapper getFcMapper() {
        return this.fcMapper;
    }

    protected String getRootDir() {
        return this.rootDir;
    }

    protected String getInputRootDir() {
        return this.inputRootDir;
    }

    protected String getOutputDir() {
        return this.outputDir;
    }

    protected Object getUiParent() {
        return this.uiParent;
    }

    protected ExecutionContext getContext() {
        return this.context;
    }
}

