/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.util.Stack;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.filterwriter.ITSContent;

public class ITSAnnotatorsRefContext {
    private XMLStreamReader reader;
    private Stack<String> annotatorsRef;

    public ITSAnnotatorsRefContext(XMLStreamReader reader) {
        this.reader = reader;
        this.annotatorsRef = new Stack();
        this.annotatorsRef.push(null);
    }

    public void readAndPush() {
        String val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "annotatorsRef");
        val = val != null ? ITSContent.updateAnnotatorsRef(this.annotatorsRef.peek(), val) : this.annotatorsRef.peek();
        this.annotatorsRef.push(val);
    }

    public void pop() {
        this.annotatorsRef.pop();
    }

    public String peek() {
        return this.annotatorsRef.peek();
    }

    public GenericAnnotation getAnnotation() {
        String tmp = this.annotatorsRef.peek();
        if (tmp == null) {
            return null;
        }
        return new GenericAnnotation("its-annotators", "annotatorsValue", tmp);
    }

    public String getAnnotatorRef(String dataCategory) {
        String tmp = this.annotatorsRef.peek();
        if (tmp == null) {
            return null;
        }
        return ITSContent.annotatorsRefToMap(tmp).get(dataCategory);
    }
}

