/*
 * Decompiled with CFR 0.152.
 */
package java.util.function;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> isSame(final Object target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return value == target;
            }
        };
    }

    public static <T> Predicate<T> isEqual(final Object target) {
        if (target == null) {
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return value == null;
                }
            };
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return target.equals(value);
            }
        };
    }

    public static <T> Predicate<T> and(final Iterable<? extends Predicate<? super T>> predicates) {
        if (predicates == null) {
            throw new NullPointerException();
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                for (Predicate predicate : predicates) {
                    if (predicate.test(value)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    static <T> Predicate<T> and(final Predicate<? super T> first, final Iterable<? extends Predicate<? super T>> predicates) {
        if (first == null || predicates == null) {
            throw new NullPointerException();
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                if (!first.test(value)) {
                    return false;
                }
                for (Predicate predicate : predicates) {
                    if (predicate.test(value)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... predicates) {
        return Predicates.and(Arrays.asList(predicates));
    }

    static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> ... predicates) {
        return Predicates.and(first, Arrays.asList(predicates));
    }

    public static <T> Predicate<T> or(final Iterable<? extends Predicate<? super T>> predicates) {
        if (predicates == null) {
            throw new NullPointerException();
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(value)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static <T> Predicate<T> or(final Predicate<? super T> first, final Iterable<? extends Predicate<? super T>> predicates) {
        if (first == null || predicates == null) {
            throw new NullPointerException();
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                if (first.test(value)) {
                    return true;
                }
                for (Predicate predicate : predicates) {
                    if (!predicate.test(value)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... predicates) {
        return Predicates.or(Arrays.asList(predicates));
    }

    static <T> Predicate<T> or(Predicate<? super T> first, Predicate<? super T> ... predicates) {
        return Predicates.or(first, Arrays.asList(predicates));
    }

    public static <T> Predicate<T> xor(final Iterable<? extends Predicate<? super T>> predicates) {
        if (predicates == null) {
            throw new NullPointerException();
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                Iterator iterator = predicates.iterator();
                if (!iterator.hasNext()) {
                    return false;
                }
                boolean initial = ((Predicate)iterator.next()).test(value);
                while (iterator.hasNext()) {
                    boolean current = ((Predicate)iterator.next()).test(value);
                    if (initial ^ current) continue;
                    return false;
                }
                return true;
            }
        };
    }

    static <T> Predicate<T> xor(final Predicate<? super T> first, final Iterable<? extends Predicate<? super T>> predicates) {
        if (first == null || predicates == null) {
            throw new NullPointerException();
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                boolean initial = first.test(value);
                for (Predicate predicate : predicates) {
                    if (initial ^ predicate.test(value)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> xor(Predicate<? super T> ... predicates) {
        return Predicates.xor(Arrays.asList(predicates));
    }

    static <T> Predicate<T> xor(Predicate<? super T> first, Predicate<? super T> ... predicates) {
        return Predicates.xor(first, Arrays.asList(predicates));
    }
}

