/*
 * Decompiled with CFR 0.152.
 */
package java.util.function;

import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Functions {
    private Functions() {
    }

    public static <T> Function<T, T> identity() {
        return new Function<T, T>(){

            @Override
            public T apply(T t) {
                return t;
            }
        };
    }

    public static <T, U, R> Function<T, R> chain(final Function<? super T, ? extends U> first, final Function<? super U, ? extends R> second) {
        if (first == null || second == null) {
            throw new NullPointerException();
        }
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                return second.apply(first.apply(t));
            }
        };
    }

    public static <T, R> Function<T, R> constant(final R constant) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                return constant;
            }
        };
    }

    public static <T> Function<T, T> substitute(final T subOut, final T subIn) {
        return new Function<T, T>(){

            @Override
            public T apply(T t) {
                if (subOut == t || subOut != null && subOut.equals(t)) {
                    return subIn;
                }
                return t;
            }
        };
    }

    public static <T, R> Function<T, R> instantiate(Class<? extends T> clazzT, Class<? extends R> clazzR) {
        Constructor<? extends R> constructor;
        if (clazzT == null || clazzR == null) {
            throw new NullPointerException();
        }
        try {
            constructor = clazzR.getConstructor(clazzT);
        }
        catch (NoSuchMethodException noConstructor) {
            throw new IllegalArgumentException("no constructor for " + clazzR.getSimpleName() + "(" + clazzT.getSimpleName() + ")", noConstructor);
        }
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return constructor.newInstance(t);
                }
                catch (Exception ex) {
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
    }

    public static <R, T> Function<T, R> forMap(final Map<? super T, ? extends R> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                if (map.containsKey(t)) {
                    return map.get(t);
                }
                throw new IllegalArgumentException("unmappable <T> : " + t);
            }
        };
    }

    public static <T, R, RR extends R> Function<T, R> forMap(final Map<? super T, RR> mapping, final RR defaultValue) {
        if (mapping == null) {
            throw new NullPointerException();
        }
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                Object result = mapping.get(t);
                if (result != null || mapping.containsKey(t)) {
                    return result;
                }
                return defaultValue;
            }
        };
    }

    public static <T, R> Function<T, R> forPredicate(final Predicate<? super T> predicate, final R forTrue, final R forFalse) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                return predicate.test(t) ? forTrue : forFalse;
            }
        };
    }
}

