/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.sf.jasperreports.customvisualization.CVUtils;
import net.sf.jasperreports.customvisualization.export.CVElementAbstractImageDataProvider;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.phantomjs.PhantomJS;
import net.sf.jasperreports.phantomjs.ScriptManager;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.util.Base64Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRPhantomCVElementImageDataProvider
extends CVElementAbstractImageDataProvider {
    private static final Log log = LogFactory.getLog(JRPhantomCVElementImageDataProvider.class);
    private final String[] scriptResourceLocations = new String[]{"net/sf/jasperreports/customvisualization/scripts/customvisualization-phantom.js", "net/sf/jasperreports/customvisualization/resources/require/require.js", "net/sf/jasperreports/customvisualization/resources/require/cv-component_static.js"};

    public boolean isEnabled() {
        return PhantomJS.isEnabled();
    }

    @Override
    public byte[] getImageData(RepositoryContext repositoryContext, JRGenericPrintElement element) throws Exception {
        if (element.getParameterValue("configuration") == null) {
            throw new JRRuntimeException("Configuration object is null.");
        }
        JasperReportsContext jasperReportsContext = repositoryContext.getJasperReportsContext();
        PhantomJS phantom = PhantomJS.instance();
        ScriptManager scriptManager = phantom.getScriptManager();
        ArrayList<String> scriptFilenames = new ArrayList<String>();
        for (String scriptLocation : this.scriptResourceLocations) {
            scriptFilenames.add(scriptManager.getScriptFilename(scriptLocation, jasperReportsContext));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configured script URI: " + element.getParameterValue("script_uri")));
            log.debug((Object)("Configured css URI: " + element.getParameterValue("css_uri")));
        }
        scriptFilenames.add(scriptManager.getScriptFilename((String)element.getParameterValue("script_uri"), jasperReportsContext));
        String cssUriParameter = (String)element.getParameterValue("css_uri");
        String cssUri = null;
        if (cssUriParameter != null) {
            cssUri = scriptManager.getScriptFilename(cssUriParameter, jasperReportsContext);
        }
        StringBuilder script = new StringBuilder();
        script.append("{\"script\": \"" + JRStringUtil.escapeJSONString((String)((String)scriptFilenames.get(0))) + "\", \"data\": {");
        String htmlPage = this.getHtmlPage(jasperReportsContext, element, scriptFilenames.subList(1, scriptFilenames.size()), cssUri);
        File htmlTempFile = File.createTempFile("cv_", ".html", scriptManager.getTempFolder());
        try (ByteArrayInputStream is = new ByteArrayInputStream(htmlPage.getBytes(StandardCharsets.UTF_8));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(htmlTempFile));){
            CVUtils.byteStreamCopy(is, os);
        }
        script.append("\"componentHtmlFile\": \"" + htmlTempFile.getName() + "\",");
        boolean renderAsPng = CVUtils.isRenderAsPng(element);
        script.append("\"outputFormat\": \"" + (renderAsPng ? "png" : "svg") + "\",");
        script.append("\"zoomFactor\": " + CVUtils.getZoomFactor(element) + "}}");
        String requestString = script.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Sending request: \n" + requestString));
        }
        String requestOutput = phantom.runRequest(requestString);
        htmlTempFile.delete();
        if (log.isTraceEnabled()) {
            if (requestOutput == null || requestOutput.length() == 0) {
                log.trace((Object)"Got null or empty request output!");
            } else {
                log.trace((Object)("Got output:\n" + requestOutput));
            }
        }
        if (requestOutput != null) {
            if (renderAsPng) {
                try (ByteArrayInputStream is = new ByteArrayInputStream(requestOutput.getBytes());){
                    byte[] byArray;
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        Base64Util.decode((InputStream)is, (OutputStream)os);
                        byArray = os.toByteArray();
                    }
                    return byArray;
                }
            }
            return requestOutput.getBytes("UTF-8");
        }
        return null;
    }
}

