/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.service.impl;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.ehcache.management.service.impl.RemoteAgentEndpointImplMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.l1bridge.AbstractRemoteAgentEndpointImpl;
import org.terracotta.management.l1bridge.RemoteCallDescriptor;

public class RemoteAgentEndpointImpl
extends AbstractRemoteAgentEndpointImpl
implements RemoteAgentEndpointImplMBean {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAgentEndpointImpl.class);
    public static final String AGENCY = "Ehcache";
    public static final String MBEAN_NAME_PREFIX = "net.sf.ehcache:type=" + IDENTIFIER;
    private final ThreadLocal<Boolean> tsaBridged = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private ObjectName objectName;
    private final List<String> clientUUIDs = new ArrayList<String>();

    protected boolean isTsaSecured() {
        return false;
    }

    public boolean isTsaBridged() {
        return this.tsaBridged.get();
    }

    public void registerMBean(String clientUUID) {
        ObjectName objectName;
        if (clientUUID == null) {
            throw new NullPointerException("clientUUID cannot be null");
        }
        try {
            objectName = new ObjectName(MBEAN_NAME_PREFIX + ",node=" + clientUUID);
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            platformMBeanServer.registerMBean(this, objectName);
        }
        catch (InstanceAlreadyExistsException iaee) {
            objectName = null;
        }
        catch (Exception e) {
            LOG.warn("Error registering RemoteAgentEndpointImpl MBean with UUID: " + clientUUID, (Throwable)e);
            objectName = null;
        }
        this.objectName = objectName;
    }

    public void unregisterMBean() {
        if (this.objectName == null) {
            return;
        }
        try {
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            LOG.warn("Error unregistering RemoteAgentEndpointImpl MBean : " + this.objectName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] invoke(RemoteCallDescriptor remoteCallDescriptor) throws Exception {
        try {
            this.tsaBridged.set(true);
            byte[] byArray = super.invoke(remoteCallDescriptor);
            return byArray;
        }
        finally {
            this.tsaBridged.set(false);
        }
    }

    public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public String getAgency() {
        return AGENCY;
    }

    public void addClientUUID(String clientUUID) {
        this.clientUUIDs.add(clientUUID);
    }

    @Override
    public String[] getClientUUIDs() {
        return this.clientUUIDs.toArray(new String[0]);
    }

    public void removeClientUUID(String clientUUID) {
        this.clientUUIDs.remove(clientUUID);
    }
}

