/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jms;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.distribution.jms.JMSCacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.util.PropertyUtil;

public class JMSCacheReplicatorFactory
extends CacheEventListenerFactory {
    private static final Logger LOG = Logger.getLogger(JMSCacheReplicatorFactory.class.getName());
    private static final String REPLICATE_PUTS = "replicatePuts";
    private static final String REPLICATE_UPDATES = "replicateUpdates";
    private static final String REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private static final String REPLICATE_REMOVALS = "replicateRemovals";
    private static final String REPLICATE_ASYNCHRONOUSLY = "replicateAsynchronously";
    private static final String ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS = "asynchronousReplicationIntervalMillis";

    public CacheEventListener createCacheEventListener(Properties properties) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("createCacheEventListener ( properties = " + properties + " ) called ");
        }
        boolean replicatePuts = this.extractBooleanProperty(properties, REPLICATE_PUTS, false);
        boolean replicateUpdates = this.extractBooleanProperty(properties, REPLICATE_UPDATES, true);
        boolean replicateUpdatesViaCopy = this.extractBooleanProperty(properties, REPLICATE_UPDATES_VIA_COPY, false);
        boolean replicateRemovals = this.extractBooleanProperty(properties, REPLICATE_REMOVALS, false);
        boolean replicateAsync = this.extractBooleanProperty(properties, REPLICATE_ASYNCHRONOUSLY, false);
        long asyncTime = this.extractAsynchronousReplicationIntervalMillis(properties, ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS, 1000L);
        return new JMSCacheReplicator(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals, replicateAsync, asyncTime);
    }

    protected long extractAsynchronousReplicationIntervalMillis(Properties properties, String propertyName, long defaultValue) {
        String parsedString = PropertyUtil.extractAndLogProperty((String)propertyName, (Properties)properties);
        if (parsedString != null) {
            try {
                Long longValue = new Long(parsedString);
                return longValue;
            }
            catch (NumberFormatException e) {
                LOG.warning("Number format exception trying to set asynchronousReplicationIntervalMillis. Using the default instead. String value was: '" + parsedString + "'");
            }
        }
        return defaultValue;
    }

    protected boolean extractBooleanProperty(Properties properties, String propertyName, boolean defaultValue) {
        String pString = PropertyUtil.extractAndLogProperty((String)propertyName, (Properties)properties);
        boolean ret = pString != null ? PropertyUtil.parseBoolean((String)pString) : defaultValue;
        return ret;
    }
}

