/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.demo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.fit.cssbox.swingbox.BrowserPane;
import org.fit.cssbox.swingbox.demo.SwingBrowserHyperlinkHandler;
import org.fit.cssbox.swingbox.util.GeneralEvent;
import org.fit.cssbox.swingbox.util.GeneralEventListener;
import org.fit.net.DataURLHandler;

public class SwingBrowser {
    protected Vector<URL> history = new Vector();
    protected int historyPos = 0;
    public static SwingBrowser browser;
    protected JFrame mainWindow = null;
    protected JPanel mainPanel = null;
    protected JPanel urlPanel = null;
    protected JPanel statusPanel = null;
    protected JTextField statusText = null;
    protected JLabel jLabel = null;
    protected JTextField urlText = null;
    protected JButton okButton = null;
    private JTabbedPane tabs;
    private JButton backButton;
    BrowserPane swingbox = null;

    public void displayURL(String urlstring) {
        try {
            if (!(urlstring.startsWith("http:") || urlstring.startsWith("https:") || urlstring.startsWith("ftp:") || urlstring.startsWith("file:") || urlstring.startsWith("data:"))) {
                urlstring = "http://" + urlstring;
            }
            URL url = DataURLHandler.createURL(null, (String)urlstring);
            this.urlText.setText(url.toString());
            while (this.historyPos < this.history.size()) {
                this.history.remove(this.history.size() - 1);
            }
            this.history.add(url);
            ++this.historyPos;
            this.displayURLSwingBox(url);
        }
        catch (Exception e) {
            System.err.println("*** Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void displayURLSwingBox(URL url) throws IOException {
        if (this.swingbox == null) {
            this.swingbox = this.createSwingbox();
            this.tabs.add("New Tab", new JScrollPane(this.swingbox));
        }
        this.swingbox.setPage(url);
    }

    public JFrame getMainWindow() {
        if (this.mainWindow == null) {
            this.mainWindow = new JFrame();
            this.mainWindow.setTitle("Swing Browser");
            this.mainWindow.setVisible(true);
            this.mainWindow.setBounds(new Rectangle(0, 0, 583, 251));
            this.mainWindow.setContentPane(this.getMainPanel());
            this.mainWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SwingBrowser.this.mainWindow.setVisible(false);
                    System.exit(0);
                }
            });
        }
        return this.mainWindow;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(10, 10, 5, 10);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 0;
            this.mainPanel = new JPanel();
            GridBagLayout gbl_mainPanel = new GridBagLayout();
            gbl_mainPanel.rowWeights = new double[]{0.0, 0.0, 0.0};
            gbl_mainPanel.columnWeights = new double[]{1.0};
            this.mainPanel.setLayout(gbl_mainPanel);
            this.mainPanel.add((Component)this.getUrlPanel(), gridBagConstraints);
            GridBagConstraints gbc_tabs = new GridBagConstraints();
            gbc_tabs.weighty = 1.0;
            gbc_tabs.weightx = 1.0;
            gbc_tabs.fill = 1;
            gbc_tabs.gridx = 0;
            gbc_tabs.gridy = 1;
            this.mainPanel.add((Component)this.getTabs(), gbc_tabs);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.gridy = 2;
            this.mainPanel.add((Component)this.getStatusPanel(), gridBagConstraints3);
        }
        return this.mainPanel;
    }

    private JPanel getUrlPanel() {
        if (this.urlPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 3;
            gridBagConstraints7.insets = new Insets(0, 0, 0, 7);
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.anchor = 10;
            gridBagConstraints5.insets = new Insets(0, 6, 0, 5);
            gridBagConstraints5.gridx = 1;
            this.jLabel = new JLabel();
            this.jLabel.setText("Location :");
            this.urlPanel = new JPanel();
            this.urlPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc_backButton = new GridBagConstraints();
            gbc_backButton.insets = new Insets(0, 0, 5, 5);
            gbc_backButton.gridx = 0;
            gbc_backButton.gridy = 0;
            this.urlPanel.add((Component)this.getBackButton(), gbc_backButton);
            this.urlPanel.add((Component)this.jLabel, gridBagConstraints5);
            this.urlPanel.add((Component)this.getUrlText(), gridBagConstraints6);
            this.urlPanel.add((Component)this.getOkButton(), gridBagConstraints7);
        }
        return this.urlPanel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            GridBagLayout gbl_statusPanel = new GridBagLayout();
            gbl_statusPanel.columnWidths = new int[]{550, 91, 0};
            gbl_statusPanel.rowHeights = new int[]{19, 0};
            gbl_statusPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
            gbl_statusPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.statusPanel.setLayout(gbl_statusPanel);
            GridBagConstraints gbc_statusText = new GridBagConstraints();
            gbc_statusText.fill = 2;
            gbc_statusText.anchor = 13;
            gbc_statusText.gridx = 0;
            gbc_statusText.gridy = 0;
            this.statusPanel.add((Component)this.getStatusText(), gbc_statusText);
        }
        return this.statusPanel;
    }

    private JTextField getStatusText() {
        if (this.statusText == null) {
            this.statusText = new JTextField();
            this.statusText.setEditable(false);
            this.statusText.setText("Browser ready.");
        }
        return this.statusText;
    }

    private JTextField getUrlText() {
        if (this.urlText == null) {
            this.urlText = new JTextField();
            this.urlText.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingBrowser.this.displayURL(SwingBrowser.this.urlText.getText());
                }
            });
        }
        return this.urlText;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Go!");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingBrowser.this.displayURL(SwingBrowser.this.urlText.getText());
                }
            });
        }
        return this.okButton;
    }

    private BrowserPane createSwingbox() {
        this.swingbox = new BrowserPane();
        this.swingbox.addHyperlinkListener(new SwingBrowserHyperlinkHandler(this));
        this.swingbox.addGeneralEventListener(new GeneralEventListener(){
            private long time;

            @Override
            public void generalEventUpdate(GeneralEvent e) {
                if (e.event_type == GeneralEvent.EventType.page_loading_begin) {
                    this.time = System.currentTimeMillis();
                } else if (e.event_type == GeneralEvent.EventType.page_loading_end) {
                    Object title = SwingBrowser.this.swingbox.getDocument().getProperty("title");
                    if (title != null) {
                        SwingBrowser.this.tabs.setTitleAt(0, title.toString());
                    }
                    System.out.println("SwingBox: page loaded in: " + (System.currentTimeMillis() - this.time) + " ms");
                }
            }
        });
        return this.swingbox;
    }

    private JTabbedPane getTabs() {
        if (this.tabs == null) {
            this.tabs = new JTabbedPane(1);
        }
        return this.tabs;
    }

    private JButton getBackButton() {
        if (this.backButton == null) {
            this.backButton = new JButton("Back");
            this.backButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (SwingBrowser.this.historyPos > 1) {
                        --SwingBrowser.this.historyPos;
                        URL url = SwingBrowser.this.history.elementAt(SwingBrowser.this.historyPos - 1);
                        try {
                            SwingBrowser.this.displayURLSwingBox(url);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.backButton;
    }

    public static void main(String[] args) {
        browser = new SwingBrowser();
        JFrame main = browser.getMainWindow();
        main.setSize(1100, 850);
        main.setVisible(true);
        browser.displayURL("http://cssbox.sourceforge.net/swingbox");
    }
}

