/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.fit.pdfdom.PDFDomTree;
import org.fit.pdfdom.PDFDomTreeConfig;
import org.fit.pdfdom.resource.HtmlResourceHandler;
import org.fit.pdfdom.resource.IgnoreResourceHandler;
import org.fit.pdfdom.resource.SaveResourceToDirHandler;

public class PDFToHTML {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String outfile;
        if (args.length < 1) {
            System.out.println("Usage: PDFToHTML <infile> [<outfile>] [<options>]");
            System.out.println("Options: ");
            System.out.println("-fm=[mode] Font handler mode. [mode] = EMBED_BASE64, SAVE_TO_DIR, IGNORE");
            System.out.println("-fdir=[path] Directory to extract fonts to. [path] = font extract directory ie dir/my-font-dir");
            System.out.println();
            System.out.println("-im=[mode] Image handler mode. [mode] = EMBED_BASE64, SAVE_TO_DIR, IGNORE");
            System.out.println("-idir=[path] Directory to extract images to. [path] = image extract directory ie dir/my-image-dir");
            System.exit(1);
        }
        String infile = args[0];
        if (args.length > 1 && !args[1].startsWith("-")) {
            outfile = args[1];
        } else {
            String base = args[0];
            if (base.toLowerCase().endsWith(".pdf")) {
                base = base.substring(0, base.length() - 4);
            }
            outfile = base + ".html";
        }
        PDFDomTreeConfig config = PDFToHTML.parseOptions(args);
        PDDocument document = null;
        try {
            document = PDDocument.load((File)new File(infile));
            PDFDomTree parser = new PDFDomTree(config);
            PrintWriter output = new PrintWriter(outfile, "utf-8");
            parser.writeText(document, output);
            ((Writer)output).close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    System.err.println("Error: " + e.getMessage());
                }
            }
        }
    }

    private static PDFDomTreeConfig parseOptions(String[] args) {
        PDFDomTreeConfig config = PDFDomTreeConfig.createDefaultConfig();
        List<CommandLineFlag> flags = PDFToHTML.parseFlags(args);
        for (CommandLineFlag flagOn : flags) {
            HtmlResourceHandler handler;
            if (flagOn.flagName.equals("fm")) {
                handler = PDFToHTML.createResourceHandlerFor(flagOn.value);
                config.setFontHandler(handler);
                continue;
            }
            if (flagOn.flagName.equals("fdir")) {
                config.setFontHandler(new SaveResourceToDirHandler(new File(flagOn.value)));
                continue;
            }
            if (flagOn.flagName.equals("im")) {
                handler = PDFToHTML.createResourceHandlerFor(flagOn.value);
                config.setImageHandler(handler);
                continue;
            }
            if (!flagOn.flagName.equals("idir")) continue;
            config.setImageHandler(new SaveResourceToDirHandler(new File(flagOn.value)));
        }
        return config;
    }

    private static HtmlResourceHandler createResourceHandlerFor(String value) {
        HtmlResourceHandler handler = PDFDomTreeConfig.embedAsBase64();
        if (value.equalsIgnoreCase("EMBED_BASE64")) {
            handler = PDFDomTreeConfig.embedAsBase64();
        } else if (value.equalsIgnoreCase("SAVE_TO_DIR")) {
            handler = new SaveResourceToDirHandler();
        } else if (value.equalsIgnoreCase("IGNORE")) {
            handler = new IgnoreResourceHandler();
        }
        return handler;
    }

    private static List<CommandLineFlag> parseFlags(String[] args) {
        ArrayList<CommandLineFlag> flags = new ArrayList<CommandLineFlag>();
        for (String argOn : args) {
            if (!argOn.startsWith("-")) continue;
            flags.add(CommandLineFlag.parse(argOn));
        }
        return flags;
    }

    private static class CommandLineFlag {
        public String flagName;
        public String value = "";

        private CommandLineFlag() {
        }

        public static CommandLineFlag parse(String argOn) {
            CommandLineFlag flag = new CommandLineFlag();
            String[] flagSplit = argOn.split("=");
            flag.flagName = flagSplit[0].replace("-", "");
            if (flagSplit.length > 1) {
                flag.value = flagSplit[1].replace("=", "");
            }
            return flag;
        }
    }
}

