/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.fit.pdfdom.PDFDomTree;

public class PDFToHTML {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String outfile;
        if (args.length < 1) {
            System.out.println("Usage: PDFToHTML <infile> [<outfile>]");
            System.exit(1);
        }
        String infile = args[0];
        if (args.length > 1) {
            outfile = args[1];
        } else {
            String base = args[0];
            if (base.toLowerCase().endsWith(".pdf")) {
                base = base.substring(0, base.length() - 4);
            }
            outfile = base + ".html";
        }
        PDDocument document = null;
        try {
            document = PDDocument.load((String)infile);
            if (document.isEncrypted()) {
                try {
                    document.decrypt("");
                }
                catch (InvalidPasswordException e) {
                    System.err.println("Error: Document is encrypted with a password.");
                    System.exit(1);
                }
            }
            PDFDomTree parser = new PDFDomTree();
            PrintWriter output = new PrintWriter(outfile, "utf-8");
            parser.writeText(document, output);
            ((Writer)output).close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    System.err.println("Error: " + e.getMessage());
                }
            }
        }
    }
}

