/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageNode;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;
import org.fit.pdfdom.BoxStyle;
import org.fit.pdfdom.RectPath;

public abstract class PDFBoxTree
extends PDFTextStripper {
    public static final String UNIT = "pt";
    protected static String[] cssFontFamily = new String[]{"Times New Roman", "Times", "Garamond", "Helvetica", "Arial", "Arial Narrow", "Verdana", "Courier New", "MS Sans Serif"};
    protected static String[] pdFontType = new String[]{"normal", "roman", "bold", "italic", "bolditalic"};
    protected static String[] cssFontWeight = new String[]{"normal", "normal", "bold", "normal", "bold"};
    protected static String[] cssFontStyle = new String[]{"normal", "normal", "normal", "italic", "italic"};
    protected boolean disableGraphics = false;
    protected boolean disableImages = false;
    protected boolean disableImageData = false;
    protected int startPage;
    protected int endPage;
    protected PDPage pdpage;
    protected float cur_x;
    protected float cur_y;
    protected TextPosition lastText = null;
    protected StringBuilder textLine;
    protected Vector<RectPath> graphicsPath;
    protected BoxStyle style;
    protected BoxStyle curstyle;
    protected String strokingColor;
    protected float lineWidth;

    public PDFBoxTree() throws IOException {
        super.setSortByPosition(true);
        super.setSuppressDuplicateOverlappingText(true);
        this.init();
    }

    private void init() {
        this.style = new BoxStyle(UNIT);
        this.textLine = new StringBuilder();
        this.strokingColor = null;
        this.lineWidth = 0.0f;
        this.graphicsPath = new Vector();
        this.startPage = 0;
        this.endPage = Integer.MAX_VALUE;
    }

    public void processDocument(PDDocument document) throws IOException {
        this.processDocument(document, 0, Integer.MAX_VALUE);
    }

    public void processDocument(PDDocument document, int startPage, int endPage) throws IOException {
        this.resetEngine();
        this.startPage = startPage;
        this.endPage = endPage;
        if (document.isEncrypted()) {
            try {
                document.decrypt("");
            }
            catch (CryptographyException e) {
                throw new WrappedIOException("Error decrypting document, details: ", (Throwable)e);
            }
            catch (InvalidPasswordException e) {
                throw new WrappedIOException("Error: document is encrypted", (Throwable)e);
            }
        }
        List allPages = document.getDocumentCatalog().getAllPages();
        for (int i = startPage; i <= endPage; ++i) {
            if (i >= 0 && i < allPages.size()) {
                PDPage page = (PDPage)allPages.get(i);
                PDStream contents = page.getContents();
                if (contents == null) continue;
                this.processPage(page, contents.getStream());
                continue;
            }
            if (i >= allPages.size()) break;
        }
    }

    protected void processPage(PDPage page, COSStream content) throws IOException {
        this.pdpage = page;
        this.startNewPage();
        this.processStream(page, page.findResources(), content);
        this.finishBox();
    }

    public boolean getDisableGraphics() {
        return this.disableGraphics;
    }

    public void setDisableGraphics(boolean disableGraphics) {
        this.disableGraphics = disableGraphics;
    }

    public boolean getDisableImages() {
        return this.disableImages;
    }

    public void setDisableImages(boolean disableImages) {
        this.disableImages = disableImages;
    }

    public boolean getDisableImageData() {
        return this.disableImageData;
    }

    public void setDisableImageData(boolean disableImageData) {
        this.disableImageData = disableImageData;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    protected abstract void startNewPage();

    protected abstract void renderText(String var1);

    protected abstract void renderRectangle(float var1, float var2, float var3, float var4, boolean var5, boolean var6);

    protected abstract void renderImage(float var1, float var2, float var3, float var4, String var5, byte[] var6);

    protected void processOperator(PDFOperator operator, List<COSBase> arguments) throws IOException {
        String operation = operator.getOperation();
        if (operation.equals("g")) {
            float gray = this.floatValue(arguments.get(0));
            this.style.setColor(this.colorString(gray, gray, gray));
        } else if (operation.equals("G")) {
            float gray = this.floatValue(arguments.get(0));
            this.strokingColor = this.colorString(gray, gray, gray);
        } else if (operation.equals("rg")) {
            this.style.setColor(this.colorString(this.floatValue(arguments.get(0)), this.floatValue(arguments.get(1)), this.floatValue(arguments.get(2))));
        } else if (operation.equals("RG")) {
            this.strokingColor = this.colorString(this.floatValue(arguments.get(0)), this.floatValue(arguments.get(1)), this.floatValue(arguments.get(2)));
        } else if (operation.equals("scn")) {
            if (arguments.size() == 3) {
                this.style.setColor(this.colorString(this.floatValue(arguments.get(0)), this.floatValue(arguments.get(1)), this.floatValue(arguments.get(2))));
            } else {
                System.err.println("Warning: scn: unsupported color specification: " + arguments);
            }
        } else if (operation.equals("SCN")) {
            if (arguments.size() == 3) {
                this.strokingColor = this.colorString(this.floatValue(arguments.get(0)), this.floatValue(arguments.get(1)), this.floatValue(arguments.get(2)));
            } else {
                System.err.println("Warning: SCN: unsupported color specification: " + arguments);
            }
        } else if (operation.equals("Tw")) {
            this.style.setWordSpacing(this.getLength(arguments.get(0)));
        } else if (operation.equals("Tc")) {
            this.style.setLetterSpacing(this.getLength(arguments.get(0)));
        } else if (operation.equals("re")) {
            if (!this.disableGraphics && arguments.size() == 4) {
                float x = this.getLength(arguments.get(0));
                float y = this.getLength(arguments.get(1));
                float width = this.getLength(arguments.get(2));
                float height = this.getLength(arguments.get(3));
                Matrix spos = new Matrix();
                spos.setValue(2, 0, x);
                spos.setValue(2, 1, y);
                Matrix epos = new Matrix();
                epos.setValue(2, 0, x + width);
                epos.setValue(2, 1, y + height);
                Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
                Matrix sposXctm = spos.multiply(ctm);
                Matrix eposXctm = epos.multiply(ctm);
                width = eposXctm.getXPosition() - sposXctm.getXPosition();
                height = eposXctm.getYPosition() - sposXctm.getYPosition();
                this.graphicsPath.add(new RectPath(sposXctm.getXPosition(), sposXctm.getYPosition(), width, height));
            }
        } else if (operation.equals("f") || operation.equals("F") || operation.equals("f*")) {
            for (RectPath rect : this.graphicsPath) {
                this.renderRectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), false, true);
            }
            this.graphicsPath.removeAllElements();
        } else if (operation.equals("s") || operation.equals("S")) {
            for (RectPath rect : this.graphicsPath) {
                this.renderRectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), true, false);
            }
            this.graphicsPath.removeAllElements();
        } else if (operation.equals("B") || operation.equals("B*") || operation.equals("b") || operation.equals("b*")) {
            for (RectPath rect : this.graphicsPath) {
                this.renderRectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), true, true);
            }
            this.graphicsPath.removeAllElements();
        } else if (operation.equals("n")) {
            this.graphicsPath.removeAllElements();
        } else if (operation.equals("Do") && !this.disableImages) {
            COSName objectName = (COSName)arguments.get(0);
            Map xobjects = this.getResources().getXObjects();
            PDXObject xobject = (PDXObject)xobjects.get(objectName.getName());
            if (xobject instanceof PDXObjectImage) {
                PDXObjectImage image = (PDXObjectImage)xobject;
                byte[] data = this.getImageData(image);
                Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
                float x = ctm.getXPosition();
                float y = ctm.getYPosition();
                float width = ctm.getXScale();
                float height = ctm.getYScale();
                if (width < 0.0f) {
                    width = -width;
                    x -= width;
                }
                if (height < 0.0f) {
                    height = -height;
                    y -= height;
                }
                String mime = image.getSuffix().equalsIgnoreCase("jpg") || image.getSuffix().equalsIgnoreCase("jpeg") ? "image/jpeg" : "image/png";
                this.renderImage(x, y, width, height, mime, data);
            }
        }
        super.processOperator(operator, arguments);
    }

    protected void processTextPosition(TextPosition text) {
        if (!text.getCharacter().trim().isEmpty()) {
            this.cur_x = text.getX();
            this.cur_y = text.getY();
            int distx = 0;
            int disty = 0;
            if (this.lastText != null) {
                distx = (int)(text.getX() - (this.lastText.getX() + this.lastText.getWidth()));
                disty = (int)(text.getY() - this.lastText.getY());
            }
            boolean split = this.lastText == null || distx > 1 || distx < -6 || Math.abs(disty) > 1;
            this.updateStyle(this.style, text);
            if (!this.style.equals(this.curstyle)) {
                split = true;
            }
            if (split) {
                if (this.lastText != null) {
                    this.finishBox();
                }
                this.curstyle = new BoxStyle(this.style);
                this.curstyle.setLeft(this.cur_x);
                this.curstyle.setTop(this.cur_y - text.getFontSizeInPt());
            }
            this.textLine.append(text.getCharacter());
            this.lastText = text;
        }
    }

    protected void finishBox() {
        if (this.textLine.length() > 0) {
            this.renderText(this.textLine.toString());
            this.textLine = new StringBuilder();
        }
    }

    protected void updateStyle(BoxStyle bstyle, TextPosition text) {
        String font = text.getFont().getBaseFont();
        String family = null;
        String weight = null;
        String fstyle = null;
        bstyle.setFontSize(text.getFontSizeInPt());
        if (font != null) {
            int i;
            for (i = 0; i < pdFontType.length; ++i) {
                if (font.toLowerCase().lastIndexOf(pdFontType[i]) < 0) continue;
                weight = cssFontWeight[i];
                fstyle = cssFontStyle[i];
                break;
            }
            if (weight != null) {
                bstyle.setFontWeight(weight);
            } else {
                bstyle.setFontWeight(cssFontWeight[0]);
            }
            if (fstyle != null) {
                bstyle.setFontStyle(fstyle);
            } else {
                bstyle.setFontStyle(cssFontStyle[0]);
            }
            for (i = 0; i < cssFontFamily.length; ++i) {
                if (font.toLowerCase().lastIndexOf(cssFontFamily[i].toLowerCase()) < 0) continue;
                family = cssFontFamily[i];
                break;
            }
            if (family != null) {
                bstyle.setFontFamily(family);
            }
        }
    }

    protected PDRectangle getCurrentMediaBox() {
        PDRectangle layout = this.pdpage.getMediaBox();
        if (layout == null) {
            PDPageNode curpage;
            do {
                if ((curpage = this.pdpage.getParent()) == null) continue;
                layout = curpage.getMediaBox();
            } while (layout == null && curpage != null);
        }
        return layout;
    }

    protected float transformLength(float w) {
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        Matrix m = new Matrix();
        m.setValue(2, 0, w);
        return m.multiply(ctm).getXPosition();
    }

    protected int intValue(COSBase value) {
        if (value instanceof COSNumber) {
            return ((COSNumber)value).intValue();
        }
        return 0;
    }

    protected float floatValue(COSBase value) {
        if (value instanceof COSNumber) {
            return ((COSNumber)value).floatValue();
        }
        return 0.0f;
    }

    protected float getLength(COSBase value) {
        return this.floatValue(value);
    }

    protected String stringValue(COSBase value) {
        if (value instanceof COSString) {
            return ((COSString)value).getString();
        }
        if (value instanceof COSNumber) {
            return String.valueOf(((COSNumber)value).floatValue());
        }
        return "";
    }

    protected String colorString(int ir, int ig, int ib) {
        return String.format("#%02x%02x%02x", ir, ig, ib);
    }

    protected String colorString(float r, float g, float b) {
        return this.colorString((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    protected byte[] getImageData(PDXObjectImage image) throws IOException {
        if (image instanceof PDJpeg) {
            ArrayList<String> DCT_FILTERS = new ArrayList<String>();
            DCT_FILTERS.add(COSName.DCT_DECODE.getName());
            DCT_FILTERS.add(COSName.DCT_DECODE_ABBREVIATION.getName());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            InputStream data = image.getPDStream().getPartiallyFilteredStream(DCT_FILTERS);
            byte[] buf = new byte[1024];
            int amountRead = -1;
            while ((amountRead = data.read(buf)) != -1) {
                os.write(buf, 0, amountRead);
            }
            os.close();
            return os.toByteArray();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        image.write2OutputStream((OutputStream)os);
        os.close();
        return os.toByteArray();
    }
}

