// $ANTLR 3.5.2 CSSLexer.g 2016-07-08 23:35:09
package cz.vutbr.web.csskit.antlr;

import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/**
 * A basic CSS grammar.
 */
@SuppressWarnings("all")
public class DefaultCSSLexer_CSSLexer extends Lexer {
	public static final int EOF=-1;
	public static final int ADJACENT=4;
	public static final int AMPERSAND=5;
	public static final int APOS=6;
	public static final int ASTERISK=7;
	public static final int ATBLOCK=8;
	public static final int ATKEYWORD=9;
	public static final int ATTRIBUTE=10;
	public static final int BRACEBLOCK=11;
	public static final int CDC=12;
	public static final int CDO=13;
	public static final int CHARSET=14;
	public static final int CHILD=15;
	public static final int CLASSKEYWORD=16;
	public static final int COLON=17;
	public static final int COMMA=18;
	public static final int COMMENT=19;
	public static final int CONTAINS=20;
	public static final int CTRL=21;
	public static final int CTRL_CHAR=22;
	public static final int CURLYBLOCK=23;
	public static final int DASHMATCH=24;
	public static final int DECLARATION=25;
	public static final int DESCENDANT=26;
	public static final int DIMENSION=27;
	public static final int DUMMY=28;
	public static final int ELEMENT=29;
	public static final int ENDSWITH=30;
	public static final int EQUALS=31;
	public static final int ESCAPE_CHAR=32;
	public static final int EXCLAMATION=33;
	public static final int EXPRESSION=34;
	public static final int FONTFACE=35;
	public static final int FUNCTION=36;
	public static final int GREATER=37;
	public static final int HASH=38;
	public static final int HAT=39;
	public static final int IDENT=40;
	public static final int IDENT_MACR=41;
	public static final int IMPORT=42;
	public static final int IMPORTANT=43;
	public static final int INCLUDES=44;
	public static final int INDEX=45;
	public static final int INLINESTYLE=46;
	public static final int INTEGER_MACR=47;
	public static final int INVALID_ATSTATEMENT=48;
	public static final int INVALID_DECLARATION=49;
	public static final int INVALID_DIRECTIVE=50;
	public static final int INVALID_IMPORT=51;
	public static final int INVALID_SELECTOR=52;
	public static final int INVALID_SELPART=53;
	public static final int INVALID_STATEMENT=54;
	public static final int INVALID_STRING=55;
	public static final int INVALID_TOKEN=56;
	public static final int LBRACE=57;
	public static final int LCURLY=58;
	public static final int LESS=59;
	public static final int LPAREN=60;
	public static final int MARGIN_AREA=61;
	public static final int MEDIA=62;
	public static final int MEDIA_QUERY=63;
	public static final int MINUS=64;
	public static final int NAME_CHAR=65;
	public static final int NAME_MACR=66;
	public static final int NAME_START=67;
	public static final int NL_CHAR=68;
	public static final int NON_ASCII=69;
	public static final int NUMBER=70;
	public static final int NUMBER_MACR=71;
	public static final int PAGE=72;
	public static final int PARENBLOCK=73;
	public static final int PERCENT=74;
	public static final int PERCENTAGE=75;
	public static final int PLUS=76;
	public static final int POUND=77;
	public static final int PRECEDING=78;
	public static final int PSEUDOCLASS=79;
	public static final int PSEUDOELEM=80;
	public static final int QUESTION=81;
	public static final int QUOT=82;
	public static final int RBRACE=83;
	public static final int RCURLY=84;
	public static final int RPAREN=85;
	public static final int RULE=86;
	public static final int S=87;
	public static final int SELECTOR=88;
	public static final int SEMICOLON=89;
	public static final int SET=90;
	public static final int SLASH=91;
	public static final int SL_COMMENT=92;
	public static final int STARTSWITH=93;
	public static final int STRING=94;
	public static final int STRING_CHAR=95;
	public static final int STRING_MACR=96;
	public static final int STYLESHEET=97;
	public static final int TILDE=98;
	public static final int Tokens=99;
	public static final int UNIRANGE=100;
	public static final int URI=101;
	public static final int URI_CHAR=102;
	public static final int URI_MACR=103;
	public static final int VALUE=104;
	public static final int VIEWPORT=105;
	public static final int W_CHAR=106;
	public static final int W_MACR=107;

	    

	    private org.slf4j.Logger log;
	    
	    // number of already processed tokens (for checking the beginning of the style sheet)
	    protected int tokencnt = 0;
	    
	    // current lexer state
	    protected cz.vutbr.web.csskit.antlr.CSSLexerState ls;
	    protected cz.vutbr.web.csskit.antlr.CSSTokenFactory tf;
	    protected cz.vutbr.web.csskit.antlr.CSSTokenRecovery tr;
	    protected cz.vutbr.web.csskit.antlr.CSSExpressionReader er;
	    
	    /**
	     * This function must be called to initialize lexer's state.
	     * Because we can't change directly generated constructors.
	     */
	    public void init() {
	        this.log = org.slf4j.LoggerFactory.getLogger(getClass());
	        this.ls = new cz.vutbr.web.csskit.antlr.CSSLexerState();
	        this.tf = new cz.vutbr.web.csskit.antlr.CSSTokenFactory(input, state, ls, getClass());
	        this.tr = new cz.vutbr.web.csskit.antlr.CSSTokenRecovery(this, input, state, ls, log);
	        this.er = new cz.vutbr.web.csskit.antlr.CSSExpressionReader(input, log);
	    }
	    
	    @Override
	    public void reset() {
	        throw new UnsupportedOperationException();
	    }
	    
	    @Override
	    public void setCharStream(CharStream input) {
	        throw new UnsupportedOperationException();
	    }
	    
	    /**
	     * Overrides next token to match includes and to 
	     * recover from EOF
	     */
		@Override 
	    public Token nextToken(){
	       Token token = tr.nextToken();

	       //count non-empty tokens for eventual checking of the style sheet start
	       if (token.getType() == S) {
	           tokencnt++;
	       }

	       // Skip first token after switching on another input.
	       if(((CommonToken)token).getStartIndex() < 0)
	         token = nextToken();
	        
	       return token;
	    }

	    /**
	     * Adds contextual information about nesting into token.
		 */
	    @Override
		public Token emit() {
	        Token t = tf.make();
	        emit(t);
	        return t;
		}

		@Override
	    public void emitErrorMessage(String msg) {
	    	log.info("ANTLR: {}", msg);
	    }
	    
	    /**
	     * Does special token recovery for some cases
	     */ 
	    @Override
	    public void recover(RecognitionException re) {
	        if (!tr.recover())
	            super.recover(re);
	    }


	// delegates
	// delegators
	public DefaultCSSLexer gDefaultCSSLexer;
	public DefaultCSSLexer gParent;
	public Lexer[] getDelegates() {
		return new Lexer[] {};
	}

	public DefaultCSSLexer_CSSLexer() {} 
	public DefaultCSSLexer_CSSLexer(CharStream input, DefaultCSSLexer gDefaultCSSLexer) {
		this(input, new RecognizerSharedState(), gDefaultCSSLexer);
	}
	public DefaultCSSLexer_CSSLexer(CharStream input, RecognizerSharedState state, DefaultCSSLexer gDefaultCSSLexer) {
		super(input,state);
		this.gDefaultCSSLexer = gDefaultCSSLexer;
		gParent = gDefaultCSSLexer;
	}
	@Override public String getGrammarFileName() { return "CSSLexer.g"; }

	// $ANTLR start "IMPORTANT"
	public final void mIMPORTANT() throws RecognitionException {
		try {
			int _type = IMPORTANT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:144:5: ( 'important' )
			// CSSLexer.g:144:7: 'important'
			{
			match("important"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IMPORTANT"

	// $ANTLR start "IDENT"
	public final void mIDENT() throws RecognitionException {
		try {
			int _type = IDENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:149:2: ( IDENT_MACR )
			// CSSLexer.g:149:4: IDENT_MACR
			{
			mIDENT_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IDENT"

	// $ANTLR start "CHARSET"
	public final void mCHARSET() throws RecognitionException {
		try {
			int _type = CHARSET;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken s=null;


				tr.expecting(CHARSET);

			// CSSLexer.g:160:2: ( '@charset' ( S )* s= STRING_MACR ( S )* SEMICOLON )
			// CSSLexer.g:160:4: '@charset' ( S )* s= STRING_MACR ( S )* SEMICOLON
			{
			match("@charset"); 

			// CSSLexer.g:160:15: ( S )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( ((LA1_0 >= '\t' && LA1_0 <= '\r')||LA1_0==' ') ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// CSSLexer.g:160:15: S
					{
					mS(); 

					}
					break;

				default :
					break loop1;
				}
			}

			int sStart205 = getCharIndex();
			int sStartLine205 = getLine();
			int sStartCharPos205 = getCharPositionInLine();
			mSTRING_MACR(); 
			s = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, sStart205, getCharIndex()-1);
			s.setLine(sStartLine205);
			s.setCharPositionInLine(sStartCharPos205);

			// CSSLexer.g:160:32: ( S )*
			loop2:
			while (true) {
				int alt2=2;
				int LA2_0 = input.LA(1);
				if ( ((LA2_0 >= '\t' && LA2_0 <= '\r')||LA2_0==' ') ) {
					alt2=1;
				}

				switch (alt2) {
				case 1 :
					// CSSLexer.g:160:32: S
					{
					mS(); 

					}
					break;

				default :
					break loop2;
				}
			}

			mSEMICOLON(); 


				    // we have to trim manually
				    String enc = cz.vutbr.web.csskit.antlr.CSSToken.extractSTRING(s.getText());
				    //System.err.println("CHARSET"+tokencnt);
				    if (tokencnt <= 1) //we are at the beginning of the style sheet
				    {
						    tokencnt++;
						    try {
						           log.warn("Changing charset to {}", enc);
						          ((cz.vutbr.web.csskit.antlr.CSSInputStream) input).setEncoding(enc);
						          //input = setCharStream(new ANTLFileStream(input.getSourceName(), enc));
						        }
						        catch(java.nio.charset.IllegalCharsetNameException icne) {
						        	log.warn("Could not change to unsupported charset!", icne);
						        	throw new RuntimeException(new cz.vutbr.web.css.CSSException("Unsupported charset: " + enc));
						        }
						        catch (java.io.IOException e) {
			                log.warn("Could not change to unsupported charset!", e);
						        }
						 }
						 else
						      log.warn("Ignoring @charset rule not at the beginning of the style sheet");
				  
			}

			state.type = _type;
			state.channel = _channel;

				tr.end();

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CHARSET"

	// $ANTLR start "IMPORT"
	public final void mIMPORT() throws RecognitionException {
		try {
			int _type = IMPORT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:187:2: ( '@import' )
			// CSSLexer.g:187:4: '@import'
			{
			match("@import"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IMPORT"

	// $ANTLR start "MEDIA"
	public final void mMEDIA() throws RecognitionException {
		try {
			int _type = MEDIA;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:191:2: ( '@media' )
			// CSSLexer.g:191:4: '@media'
			{
			match("@media"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MEDIA"

	// $ANTLR start "PAGE"
	public final void mPAGE() throws RecognitionException {
		try {
			int _type = PAGE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:195:2: ( '@page' )
			// CSSLexer.g:195:4: '@page'
			{
			match("@page"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PAGE"

	// $ANTLR start "MARGIN_AREA"
	public final void mMARGIN_AREA() throws RecognitionException {
		try {
			int _type = MARGIN_AREA;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:199:3: ( '@top-left-corner' | '@top-left' | '@top-center' | '@top-right' | '@top-right-corner' | '@bottom-left-corner' | '@bottom-left' | '@bottom-center' | '@bottom-right' | '@bottom-right-corner' | '@left-top' | '@left-middle' | '@left-bottom' | '@right-top' | '@right-middle' | '@right-bottom' )
			int alt3=16;
			int LA3_0 = input.LA(1);
			if ( (LA3_0=='@') ) {
				switch ( input.LA(2) ) {
				case 't':
					{
					int LA3_2 = input.LA(3);
					if ( (LA3_2=='o') ) {
						int LA3_6 = input.LA(4);
						if ( (LA3_6=='p') ) {
							int LA3_10 = input.LA(5);
							if ( (LA3_10=='-') ) {
								switch ( input.LA(6) ) {
								case 'l':
									{
									int LA3_18 = input.LA(7);
									if ( (LA3_18=='e') ) {
										int LA3_24 = input.LA(8);
										if ( (LA3_24=='f') ) {
											int LA3_31 = input.LA(9);
											if ( (LA3_31=='t') ) {
												int LA3_37 = input.LA(10);
												if ( (LA3_37=='-') ) {
													alt3=1;
												}

												else {
													alt3=2;
												}

											}

											else {
												int nvaeMark = input.mark();
												try {
													for (int nvaeConsume = 0; nvaeConsume < 9 - 1; nvaeConsume++) {
														input.consume();
													}
													NoViableAltException nvae =
														new NoViableAltException("", 3, 31, input);
													throw nvae;
												} finally {
													input.rewind(nvaeMark);
												}
											}

										}

										else {
											int nvaeMark = input.mark();
											try {
												for (int nvaeConsume = 0; nvaeConsume < 8 - 1; nvaeConsume++) {
													input.consume();
												}
												NoViableAltException nvae =
													new NoViableAltException("", 3, 24, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 7 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 3, 18, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

									}
									break;
								case 'c':
									{
									alt3=3;
									}
									break;
								case 'r':
									{
									int LA3_20 = input.LA(7);
									if ( (LA3_20=='i') ) {
										int LA3_25 = input.LA(8);
										if ( (LA3_25=='g') ) {
											int LA3_32 = input.LA(9);
											if ( (LA3_32=='h') ) {
												int LA3_38 = input.LA(10);
												if ( (LA3_38=='t') ) {
													int LA3_44 = input.LA(11);
													if ( (LA3_44=='-') ) {
														alt3=5;
													}

													else {
														alt3=4;
													}

												}

												else {
													int nvaeMark = input.mark();
													try {
														for (int nvaeConsume = 0; nvaeConsume < 10 - 1; nvaeConsume++) {
															input.consume();
														}
														NoViableAltException nvae =
															new NoViableAltException("", 3, 38, input);
														throw nvae;
													} finally {
														input.rewind(nvaeMark);
													}
												}

											}

											else {
												int nvaeMark = input.mark();
												try {
													for (int nvaeConsume = 0; nvaeConsume < 9 - 1; nvaeConsume++) {
														input.consume();
													}
													NoViableAltException nvae =
														new NoViableAltException("", 3, 32, input);
													throw nvae;
												} finally {
													input.rewind(nvaeMark);
												}
											}

										}

										else {
											int nvaeMark = input.mark();
											try {
												for (int nvaeConsume = 0; nvaeConsume < 8 - 1; nvaeConsume++) {
													input.consume();
												}
												NoViableAltException nvae =
													new NoViableAltException("", 3, 25, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 7 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 3, 20, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

									}
									break;
								default:
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 3, 14, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}
							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 3, 10, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 3, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 3, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case 'b':
					{
					int LA3_3 = input.LA(3);
					if ( (LA3_3=='o') ) {
						int LA3_7 = input.LA(4);
						if ( (LA3_7=='t') ) {
							int LA3_11 = input.LA(5);
							if ( (LA3_11=='t') ) {
								int LA3_15 = input.LA(6);
								if ( (LA3_15=='o') ) {
									int LA3_21 = input.LA(7);
									if ( (LA3_21=='m') ) {
										int LA3_26 = input.LA(8);
										if ( (LA3_26=='-') ) {
											switch ( input.LA(9) ) {
											case 'l':
												{
												int LA3_39 = input.LA(10);
												if ( (LA3_39=='e') ) {
													int LA3_45 = input.LA(11);
													if ( (LA3_45=='f') ) {
														int LA3_49 = input.LA(12);
														if ( (LA3_49=='t') ) {
															int LA3_51 = input.LA(13);
															if ( (LA3_51=='-') ) {
																alt3=6;
															}

															else {
																alt3=7;
															}

														}

														else {
															int nvaeMark = input.mark();
															try {
																for (int nvaeConsume = 0; nvaeConsume < 12 - 1; nvaeConsume++) {
																	input.consume();
																}
																NoViableAltException nvae =
																	new NoViableAltException("", 3, 49, input);
																throw nvae;
															} finally {
																input.rewind(nvaeMark);
															}
														}

													}

													else {
														int nvaeMark = input.mark();
														try {
															for (int nvaeConsume = 0; nvaeConsume < 11 - 1; nvaeConsume++) {
																input.consume();
															}
															NoViableAltException nvae =
																new NoViableAltException("", 3, 45, input);
															throw nvae;
														} finally {
															input.rewind(nvaeMark);
														}
													}

												}

												else {
													int nvaeMark = input.mark();
													try {
														for (int nvaeConsume = 0; nvaeConsume < 10 - 1; nvaeConsume++) {
															input.consume();
														}
														NoViableAltException nvae =
															new NoViableAltException("", 3, 39, input);
														throw nvae;
													} finally {
														input.rewind(nvaeMark);
													}
												}

												}
												break;
											case 'c':
												{
												alt3=8;
												}
												break;
											case 'r':
												{
												int LA3_41 = input.LA(10);
												if ( (LA3_41=='i') ) {
													int LA3_46 = input.LA(11);
													if ( (LA3_46=='g') ) {
														int LA3_50 = input.LA(12);
														if ( (LA3_50=='h') ) {
															int LA3_52 = input.LA(13);
															if ( (LA3_52=='t') ) {
																int LA3_55 = input.LA(14);
																if ( (LA3_55=='-') ) {
																	alt3=10;
																}

																else {
																	alt3=9;
																}

															}

															else {
																int nvaeMark = input.mark();
																try {
																	for (int nvaeConsume = 0; nvaeConsume < 13 - 1; nvaeConsume++) {
																		input.consume();
																	}
																	NoViableAltException nvae =
																		new NoViableAltException("", 3, 52, input);
																	throw nvae;
																} finally {
																	input.rewind(nvaeMark);
																}
															}

														}

														else {
															int nvaeMark = input.mark();
															try {
																for (int nvaeConsume = 0; nvaeConsume < 12 - 1; nvaeConsume++) {
																	input.consume();
																}
																NoViableAltException nvae =
																	new NoViableAltException("", 3, 50, input);
																throw nvae;
															} finally {
																input.rewind(nvaeMark);
															}
														}

													}

													else {
														int nvaeMark = input.mark();
														try {
															for (int nvaeConsume = 0; nvaeConsume < 11 - 1; nvaeConsume++) {
																input.consume();
															}
															NoViableAltException nvae =
																new NoViableAltException("", 3, 46, input);
															throw nvae;
														} finally {
															input.rewind(nvaeMark);
														}
													}

												}

												else {
													int nvaeMark = input.mark();
													try {
														for (int nvaeConsume = 0; nvaeConsume < 10 - 1; nvaeConsume++) {
															input.consume();
														}
														NoViableAltException nvae =
															new NoViableAltException("", 3, 41, input);
														throw nvae;
													} finally {
														input.rewind(nvaeMark);
													}
												}

												}
												break;
											default:
												int nvaeMark = input.mark();
												try {
													for (int nvaeConsume = 0; nvaeConsume < 9 - 1; nvaeConsume++) {
														input.consume();
													}
													NoViableAltException nvae =
														new NoViableAltException("", 3, 33, input);
													throw nvae;
												} finally {
													input.rewind(nvaeMark);
												}
											}
										}

										else {
											int nvaeMark = input.mark();
											try {
												for (int nvaeConsume = 0; nvaeConsume < 8 - 1; nvaeConsume++) {
													input.consume();
												}
												NoViableAltException nvae =
													new NoViableAltException("", 3, 26, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 7 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 3, 21, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 3, 15, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 3, 11, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 3, 7, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 3, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case 'l':
					{
					int LA3_4 = input.LA(3);
					if ( (LA3_4=='e') ) {
						int LA3_8 = input.LA(4);
						if ( (LA3_8=='f') ) {
							int LA3_12 = input.LA(5);
							if ( (LA3_12=='t') ) {
								int LA3_16 = input.LA(6);
								if ( (LA3_16=='-') ) {
									switch ( input.LA(7) ) {
									case 't':
										{
										alt3=11;
										}
										break;
									case 'm':
										{
										alt3=12;
										}
										break;
									case 'b':
										{
										alt3=13;
										}
										break;
									default:
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 7 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 3, 22, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 3, 16, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 3, 12, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 3, 8, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 3, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case 'r':
					{
					int LA3_5 = input.LA(3);
					if ( (LA3_5=='i') ) {
						int LA3_9 = input.LA(4);
						if ( (LA3_9=='g') ) {
							int LA3_13 = input.LA(5);
							if ( (LA3_13=='h') ) {
								int LA3_17 = input.LA(6);
								if ( (LA3_17=='t') ) {
									int LA3_23 = input.LA(7);
									if ( (LA3_23=='-') ) {
										switch ( input.LA(8) ) {
										case 't':
											{
											alt3=14;
											}
											break;
										case 'm':
											{
											alt3=15;
											}
											break;
										case 'b':
											{
											alt3=16;
											}
											break;
										default:
											int nvaeMark = input.mark();
											try {
												for (int nvaeConsume = 0; nvaeConsume < 8 - 1; nvaeConsume++) {
													input.consume();
												}
												NoViableAltException nvae =
													new NoViableAltException("", 3, 30, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}
									}

									else {
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 7 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 3, 23, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 3, 17, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 3, 13, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 3, 9, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 3, 5, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 3, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 3, 0, input);
				throw nvae;
			}

			switch (alt3) {
				case 1 :
					// CSSLexer.g:199:5: '@top-left-corner'
					{
					match("@top-left-corner"); 

					}
					break;
				case 2 :
					// CSSLexer.g:200:5: '@top-left'
					{
					match("@top-left"); 

					}
					break;
				case 3 :
					// CSSLexer.g:201:5: '@top-center'
					{
					match("@top-center"); 

					}
					break;
				case 4 :
					// CSSLexer.g:202:5: '@top-right'
					{
					match("@top-right"); 

					}
					break;
				case 5 :
					// CSSLexer.g:203:5: '@top-right-corner'
					{
					match("@top-right-corner"); 

					}
					break;
				case 6 :
					// CSSLexer.g:204:5: '@bottom-left-corner'
					{
					match("@bottom-left-corner"); 

					}
					break;
				case 7 :
					// CSSLexer.g:205:5: '@bottom-left'
					{
					match("@bottom-left"); 

					}
					break;
				case 8 :
					// CSSLexer.g:206:5: '@bottom-center'
					{
					match("@bottom-center"); 

					}
					break;
				case 9 :
					// CSSLexer.g:207:5: '@bottom-right'
					{
					match("@bottom-right"); 

					}
					break;
				case 10 :
					// CSSLexer.g:208:5: '@bottom-right-corner'
					{
					match("@bottom-right-corner"); 

					}
					break;
				case 11 :
					// CSSLexer.g:209:5: '@left-top'
					{
					match("@left-top"); 

					}
					break;
				case 12 :
					// CSSLexer.g:210:5: '@left-middle'
					{
					match("@left-middle"); 

					}
					break;
				case 13 :
					// CSSLexer.g:211:5: '@left-bottom'
					{
					match("@left-bottom"); 

					}
					break;
				case 14 :
					// CSSLexer.g:212:5: '@right-top'
					{
					match("@right-top"); 

					}
					break;
				case 15 :
					// CSSLexer.g:213:5: '@right-middle'
					{
					match("@right-middle"); 

					}
					break;
				case 16 :
					// CSSLexer.g:214:5: '@right-bottom'
					{
					match("@right-bottom"); 

					}
					break;

			}
			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MARGIN_AREA"

	// $ANTLR start "VIEWPORT"
	public final void mVIEWPORT() throws RecognitionException {
		try {
			int _type = VIEWPORT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:218:3: ( '@viewport' )
			// CSSLexer.g:218:5: '@viewport'
			{
			match("@viewport"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "VIEWPORT"

	// $ANTLR start "FONTFACE"
	public final void mFONTFACE() throws RecognitionException {
		try {
			int _type = FONTFACE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:222:3: ( '@font-face' )
			// CSSLexer.g:222:5: '@font-face'
			{
			match("@font-face"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FONTFACE"

	// $ANTLR start "ATKEYWORD"
	public final void mATKEYWORD() throws RecognitionException {
		try {
			int _type = ATKEYWORD;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:227:2: ( '@' ( MINUS )? ( IDENT_MACR )? )
			// CSSLexer.g:227:4: '@' ( MINUS )? ( IDENT_MACR )?
			{
			match('@'); 
			// CSSLexer.g:227:8: ( MINUS )?
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0=='-') ) {
				alt4=1;
			}
			switch (alt4) {
				case 1 :
					// CSSLexer.g:
					{
					if ( input.LA(1)=='-' ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

			}

			// CSSLexer.g:227:15: ( IDENT_MACR )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( ((LA5_0 >= 'A' && LA5_0 <= 'Z')||LA5_0=='\\'||LA5_0=='_'||(LA5_0 >= 'a' && LA5_0 <= 'z')||(LA5_0 >= '\u0080' && LA5_0 <= '\uD7FF')||(LA5_0 >= '\uE000' && LA5_0 <= '\uFFFD')) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// CSSLexer.g:227:15: IDENT_MACR
					{
					mIDENT_MACR(); 

					}
					break;

			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ATKEYWORD"

	// $ANTLR start "CLASSKEYWORD"
	public final void mCLASSKEYWORD() throws RecognitionException {
		try {
			int _type = CLASSKEYWORD;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:231:5: ( '.' IDENT_MACR )
			// CSSLexer.g:231:7: '.' IDENT_MACR
			{
			match('.'); 
			mIDENT_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CLASSKEYWORD"

	// $ANTLR start "STRING"
	public final void mSTRING() throws RecognitionException {
		try {
			int _type = STRING;
			int _channel = DEFAULT_TOKEN_CHANNEL;

				tr.expecting(STRING);

			// CSSLexer.g:242:2: ( STRING_MACR )
			// CSSLexer.g:242:4: STRING_MACR
			{
			mSTRING_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;

				tr.end();

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STRING"

	// $ANTLR start "HASH"
	public final void mHASH() throws RecognitionException {
		try {
			int _type = HASH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:247:2: ( POUND NAME_MACR )
			// CSSLexer.g:247:4: POUND NAME_MACR
			{
			mPOUND(); 

			mNAME_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "HASH"

	// $ANTLR start "INDEX"
	public final void mINDEX() throws RecognitionException {
		try {
			int _type = INDEX;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:252:3: ( ( INTEGER_MACR )? ( 'N' | 'n' ) ( ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR )? )
			// CSSLexer.g:252:5: ( INTEGER_MACR )? ( 'N' | 'n' ) ( ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR )?
			{
			// CSSLexer.g:252:5: ( INTEGER_MACR )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( ((LA6_0 >= '0' && LA6_0 <= '9')) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// CSSLexer.g:252:5: INTEGER_MACR
					{
					mINTEGER_MACR(); 

					}
					break;

			}

			if ( input.LA(1)=='N'||input.LA(1)=='n' ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			// CSSLexer.g:252:31: ( ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( ((LA9_0 >= '\t' && LA9_0 <= '\r')||LA9_0==' '||LA9_0=='+'||LA9_0=='-') ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// CSSLexer.g:252:32: ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR
					{
					// CSSLexer.g:252:32: ( S )*
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( ((LA7_0 >= '\t' && LA7_0 <= '\r')||LA7_0==' ') ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// CSSLexer.g:252:32: S
							{
							mS(); 

							}
							break;

						default :
							break loop7;
						}
					}

					if ( input.LA(1)=='+'||input.LA(1)=='-' ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					// CSSLexer.g:252:50: ( S )*
					loop8:
					while (true) {
						int alt8=2;
						int LA8_0 = input.LA(1);
						if ( ((LA8_0 >= '\t' && LA8_0 <= '\r')||LA8_0==' ') ) {
							alt8=1;
						}

						switch (alt8) {
						case 1 :
							// CSSLexer.g:252:50: S
							{
							mS(); 

							}
							break;

						default :
							break loop8;
						}
					}

					mINTEGER_MACR(); 

					}
					break;

			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INDEX"

	// $ANTLR start "NUMBER"
	public final void mNUMBER() throws RecognitionException {
		try {
			int _type = NUMBER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:257:2: ( NUMBER_MACR )
			// CSSLexer.g:257:4: NUMBER_MACR
			{
			mNUMBER_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NUMBER"

	// $ANTLR start "PERCENTAGE"
	public final void mPERCENTAGE() throws RecognitionException {
		try {
			int _type = PERCENTAGE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:262:2: ( NUMBER_MACR '%' )
			// CSSLexer.g:262:4: NUMBER_MACR '%'
			{
			mNUMBER_MACR(); 

			match('%'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PERCENTAGE"

	// $ANTLR start "DIMENSION"
	public final void mDIMENSION() throws RecognitionException {
		try {
			int _type = DIMENSION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:267:2: ( NUMBER_MACR IDENT_MACR )
			// CSSLexer.g:267:4: NUMBER_MACR IDENT_MACR
			{
			mNUMBER_MACR(); 

			mIDENT_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DIMENSION"

	// $ANTLR start "URI"
	public final void mURI() throws RecognitionException {
		try {
			int _type = URI;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:272:2: ( 'url(' W_MACR ( STRING_MACR | URI_MACR ) W_MACR ')' )
			// CSSLexer.g:272:4: 'url(' W_MACR ( STRING_MACR | URI_MACR ) W_MACR ')'
			{
			match("url("); 

			mW_MACR(); 

			// CSSLexer.g:272:18: ( STRING_MACR | URI_MACR )
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0=='\"'||LA10_0=='\'') ) {
				alt10=1;
			}
			else if ( ((LA10_0 >= '\t' && LA10_0 <= '\r')||(LA10_0 >= ' ' && LA10_0 <= '!')||(LA10_0 >= '#' && LA10_0 <= '&')||(LA10_0 >= ')' && LA10_0 <= '~')||(LA10_0 >= '\u0080' && LA10_0 <= '\uD7FF')||(LA10_0 >= '\uE000' && LA10_0 <= '\uFFFD')) ) {
				alt10=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 10, 0, input);
				throw nvae;
			}

			switch (alt10) {
				case 1 :
					// CSSLexer.g:272:19: STRING_MACR
					{
					mSTRING_MACR(); 

					}
					break;
				case 2 :
					// CSSLexer.g:272:33: URI_MACR
					{
					mURI_MACR(); 

					}
					break;

			}

			mW_MACR(); 

			match(')'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "URI"

	// $ANTLR start "UNIRANGE"
	public final void mUNIRANGE() throws RecognitionException {
		try {
			int _type = UNIRANGE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:276:9: ( 'U+' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) )? ( '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )? )
			// CSSLexer.g:277:2: 'U+' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) )? ( '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )?
			{
			match("U+"); 

			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			// CSSLexer.g:281:7: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) )?
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( ((LA11_0 >= '0' && LA11_0 <= '9')||LA11_0=='?'||(LA11_0 >= 'A' && LA11_0 <= 'F')||(LA11_0 >= 'a' && LA11_0 <= 'f')) ) {
				alt11=1;
			}
			switch (alt11) {
				case 1 :
					// CSSLexer.g:281:8: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' )
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

			}

			// CSSLexer.g:282:2: ( '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0=='-') ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// CSSLexer.g:282:3: '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )?
					{
					match('-'); 
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					// CSSLexer.g:287:14: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )?
					int alt12=2;
					int LA12_0 = input.LA(1);
					if ( ((LA12_0 >= '0' && LA12_0 <= '9')||(LA12_0 >= 'A' && LA12_0 <= 'F')||(LA12_0 >= 'a' && LA12_0 <= 'f')) ) {
						alt12=1;
					}
					switch (alt12) {
						case 1 :
							// CSSLexer.g:287:15: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

					}

					}
					break;

			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UNIRANGE"

	// $ANTLR start "CDO"
	public final void mCDO() throws RecognitionException {
		try {
			int _type = CDO;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:293:2: ( '<!--' )
			// CSSLexer.g:293:4: '<!--'
			{
			match("<!--"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CDO"

	// $ANTLR start "CDC"
	public final void mCDC() throws RecognitionException {
		try {
			int _type = CDC;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:298:2: ( '-->' )
			// CSSLexer.g:298:4: '-->'
			{
			match("-->"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CDC"

	// $ANTLR start "SEMICOLON"
	public final void mSEMICOLON() throws RecognitionException {
		try {
			int _type = SEMICOLON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:302:2: ( ';' )
			// CSSLexer.g:302:4: ';'
			{
			match(';'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SEMICOLON"

	// $ANTLR start "COLON"
	public final void mCOLON() throws RecognitionException {
		try {
			int _type = COLON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:306:2: ( ':' )
			// CSSLexer.g:306:4: ':'
			{
			match(':'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COLON"

	// $ANTLR start "COMMA"
	public final void mCOMMA() throws RecognitionException {
		try {
			int _type = COMMA;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:310:5: ( ',' )
			// CSSLexer.g:310:7: ','
			{
			match(','); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COMMA"

	// $ANTLR start "QUESTION"
	public final void mQUESTION() throws RecognitionException {
		try {
			int _type = QUESTION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:314:2: ( '?' )
			// CSSLexer.g:314:4: '?'
			{
			match('?'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "QUESTION"

	// $ANTLR start "PERCENT"
	public final void mPERCENT() throws RecognitionException {
		try {
			int _type = PERCENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:318:2: ( '%' )
			// CSSLexer.g:318:4: '%'
			{
			match('%'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PERCENT"

	// $ANTLR start "EQUALS"
	public final void mEQUALS() throws RecognitionException {
		try {
			int _type = EQUALS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:322:5: ( '=' )
			// CSSLexer.g:322:7: '='
			{
			match('='); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EQUALS"

	// $ANTLR start "SLASH"
	public final void mSLASH() throws RecognitionException {
		try {
			int _type = SLASH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:326:5: ( '/' )
			// CSSLexer.g:326:7: '/'
			{
			match('/'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SLASH"

	// $ANTLR start "GREATER"
	public final void mGREATER() throws RecognitionException {
		try {
			int _type = GREATER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:330:5: ( '>' )
			// CSSLexer.g:330:7: '>'
			{
			match('>'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "GREATER"

	// $ANTLR start "LESS"
	public final void mLESS() throws RecognitionException {
		try {
			int _type = LESS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:334:5: ( '<' )
			// CSSLexer.g:334:7: '<'
			{
			match('<'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LESS"

	// $ANTLR start "LCURLY"
	public final void mLCURLY() throws RecognitionException {
		try {
			int _type = LCURLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:338:2: ( '{' )
			// CSSLexer.g:338:4: '{'
			{
			match('{'); 
			ls.curlyNest++;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LCURLY"

	// $ANTLR start "RCURLY"
	public final void mRCURLY() throws RecognitionException {
		try {
			int _type = RCURLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:342:2: ( '}' )
			// CSSLexer.g:342:4: '}'
			{
			match('}'); 
			 if(ls.curlyNest>0) ls.curlyNest--;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RCURLY"

	// $ANTLR start "APOS"
	public final void mAPOS() throws RecognitionException {
		try {
			int _type = APOS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:346:2: ( '\\'' )
			// CSSLexer.g:346:4: '\\''
			{
			match('\''); 
			 ls.aposOpen=!ls.aposOpen; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "APOS"

	// $ANTLR start "QUOT"
	public final void mQUOT() throws RecognitionException {
		try {
			int _type = QUOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:350:2: ( '\"' )
			// CSSLexer.g:350:4: '\"'
			{
			match('\"'); 
			 ls.quotOpen=!ls.quotOpen; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "QUOT"

	// $ANTLR start "LPAREN"
	public final void mLPAREN() throws RecognitionException {
		try {
			int _type = LPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:354:2: ( '(' )
			// CSSLexer.g:354:4: '('
			{
			match('('); 
			ls.parenNest++; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LPAREN"

	// $ANTLR start "RPAREN"
	public final void mRPAREN() throws RecognitionException {
		try {
			int _type = RPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:358:2: ( ')' )
			// CSSLexer.g:358:4: ')'
			{
			match(')'); 
			 if(ls.parenNest>0) ls.parenNest--; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RPAREN"

	// $ANTLR start "LBRACE"
	public final void mLBRACE() throws RecognitionException {
		try {
			int _type = LBRACE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:362:2: ( '[' )
			// CSSLexer.g:362:4: '['
			{
			match('['); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LBRACE"

	// $ANTLR start "RBRACE"
	public final void mRBRACE() throws RecognitionException {
		try {
			int _type = RBRACE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:366:2: ( ']' )
			// CSSLexer.g:366:4: ']'
			{
			match(']'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RBRACE"

	// $ANTLR start "EXCLAMATION"
	public final void mEXCLAMATION() throws RecognitionException {
		try {
			int _type = EXCLAMATION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:370:5: ( '!' )
			// CSSLexer.g:370:7: '!'
			{
			match('!'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EXCLAMATION"

	// $ANTLR start "TILDE"
	public final void mTILDE() throws RecognitionException {
		try {
			int _type = TILDE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:374:3: ( '~' )
			// CSSLexer.g:374:5: '~'
			{
			match('~'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TILDE"

	// $ANTLR start "MINUS"
	public final void mMINUS() throws RecognitionException {
		try {
			int _type = MINUS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:378:2: ( '-' )
			// CSSLexer.g:378:4: '-'
			{
			match('-'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MINUS"

	// $ANTLR start "PLUS"
	public final void mPLUS() throws RecognitionException {
		try {
			int _type = PLUS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:382:2: ( '+' )
			// CSSLexer.g:382:4: '+'
			{
			match('+'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PLUS"

	// $ANTLR start "ASTERISK"
	public final void mASTERISK() throws RecognitionException {
		try {
			int _type = ASTERISK;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:386:2: ( '*' )
			// CSSLexer.g:386:4: '*'
			{
			match('*'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ASTERISK"

	// $ANTLR start "POUND"
	public final void mPOUND() throws RecognitionException {
		try {
			int _type = POUND;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:390:2: ( '#' )
			// CSSLexer.g:390:4: '#'
			{
			match('#'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "POUND"

	// $ANTLR start "AMPERSAND"
	public final void mAMPERSAND() throws RecognitionException {
		try {
			int _type = AMPERSAND;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:394:2: ( '&' )
			// CSSLexer.g:394:4: '&'
			{
			match('&'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "AMPERSAND"

	// $ANTLR start "HAT"
	public final void mHAT() throws RecognitionException {
		try {
			int _type = HAT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:398:2: ( '^' )
			// CSSLexer.g:398:4: '^'
			{
			match('^'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "HAT"

	// $ANTLR start "S"
	public final void mS() throws RecognitionException {
		try {
			int _type = S;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:403:2: ( ( W_CHAR )+ )
			// CSSLexer.g:403:4: ( W_CHAR )+
			{
			// CSSLexer.g:403:4: ( W_CHAR )+
			int cnt14=0;
			loop14:
			while (true) {
				int alt14=2;
				int LA14_0 = input.LA(1);
				if ( ((LA14_0 >= '\t' && LA14_0 <= '\r')||LA14_0==' ') ) {
					alt14=1;
				}

				switch (alt14) {
				case 1 :
					// CSSLexer.g:
					{
					if ( (input.LA(1) >= '\t' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt14 >= 1 ) break loop14;
					EarlyExitException eee = new EarlyExitException(14, input);
					throw eee;
				}
				cnt14++;
			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "S"

	// $ANTLR start "COMMENT"
	public final void mCOMMENT() throws RecognitionException {
		try {
			int _type = COMMENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:407:2: ( '/*' ( options {greedy=false; } : . )* '*/' )
			// CSSLexer.g:407:4: '/*' ( options {greedy=false; } : . )* '*/'
			{
			match("/*"); 

			// CSSLexer.g:407:9: ( options {greedy=false; } : . )*
			loop15:
			while (true) {
				int alt15=2;
				int LA15_0 = input.LA(1);
				if ( (LA15_0=='*') ) {
					int LA15_1 = input.LA(2);
					if ( (LA15_1=='/') ) {
						alt15=2;
					}
					else if ( ((LA15_1 >= '\u0000' && LA15_1 <= '.')||(LA15_1 >= '0' && LA15_1 <= '\uFFFF')) ) {
						alt15=1;
					}

				}
				else if ( ((LA15_0 >= '\u0000' && LA15_0 <= ')')||(LA15_0 >= '+' && LA15_0 <= '\uFFFF')) ) {
					alt15=1;
				}

				switch (alt15) {
				case 1 :
					// CSSLexer.g:407:37: .
					{
					matchAny(); 
					}
					break;

				default :
					break loop15;
				}
			}

			match("*/"); 

			 _channel = HIDDEN; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COMMENT"

	// $ANTLR start "SL_COMMENT"
	public final void mSL_COMMENT() throws RecognitionException {
		try {
			int _type = SL_COMMENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:411:2: ( '//' ( options {greedy=false; } : . )* ( '\\n' | '\\r' ) )
			// CSSLexer.g:411:4: '//' ( options {greedy=false; } : . )* ( '\\n' | '\\r' )
			{
			match("//"); 

			// CSSLexer.g:411:9: ( options {greedy=false; } : . )*
			loop16:
			while (true) {
				int alt16=2;
				int LA16_0 = input.LA(1);
				if ( (LA16_0=='\n'||LA16_0=='\r') ) {
					alt16=2;
				}
				else if ( ((LA16_0 >= '\u0000' && LA16_0 <= '\t')||(LA16_0 >= '\u000B' && LA16_0 <= '\f')||(LA16_0 >= '\u000E' && LA16_0 <= '\uFFFF')) ) {
					alt16=1;
				}

				switch (alt16) {
				case 1 :
					// CSSLexer.g:411:37: .
					{
					matchAny(); 
					}
					break;

				default :
					break loop16;
				}
			}

			if ( input.LA(1)=='\n'||input.LA(1)=='\r' ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			 _channel=HIDDEN; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SL_COMMENT"

	// $ANTLR start "EXPRESSION"
	public final void mEXPRESSION() throws RecognitionException {
		try {
			int _type = EXPRESSION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:416:3: ( 'expression(' )
			// CSSLexer.g:416:5: 'expression('
			{
			match("expression("); 

			 er.read(); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EXPRESSION"

	// $ANTLR start "FUNCTION"
	public final void mFUNCTION() throws RecognitionException {
		try {
			int _type = FUNCTION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:421:2: ( IDENT_MACR '(' )
			// CSSLexer.g:421:4: IDENT_MACR '('
			{
			mIDENT_MACR(); 

			match('('); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FUNCTION"

	// $ANTLR start "INCLUDES"
	public final void mINCLUDES() throws RecognitionException {
		try {
			int _type = INCLUDES;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:425:2: ( '~=' )
			// CSSLexer.g:425:4: '~='
			{
			match("~="); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INCLUDES"

	// $ANTLR start "DASHMATCH"
	public final void mDASHMATCH() throws RecognitionException {
		try {
			int _type = DASHMATCH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:429:2: ( '|=' )
			// CSSLexer.g:429:4: '|='
			{
			match("|="); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DASHMATCH"

	// $ANTLR start "STARTSWITH"
	public final void mSTARTSWITH() throws RecognitionException {
		try {
			int _type = STARTSWITH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:433:3: ( '^=' )
			// CSSLexer.g:433:5: '^='
			{
			match("^="); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STARTSWITH"

	// $ANTLR start "ENDSWITH"
	public final void mENDSWITH() throws RecognitionException {
		try {
			int _type = ENDSWITH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:437:3: ( '$=' )
			// CSSLexer.g:437:5: '$='
			{
			match("$="); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ENDSWITH"

	// $ANTLR start "CONTAINS"
	public final void mCONTAINS() throws RecognitionException {
		try {
			int _type = CONTAINS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:441:3: ( '*=' )
			// CSSLexer.g:441:5: '*='
			{
			match("*="); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CONTAINS"

	// $ANTLR start "CTRL"
	public final void mCTRL() throws RecognitionException {
		try {
			int _type = CTRL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:445:3: ( ( CTRL_CHAR )+ )
			// CSSLexer.g:445:5: ( CTRL_CHAR )+
			{
			// CSSLexer.g:445:5: ( CTRL_CHAR )+
			int cnt17=0;
			loop17:
			while (true) {
				int alt17=2;
				int LA17_0 = input.LA(1);
				if ( ((LA17_0 >= '\u0000' && LA17_0 <= '\b')||(LA17_0 >= '\u000E' && LA17_0 <= '\u001F')) ) {
					alt17=1;
				}

				switch (alt17) {
				case 1 :
					// CSSLexer.g:
					{
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\b')||(input.LA(1) >= '\u000E' && input.LA(1) <= '\u001F') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt17 >= 1 ) break loop17;
					EarlyExitException eee = new EarlyExitException(17, input);
					throw eee;
				}
				cnt17++;
			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CTRL"

	// $ANTLR start "INVALID_TOKEN"
	public final void mINVALID_TOKEN() throws RecognitionException {
		try {
			int _type = INVALID_TOKEN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// CSSLexer.g:449:2: ( . )
			// CSSLexer.g:449:4: .
			{
			matchAny(); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INVALID_TOKEN"

	// $ANTLR start "IDENT_MACR"
	public final void mIDENT_MACR() throws RecognitionException {
		try {
			// CSSLexer.g:458:4: ( NAME_START ( NAME_CHAR )* )
			// CSSLexer.g:458:6: NAME_START ( NAME_CHAR )*
			{
			mNAME_START(); 

			// CSSLexer.g:458:17: ( NAME_CHAR )*
			loop18:
			while (true) {
				int alt18=2;
				int LA18_0 = input.LA(1);
				if ( (LA18_0=='-'||(LA18_0 >= '0' && LA18_0 <= '9')||(LA18_0 >= 'A' && LA18_0 <= 'Z')||LA18_0=='\\'||LA18_0=='_'||(LA18_0 >= 'a' && LA18_0 <= 'z')||(LA18_0 >= '\u0080' && LA18_0 <= '\uD7FF')||(LA18_0 >= '\uE000' && LA18_0 <= '\uFFFD')) ) {
					alt18=1;
				}

				switch (alt18) {
				case 1 :
					// CSSLexer.g:458:17: NAME_CHAR
					{
					mNAME_CHAR(); 

					}
					break;

				default :
					break loop18;
				}
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IDENT_MACR"

	// $ANTLR start "NAME_MACR"
	public final void mNAME_MACR() throws RecognitionException {
		try {
			// CSSLexer.g:463:3: ( ( NAME_CHAR )+ )
			// CSSLexer.g:463:5: ( NAME_CHAR )+
			{
			// CSSLexer.g:463:5: ( NAME_CHAR )+
			int cnt19=0;
			loop19:
			while (true) {
				int alt19=2;
				int LA19_0 = input.LA(1);
				if ( (LA19_0=='-'||(LA19_0 >= '0' && LA19_0 <= '9')||(LA19_0 >= 'A' && LA19_0 <= 'Z')||LA19_0=='\\'||LA19_0=='_'||(LA19_0 >= 'a' && LA19_0 <= 'z')||(LA19_0 >= '\u0080' && LA19_0 <= '\uD7FF')||(LA19_0 >= '\uE000' && LA19_0 <= '\uFFFD')) ) {
					alt19=1;
				}

				switch (alt19) {
				case 1 :
					// CSSLexer.g:463:5: NAME_CHAR
					{
					mNAME_CHAR(); 

					}
					break;

				default :
					if ( cnt19 >= 1 ) break loop19;
					EarlyExitException eee = new EarlyExitException(19, input);
					throw eee;
				}
				cnt19++;
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NAME_MACR"

	// $ANTLR start "NAME_START"
	public final void mNAME_START() throws RecognitionException {
		try {
			// CSSLexer.g:468:4: ( ( 'a' .. 'z' | 'A' .. 'Z' | '_' | NON_ASCII | ESCAPE_CHAR ) )
			// CSSLexer.g:468:6: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | NON_ASCII | ESCAPE_CHAR )
			{
			// CSSLexer.g:468:6: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | NON_ASCII | ESCAPE_CHAR )
			int alt20=5;
			int LA20_0 = input.LA(1);
			if ( ((LA20_0 >= 'a' && LA20_0 <= 'z')) ) {
				alt20=1;
			}
			else if ( ((LA20_0 >= 'A' && LA20_0 <= 'Z')) ) {
				alt20=2;
			}
			else if ( (LA20_0=='_') ) {
				alt20=3;
			}
			else if ( ((LA20_0 >= '\u0080' && LA20_0 <= '\uD7FF')||(LA20_0 >= '\uE000' && LA20_0 <= '\uFFFD')) ) {
				alt20=4;
			}
			else if ( (LA20_0=='\\') ) {
				alt20=5;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 20, 0, input);
				throw nvae;
			}

			switch (alt20) {
				case 1 :
					// CSSLexer.g:468:7: 'a' .. 'z'
					{
					matchRange('a','z'); 
					}
					break;
				case 2 :
					// CSSLexer.g:468:18: 'A' .. 'Z'
					{
					matchRange('A','Z'); 
					}
					break;
				case 3 :
					// CSSLexer.g:468:29: '_'
					{
					match('_'); 
					}
					break;
				case 4 :
					// CSSLexer.g:468:35: NON_ASCII
					{
					mNON_ASCII(); 

					}
					break;
				case 5 :
					// CSSLexer.g:468:47: ESCAPE_CHAR
					{
					mESCAPE_CHAR(); 

					}
					break;

			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NAME_START"

	// $ANTLR start "NON_ASCII"
	public final void mNON_ASCII() throws RecognitionException {
		try {
			// CSSLexer.g:473:4: ( ( '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) )
			// CSSLexer.g:
			{
			if ( (input.LA(1) >= '\u0080' && input.LA(1) <= '\uD7FF')||(input.LA(1) >= '\uE000' && input.LA(1) <= '\uFFFD') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NON_ASCII"

	// $ANTLR start "ESCAPE_CHAR"
	public final void mESCAPE_CHAR() throws RecognitionException {
		try {
			// CSSLexer.g:478:3: ( ( '\\\\' ) ( ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )+ ( W_CHAR )? ) | ( '\\u0020' .. '\\u002F' | '\\u003A' .. '\\u0040' | '\\u0047' .. '\\u0060' | '\\u0067' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) ) )
			// CSSLexer.g:478:5: ( '\\\\' ) ( ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )+ ( W_CHAR )? ) | ( '\\u0020' .. '\\u002F' | '\\u003A' .. '\\u0040' | '\\u0047' .. '\\u0060' | '\\u0067' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) )
			{
			// CSSLexer.g:478:5: ( '\\\\' )
			// CSSLexer.g:478:6: '\\\\'
			{
			match('\\'); 
			}

			// CSSLexer.g:479:5: ( ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )+ ( W_CHAR )? ) | ( '\\u0020' .. '\\u002F' | '\\u003A' .. '\\u0040' | '\\u0047' .. '\\u0060' | '\\u0067' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) )
			int alt23=2;
			int LA23_0 = input.LA(1);
			if ( ((LA23_0 >= '0' && LA23_0 <= '9')||(LA23_0 >= 'A' && LA23_0 <= 'F')||(LA23_0 >= 'a' && LA23_0 <= 'f')) ) {
				alt23=1;
			}
			else if ( ((LA23_0 >= ' ' && LA23_0 <= '/')||(LA23_0 >= ':' && LA23_0 <= '@')||(LA23_0 >= 'G' && LA23_0 <= '`')||(LA23_0 >= 'g' && LA23_0 <= '~')||(LA23_0 >= '\u0080' && LA23_0 <= '\uD7FF')||(LA23_0 >= '\uE000' && LA23_0 <= '\uFFFD')) ) {
				alt23=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 23, 0, input);
				throw nvae;
			}

			switch (alt23) {
				case 1 :
					// CSSLexer.g:480:7: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )+ ( W_CHAR )? )
					{
					// CSSLexer.g:480:7: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )+ ( W_CHAR )? )
					// CSSLexer.g:480:8: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )+ ( W_CHAR )?
					{
					// CSSLexer.g:480:8: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )+
					int cnt21=0;
					loop21:
					while (true) {
						int alt21=2;
						int LA21_0 = input.LA(1);
						if ( ((LA21_0 >= '0' && LA21_0 <= '9')||(LA21_0 >= 'A' && LA21_0 <= 'F')||(LA21_0 >= 'a' && LA21_0 <= 'f')) ) {
							alt21=1;
						}

						switch (alt21) {
						case 1 :
							// CSSLexer.g:
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

						default :
							if ( cnt21 >= 1 ) break loop21;
							EarlyExitException eee = new EarlyExitException(21, input);
							throw eee;
						}
						cnt21++;
					}

					// CSSLexer.g:480:41: ( W_CHAR )?
					int alt22=2;
					int LA22_0 = input.LA(1);
					if ( ((LA22_0 >= '\t' && LA22_0 <= '\r')||LA22_0==' ') ) {
						alt22=1;
					}
					switch (alt22) {
						case 1 :
							// CSSLexer.g:
							{
							if ( (input.LA(1) >= '\t' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// CSSLexer.g:481:8: ( '\\u0020' .. '\\u002F' | '\\u003A' .. '\\u0040' | '\\u0047' .. '\\u0060' | '\\u0067' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' )
					{
					if ( (input.LA(1) >= ' ' && input.LA(1) <= '/')||(input.LA(1) >= ':' && input.LA(1) <= '@')||(input.LA(1) >= 'G' && input.LA(1) <= '`')||(input.LA(1) >= 'g' && input.LA(1) <= '~')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\uD7FF')||(input.LA(1) >= '\uE000' && input.LA(1) <= '\uFFFD') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ESCAPE_CHAR"

	// $ANTLR start "NAME_CHAR"
	public final void mNAME_CHAR() throws RecognitionException {
		try {
			// CSSLexer.g:487:4: ( ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' | NON_ASCII | ESCAPE_CHAR ) )
			// CSSLexer.g:487:6: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' | NON_ASCII | ESCAPE_CHAR )
			{
			// CSSLexer.g:487:6: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' | NON_ASCII | ESCAPE_CHAR )
			int alt24=7;
			int LA24_0 = input.LA(1);
			if ( ((LA24_0 >= 'a' && LA24_0 <= 'z')) ) {
				alt24=1;
			}
			else if ( ((LA24_0 >= 'A' && LA24_0 <= 'Z')) ) {
				alt24=2;
			}
			else if ( ((LA24_0 >= '0' && LA24_0 <= '9')) ) {
				alt24=3;
			}
			else if ( (LA24_0=='-') ) {
				alt24=4;
			}
			else if ( (LA24_0=='_') ) {
				alt24=5;
			}
			else if ( ((LA24_0 >= '\u0080' && LA24_0 <= '\uD7FF')||(LA24_0 >= '\uE000' && LA24_0 <= '\uFFFD')) ) {
				alt24=6;
			}
			else if ( (LA24_0=='\\') ) {
				alt24=7;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 24, 0, input);
				throw nvae;
			}

			switch (alt24) {
				case 1 :
					// CSSLexer.g:487:7: 'a' .. 'z'
					{
					matchRange('a','z'); 
					}
					break;
				case 2 :
					// CSSLexer.g:487:18: 'A' .. 'Z'
					{
					matchRange('A','Z'); 
					}
					break;
				case 3 :
					// CSSLexer.g:487:29: '0' .. '9'
					{
					matchRange('0','9'); 
					}
					break;
				case 4 :
					// CSSLexer.g:487:40: '-'
					{
					match('-'); 
					}
					break;
				case 5 :
					// CSSLexer.g:487:46: '_'
					{
					match('_'); 
					}
					break;
				case 6 :
					// CSSLexer.g:487:52: NON_ASCII
					{
					mNON_ASCII(); 

					}
					break;
				case 7 :
					// CSSLexer.g:487:64: ESCAPE_CHAR
					{
					mESCAPE_CHAR(); 

					}
					break;

			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NAME_CHAR"

	// $ANTLR start "INTEGER_MACR"
	public final void mINTEGER_MACR() throws RecognitionException {
		try {
			// CSSLexer.g:492:5: ( ( '0' .. '9' )+ )
			// CSSLexer.g:492:7: ( '0' .. '9' )+
			{
			// CSSLexer.g:492:7: ( '0' .. '9' )+
			int cnt25=0;
			loop25:
			while (true) {
				int alt25=2;
				int LA25_0 = input.LA(1);
				if ( ((LA25_0 >= '0' && LA25_0 <= '9')) ) {
					alt25=1;
				}

				switch (alt25) {
				case 1 :
					// CSSLexer.g:
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt25 >= 1 ) break loop25;
					EarlyExitException eee = new EarlyExitException(25, input);
					throw eee;
				}
				cnt25++;
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INTEGER_MACR"

	// $ANTLR start "NUMBER_MACR"
	public final void mNUMBER_MACR() throws RecognitionException {
		try {
			// CSSLexer.g:497:4: ( ( '0' .. '9' )+ | ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ ) )
			int alt29=2;
			alt29 = dfa29.predict(input);
			switch (alt29) {
				case 1 :
					// CSSLexer.g:497:6: ( '0' .. '9' )+
					{
					// CSSLexer.g:497:6: ( '0' .. '9' )+
					int cnt26=0;
					loop26:
					while (true) {
						int alt26=2;
						int LA26_0 = input.LA(1);
						if ( ((LA26_0 >= '0' && LA26_0 <= '9')) ) {
							alt26=1;
						}

						switch (alt26) {
						case 1 :
							// CSSLexer.g:
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

						default :
							if ( cnt26 >= 1 ) break loop26;
							EarlyExitException eee = new EarlyExitException(26, input);
							throw eee;
						}
						cnt26++;
					}

					}
					break;
				case 2 :
					// CSSLexer.g:497:20: ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ )
					{
					// CSSLexer.g:497:20: ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ )
					// CSSLexer.g:497:21: ( '0' .. '9' )* '.' ( '0' .. '9' )+
					{
					// CSSLexer.g:497:21: ( '0' .. '9' )*
					loop27:
					while (true) {
						int alt27=2;
						int LA27_0 = input.LA(1);
						if ( ((LA27_0 >= '0' && LA27_0 <= '9')) ) {
							alt27=1;
						}

						switch (alt27) {
						case 1 :
							// CSSLexer.g:
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

						default :
							break loop27;
						}
					}

					match('.'); 
					// CSSLexer.g:497:37: ( '0' .. '9' )+
					int cnt28=0;
					loop28:
					while (true) {
						int alt28=2;
						int LA28_0 = input.LA(1);
						if ( ((LA28_0 >= '0' && LA28_0 <= '9')) ) {
							alt28=1;
						}

						switch (alt28) {
						case 1 :
							// CSSLexer.g:
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

						default :
							if ( cnt28 >= 1 ) break loop28;
							EarlyExitException eee = new EarlyExitException(28, input);
							throw eee;
						}
						cnt28++;
					}

					}

					}
					break;

			}
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NUMBER_MACR"

	// $ANTLR start "STRING_MACR"
	public final void mSTRING_MACR() throws RecognitionException {
		try {
			// CSSLexer.g:502:2: ( QUOT ( STRING_CHAR | APOS )* QUOT | APOS ( STRING_CHAR | QUOT )* APOS )
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0=='\"') ) {
				alt32=1;
			}
			else if ( (LA32_0=='\'') ) {
				alt32=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 32, 0, input);
				throw nvae;
			}

			switch (alt32) {
				case 1 :
					// CSSLexer.g:502:4: QUOT ( STRING_CHAR | APOS )* QUOT
					{
					mQUOT(); 

					// CSSLexer.g:502:9: ( STRING_CHAR | APOS )*
					loop30:
					while (true) {
						int alt30=3;
						int LA30_0 = input.LA(1);
						if ( (LA30_0=='\t'||(LA30_0 >= ' ' && LA30_0 <= '!')||(LA30_0 >= '#' && LA30_0 <= '&')||(LA30_0 >= '(' && LA30_0 <= '~')||(LA30_0 >= '\u0080' && LA30_0 <= '\uD7FF')||(LA30_0 >= '\uE000' && LA30_0 <= '\uFFFD')) ) {
							alt30=1;
						}
						else if ( (LA30_0=='\'') ) {
							alt30=2;
						}

						switch (alt30) {
						case 1 :
							// CSSLexer.g:502:10: STRING_CHAR
							{
							mSTRING_CHAR(); 

							}
							break;
						case 2 :
							// CSSLexer.g:502:24: APOS
							{
							mAPOS(); 

							ls.aposOpen=false;
							}
							break;

						default :
							break loop30;
						}
					}

					mQUOT(); 

					}
					break;
				case 2 :
					// CSSLexer.g:503:4: APOS ( STRING_CHAR | QUOT )* APOS
					{
					mAPOS(); 

					// CSSLexer.g:503:9: ( STRING_CHAR | QUOT )*
					loop31:
					while (true) {
						int alt31=3;
						int LA31_0 = input.LA(1);
						if ( (LA31_0=='\t'||(LA31_0 >= ' ' && LA31_0 <= '!')||(LA31_0 >= '#' && LA31_0 <= '&')||(LA31_0 >= '(' && LA31_0 <= '~')||(LA31_0 >= '\u0080' && LA31_0 <= '\uD7FF')||(LA31_0 >= '\uE000' && LA31_0 <= '\uFFFD')) ) {
							alt31=1;
						}
						else if ( (LA31_0=='\"') ) {
							alt31=2;
						}

						switch (alt31) {
						case 1 :
							// CSSLexer.g:503:10: STRING_CHAR
							{
							mSTRING_CHAR(); 

							}
							break;
						case 2 :
							// CSSLexer.g:503:24: QUOT
							{
							mQUOT(); 

							ls.quotOpen=false;
							}
							break;

						default :
							break loop31;
						}
					}

					mAPOS(); 

					}
					break;

			}
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STRING_MACR"

	// $ANTLR start "STRING_CHAR"
	public final void mSTRING_CHAR() throws RecognitionException {
		try {
			// CSSLexer.g:508:2: ( ( URI_CHAR | ' ' | '(' | ')' | ( '\\\\' NL_CHAR ) ) )
			// CSSLexer.g:508:5: ( URI_CHAR | ' ' | '(' | ')' | ( '\\\\' NL_CHAR ) )
			{
			// CSSLexer.g:508:5: ( URI_CHAR | ' ' | '(' | ')' | ( '\\\\' NL_CHAR ) )
			int alt33=5;
			int LA33_0 = input.LA(1);
			if ( (LA33_0=='\\') ) {
				int LA33_1 = input.LA(2);
				if ( (LA33_1=='\n'||(LA33_1 >= '\f' && LA33_1 <= '\r')) ) {
					alt33=5;
				}

				else {
					alt33=1;
				}

			}
			else if ( (LA33_0=='\t'||LA33_0=='!'||(LA33_0 >= '#' && LA33_0 <= '&')||(LA33_0 >= '*' && LA33_0 <= '[')||(LA33_0 >= ']' && LA33_0 <= '~')||(LA33_0 >= '\u0080' && LA33_0 <= '\uD7FF')||(LA33_0 >= '\uE000' && LA33_0 <= '\uFFFD')) ) {
				alt33=1;
			}
			else if ( (LA33_0==' ') ) {
				alt33=2;
			}
			else if ( (LA33_0=='(') ) {
				alt33=3;
			}
			else if ( (LA33_0==')') ) {
				alt33=4;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 33, 0, input);
				throw nvae;
			}

			switch (alt33) {
				case 1 :
					// CSSLexer.g:508:6: URI_CHAR
					{
					mURI_CHAR(); 

					}
					break;
				case 2 :
					// CSSLexer.g:508:17: ' '
					{
					match(' '); 
					}
					break;
				case 3 :
					// CSSLexer.g:508:23: '('
					{
					match('('); 
					}
					break;
				case 4 :
					// CSSLexer.g:508:29: ')'
					{
					match(')'); 
					}
					break;
				case 5 :
					// CSSLexer.g:508:35: ( '\\\\' NL_CHAR )
					{
					// CSSLexer.g:508:35: ( '\\\\' NL_CHAR )
					// CSSLexer.g:508:36: '\\\\' NL_CHAR
					{
					match('\\'); 
					mNL_CHAR(); 

					}

					}
					break;

			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STRING_CHAR"

	// $ANTLR start "URI_MACR"
	public final void mURI_MACR() throws RecognitionException {
		try {
			// CSSLexer.g:513:2: ( ( URI_CHAR )* )
			// CSSLexer.g:513:4: ( URI_CHAR )*
			{
			// CSSLexer.g:513:4: ( URI_CHAR )*
			loop34:
			while (true) {
				int alt34=2;
				int LA34_0 = input.LA(1);
				if ( (LA34_0=='\t'||LA34_0=='!'||(LA34_0 >= '#' && LA34_0 <= '&')||(LA34_0 >= '*' && LA34_0 <= '~')||(LA34_0 >= '\u0080' && LA34_0 <= '\uD7FF')||(LA34_0 >= '\uE000' && LA34_0 <= '\uFFFD')) ) {
					alt34=1;
				}

				switch (alt34) {
				case 1 :
					// CSSLexer.g:513:4: URI_CHAR
					{
					mURI_CHAR(); 

					}
					break;

				default :
					break loop34;
				}
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "URI_MACR"

	// $ANTLR start "URI_CHAR"
	public final void mURI_CHAR() throws RecognitionException {
		try {
			// CSSLexer.g:518:2: ( ( '\\u0009' | '\\u0021' | '\\u0023' .. '\\u0026' | '\\u002A' .. '\\u007E' ) | NON_ASCII | ESCAPE_CHAR )
			int alt35=3;
			int LA35_0 = input.LA(1);
			if ( (LA35_0=='\\') ) {
				int LA35_1 = input.LA(2);
				if ( ((LA35_1 >= ' ' && LA35_1 <= '~')||(LA35_1 >= '\u0080' && LA35_1 <= '\uD7FF')||(LA35_1 >= '\uE000' && LA35_1 <= '\uFFFD')) ) {
					alt35=3;
				}

				else {
					alt35=1;
				}

			}
			else if ( ((LA35_0 >= '\u0080' && LA35_0 <= '\uD7FF')||(LA35_0 >= '\uE000' && LA35_0 <= '\uFFFD')) ) {
				alt35=2;
			}
			else if ( (LA35_0=='\t'||LA35_0=='!'||(LA35_0 >= '#' && LA35_0 <= '&')||(LA35_0 >= '*' && LA35_0 <= '[')||(LA35_0 >= ']' && LA35_0 <= '~')) ) {
				alt35=1;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 35, 0, input);
				throw nvae;
			}

			switch (alt35) {
				case 1 :
					// CSSLexer.g:518:4: ( '\\u0009' | '\\u0021' | '\\u0023' .. '\\u0026' | '\\u002A' .. '\\u007E' )
					{
					if ( input.LA(1)=='\t'||input.LA(1)=='!'||(input.LA(1) >= '#' && input.LA(1) <= '&')||(input.LA(1) >= '*' && input.LA(1) <= '~') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;
				case 2 :
					// CSSLexer.g:519:6: NON_ASCII
					{
					mNON_ASCII(); 

					}
					break;
				case 3 :
					// CSSLexer.g:519:18: ESCAPE_CHAR
					{
					mESCAPE_CHAR(); 

					}
					break;

			}
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "URI_CHAR"

	// $ANTLR start "NL_CHAR"
	public final void mNL_CHAR() throws RecognitionException {
		try {
			// CSSLexer.g:524:4: ( '\\u000A' | '\\u000D' '\\u000A' | '\\u000D' | '\\u000C' )
			int alt36=4;
			switch ( input.LA(1) ) {
			case '\n':
				{
				alt36=1;
				}
				break;
			case '\r':
				{
				int LA36_2 = input.LA(2);
				if ( (LA36_2=='\n') ) {
					alt36=2;
				}

				else {
					alt36=3;
				}

				}
				break;
			case '\f':
				{
				alt36=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 36, 0, input);
				throw nvae;
			}
			switch (alt36) {
				case 1 :
					// CSSLexer.g:524:6: '\\u000A'
					{
					match('\n'); 
					}
					break;
				case 2 :
					// CSSLexer.g:524:17: '\\u000D' '\\u000A'
					{
					match('\r'); 
					match('\n'); 
					}
					break;
				case 3 :
					// CSSLexer.g:524:37: '\\u000D'
					{
					match('\r'); 
					}
					break;
				case 4 :
					// CSSLexer.g:524:48: '\\u000C'
					{
					match('\f'); 
					}
					break;

			}
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NL_CHAR"

	// $ANTLR start "W_MACR"
	public final void mW_MACR() throws RecognitionException {
		try {
			// CSSLexer.g:529:2: ( ( W_CHAR )* )
			// CSSLexer.g:529:4: ( W_CHAR )*
			{
			// CSSLexer.g:529:4: ( W_CHAR )*
			loop37:
			while (true) {
				int alt37=2;
				int LA37_0 = input.LA(1);
				if ( ((LA37_0 >= '\t' && LA37_0 <= '\r')||LA37_0==' ') ) {
					alt37=1;
				}

				switch (alt37) {
				case 1 :
					// CSSLexer.g:
					{
					if ( (input.LA(1) >= '\t' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop37;
				}
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "W_MACR"

	// $ANTLR start "W_CHAR"
	public final void mW_CHAR() throws RecognitionException {
		try {
			// CSSLexer.g:534:4: ( '\\u0009' | '\\u000A' | '\\u000B' | '\\u000C' | '\\u000D' | '\\u0020' )
			// CSSLexer.g:
			{
			if ( (input.LA(1) >= '\t' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "W_CHAR"

	// $ANTLR start "CTRL_CHAR"
	public final void mCTRL_CHAR() throws RecognitionException {
		try {
			// CSSLexer.g:539:5: ( '\\u0000' .. '\\u0008' | '\\u000E' .. '\\u001F' )
			// CSSLexer.g:
			{
			if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\b')||(input.LA(1) >= '\u000E' && input.LA(1) <= '\u001F') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CTRL_CHAR"

	@Override
	public void mTokens() throws RecognitionException {
		// CSSLexer.g:1:8: ( IMPORTANT | IDENT | CHARSET | IMPORT | MEDIA | PAGE | MARGIN_AREA | VIEWPORT | FONTFACE | ATKEYWORD | CLASSKEYWORD | STRING | HASH | INDEX | NUMBER | PERCENTAGE | DIMENSION | URI | UNIRANGE | CDO | CDC | SEMICOLON | COLON | COMMA | QUESTION | PERCENT | EQUALS | SLASH | GREATER | LESS | LCURLY | RCURLY | APOS | QUOT | LPAREN | RPAREN | LBRACE | RBRACE | EXCLAMATION | TILDE | MINUS | PLUS | ASTERISK | POUND | AMPERSAND | HAT | S | COMMENT | SL_COMMENT | EXPRESSION | FUNCTION | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS | CTRL | INVALID_TOKEN )
		int alt38=58;
		alt38 = dfa38.predict(input);
		switch (alt38) {
			case 1 :
				// CSSLexer.g:1:10: IMPORTANT
				{
				mIMPORTANT(); 

				}
				break;
			case 2 :
				// CSSLexer.g:1:20: IDENT
				{
				mIDENT(); 

				}
				break;
			case 3 :
				// CSSLexer.g:1:26: CHARSET
				{
				mCHARSET(); 

				}
				break;
			case 4 :
				// CSSLexer.g:1:34: IMPORT
				{
				mIMPORT(); 

				}
				break;
			case 5 :
				// CSSLexer.g:1:41: MEDIA
				{
				mMEDIA(); 

				}
				break;
			case 6 :
				// CSSLexer.g:1:47: PAGE
				{
				mPAGE(); 

				}
				break;
			case 7 :
				// CSSLexer.g:1:52: MARGIN_AREA
				{
				mMARGIN_AREA(); 

				}
				break;
			case 8 :
				// CSSLexer.g:1:64: VIEWPORT
				{
				mVIEWPORT(); 

				}
				break;
			case 9 :
				// CSSLexer.g:1:73: FONTFACE
				{
				mFONTFACE(); 

				}
				break;
			case 10 :
				// CSSLexer.g:1:82: ATKEYWORD
				{
				mATKEYWORD(); 

				}
				break;
			case 11 :
				// CSSLexer.g:1:92: CLASSKEYWORD
				{
				mCLASSKEYWORD(); 

				}
				break;
			case 12 :
				// CSSLexer.g:1:105: STRING
				{
				mSTRING(); 

				}
				break;
			case 13 :
				// CSSLexer.g:1:112: HASH
				{
				mHASH(); 

				}
				break;
			case 14 :
				// CSSLexer.g:1:117: INDEX
				{
				mINDEX(); 

				}
				break;
			case 15 :
				// CSSLexer.g:1:123: NUMBER
				{
				mNUMBER(); 

				}
				break;
			case 16 :
				// CSSLexer.g:1:130: PERCENTAGE
				{
				mPERCENTAGE(); 

				}
				break;
			case 17 :
				// CSSLexer.g:1:141: DIMENSION
				{
				mDIMENSION(); 

				}
				break;
			case 18 :
				// CSSLexer.g:1:151: URI
				{
				mURI(); 

				}
				break;
			case 19 :
				// CSSLexer.g:1:155: UNIRANGE
				{
				mUNIRANGE(); 

				}
				break;
			case 20 :
				// CSSLexer.g:1:164: CDO
				{
				mCDO(); 

				}
				break;
			case 21 :
				// CSSLexer.g:1:168: CDC
				{
				mCDC(); 

				}
				break;
			case 22 :
				// CSSLexer.g:1:172: SEMICOLON
				{
				mSEMICOLON(); 

				}
				break;
			case 23 :
				// CSSLexer.g:1:182: COLON
				{
				mCOLON(); 

				}
				break;
			case 24 :
				// CSSLexer.g:1:188: COMMA
				{
				mCOMMA(); 

				}
				break;
			case 25 :
				// CSSLexer.g:1:194: QUESTION
				{
				mQUESTION(); 

				}
				break;
			case 26 :
				// CSSLexer.g:1:203: PERCENT
				{
				mPERCENT(); 

				}
				break;
			case 27 :
				// CSSLexer.g:1:211: EQUALS
				{
				mEQUALS(); 

				}
				break;
			case 28 :
				// CSSLexer.g:1:218: SLASH
				{
				mSLASH(); 

				}
				break;
			case 29 :
				// CSSLexer.g:1:224: GREATER
				{
				mGREATER(); 

				}
				break;
			case 30 :
				// CSSLexer.g:1:232: LESS
				{
				mLESS(); 

				}
				break;
			case 31 :
				// CSSLexer.g:1:237: LCURLY
				{
				mLCURLY(); 

				}
				break;
			case 32 :
				// CSSLexer.g:1:244: RCURLY
				{
				mRCURLY(); 

				}
				break;
			case 33 :
				// CSSLexer.g:1:251: APOS
				{
				mAPOS(); 

				}
				break;
			case 34 :
				// CSSLexer.g:1:256: QUOT
				{
				mQUOT(); 

				}
				break;
			case 35 :
				// CSSLexer.g:1:261: LPAREN
				{
				mLPAREN(); 

				}
				break;
			case 36 :
				// CSSLexer.g:1:268: RPAREN
				{
				mRPAREN(); 

				}
				break;
			case 37 :
				// CSSLexer.g:1:275: LBRACE
				{
				mLBRACE(); 

				}
				break;
			case 38 :
				// CSSLexer.g:1:282: RBRACE
				{
				mRBRACE(); 

				}
				break;
			case 39 :
				// CSSLexer.g:1:289: EXCLAMATION
				{
				mEXCLAMATION(); 

				}
				break;
			case 40 :
				// CSSLexer.g:1:301: TILDE
				{
				mTILDE(); 

				}
				break;
			case 41 :
				// CSSLexer.g:1:307: MINUS
				{
				mMINUS(); 

				}
				break;
			case 42 :
				// CSSLexer.g:1:313: PLUS
				{
				mPLUS(); 

				}
				break;
			case 43 :
				// CSSLexer.g:1:318: ASTERISK
				{
				mASTERISK(); 

				}
				break;
			case 44 :
				// CSSLexer.g:1:327: POUND
				{
				mPOUND(); 

				}
				break;
			case 45 :
				// CSSLexer.g:1:333: AMPERSAND
				{
				mAMPERSAND(); 

				}
				break;
			case 46 :
				// CSSLexer.g:1:343: HAT
				{
				mHAT(); 

				}
				break;
			case 47 :
				// CSSLexer.g:1:347: S
				{
				mS(); 

				}
				break;
			case 48 :
				// CSSLexer.g:1:349: COMMENT
				{
				mCOMMENT(); 

				}
				break;
			case 49 :
				// CSSLexer.g:1:357: SL_COMMENT
				{
				mSL_COMMENT(); 

				}
				break;
			case 50 :
				// CSSLexer.g:1:368: EXPRESSION
				{
				mEXPRESSION(); 

				}
				break;
			case 51 :
				// CSSLexer.g:1:379: FUNCTION
				{
				mFUNCTION(); 

				}
				break;
			case 52 :
				// CSSLexer.g:1:388: INCLUDES
				{
				mINCLUDES(); 

				}
				break;
			case 53 :
				// CSSLexer.g:1:397: DASHMATCH
				{
				mDASHMATCH(); 

				}
				break;
			case 54 :
				// CSSLexer.g:1:407: STARTSWITH
				{
				mSTARTSWITH(); 

				}
				break;
			case 55 :
				// CSSLexer.g:1:418: ENDSWITH
				{
				mENDSWITH(); 

				}
				break;
			case 56 :
				// CSSLexer.g:1:427: CONTAINS
				{
				mCONTAINS(); 

				}
				break;
			case 57 :
				// CSSLexer.g:1:436: CTRL
				{
				mCTRL(); 

				}
				break;
			case 58 :
				// CSSLexer.g:1:441: INVALID_TOKEN
				{
				mINVALID_TOKEN(); 

				}
				break;

		}
	}


	protected DFA29 dfa29 = new DFA29(this);
	protected DFA38 dfa38 = new DFA38(this);
	static final String DFA29_eotS =
		"\1\uffff\1\3\2\uffff";
	static final String DFA29_eofS =
		"\4\uffff";
	static final String DFA29_minS =
		"\2\56\2\uffff";
	static final String DFA29_maxS =
		"\2\71\2\uffff";
	static final String DFA29_acceptS =
		"\2\uffff\1\2\1\1";
	static final String DFA29_specialS =
		"\4\uffff}>";
	static final String[] DFA29_transitionS = {
			"\1\2\1\uffff\12\1",
			"\1\2\1\uffff\12\1",
			"",
			""
	};

	static final short[] DFA29_eot = DFA.unpackEncodedString(DFA29_eotS);
	static final short[] DFA29_eof = DFA.unpackEncodedString(DFA29_eofS);
	static final char[] DFA29_min = DFA.unpackEncodedStringToUnsignedChars(DFA29_minS);
	static final char[] DFA29_max = DFA.unpackEncodedStringToUnsignedChars(DFA29_maxS);
	static final short[] DFA29_accept = DFA.unpackEncodedString(DFA29_acceptS);
	static final short[] DFA29_special = DFA.unpackEncodedString(DFA29_specialS);
	static final short[][] DFA29_transition;

	static {
		int numStates = DFA29_transitionS.length;
		DFA29_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA29_transition[i] = DFA.unpackEncodedString(DFA29_transitionS[i]);
		}
	}

	protected class DFA29 extends DFA {

		public DFA29(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 29;
			this.eot = DFA29_eot;
			this.eof = DFA29_eof;
			this.min = DFA29_min;
			this.max = DFA29_max;
			this.accept = DFA29_accept;
			this.special = DFA29_special;
			this.transition = DFA29_transition;
		}
		@Override
		public String getDescription() {
			return "496:1: fragment NUMBER_MACR : ( ( '0' .. '9' )+ | ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ ) );";
		}
	}

	static final String DFA38_eotS =
		"\1\uffff\5\56\1\54\1\105\1\54\1\110\1\112\1\113\1\115\4\56\1\130\1\132"+
		"\6\uffff\1\143\10\uffff\1\155\1\uffff\1\160\1\uffff\1\163\1\uffff\1\56"+
		"\2\54\2\uffff\1\56\1\uffff\6\56\2\uffff\1\56\1\uffff\2\56\12\105\2\uffff"+
		"\1\115\6\uffff\1\70\1\115\2\uffff\1\70\1\uffff\1\56\1\uffff\1\56\41\uffff"+
		"\10\56\12\105\1\123\7\56\12\105\1\70\1\66\2\56\3\105\1\u00b0\6\105\1\uffff"+
		"\2\56\2\105\1\u00bd\1\uffff\10\105\2\56\1\105\1\u00cb\1\uffff\12\105\2"+
		"\56\1\105\1\uffff\14\105\1\56\1\u00ea\1\uffff\1\u00ec\5\105\1\u00ec\5"+
		"\105\1\u00f7\1\105\1\56\1\uffff\1\105\1\uffff\1\105\1\u00ec\5\105\1\u00ec"+
		"\2\105\1\uffff\1\u0104\1\56\1\105\1\u00ec\10\105\2\uffff\2\105\1\u00ec"+
		"\2\105\2\u00ec\2\105\1\uffff\4\105\3\u00ec\3\105\1\u00ec\5\105\1\u00ec"+
		"\3\105\1\u00ec\4\105\1\u00ec\1\105\1\u00ec";
	static final String DFA38_eofS =
		"\u012c\uffff";
	static final String DFA38_minS =
		"\1\0\1\50\2\11\2\50\1\40\1\142\1\60\2\11\1\55\1\45\4\50\1\41\1\55\6\uffff"+
		"\1\52\10\uffff\1\75\1\uffff\1\75\1\uffff\1\75\1\uffff\1\50\2\75\2\uffff"+
		"\1\50\1\uffff\6\50\1\40\1\uffff\1\11\1\uffff\1\11\1\50\1\150\1\155\1\145"+
		"\1\141\2\157\1\145\2\151\1\157\2\uffff\1\45\6\uffff\1\55\1\45\1\60\1\uffff"+
		"\1\55\1\uffff\1\50\1\uffff\1\50\41\uffff\1\50\1\11\3\50\3\11\1\141\1\160"+
		"\1\144\1\147\1\160\1\164\1\146\1\147\1\145\1\156\1\11\4\50\3\11\1\162"+
		"\1\157\1\151\1\145\1\55\2\164\1\150\1\167\1\164\1\55\1\11\2\50\1\163\1"+
		"\162\1\141\1\55\1\143\1\157\1\55\1\164\1\160\1\55\1\uffff\2\50\1\145\1"+
		"\164\1\55\1\uffff\2\145\1\151\1\155\1\142\1\55\1\157\1\146\2\50\1\164"+
		"\1\55\1\uffff\1\146\1\156\1\147\1\55\1\157\1\151\1\157\1\142\1\162\1\141"+
		"\2\50\1\11\1\uffff\2\164\1\150\1\143\1\160\1\144\1\164\1\157\1\151\1\157"+
		"\1\164\1\143\2\50\1\uffff\1\55\1\145\1\164\2\145\1\151\1\55\1\144\1\164"+
		"\1\160\1\144\1\164\1\55\1\145\1\50\1\uffff\1\143\1\uffff\1\162\1\55\1"+
		"\146\1\156\1\147\1\154\1\157\1\55\1\144\1\164\1\uffff\1\55\1\50\1\157"+
		"\1\55\1\143\2\164\1\150\1\145\1\155\1\154\1\157\2\uffff\1\162\1\157\1"+
		"\55\1\145\1\164\2\55\1\145\1\155\1\uffff\1\156\1\162\1\143\1\162\3\55"+
		"\1\145\1\156\1\157\1\55\1\143\1\162\1\145\1\162\1\157\1\55\1\162\1\156"+
		"\1\162\1\55\1\145\1\156\1\162\1\145\1\55\1\162\1\55";
	static final String DFA38_maxS =
		"\1\uffff\6\ufffd\1\166\11\ufffd\1\41\1\55\6\uffff\1\57\10\uffff\1\75\1"+
		"\uffff\1\75\1\uffff\1\75\1\uffff\1\ufffd\2\75\2\uffff\1\ufffd\1\uffff"+
		"\7\ufffd\1\uffff\1\ufffd\1\uffff\2\ufffd\1\150\1\155\1\145\1\141\2\157"+
		"\1\145\2\151\1\157\2\uffff\1\ufffd\6\uffff\2\ufffd\1\71\1\uffff\1\ufffd"+
		"\1\uffff\1\ufffd\1\uffff\1\ufffd\41\uffff\10\ufffd\1\141\1\160\1\144\1"+
		"\147\1\160\1\164\1\146\1\147\1\145\1\156\1\71\7\ufffd\1\162\1\157\1\151"+
		"\1\145\1\55\2\164\1\150\1\167\1\164\4\ufffd\1\163\1\162\1\141\1\ufffd"+
		"\1\162\1\157\1\55\1\164\1\160\1\55\1\uffff\2\ufffd\1\145\1\164\1\ufffd"+
		"\1\uffff\2\145\1\151\1\155\1\164\1\55\1\157\1\146\2\ufffd\1\164\1\ufffd"+
		"\1\uffff\1\146\1\156\1\147\1\55\1\157\1\151\1\157\1\164\1\162\1\141\2"+
		"\ufffd\1\47\1\uffff\2\164\1\150\1\162\1\160\1\144\1\164\1\157\1\151\1"+
		"\157\1\164\1\143\2\ufffd\1\uffff\1\ufffd\1\145\1\164\2\145\1\151\1\ufffd"+
		"\1\144\1\164\1\160\1\144\1\164\1\ufffd\1\145\1\ufffd\1\uffff\1\143\1\uffff"+
		"\1\162\1\ufffd\1\146\1\156\1\147\1\154\1\157\1\ufffd\1\144\1\164\1\uffff"+
		"\2\ufffd\1\157\1\ufffd\1\143\2\164\1\150\1\145\1\155\1\154\1\157\2\uffff"+
		"\1\162\1\157\1\ufffd\1\145\1\164\2\ufffd\1\145\1\155\1\uffff\1\156\1\162"+
		"\1\143\1\162\3\ufffd\1\145\1\156\1\157\1\ufffd\1\143\1\162\1\145\1\162"+
		"\1\157\1\ufffd\1\162\1\156\1\162\1\ufffd\1\145\1\156\1\162\1\145\1\ufffd"+
		"\1\162\1\ufffd";
	static final String DFA38_acceptS =
		"\23\uffff\1\26\1\27\1\30\1\31\1\32\1\33\1\uffff\1\35\1\37\1\40\1\43\1"+
		"\44\1\45\1\46\1\47\1\uffff\1\52\1\uffff\1\55\1\uffff\1\57\3\uffff\1\71"+
		"\1\72\1\uffff\1\2\7\uffff\1\63\1\uffff\1\16\14\uffff\1\12\1\13\1\uffff"+
		"\1\42\1\14\1\41\1\54\1\15\1\17\3\uffff\1\20\1\uffff\1\21\1\uffff\1\23"+
		"\1\uffff\1\24\1\36\1\25\1\51\1\26\1\27\1\30\1\31\1\32\1\33\1\60\1\61\1"+
		"\34\1\35\1\37\1\40\1\43\1\44\1\45\1\46\1\47\1\64\1\50\1\52\1\70\1\53\1"+
		"\55\1\66\1\56\1\57\1\65\1\67\1\71\62\uffff\1\22\5\uffff\1\6\14\uffff\1"+
		"\5\15\uffff\1\4\16\uffff\1\3\17\uffff\1\1\1\uffff\1\7\12\uffff\1\10\14"+
		"\uffff\1\11\1\62\11\uffff\1\62\34\uffff";
	static final String DFA38_specialS =
		"\1\0\u012b\uffff}>";
	static final String[] DFA38_transitionS = {
			"\11\53\5\47\22\53\1\47\1\41\1\11\1\13\1\52\1\27\1\45\1\12\1\35\1\36\1"+
			"\44\1\43\1\25\1\22\1\10\1\31\12\14\1\24\1\23\1\21\1\30\1\32\1\26\1\7"+
			"\15\20\1\3\6\20\1\16\5\20\1\37\1\6\1\40\1\46\1\4\1\54\4\50\1\17\3\50"+
			"\1\1\4\50\1\2\6\50\1\15\5\50\1\33\1\51\1\34\1\42\1\54\ud780\5\u0800\54"+
			"\u1ffe\5\2\54",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\14\57\1\55\15\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\5\70\22\uffff\1\70\7\uffff\1\66\2\uffff\1\70\1\uffff\1\67\2\uffff\12"+
			"\61\7\uffff\32\60\1\uffff\1\65\2\uffff\1\63\1\uffff\32\57\5\uffff\ud780"+
			"\64\u0800\uffff\u1ffe\64",
			"\5\70\22\uffff\1\70\7\uffff\1\66\2\uffff\1\70\1\uffff\1\67\2\uffff\12"+
			"\61\7\uffff\32\60\1\uffff\1\65\2\uffff\1\63\1\uffff\32\57\5\uffff\ud780"+
			"\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\20\72\12\71\7\72\6\71\32\72\6\71\30\72\1\uffff\ud780\72\u0800\uffff"+
			"\u1ffe\72",
			"\1\100\1\73\2\uffff\1\104\2\uffff\1\74\2\uffff\1\101\1\75\2\uffff\1"+
			"\76\1\uffff\1\102\1\uffff\1\77\1\uffff\1\103",
			"\12\107\7\uffff\32\106\1\uffff\1\106\2\uffff\1\106\1\uffff\32\106\5"+
			"\uffff\ud780\106\u0800\uffff\u1ffe\106",
			"\1\111\26\uffff\137\111\1\uffff\ud780\111\u0800\uffff\u1ffe\111",
			"\1\111\26\uffff\137\111\1\uffff\ud780\111\u0800\uffff\u1ffe\111",
			"\1\114\2\uffff\12\114\7\uffff\32\114\1\uffff\1\114\2\uffff\1\114\1\uffff"+
			"\32\114\5\uffff\ud780\114\u0800\uffff\u1ffe\114",
			"\1\121\10\uffff\1\120\1\uffff\12\117\7\uffff\15\123\1\122\14\123\1\uffff"+
			"\1\123\2\uffff\1\123\1\uffff\15\123\1\116\14\123\5\uffff\ud780\123\u0800"+
			"\uffff\u1ffe\123",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\21\57\1\124\10\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\2\uffff\1\125\1\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff"+
			"\1\65\2\uffff\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\27\57\1\126\2\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\127",
			"\1\131",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\141\4\uffff\1\142",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\154",
			"",
			"\1\157",
			"",
			"\1\162",
			"",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\165",
			"\1\166",
			"",
			"",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\17\57\1\170\12\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\20\172\12\171\7\172\6\171\32\172\6\171\30\172\1\uffff\ud780\172\u0800"+
			"\uffff\u1ffe\172",
			"",
			"\5\70\22\uffff\1\70\7\uffff\1\66\4\uffff\1\62\2\uffff\12\173\7\uffff"+
			"\32\60\1\uffff\1\65\2\uffff\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800"+
			"\uffff\u1ffe\64",
			"",
			"\5\174\22\uffff\1\174\7\uffff\1\66\4\uffff\1\62\2\uffff\12\177\7\uffff"+
			"\6\176\24\60\1\uffff\1\65\2\uffff\1\63\1\uffff\6\175\24\57\5\uffff\ud780"+
			"\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\u0080",
			"\1\u0081",
			"\1\u0082",
			"\1\u0083",
			"\1\u0084",
			"\1\u0085",
			"\1\u0086",
			"\1\u0087",
			"\1\u0088",
			"\1\u0089",
			"",
			"",
			"\1\121\12\uffff\12\107\7\uffff\32\123\1\uffff\1\123\2\uffff\1\123\1"+
			"\uffff\32\123\5\uffff\ud780\123\u0800\uffff\u1ffe\123",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\u008a\2\uffff\12\123\7\uffff\32\123\1\uffff\1\123\2\uffff\1\123\1"+
			"\uffff\32\123\5\uffff\ud780\123\u0800\uffff\u1ffe\123",
			"\1\121\10\uffff\1\120\1\uffff\12\117\7\uffff\15\123\1\122\14\123\1\uffff"+
			"\1\123\2\uffff\1\123\1\uffff\15\123\1\116\14\123\5\uffff\ud780\123\u0800"+
			"\uffff\u1ffe\123",
			"\12\107",
			"",
			"\1\u008a\2\uffff\12\123\7\uffff\32\123\1\uffff\1\123\2\uffff\1\123\1"+
			"\uffff\32\123\5\uffff\ud780\123\u0800\uffff\u1ffe\123",
			"",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\13\57\1\u008b\16\57\5\uffff\ud780\64\u0800\uffff\u1ffe"+
			"\64",
			"",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\17\57\1\u008c\12\57\5\uffff\ud780\64\u0800\uffff\u1ffe"+
			"\64",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\16\57\1\u008d\13\57\5\uffff\ud780\64\u0800\uffff\u1ffe"+
			"\64",
			"\5\u008e\22\uffff\1\u008e\7\uffff\1\66\4\uffff\1\62\2\uffff\12\u0091"+
			"\7\uffff\6\u0090\24\60\1\uffff\1\65\2\uffff\1\63\1\uffff\6\u008f\24\57"+
			"\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\173\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\5\174\22\uffff\1\174\7\uffff\1\66\4\uffff\1\62\2\uffff\12\177\7\uffff"+
			"\6\176\24\60\1\uffff\1\65\2\uffff\1\63\1\uffff\6\175\24\57\5\uffff\ud780"+
			"\64\u0800\uffff\u1ffe\64",
			"\5\174\22\uffff\1\174\7\uffff\1\66\4\uffff\1\62\2\uffff\12\177\7\uffff"+
			"\6\176\24\60\1\uffff\1\65\2\uffff\1\63\1\uffff\6\175\24\57\5\uffff\ud780"+
			"\64\u0800\uffff\u1ffe\64",
			"\5\174\22\uffff\1\174\7\uffff\1\66\4\uffff\1\62\2\uffff\12\177\7\uffff"+
			"\6\176\24\60\1\uffff\1\65\2\uffff\1\63\1\uffff\6\175\24\57\5\uffff\ud780"+
			"\64\u0800\uffff\u1ffe\64",
			"\1\u0092",
			"\1\u0093",
			"\1\u0094",
			"\1\u0095",
			"\1\u0096",
			"\1\u0097",
			"\1\u0098",
			"\1\u0099",
			"\1\u009a",
			"\1\u009b",
			"\5\70\22\uffff\1\70\17\uffff\12\u009c",
			"\1\u009d\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\21\57\1\u009e\10\57\5\uffff\ud780\64\u0800\uffff\u1ffe"+
			"\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\21\57\1\u009f\10\57\5\uffff\ud780\64\u0800\uffff\u1ffe"+
			"\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\5\u008e\22\uffff\1\u008e\7\uffff\1\66\4\uffff\1\62\2\uffff\12\u0091"+
			"\7\uffff\6\u0090\24\60\1\uffff\1\65\2\uffff\1\63\1\uffff\6\u008f\24\57"+
			"\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\5\u008e\22\uffff\1\u008e\7\uffff\1\66\4\uffff\1\62\2\uffff\12\u0091"+
			"\7\uffff\6\u0090\24\60\1\uffff\1\65\2\uffff\1\63\1\uffff\6\u008f\24\57"+
			"\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\5\u008e\22\uffff\1\u008e\7\uffff\1\66\4\uffff\1\62\2\uffff\12\u0091"+
			"\7\uffff\6\u0090\24\60\1\uffff\1\65\2\uffff\1\63\1\uffff\6\u008f\24\57"+
			"\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\u00a0",
			"\1\u00a1",
			"\1\u00a2",
			"\1\u00a3",
			"\1\u00a4",
			"\1\u00a5",
			"\1\u00a6",
			"\1\u00a7",
			"\1\u00a8",
			"\1\u00a9",
			"\1\123\2\uffff\12\u009c\7\uffff\32\123\1\uffff\1\123\2\uffff\1\123\1"+
			"\uffff\32\123\5\uffff\ud780\123\u0800\uffff\u1ffe\123",
			"\5\u00aa\22\uffff\10\u00aa\1\uffff\126\u00aa\1\uffff\ud780\u00aa\u0800"+
			"\uffff\u1ffe\u00aa",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\4\57\1\u00ab\25\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\23\57\1\u00ac\6\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\u00ad",
			"\1\u00ae",
			"\1\u00af",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u00b2\10\uffff\1\u00b1\5\uffff\1\u00b3",
			"\1\u00b4",
			"\1\u00b5",
			"\1\u00b6",
			"\1\u00b7",
			"\1\u00b8",
			"",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\22\57\1\u00b9\7\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\1\u00ba\31\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\u00bb",
			"\1\u00bc",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"",
			"\1\u00be",
			"\1\u00bf",
			"\1\u00c0",
			"\1\u00c1",
			"\1\u00c4\12\uffff\1\u00c3\6\uffff\1\u00c2",
			"\1\u00c5",
			"\1\u00c6",
			"\1\u00c7",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\22\57\1\u00c8\7\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\15\57\1\u00c9\14\57\5\uffff\ud780\64\u0800\uffff\u1ffe"+
			"\64",
			"\1\u00ca",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"",
			"\1\u00cc",
			"\1\u00cd",
			"\1\u00ce",
			"\1\u00cf",
			"\1\u00d0",
			"\1\u00d1",
			"\1\u00d2",
			"\1\u00d5\12\uffff\1\u00d4\6\uffff\1\u00d3",
			"\1\u00d6",
			"\1\u00d7",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\10\57\1\u00d8\21\57\5\uffff\ud780\64\u0800\uffff\u1ffe"+
			"\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\23\57\1\u00d9\6\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\5\u00da\22\uffff\1\u00da\1\uffff\1\u00da\4\uffff\1\u00da",
			"",
			"\1\u00db",
			"\1\u00dc",
			"\1\u00dd",
			"\1\u00df\10\uffff\1\u00de\5\uffff\1\u00e0",
			"\1\u00e1",
			"\1\u00e2",
			"\1\u00e3",
			"\1\u00e4",
			"\1\u00e5",
			"\1\u00e6",
			"\1\u00e7",
			"\1\u00e8",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\16\57\1\u00e9\13\57\5\uffff\ud780\64\u0800\uffff\u1ffe"+
			"\64",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"",
			"\1\u00eb\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1"+
			"\uffff\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u00ed",
			"\1\u00ee",
			"\1\u00ef",
			"\1\u00f0",
			"\1\u00f1",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u00f2",
			"\1\u00f3",
			"\1\u00f4",
			"\1\u00f5",
			"\1\u00f6",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u00f8",
			"\1\66\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\15\57\1\u00f9\14\57\5\uffff\ud780\64\u0800\uffff\u1ffe"+
			"\64",
			"",
			"\1\u00fa",
			"",
			"\1\u00fb",
			"\1\u00fc\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1"+
			"\uffff\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u00fd",
			"\1\u00fe",
			"\1\u00ff",
			"\1\u0100",
			"\1\u0101",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u0102",
			"\1\u0103",
			"",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u0105\4\uffff\1\62\2\uffff\12\61\7\uffff\32\60\1\uffff\1\65\2\uffff"+
			"\1\63\1\uffff\32\57\5\uffff\ud780\64\u0800\uffff\u1ffe\64",
			"\1\u0106",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u0107",
			"\1\u0108",
			"\1\u0109",
			"\1\u010a",
			"\1\u010b",
			"\1\u010c",
			"\1\u010d",
			"\1\u010e",
			"",
			"",
			"\1\u0110",
			"\1\u0111",
			"\1\u0112\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1"+
			"\uffff\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u0113",
			"\1\u0114",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u0115",
			"\1\u0116",
			"",
			"\1\u0117",
			"\1\u0118",
			"\1\u0119",
			"\1\u011a",
			"\1\u011b\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1"+
			"\uffff\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u011c",
			"\1\u011d",
			"\1\u011e",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u011f",
			"\1\u0120",
			"\1\u0121",
			"\1\u0122",
			"\1\u0123",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u0124",
			"\1\u0125",
			"\1\u0126",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u0127",
			"\1\u0128",
			"\1\u0129",
			"\1\u012a",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105",
			"\1\u012b",
			"\1\105\2\uffff\12\105\7\uffff\32\105\1\uffff\1\105\2\uffff\1\105\1\uffff"+
			"\32\105\5\uffff\ud780\105\u0800\uffff\u1ffe\105"
	};

	static final short[] DFA38_eot = DFA.unpackEncodedString(DFA38_eotS);
	static final short[] DFA38_eof = DFA.unpackEncodedString(DFA38_eofS);
	static final char[] DFA38_min = DFA.unpackEncodedStringToUnsignedChars(DFA38_minS);
	static final char[] DFA38_max = DFA.unpackEncodedStringToUnsignedChars(DFA38_maxS);
	static final short[] DFA38_accept = DFA.unpackEncodedString(DFA38_acceptS);
	static final short[] DFA38_special = DFA.unpackEncodedString(DFA38_specialS);
	static final short[][] DFA38_transition;

	static {
		int numStates = DFA38_transitionS.length;
		DFA38_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA38_transition[i] = DFA.unpackEncodedString(DFA38_transitionS[i]);
		}
	}

	protected class DFA38 extends DFA {

		public DFA38(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 38;
			this.eot = DFA38_eot;
			this.eof = DFA38_eof;
			this.min = DFA38_min;
			this.max = DFA38_max;
			this.accept = DFA38_accept;
			this.special = DFA38_special;
			this.transition = DFA38_transition;
		}
		@Override
		public String getDescription() {
			return "1:1: Tokens : ( IMPORTANT | IDENT | CHARSET | IMPORT | MEDIA | PAGE | MARGIN_AREA | VIEWPORT | FONTFACE | ATKEYWORD | CLASSKEYWORD | STRING | HASH | INDEX | NUMBER | PERCENTAGE | DIMENSION | URI | UNIRANGE | CDO | CDC | SEMICOLON | COLON | COMMA | QUESTION | PERCENT | EQUALS | SLASH | GREATER | LESS | LCURLY | RCURLY | APOS | QUOT | LPAREN | RPAREN | LBRACE | RBRACE | EXCLAMATION | TILDE | MINUS | PLUS | ASTERISK | POUND | AMPERSAND | HAT | S | COMMENT | SL_COMMENT | EXPRESSION | FUNCTION | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS | CTRL | INVALID_TOKEN );";
		}
		@Override
		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			IntStream input = _input;
			int _s = s;
			switch ( s ) {
					case 0 : 
						int LA38_0 = input.LA(1);
						s = -1;
						if ( (LA38_0=='i') ) {s = 1;}
						else if ( (LA38_0=='n') ) {s = 2;}
						else if ( (LA38_0=='N') ) {s = 3;}
						else if ( (LA38_0=='_') ) {s = 4;}
						else if ( ((LA38_0 >= '\u0080' && LA38_0 <= '\uD7FF')||(LA38_0 >= '\uE000' && LA38_0 <= '\uFFFD')) ) {s = 5;}
						else if ( (LA38_0=='\\') ) {s = 6;}
						else if ( (LA38_0=='@') ) {s = 7;}
						else if ( (LA38_0=='.') ) {s = 8;}
						else if ( (LA38_0=='\"') ) {s = 9;}
						else if ( (LA38_0=='\'') ) {s = 10;}
						else if ( (LA38_0=='#') ) {s = 11;}
						else if ( ((LA38_0 >= '0' && LA38_0 <= '9')) ) {s = 12;}
						else if ( (LA38_0=='u') ) {s = 13;}
						else if ( (LA38_0=='U') ) {s = 14;}
						else if ( (LA38_0=='e') ) {s = 15;}
						else if ( ((LA38_0 >= 'A' && LA38_0 <= 'M')||(LA38_0 >= 'O' && LA38_0 <= 'T')||(LA38_0 >= 'V' && LA38_0 <= 'Z')) ) {s = 16;}
						else if ( (LA38_0=='<') ) {s = 17;}
						else if ( (LA38_0=='-') ) {s = 18;}
						else if ( (LA38_0==';') ) {s = 19;}
						else if ( (LA38_0==':') ) {s = 20;}
						else if ( (LA38_0==',') ) {s = 21;}
						else if ( (LA38_0=='?') ) {s = 22;}
						else if ( (LA38_0=='%') ) {s = 23;}
						else if ( (LA38_0=='=') ) {s = 24;}
						else if ( (LA38_0=='/') ) {s = 25;}
						else if ( (LA38_0=='>') ) {s = 26;}
						else if ( (LA38_0=='{') ) {s = 27;}
						else if ( (LA38_0=='}') ) {s = 28;}
						else if ( (LA38_0=='(') ) {s = 29;}
						else if ( (LA38_0==')') ) {s = 30;}
						else if ( (LA38_0=='[') ) {s = 31;}
						else if ( (LA38_0==']') ) {s = 32;}
						else if ( (LA38_0=='!') ) {s = 33;}
						else if ( (LA38_0=='~') ) {s = 34;}
						else if ( (LA38_0=='+') ) {s = 35;}
						else if ( (LA38_0=='*') ) {s = 36;}
						else if ( (LA38_0=='&') ) {s = 37;}
						else if ( (LA38_0=='^') ) {s = 38;}
						else if ( ((LA38_0 >= '\t' && LA38_0 <= '\r')||LA38_0==' ') ) {s = 39;}
						else if ( ((LA38_0 >= 'a' && LA38_0 <= 'd')||(LA38_0 >= 'f' && LA38_0 <= 'h')||(LA38_0 >= 'j' && LA38_0 <= 'm')||(LA38_0 >= 'o' && LA38_0 <= 't')||(LA38_0 >= 'v' && LA38_0 <= 'z')) ) {s = 40;}
						else if ( (LA38_0=='|') ) {s = 41;}
						else if ( (LA38_0=='$') ) {s = 42;}
						else if ( ((LA38_0 >= '\u0000' && LA38_0 <= '\b')||(LA38_0 >= '\u000E' && LA38_0 <= '\u001F')) ) {s = 43;}
						else if ( (LA38_0=='`'||LA38_0=='\u007F'||(LA38_0 >= '\uD800' && LA38_0 <= '\uDFFF')||(LA38_0 >= '\uFFFE' && LA38_0 <= '\uFFFF')) ) {s = 44;}
						if ( s>=0 ) return s;
						break;
			}
			NoViableAltException nvae =
				new NoViableAltException(getDescription(), 38, _s, input);
			error(nvae);
			throw nvae;
		}
	}

}
