/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import net.roseboy.classfinal.util.EncryptUtils;
import net.roseboy.classfinal.util.IoUtils;
import net.roseboy.classfinal.util.JarUtils;
import net.roseboy.classfinal.util.Log;
import net.roseboy.classfinal.util.StrUtils;
import net.roseboy.classfinal.util.SysUtils;

public class JarDecryptor {
    private static final JarDecryptor single = new JarDecryptor();
    private char[] code = SysUtils.makeMarchinCode();
    private static final String ENCRYPT_PATH = "META-INF/.classes/";

    public static JarDecryptor getInstance() {
        return single;
    }

    public byte[] doDecrypt(String projectPath, String fileName, char[] password) {
        char[] pass;
        long t1 = System.currentTimeMillis();
        File workDir = new File(projectPath);
        byte[] bytes = JarDecryptor.readEncryptedFile(workDir, fileName);
        if (bytes == null) {
            return null;
        }
        byte[] codeBytes = JarDecryptor.readEncryptedFile(workDir, "org.springframework.config.Code");
        if (codeBytes != null) {
            if (!StrUtils.equal(EncryptUtils.md5(this.code), StrUtils.toChars(codeBytes))) {
                Log.println("\u8be5\u9879\u76ee\u4e0d\u53ef\u5728\u6b64\u673a\u5668\u4e0a\u8fd0\u884c!\n");
                System.exit(-1);
            }
            pass = StrUtils.merger(fileName.toCharArray(), this.code);
            bytes = EncryptUtils.de(bytes, pass, 1);
        }
        if (password.length == 1 && password[0] == '#') {
            password = JarDecryptor.readPassFromJar(workDir);
        }
        pass = StrUtils.merger(password, fileName.toCharArray());
        bytes = EncryptUtils.de(bytes, pass, 1);
        long t2 = System.currentTimeMillis();
        Log.debug("\u89e3\u5bc6: " + fileName + " (" + (t2 - t1) + " ms)");
        return bytes;
    }

    public static byte[] readEncryptedFile(File workDir, String name) {
        byte[] bytes = null;
        String fileName = ENCRYPT_PATH + name;
        if (workDir.isFile()) {
            bytes = JarUtils.getFileFromJar(workDir, fileName);
        } else {
            File file = new File(workDir, fileName);
            if (file.exists()) {
                bytes = IoUtils.readFileToByte(file);
            }
        }
        return bytes;
    }

    public static char[] readPassFromJar(File workDir) {
        byte[] passbyte = JarDecryptor.readEncryptedFile(workDir, "org.springframework.config.Pass");
        if (passbyte != null) {
            char[] pass = StrUtils.toChars(passbyte);
            return EncryptUtils.md5(pass);
        }
        return null;
    }

    public InputStream decryptConfigFile(String path, InputStream in, char[] pass) {
        if (path.endsWith(".class")) {
            return in;
        }
        String projectPath = JarUtils.getRootPath(null);
        if (StrUtils.isEmpty(projectPath)) {
            return in;
        }
        byte[] bytes = null;
        try {
            bytes = IoUtils.toBytes(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bytes == null || bytes.length == 0) {
            bytes = this.doDecrypt(projectPath, path, pass);
        }
        if (bytes == null) {
            return in;
        }
        in = new ByteArrayInputStream(bytes);
        return in;
    }
}

