/*
 * Decompiled with CFR 0.152.
 */
package net.rdrei.android.dirchooser;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileObserver;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.gu.option.Option;
import com.gu.option.UnitFunction;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.rdrei.android.dirchooser.DirectoryChooserConfig;
import net.rdrei.android.dirchooser.R;

public class DirectoryChooserFragment
extends DialogFragment {
    public static final String KEY_CURRENT_DIRECTORY = "CURRENT_DIRECTORY";
    private static final String ARG_CONFIG = "CONFIG";
    private static final String TAG = DirectoryChooserFragment.class.getSimpleName();
    private String mNewDirectoryName;
    private String mInitialDirectory;
    private Option<OnFragmentInteractionListener> mListener = Option.none();
    private Button mBtnConfirm;
    private Button mBtnCancel;
    private ImageButton mBtnNavUp;
    private ImageButton mBtnCreateFolder;
    private TextView mTxtvSelectedFolder;
    private ListView mListDirectories;
    private ArrayAdapter<String> mListDirectoriesAdapter;
    private List<String> mFilenames;
    private File mSelectedDir;
    private File[] mFilesInDir;
    private FileObserver mFileObserver;
    private DirectoryChooserConfig mConfig;

    public static DirectoryChooserFragment newInstance(@NonNull DirectoryChooserConfig config) {
        DirectoryChooserFragment fragment = new DirectoryChooserFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_CONFIG, (Parcelable)config);
        fragment.setArguments(args);
        return fragment;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mSelectedDir != null) {
            outState.putString(KEY_CURRENT_DIRECTORY, this.mSelectedDir.getAbsolutePath());
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() == null) {
            throw new IllegalArgumentException("You must create DirectoryChooserFragment via newInstance().");
        }
        this.mConfig = (DirectoryChooserConfig)this.getArguments().getParcelable(ARG_CONFIG);
        if (this.mConfig == null) {
            throw new NullPointerException("No ARG_CONFIG provided for DirectoryChooserFragment creation.");
        }
        this.mNewDirectoryName = this.mConfig.newDirectoryName();
        this.mInitialDirectory = this.mConfig.initialDirectory();
        if (savedInstanceState != null) {
            this.mInitialDirectory = savedInstanceState.getString(KEY_CURRENT_DIRECTORY);
        }
        if (this.getShowsDialog()) {
            this.setStyle(1, 0);
        } else {
            this.setHasOptionsMenu(true);
        }
        if (!this.mConfig.allowNewDirectoryNameModification() && TextUtils.isEmpty((CharSequence)this.mNewDirectoryName)) {
            throw new IllegalArgumentException("New directory name must have a strictly positive length (not zero) when user is not allowed to modify it.");
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        assert (this.getActivity() != null);
        View view = inflater.inflate(R.layout.directory_chooser, container, false);
        this.mBtnConfirm = (Button)view.findViewById(R.id.btnConfirm);
        this.mBtnCancel = (Button)view.findViewById(R.id.btnCancel);
        this.mBtnNavUp = (ImageButton)view.findViewById(R.id.btnNavUp);
        this.mBtnCreateFolder = (ImageButton)view.findViewById(R.id.btnCreateFolder);
        this.mTxtvSelectedFolder = (TextView)view.findViewById(R.id.txtvSelectedFolder);
        this.mListDirectories = (ListView)view.findViewById(R.id.directoryList);
        this.mBtnConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DirectoryChooserFragment.this.isValidFile(DirectoryChooserFragment.this.mSelectedDir)) {
                    DirectoryChooserFragment.this.returnSelectedFolder();
                }
            }
        });
        this.mBtnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DirectoryChooserFragment.this.mListener.foreach((UnitFunction)new UnitFunction<OnFragmentInteractionListener>(){

                    public void apply(OnFragmentInteractionListener listener) {
                        listener.onCancelChooser();
                    }
                });
            }
        });
        this.mListDirectories.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                DirectoryChooserFragment.debug("Selected index: %d", new Object[]{position});
                if (DirectoryChooserFragment.this.mFilesInDir != null && position >= 0 && position < DirectoryChooserFragment.this.mFilesInDir.length) {
                    DirectoryChooserFragment.this.changeDirectory(DirectoryChooserFragment.this.mFilesInDir[position]);
                }
            }
        });
        this.mBtnNavUp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                File parent;
                if (DirectoryChooserFragment.this.mSelectedDir != null && (parent = DirectoryChooserFragment.this.mSelectedDir.getParentFile()) != null) {
                    DirectoryChooserFragment.this.changeDirectory(parent);
                }
            }
        });
        this.mBtnCreateFolder.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DirectoryChooserFragment.this.openNewFolderDialog();
            }
        });
        if (!this.getShowsDialog()) {
            this.mBtnCreateFolder.setVisibility(8);
        }
        this.adjustResourceLightness();
        this.mFilenames = new ArrayList<String>();
        this.mListDirectoriesAdapter = new ArrayAdapter((Context)this.getActivity(), 17367043, this.mFilenames);
        this.mListDirectories.setAdapter(this.mListDirectoriesAdapter);
        File initialDir = !TextUtils.isEmpty((CharSequence)this.mInitialDirectory) && this.isValidFile(new File(this.mInitialDirectory)) ? new File(this.mInitialDirectory) : Environment.getExternalStorageDirectory();
        this.changeDirectory(initialDir);
        return view;
    }

    private void adjustResourceLightness() {
        TypedArray backgroundAttributes;
        int color = 0xFFFFFF;
        Resources.Theme theme = this.getActivity().getTheme();
        if (theme != null && (backgroundAttributes = theme.obtainStyledAttributes(new int[]{0x1010031})) != null) {
            color = backgroundAttributes.getColor(0, 0xFFFFFF);
            backgroundAttributes.recycle();
        }
        if (color != 0xFFFFFF && 0.21 * (double)Color.red((int)color) + 0.72 * (double)Color.green((int)color) + 0.07 * (double)Color.blue((int)color) < 128.0) {
            this.mBtnNavUp.setImageResource(R.drawable.navigation_up_light);
            this.mBtnCreateFolder.setImageResource(R.drawable.ic_action_create_light);
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (activity instanceof OnFragmentInteractionListener) {
            this.mListener = Option.some((Object)((OnFragmentInteractionListener)activity));
        } else {
            Fragment owner = this.getTargetFragment();
            if (owner instanceof OnFragmentInteractionListener) {
                this.mListener = Option.some((Object)((OnFragmentInteractionListener)owner));
            }
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public void onPause() {
        super.onPause();
        if (this.mFileObserver != null) {
            this.mFileObserver.stopWatching();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.mFileObserver != null) {
            this.mFileObserver.startWatching();
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.directory_chooser, menu2);
        MenuItem menuItem = menu2.findItem(R.id.new_folder_item);
        if (menuItem == null) {
            return;
        }
        menuItem.setVisible(this.isValidFile(this.mSelectedDir) && this.mNewDirectoryName != null);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.new_folder_item) {
            this.openNewFolderDialog();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void openNewFolderDialog() {
        View dialogView = this.getActivity().getLayoutInflater().inflate(R.layout.dialog_new_folder, null);
        final TextView msgView = (TextView)dialogView.findViewById(R.id.msgText);
        final EditText editText = (EditText)dialogView.findViewById(R.id.editText);
        editText.setText((CharSequence)this.mNewDirectoryName);
        msgView.setText((CharSequence)this.getString(R.string.create_folder_msg, new Object[]{this.mNewDirectoryName}));
        final AlertDialog alertDialog = new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.create_folder_label).setView(dialogView).setNegativeButton(R.string.cancel_label, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setPositiveButton(R.string.confirm_label, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                DirectoryChooserFragment.this.mNewDirectoryName = editText.getText().toString();
                int msg = DirectoryChooserFragment.this.createFolder();
                Toast.makeText((Context)DirectoryChooserFragment.this.getActivity(), (int)msg, (int)0).show();
            }
        }).show();
        alertDialog.getButton(-1).setEnabled(editText.getText().length() != 0);
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                boolean textNotEmpty = charSequence.length() != 0;
                alertDialog.getButton(-1).setEnabled(textNotEmpty);
                msgView.setText((CharSequence)DirectoryChooserFragment.this.getString(R.string.create_folder_msg, new Object[]{charSequence.toString()}));
            }

            public void afterTextChanged(Editable editable) {
            }
        });
        editText.setVisibility(this.mConfig.allowNewDirectoryNameModification() ? 0 : 8);
    }

    private static void debug(String message, Object ... args) {
        Log.d((String)TAG, (String)String.format(message, args));
    }

    private void changeDirectory(File dir) {
        if (dir == null) {
            DirectoryChooserFragment.debug("Could not change folder: dir was null", new Object[0]);
        } else if (!dir.isDirectory()) {
            DirectoryChooserFragment.debug("Could not change folder: dir is no directory", new Object[0]);
        } else {
            File[] contents = dir.listFiles();
            if (contents != null) {
                int numDirectories = 0;
                for (File f : contents) {
                    if (!f.isDirectory()) continue;
                    ++numDirectories;
                }
                this.mFilesInDir = new File[numDirectories];
                this.mFilenames.clear();
                int i = 0;
                int counter = 0;
                while (i < numDirectories) {
                    if (contents[counter].isDirectory()) {
                        this.mFilesInDir[i] = contents[counter];
                        this.mFilenames.add(contents[counter].getName());
                        ++i;
                    }
                    ++counter;
                }
                Arrays.sort(this.mFilesInDir);
                Collections.sort(this.mFilenames);
                this.mSelectedDir = dir;
                this.mTxtvSelectedFolder.setText((CharSequence)dir.getAbsolutePath());
                this.mListDirectoriesAdapter.notifyDataSetChanged();
                this.mFileObserver = this.createFileObserver(dir.getAbsolutePath());
                this.mFileObserver.startWatching();
                DirectoryChooserFragment.debug("Changed directory to %s", dir.getAbsolutePath());
            } else {
                DirectoryChooserFragment.debug("Could not change folder: contents of dir were null", new Object[0]);
            }
        }
        this.refreshButtonState();
    }

    private void refreshButtonState() {
        Activity activity = this.getActivity();
        if (activity != null && this.mSelectedDir != null) {
            this.mBtnConfirm.setEnabled(this.isValidFile(this.mSelectedDir));
            this.getActivity().invalidateOptionsMenu();
        }
    }

    private void refreshDirectory() {
        if (this.mSelectedDir != null) {
            this.changeDirectory(this.mSelectedDir);
        }
    }

    private FileObserver createFileObserver(String path) {
        return new FileObserver(path, 960){

            public void onEvent(int event, String path) {
                DirectoryChooserFragment.debug("FileObserver received event %d", new Object[]{event});
                Activity activity = DirectoryChooserFragment.this.getActivity();
                if (activity != null) {
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            DirectoryChooserFragment.this.refreshDirectory();
                        }
                    });
                }
            }
        };
    }

    private void returnSelectedFolder() {
        if (this.mSelectedDir != null) {
            DirectoryChooserFragment.debug("Returning %s as result", this.mSelectedDir.getAbsolutePath());
            this.mListener.foreach((UnitFunction)new UnitFunction<OnFragmentInteractionListener>(){

                public void apply(OnFragmentInteractionListener f) {
                    f.onSelectDirectory(DirectoryChooserFragment.this.mSelectedDir.getAbsolutePath());
                }
            });
        } else {
            this.mListener.foreach((UnitFunction)new UnitFunction<OnFragmentInteractionListener>(){

                public void apply(OnFragmentInteractionListener f) {
                    f.onCancelChooser();
                }
            });
        }
    }

    private int createFolder() {
        if (this.mNewDirectoryName != null && this.mSelectedDir != null && this.mSelectedDir.canWrite()) {
            File newDir = new File(this.mSelectedDir, this.mNewDirectoryName);
            if (newDir.exists()) {
                return R.string.create_folder_error_already_exists;
            }
            boolean result = newDir.mkdir();
            if (result) {
                return R.string.create_folder_success;
            }
            return R.string.create_folder_error;
        }
        if (this.mSelectedDir != null && !this.mSelectedDir.canWrite()) {
            return R.string.create_folder_error_no_write_access;
        }
        return R.string.create_folder_error;
    }

    private boolean isValidFile(File file) {
        return file != null && file.isDirectory() && file.canRead() && (this.mConfig.allowNewDirectoryNameModification() || file.canWrite());
    }

    @Nullable
    public OnFragmentInteractionListener getDirectoryChooserListener() {
        return (OnFragmentInteractionListener)this.mListener.get();
    }

    public void setDirectoryChooserListener(@Nullable OnFragmentInteractionListener listener) {
        this.mListener = Option.option((Object)listener);
    }

    public static interface OnFragmentInteractionListener {
        public void onSelectDirectory(@NonNull String var1);

        public void onCancelChooser();
    }
}

