/*
 * Decompiled with CFR 0.152.
 */
package net.rdrei.android.dirchooser;

import android.app.ActionBar;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import net.rdrei.android.dirchooser.DirectoryChooserConfig;
import net.rdrei.android.dirchooser.DirectoryChooserFragment;
import net.rdrei.android.dirchooser.R;

public class DirectoryChooserActivity
extends AppCompatActivity
implements DirectoryChooserFragment.OnFragmentInteractionListener {
    public static final String EXTRA_CONFIG = "config";
    public static final String RESULT_SELECTED_DIR = "selected_dir";
    public static final int RESULT_CODE_DIR_SELECTED = 1;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setupActionBar();
        this.setContentView(R.layout.directory_chooser_activity);
        DirectoryChooserConfig config = (DirectoryChooserConfig)this.getIntent().getParcelableExtra(EXTRA_CONFIG);
        if (config == null) {
            throw new IllegalArgumentException("You must provide EXTRA_CONFIG when starting the DirectoryChooserActivity.");
        }
        if (savedInstanceState == null) {
            FragmentManager fragmentManager = this.getFragmentManager();
            DirectoryChooserFragment fragment = DirectoryChooserFragment.newInstance(config);
            fragmentManager.beginTransaction().add(R.id.main, (Fragment)fragment).commit();
        }
    }

    void setupActionBar() {
        ActionBar actionBar = this.getActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == 16908332) {
            this.setResult(0);
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onSelectDirectory(@NonNull String path) {
        Intent intent = new Intent();
        intent.putExtra(RESULT_SELECTED_DIR, path);
        this.setResult(1, intent);
        this.finish();
    }

    @Override
    public void onCancelChooser() {
        this.setResult(0);
        this.finish();
    }
}

